/* FILVAL:
 * You now have the field number from the first prompt.
 * Now get the new information and fill it into the structure.
 * If you get an error, let the user know what kind.
 * Dont fill the field but return.
 */
 /* types for filerr */
#include "extern.h"
#define ATONERR	0x01		/* error on ascii to long translation */
#define TYPERR  0x02		/* unknown type of field value */
#define STRINGERR 0x04		/* string too long for field */
filval(field)
register field;
{
	register filerr = 0;
	register unsigned int val;
	register char * bootptr = (char *)&aouthdr.boothdr;
	register char * prompt; 
	register type = fieldinfo[field].type;
	register offset = fieldinfo[field].offset;
	register charlen = fieldinfo[field].charlen;
	register char * namestring = fieldinfo[field].namestring;

/*
printf("INSIDE FILVAL\n");
*/
	if (type == STRING)
		prompt = "character";
	else {
		switch(baseflag){
			case OCT:	prompt = "octal"; break;
			case HEX:	prompt = "hexidecimal"; break;
			case DEC:	prompt = "decimal"; break;
			case BIN:	prompt = "binary"; break;
			default: prompt="";
		}/* end switch */
	}

	prepprompt(22); /* clear the prompt line */
	printf("Enter new %s value for field %s : ",
		prompt, namestring);

	scanf("%s",inbuf);
	if ( type == STRING ){
		if (strlen(inbuf) > charlen)
			filerr |=STRINGERR;
		else strncpy(&bootptr[offset],inbuf,charlen);
	} else {
		val = aton(inbuf);
		if (atonerr) 
			filerr |= ATONERR;
		else{
			switch( type ){
				case CHAR:	bootptr[offset] = (char)val;
						break;
				case UCHAR:	bootptr[offset] = (unsigned char)val;
						break;
				case SHORT:bootptr[offset] = ((short)val >> 8) & 0xff;
					bootptr[offset+1] = (short)val & 0xff;
					break;
				case USHORT:bootptr[offset] = ((unsigned short)val>>8) & 0xff;
					bootptr[offset+1] = (unsigned short)val & 0xff;
					break;
				case PTR:
				case ULONG:	
				case LONG:	
				case UINT:	
				case INT:{register int x;	
					for (x=3;x>=0;x--){
					bootptr[offset+x] = 0xff & val;
					val >>=8;
					}
					}
					break;
			default: filerr |= TYPERR;
			} /* end switch on type */
		} /* end if atonerr */
	} /* end of if type is string */
	if(filerr){
	prepprompt(23); /* clear the prompt line */
		switch(filerr){
			case TYPERR:
				printf("Can't figure type of field.");
				break;
			case STRINGERR:
				printf("String too long for field. Maximum = [ %d ] characters.");
				break;
			case ATONERR:
				printf("Value out of range for %s input",prompt);
				break;
			default:
				printf("Some kind of input error");
		}/* end switch on filerr */
		sleep(DIGESTION); /* wait for user to digest message */
	} /* end if filerr true */
} /* end filval */
