#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "icbcmd.h"
#include "hsdttape.h"
#include "hsdtdevdq.h"
#include "vreg.h"
#include "hsdtextrn.h"
#include "hsdtvern.h"
#include "hsdtstruct.h"
#include "data_struct.h"

#define TD0	0
char ver_array[] = {'0','1','2','3','4','5',':','\0','\0','\0','\0','\0','\0','\0'};
extern end;


inithsdt()
{
	register unsigned short intfcard;
	register struct bd_desc *bd;
	register struct dkinf *dkptr;
	register struct devq *bptr, *rptr;
	register unsigned short i;
	register struct dev_desc *devptr;
	struct ddcid *id;
	struct smdwr *wr;
	struct tp *taptr;
	char *cptr;


	/* following is already setup by PROM */
	/* 1. *DTB_IDR = DTC board id #, DMA channel # for HSDT */
	/* 2. *DTC_CRL = enable disk interface card, led light */
	/* 3. *DDC_CR = reset, enable disk data channel */
	/* 4. *DDC_ID0 = setup disk ID0 to 0 */
	/* 5. *DBC_CR = reset all dma */
	/* 6. *DTB_CR = reset DTB function code */
	/* 7. disk timing reg */
	/* 8. vreg information : bd_info, bd_stst, bd_icbint, bc_cpu,
			bd_dtbid, bd_xdtbid */
	/* 9. setup bd vector */

	/* check which kind of interface card */

	bd = &bddesc;
	ver_array[VER_SLOT] = VERNUM + 0x30;
	ver_array[VER_SLOT+1] = '.';
	ver_array[VER_SLOT+2] = RELEASE + 0x30;
	ver_array[VER_SLOT+3] = RELEASE1 + 0x30;
	bd->sysinfptr = (long *)ver_array;
	bd->bd_imcptr = (struct icbcmdhdr *)drive_pointer_array;

	intfcard = *TP_SR & TP_INFC;
	if ( intfcard == TP_9TRKIF )
		bd->bd_ifcard = IFC_TRK9;
	else if ( intfcard & TP_ARIF )
		bd->bd_ifcard = IFC_ARCH;
	else
		bd->bd_ifcard = IFC_DWN;


	/* lock TAS bit to setup vreg */
	locktas();

	bd->bd_dwnld = HSDT_FM2TP;
	bd->bd_devs = 0;

	/* zero disk & tape structure */
	setbuf (input_q, ((int)&status_change-(int)input_q) >>2, 0 );

	/* disk size: default to 84 meg disk */
	cylsize = CYL84_DRV;
	headsize = HEAD84_CYL;
	sectsize = SEC84_HEAD;

	bd->bd_frev	= (VERNUM<<4) | RELEASE;
	bd->bd_memst	= (char *)(&etext+4);
	bd->bd_szmem	= (RAMSTACK-STACKLEN)-(int)(&etext);
	bd->bd_dvptr	= devdesc;
	irqlevl		= ICBLEVL << 13;

	/*initialize the free memory structures */
	init_mem();

	bd->freefst	=  nq;
	rptr = bd->freefst;

	bptr = 0;
	for (i=0; i< NQNUM; i++) {
		rptr->q_prev = bptr;  	/* current */
		bptr = rptr;
		bptr->q_next = ++rptr;
	}
	bptr->q_next = 0;
		

	/* init keyboard buffer pointer */
	init_q();

	/* check which device in */
	if ( intfcard == TP_9TRKIF ) {
		taptr = tapdr;
		for (i=0; i<MAX_TDRIVE; i++)  {
			taptr->tp_type = TP_9TRK;
			taptr++;
		}
			
		ck9track(TD0);
	}
	else
		setape(TD0);
		



	/* determine which device is ready */
	devptr = devdesc;
	if ( tapdr[TD0].tp_type & TAPEON ) {
		devptr->dd_type = DTTAPE;
		devptr->dd_count = 1;
		devptr->dd_un.dd_tape = tapdr;
		bd->bd_devs++;
		devptr++;
	}

	/* device is disk and seekable */
	bd->bd_devs++;
	devptr->dd_type = DTDISK | DTISK;
	devptr->dd_un.dd_pdisk = (struct pd *)phydr;


	printflag = 0;
	for(i=0;i<MAX_PDRIVE-1;i++)
		seekque.s_p_d[i].next_seek_per_disk_ptr = &seekque.s_p_d[i+1];
	seekque.s_p_d[MAX_PDRIVE-1].next_seek_per_disk_ptr = seekque.s_p_d;
	bptr = ipque.i_p_dqfirst;
	ipque.i_p_dqfirst = ipque.i_p_dqfirst->q_next;

	dkptr = phydr;
	for ( i=0; i<MAX_PDRIVE; i++) {
		io_counter_array[i] = &dkptr->io_bcnt;
		drive_pointer_array[i] = dkptr;
		if ( ckdrready (i) == 0 ) {
			devptr->dd_count++;	/* # of disks ready */

			/* indicate drive is ready */
			dkptr->pd_ststat = DK_READY;

			/* open drive */
			initdevq (bptr);
			bptr->q_devtype = DISK;
			bptr->q_devnum = i;
			diskopen (bptr, dkptr);

		}
		dkptr++;
	}
	bptr->q_next = 0;
	ipque.i_p_dqlast->q_next = bptr;
	ipque.i_p_dqlast = bptr;
	

	/* start the clock */
	prgclk();

	/* clear TAS */
	*DTC_CRH = 1;

	/* send interrupt back to master cpu for download code is running */
	intr_cpu ( IMEMCMD );

}

ckdrready (drive)
char drive;
{	register unsigned short i, j;

	for ( i=0; i<10; i++) { 
		if ( unitsel (drive) == 0 )
			return(0);
		j = 100;
		while ( j-- );
	}
	printf ("drive %x not ready\n",drive);
	return (-1);
}


setbuf (ptr, lwcnt, data)
register *ptr; register int lwcnt; register unsigned int data;
{
	while ( lwcnt -- )
		*ptr++ = data;
}

printrc(dev)
register struct devq *dev;
{
	printf (" rc(%x)", *(short *)&dev->rc1);
}

initdevq (dev)
struct devq *dev;
{
	setbuf ( dev, (sizeof (struct devq))>>2, 0 );
}

prchs(dev)
register struct devq *dev;
{
	printf ("C=%3x H=%2x S=%2x ",dev->q_devun.pdisk.cyl,dev->q_devun.pdisk.head,dev->q_devun.pdisk.sector);
}

printlf()
{	printf ("\n");
}

blinkled()
{
	register unsigned short oldpri;
	oldpri = spl6();
	
	if ( (dtc_ctl & 0x03) != greenlit )
		LIGHT (greenlit);
	else
		LIGHT (ledoff);
	splx (oldpri);
}

prbuf ( bufptr, wcnt)
register short *bufptr; register wcnt;
{
	printlf();
	while ( wcnt--) 
		printf ("%4x ", (*bufptr++)& 0xffff);
}

/* ********************************

loadeag(bufptr)
char *bufptr;
{
	if ( *(bufptr+1) == '0' )
		setimid (egdata);
	else if ( *(bufptr+1) == '1' )
		setimid (iddata);
	else
		return (-1);
	return (0);
}

******************************* */

init_mem()
{

	register struct free_mem *p;
	register struct interim_processing_que *ip;
	register struct devq *q;
	register unsigned int numptrs,i,mem_left;

	numptrs = 0x4000/BLKSIZE;
	mem_left = bddesc.bd_szmem - 0x4000;

	dtbarray = (unsigned char *)((int)bddesc.bd_memst+0x4000);
	ip = &ipque;
	ip->freemem_first=(struct free_mem *)((int)dtbarray +
		(MAXPGNUM*DTBP_LEN)+ sizeof(struct mmutbl));
	mem_left -= ((sizeof(struct mmutbl)) + (MAXPGNUM * DTBP_LEN));
	p = ip->freemem_first;
	
	p->fm = (int *)bddesc.bd_memst;
	for(i=0;i<numptrs-1;i++){
		p->fm_next = p + 1;
		p->fm_next->fm = p->fm + (BLKSIZE>>2);
		p = p->fm_next;
	}
	ip->freemem_last = p;
	p->fm_next = (struct free_mem *)0;
	mem_left -= (numptrs * sizeof (struct free_mem));
	
	ip->i_p_mmutable = (struct mmutbl *)((int)dtbarray +
		(MAXPGNUM*DTBP_LEN));
	ip->i_p_dqfirst = (struct devq *)((int)ip->freemem_last+sizeof(struct free_mem));
	NINE_TRACK_MEM = ip->freemem_first;
	for(i=0,q=ip->i_p_dqfirst;i<(mem_left/sizeof(struct devq))-1;i++){
		initdevq(q);
		q->q_next = q + 1;
		q = q->q_next;
	}
	ip->i_p_dqlast = q;
}
