
/******************************************************************************
 *
 * Below are the defines for the ICB command mechanism
 * Single byte commands are passed in the ICB interrupt register.
 * ICB command packets may be passed byte at a time over the ICB int reg or
 * laid down in ICB dual port memory.
 *
 ******************************************************************************/

/* ICB command header structure */
struct icbcmdhdr {
	unsigned char command;
	unsigned char status;
	unsigned char destination;
	unsigned char source;
	unsigned information;
	unsigned short count;
};

/* packet ICB commands */
#define ISTSCMD  0x01 /* self test status command */
#define IPUTCMD  0x02 /* put character command */
#define IGETCMD  0x03 /* get character command */
#define ILEDCMD  0x04 /* write LED command */
#define ICONFCMD 0x05 /* read configuration command */
#define IWMEMCMD 0x06 /* write memory command */
#define IRMEMCMD 0x07 /* read memory command */
#define IJMPCMD  0x08 /* jump command */
#define IGTASCMD 0x09 /* get TAS command */
#define ICTASCMD 0x0a /* clear TAS command */
#define ICONCMD  0x0b /* console command */
#define IWJCMD   0x0c /* write memory and jump command */
#define IBTINFO  0x0d /* return start sector of boot programs (disk only) */
#define ISYSINFO 0x0e /* return start sector of system info (disk only) */

/* packet ICB status */
#define ICMPLT   0x01 /* command complete */
#define IBDEST   0x02 /* bad destination slot address */
#define IILLEG   0x03 /* command not supported */
#define IPARAM   0x04 /* parameter out of range */
#define IABRTD   0x05 /* command aborted */
#define ICBBUSY  0x06 /* ICB busy */

/* single byte ICB commands */
#define ICBSBCMD 0x80 /* icb single byte command bit */
#define IMEMCMD  0x81 /* process a memory resident command packet */
#define IDWNLD   0x82 /* go into download mode */
#define IABORT   0x83 /* abort current icb command */
#define IVRUPDT  0x84 /* the virtual registers have been updated */
#define IDEVREQ  0x85 /* process a devq request */
#define ICBCON   0x86 /* process an icb console command */
#define ICBSTOP_TAPE 0x8a /*stop all tape io because of power fail*/
#define ICBSTOP_IO   0x8b /*stop all io because of power fail */

/* miscellaneous */
#define IPAKSIZ   256 /* max data pack size for ICB register commands */
#define ICBMSTR  0x20 /* use when ICB master slot is unknown */
#define MAXSLOT  0x20 /* maximum number of slots possible */
#define HDRSIZ   sizeof(struct icbcmdhdr)
#define TOTPAK   HDRSIZ+IPAKSIZ
#define FILLHDR(P,C,ST,D,S,I,CT) {P->command = C; P->status = ST; \
P->destination = D; P->source = S; P->information = I; P->count = C;}

struct icbbuf {
	struct icbcmdhdr ich;
	unsigned char idat[IPAKSIZ];
};
