
struct track9 {
	unsigned int tp_rwdone;		/* total bytes tape r/w */
	unsigned int tp_rwleft;		/* number of bytes left */

	unsigned short dtb_cnt;		/* current dtb xfer count */

	unsigned short tp_index;
	unsigned short tp_offset;
	unsigned short tp_count;

	unsigned short mm_index;
	unsigned short mm_offset;
	unsigned short mm_count;

	unsigned int tp_orgcnt;		/* original totcnt */
	unsigned short curtpinc;

	unsigned short tp_fflag;
	unsigned short tapebuf;		/* hsdt addr for last dtb xfer */
	unsigned short tapecnt;		/* cnt for last dtb xfer */

	unsigned short tpmem1;		/* hsdt address for tape dma 1 */
	unsigned short tpcnt1;		/* byte count for tape dma 1 */
	unsigned short tpmem2;		/* hsdt address for tape dma 2 */
	unsigned short tpcnt2;		/* byte count for tape dma 2 */

	unsigned short tdmacnter;

	unsigned short bufcnt1;
	unsigned short bufcnt2;
	unsigned short bufcnt3;
};

/* define bit for tp_flag */
/*
#define DMADONE		0x1		tape dma interrupt took care of all
						dma operation */
#define SENDBYTE	0x2		/* send data to main memory */
#define SENDRESP	0x4		/* dtb dma finished, also send resp */

#define TAPE_EOT	0x8		/* arch tape recieved an eot */


/* #define PAGESIZE	0x1000 */
#define T9BUFSIZ	0x0800

#define T9_RETRY	10		/* retry count in 9 track */
#define T9MAXCNT	0x4000		/* the maximum block size is 32k */

/* *************************************** */
/* mask and definition for SETMODE command */
/* *************************************** */
#define LOWSPEED	0x08
#define HISPEED		0
#define STARTSTP	0x10
#define STREAM		0x0
#define MASK_SPEED	0xf7
#define MASK_STRM	0xef

#define MODEVAL		0x27		/* other bit value in set mode cmd */

/* ***************************** */
/* cmd bit to 9 track tape drive */
/* ***************************** */
#define T9SELECT	0x04		/* select */
#define IFEN		0x00		/* select cmd bit 3:format enable */
#define IFDIS		0x08		/* select cmd bit 3:format dis(reset) */

#define T9STR_HI	0x27		/* set mode: stream, high speed */

#define T9SETDENS	0xa7		/* set tape to 1600 bpi */
				

#define T9STATUS	0xc0		/* status */
#define T9REW		0x61		/* rewind */
#define T9LOAD		0x62		/* load on line */
#define T9UNLOAD	0x63		/* unload on line */

#define T9ERASE		0xaf		/* erase to end */
#define T9ERAFIX	0xab		/* erase fix length */

#define T9WRITE		0x48		/* write data */
#define T9READ		0x80		/* read data */
#define T9FMW		0xa9		/* write file mark */

#define T9FMF		0xa3		/* space file mark forward */
#define T9FMR		0xb3		/* space file mark reverse */

#define T9RECF		0xa2		/* space record forward */
#define T9RECR		0xb2		/* space record reverse */

#define T9DENHI		0xb7		/* set high density */
#define T9DENLOW	0xa7		/* set low density */

/* ********************* */
/* 9 track status byte 0 */
/* ********************* */
#define T9_IRDY		0x80		/* drive ready */
#define T9_IONL		0x40		/* drive on line */
#define T9_IRWD		0x20		/* rewind in process */
#define T9_ILDP		0x10		/* beginning of tape */
#define T9_IEOT		0x08		/* end of tape */
#define T9_IFPT		0x04		/* file protected */
#define T9_ISPEED	0x02		/* high speed */
#define T9_IFBY		0x01		/* format busy */

/* ********************* */
/* 9 track status byte 1 */
/* ********************* */
#define T9_LIDENT	0x10		/* burst ID written*/
#define T9_LHER		0x08		/* hard error */
#define T9_LCER		0x04		/* corrected error */
#define T9_LFMK		0x02		/* file mark */
#define T9_OVRUN	0x01		/* over run */

/* tape status for byte 0, byte 1 */
#define T9_M0 (T9_ILDP | T9_IEOT | T9_IFPT)
#define T9_M1 (T9_LHER | T9_LCER | T9_LFMK | T9_OVRUN)

#define TRD9_M0_B (T9_IEOT)
#define TRD9_M1_B (0)
#define TWR9_M0_B (T9_IEOT | T9_IFPT)
#define TWR9_M1_B (0)

#define TRD9_M0 (T9_ILDP | T9_IEOT)
#define TRD9_M1 (T9_LHER | T9_LFMK | T9_OVRUN)
#define TWR9_M0 (T9_ILDP | T9_IEOT)
#define TWR9_M1 (T9_LHER | T9_LCER | T9_LFMK | T9_OVRUN)
 
#define WAIT_FOR_REWIND		120	/*number of five second time slots that
					a status command will wait for a rewind 					to complete*/
