	/*	HSDT/EDT DATA STRUCTURES	*/


struct dtb_que{
	unsigned char dtb_active; /* the dtb is busy */
	char d_tick;     /* count for dtb timeout */
	struct devq *d_first;
	struct devq *d_last;
};

struct seek_que{
	unsigned char seek_active; /*The disk is either busy seeking or some 
			disk is performing a read/write operation.
	    		As each disk starts a seek operation, the bit position
	    		corresponding to that disk will be set.  When a read/
	    		write operation is started on any disk, all of the disk
	    		bits will be set. */

	struct seek_per_disk *disk_seek_ptr;  /* this pointer is used to select
			the next seek request to be processed.  After the 
			present seek request is processed, the pointer is 
			moved to the next seek_per_disk que with a waiting 
			element. */
    	struct seek_per_disk{
		char s_time;
		struct devq *sort_ptr;
		int sort_count;
		int current_cyl;
		struct devq *s_first;
		struct devq *s_last;
		struct seek_per_disk *next_seek_per_disk_ptr;
    	}s_p_d[4];
};

struct interim_processing_que{
	unsigned char i_p_active;
		/*this flag will have several values:
			1 - busy processing parts of a request; do not
			    allow other read/write processing to start
			2 - mmu table loaded
		*/

	struct devq *i_p_first;
	struct devq *i_p_last;
	struct devq *i_p_dqfirst; /*pointer to the next available free request
				structure */
	struct devq *i_p_dqlast;
	struct mmutbl *i_p_mmutable; /*pointer to the local address of the 
				mmutable for the present request */
	struct free_mem *freemem_first; /*pointer to next free 1k block of 
				local memory*/
	struct free_mem *freemem_last;
	int i_p_block;  /*the block number which we are presently processing
			on the device */
	int i_p_count;	/*the number of bytes that have been transferred 
			so far */
	int i_p_proc_count; /*number of bytes that have been processed and
			placed on another queue for transfer */
};

struct tape_que{
	unsigned char t_active;
	unsigned short t_tick;
	struct devq *t_first;
	struct devq *t_last;
	unsigned char tape_status_waiting;
	struct devq * tape_wait_que[4];
	unsigned waiting_timer[4];
};

/* device type (devq.q_devtype) use defines for dd_type */
#define DTLBUF  4 /* the device is a local memory buffer */

/* q_extdtb use defines for bd_xdtbid */
#define XDDFLT  0xff  /* use the default external dtb in bd_desc (bd_xdtbid) */

#define NUMMUSLOTS 1024

struct  mmutbl {
/*
	short spacer;		spacer put in because the address of the
				mmu table in main memory is on a non long
				word boundary */
	short mmu1index;
	short offset1;
	int   length1;
	short mmu2index;
	short offset2;
	int length2;
	short   mmuslots[MAXPGNUM+4];	/* image of mmu registers */
};

