#include "vreg.h"
#include "data_struct.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "hsdtextrn.h"
#include "devcmd.h"


/* Every element of the interim_processing_que enters this routine.

    Input: dev  -  pointer to the original request

    Output:  1 if no free requests are available
	     0 if everything is OK

    Purpose:  This routine gets a free request pointer and then decides
	whether the request can be handled as one chained request or
	must be broken into several smaller requests to the dtb.

*/

extern que_cnt;
raw_proc(ip)
register struct interim_processing_que *ip;
{
	register struct devq *dev;
	register struct devq *dq;
	register struct mmutbl *m;
	static struct dkinf *dkptr;
	register unsigned short count;


/* Check to see if the entire transfer is complete.  If it is, send the
   request back to the master cpu and clear the interim processing
   structure.
*/

	if(((ip->i_p_count) && (ip->i_p_count >= ip->i_p_first->q_count))||
	    ((ip->i_p_first->q_devtype & TAPE) && (ip->i_p_block == FINISHED)) 
	    || ((ip->i_p_first->q_devtype != TAPE) && 
	    *(short *)&ip->i_p_first->rc1)){
	        enter_short_cr;
		dev = ip->i_p_first ;
		dev->q_count = (ip->i_p_count > dev->q_count) ? dev->q_count :
			ip->i_p_count;
		if((ip->i_p_first = dev->q_next) == (struct devq *)0)
			ip->i_p_last = (struct devq *)0;
		finreq(dev,1);
		ip->i_p_active = 0;
		ip->i_p_proc_count = -1;
		ip->i_p_count = 0;
		exit_short_cr;
		return;
	}

    /* get a free request */
	if(ip->i_p_proc_count != ip->i_p_first->q_count){

		enter_short_cr;
		if((ip->i_p_first->q_devtype == TAPE) && (ip->freemem_first == (struct free_mem *)0)){
			exit_short_cr;
			return;
		}
		if(((dev = ip->i_p_dqfirst) == (struct devq *)0)|| (que_cnt<5)){
			exit_short_cr;
			return;
		}
		ip->i_p_dqfirst = dev->q_next;
		que_cnt--;
		exit_short_cr;
		bcopy(ip->i_p_first,dev,sizeof(struct devq));
		dev->q_next = (struct devq *)0;
		dev->q_mmu = (struct mmutbl *)0;
		dev->q_mem = (char *)0;
		dev->q_flag |= FREE_REQ;
		dev->retry = 0;	/* ensure retry count */
		dev->q_devun.block = ip->i_p_block;
		dev->q_count = ip->i_p_first->q_count - ip->i_p_proc_count;


		if((((ip->i_p_mmutable->offset1&0x3ff) == 0) && 
	    	((ip->i_p_mmutable->length1&0x3ff)==0)) || 
			(dev->q_devtype & TAPE)){
			if(chain_multiple(dev)){
				enter_short_cr;
				if(ip->i_p_dqfirst)
					ip->i_p_dqlast->q_next = dev;
				else
					ip->i_p_dqfirst = dev;
				ip->i_p_dqlast = dev;
				que_cnt++;
				dev->q_next = (struct devq *)0;
				exit_short_cr;
			}
		}

		else{

/* When we enter here, the offset into the page is not a multiple
   of 1k and it is not a tape request 
   This routine will decide the number of bytes left in the
   present page and whether the transfer can be made in one operation
   or a second transfer to local memory will be necesssary.
*/

			m = ip->i_p_mmutable;
			dkptr = drive_pointer_array[dev->q_devnum];

			count = PAGESIZE - m->offset1;

			if(dev->q_count < count) 
				count = dev->q_count ;

			if(count&0x3ff || dev->q_devun.pdisk.sector+(count>>10) > dkptr->sechead){
				enter_short_cr
				if(!(ip->i_p_dqfirst) || 
				    !(ip->i_p_dqfirst->q_next) || 
				    !(ip->freemem_first)){
					if(ip->i_p_dqfirst)
						ip->i_p_dqlast->q_next = dev;
					else
						ip->i_p_dqfirst = dev;
					ip->i_p_dqlast = dev;
					que_cnt++;
					dev->q_next = (struct devq *)0;
					exit_short_cr;
					return;
				}
				exit_short_cr;
				set_up_two(dev,count,dkptr);
			}

			else
				set_up_one(dev,count,dkptr);
		}
	}


	return;

}


set_up_one(dev,count,dkptr)
register struct devq *dev;
register unsigned short count;
struct dkinf *dkptr;
{

	register struct mmutbl *mmu;
	register struct interim_processing_que *ip;
	register struct seek_per_disk *sptr;

	sptr = &seekque.s_p_d[dev->q_devnum];
	ip = &ipque;
	mmu = ip->i_p_mmutable;
	
	dev->q_count = count;
	count >>= 10;
	dev->scnt = count;
	dev->totsleft = count;
	dev->sectleft = count;

#ifndef S90
	dev->q_mem = (char *)(((mmu->mmuslots[mmu->mmu1index] << 12) | 
		mmu->offset1)>>2);
#else
	dev->q_mmu = (struct mmutbl *)(mmu->mmu1index);
	dev->q_mem = (char *)(mmu->offset1);

#endif
	dev->q_flag |= DK_TO_MAIN;
	ip->i_p_proc_count += dev->q_count;
	bump_sector_mmu(ip->i_p_first,count,dkptr);
	ip->i_p_block = ip->i_p_first->q_devun.block;
	mmu->length1 -= dev->q_count;

	enter_short_cr;
	if(sptr->s_first){
		sptr->s_last->q_next = dev;
		dev->q_prev = sptr->s_last;
	}
	else{
		sptr->s_first = dev;
		sptr->sort_ptr = dev;
	}
	sptr->s_last = dev;
	if((seekque.disk_seek_ptr == (struct seek_per_disk *)0)
		    && (!(seekque.seek_active & 
	        	    BIT(dev->q_devnum)))) {
		seekque.disk_seek_ptr = sptr;
	}
	sptr->sort_count++;
	exit_short_cr;


}
set_up_two(dev,byte_count,dkptr)
register struct devq *dev;
register unsigned short byte_count;
struct dkinf *dkptr;
{
	register struct devq *dq,*dq1;
	register unsigned short sector_count = 0;
	register unsigned short requests_seeking = 0;
	struct interim_processing_que *ip;
	struct mmutbl *mmu;
	struct seek_per_disk *sptr;
	struct devq *last_ptr;
	struct dtb_que *dptr;

	sptr = &seekque.s_p_d[dev->q_devnum];
	ip = &ipque;
	mmu = ip->i_p_mmutable;
	

	dev->q_count = byte_count;
	dq = dq1 = last_ptr = (struct devq *)0;

/* first check to see if all of the sectors in the request lie on the 
   same track */

	sector_count = dkptr->sechead - dev->q_devun.pdisk.sector;
	if((sector_count << 10) < byte_count){

/* in this case it does not and therefore we must split up the request 
 * first get a free pointer and have it handle the sectors on one track */

		enter_short_cr;
	    	if((dq = ip->i_p_dqfirst) == (struct devq *)0){
			exit_short_cr;
			return(1);
		}
		ip->i_p_dqfirst = dq->q_next;
		que_cnt--;
		exit_short_cr;
		bcopy(dev,dq,sizeof(struct devq));
		dq->q_next = 0;
		dq->retry = 0;	/* ensure retry count */
		dq->q_mmu = (struct mmutbl *)0;
		byte_count -= (sector_count<<10);
#ifndef S90
		dq->q_mem = (char *)(((mmu->mmuslots[mmu->mmu1index] << 12) 
			| mmu->offset1)>>2);
#else	

		dq->q_mmu = (struct mmutbl *)(mmu->mmu1index);
		dq->q_mem = (char *)(mmu->offset1);

#endif
   		dq->q_flag = FREE_REQ|DK_TO_MAIN;
		dq->q_count = sector_count<<10;
		dq->scnt = sector_count;
		dq->totsleft = sector_count;
		dq->sectleft = sector_count;
		ip->i_p_proc_count += dq->q_count;
		bump_sector_mmu(ip->i_p_first,sector_count,dkptr);
		mmu->length1 -= dq->q_count;
		ip->i_p_block = ip->i_p_first->q_devun.block;
		last_ptr = dq;
		requests_seeking++;

	}
	else sector_count=0;

/* next we see if there is more than one sector to transfer.  If there is,
   full sectors will be transferred directly to main memory
*/

	if((dev->q_count = (byte_count&(~0x3ff)))){
	        dev->q_devun.block = ip->i_p_block;
#ifndef S90
	        dev->q_mem = (char *)(((mmu->mmuslots[mmu->mmu1index] << 12) | 
			mmu->offset1)>>2);
#else	

		dev->q_mmu = (struct mmutbl *)(mmu->mmu1index);
		dev->q_mem = (char *)(mmu->offset1);

#endif
		dev->q_flag |= DK_TO_MAIN;
		dev->scnt = dev->q_count >>10;
		dev->totsleft = dev->scnt;
		dev->sectleft = dev->scnt;
		requests_seeking++;
		dev->q_next = dq;

		if(dev->q_count != byte_count){
			enter_short_cr;
			if((dq1=ip->i_p_dqfirst) == (struct devq *)0){
				exit_short_cr;
				return(1);
			}
			ip->i_p_dqfirst = dq1->q_next;
			que_cnt--;
			exit_short_cr;
	 		bcopy(dev,dq1,sizeof(struct devq));
			dq1->q_next = 0;
			dq1->retry = 0;	/* ensure retry count */
			dq1->q_mmu = (struct mmutbl *)0;
			dq1->q_mem = (char *)0;
			enter_short_cr;
			if((dq1->local_mem = ip->freemem_first)==(struct free_mem *)0){
				exit_short_cr;
				return(1);
			}
			ip->freemem_first=ip->freemem_first->fm_next;
			dq1->local_mem->fm_next = (struct free_mem *)0;
			exit_short_cr;


/* and partial sectors will be transferred first to local memory and then
   the exact byte count will be sent to main memory
*/

   			if(dev->q_cmd == LREAD) 
			    dq1->q_flag = FREE_REQ|DK_TO_LOC;
			else
			    dq1->q_flag = FREE_REQ|MAIN_TO_LOC;
			if(dq)
				dq1->q_next = dq;
			else{
				last_ptr = dq1;
				dq1->q_next = (struct devq *)0;
			}
	        	dev->q_next = dq1;
			requests_seeking++;

			dq1->q_devun.block = ip->i_p_block + dev->scnt;
			dq1->q_mem = (char *)(mmu->offset1+dev->q_count);
			dq1->q_mmu = (struct mmutbl *)(mmu->mmu1index);
			dq1->q_count = ((mmu->length1 - dev->q_count)<= BLKSIZE) ?
				mmu->length1-dev->q_count : BLKSIZE;
			byte_count = dev->q_count + dq1->q_count;
			dq1->scnt = 1;
			dq1->totsleft = 1;
			dq1->sectleft = 1;
		}
	}
	else{

/* this must mean that the total count for this transfer is a less than 1k */
		enter_short_cr;
		if((dev->local_mem = ip->freemem_first) == (struct free_mem *)0){
			exit_short_cr;
			return(1);
		}
		ip->freemem_first=ip->freemem_first->fm_next;
		dev->local_mem->fm_next = (struct free_mem *)0;
		exit_short_cr;

		dev->q_devun.block = ip->i_p_block;
		dev->q_count = (mmu->length1 <= BLKSIZE) ? mmu->length1 
			: BLKSIZE;
		if(dev->q_cmd == LREAD)
			dev->q_flag |= DK_TO_LOC;
		else
			dev->q_flag |= MAIN_TO_LOC;
		requests_seeking++;
		dev->q_next = dq;
		byte_count = dev->q_count;
		dev->scnt = 1;
		dev->totsleft = 1;
		dev->sectleft = 1;
		dev->q_mem = (char *)(mmu->offset1);
		dev->q_mmu = (struct mmutbl *)(mmu->mmu1index);
	}
	ip->i_p_proc_count += byte_count;
	bump_sector_mmu(ip->i_p_first,byte_count>>10,dkptr);
	mmu->length1 -= byte_count;
	ip->i_p_block = ip->i_p_first->q_devun.block;
		
	enter_short_cr;
	if(sptr->s_first){
	    	sptr->s_last->q_next = dev;
	    	dev->q_prev = sptr->s_last;
	}
	else{
		sptr->s_first = dev;
		sptr->sort_ptr = dev;
	}
	if(last_ptr){
		sptr->s_last = last_ptr;
		last_ptr->q_prev = dev;
	}
	else
		sptr->s_last = dev;
	sptr->s_last->q_next = (struct devq *)0;
	if((seekque.disk_seek_ptr == (struct seek_per_disk *)0)
		    && (!(seekque.seek_active & 
	        	    BIT(dev->q_devnum)))) {
		seekque.disk_seek_ptr = sptr;
	}
	sptr->sort_count += requests_seeking;
	exit_short_cr;
	return(0);
}

#ifdef S90
set_raw_blk(ip)
register struct interim_processing_que *ip;
{

	register struct devq *dev;

	enter_short_cr;
	if((dev = ip->i_p_first) == (struct devq *)0){
		exit_short_cr;
		return;
	}
	ip->i_p_mmutable->mmu1index = 1;
	ip->i_p_active |= MMUTABLE_IN;	/* set flag for return to main */
		/* fool the DMC into thinking we have a raw transfer */
	ip->i_p_mmutable->mmuslots[1] = ((int)dev->q_mem); 

	ip->i_p_mmutable->offset1 = 0; /* given 4k boundry */
	ip->i_p_mmutable->length1 = dev->q_count;
	ip->i_p_mmutable->length2 = (int)ip->i_p_mmutable + 20;
	exit_short_cr;
}

#endif
load_mmu(ip)
register struct interim_processing_que *ip;
{

	register struct devq *dev;
	register struct devq *fq;
	register struct dtb_que *dptr;

	dev = ip->i_p_first;
	enter_short_cr;
	if((fq = ip->i_p_dqfirst) == (struct devq *)0){
		exit_short_cr;
		return(1);
	}
	ip->i_p_dqfirst = fq->q_next;
	que_cnt--;
	fq->q_next = (struct devq *)0;
	exit_short_cr;
	setbuf (fq, (sizeof(struct devq)) >>2, 0 );


	fq->q_flag = FREE_REQ|MAIN_TO_LOC;
	fq->local_mem = (struct free_mem *)&(ip->i_p_mmutable->mmu2index);
#ifndef S90
	if((int)(dev->q_mmu)&3){
		fq->q_mem =  (char *)((int)(dev->q_mmu) & ~3);
		ip->i_p_mmutable->mmu1index = 1;
	}
	else{
		fq->q_mem = (char *)((int)dev->q_mmu-4);
		ip->i_p_mmutable->mmu1index = 2;
	}
#else	


	fq->q_mem = (char *)((int)dev->q_mmu);
	ip->i_p_mmutable->mmu1index = 1;


#endif	
	fq->q_cmd = MWRITE;
#ifndef S90
	fq->q_count = (dev->q_count < MAX_RAW_COUNT) ? ((MAX_RAW_COUNT+
	    (ip->i_p_mmutable->mmu1index<<12))>>11) :
	    sizeof(ip->i_p_mmutable->mmuslots);
#else
	fq->q_count = ((dev->q_count + (unsigned short)dev->local_mem +
			 0x1000 -1) >> 12) << 2; /* 4 bytes per page */
#endif
	fq->q_devtype = DTLBUF;
	fq->q_key = dev->q_key;

	dptr = &dtbque;

	enter_short_cr;
	ip->i_p_mmutable->length1 = dev->q_count;
#ifndef S90
	ip->i_p_mmutable->length2 = (int)ip->i_p_mmutable+16;
#else	
	ip->i_p_mmutable->length2 = (int)ip->i_p_mmutable+20;
#endif
	ip->i_p_mmutable->offset1 = (unsigned short)dev->local_mem;
	if(dptr->d_first)
		dptr->d_last->q_next = fq;
	else
		dptr->d_first = fq;

	dptr->d_last = fq;
	fq->q_next = (struct devq *)0;
	exit_short_cr;
}

/* This routine takes the request and determines the number of sectors that
   lie on a single track.  This amount can be handled as a single chained
   request. For each of these requests, a free request is obtained, filled
   in with the proper infomation and placed on the seek queue.  The amount
   processed is updated.  Only one set of requests is processed on each cycle
   so that large raw requests do not monopolize the disk.
*/

chain_multiple(free_q)
register struct devq *free_q;
{
	register int i;
	register struct seek_per_disk *sptr;
	register struct interim_processing_que *iptr;
	register struct mmutbl *mmu = ipque.i_p_mmutable;
	register unsigned int sector_count;
	register int *update_counter;
	struct dkinf *dkptr;

	iptr = &ipque;

	free_q->opr = iptr->i_p_first->opr;
	if(mmu->length1 > 0){
		free_q->q_mmu = (struct mmutbl *)(mmu->mmu1index);
		free_q->q_mem = (char *)(mmu->offset1);
		update_counter = &(mmu->length1);
	}
	else
		return(1);

	if(free_q->q_devtype == DISK){
		dkptr = drive_pointer_array[free_q->q_devnum];
		sector_count = dkptr->sechead - free_q->q_devun.pdisk.sector;
		if(sector_count < (free_q->q_count>>10))
			free_q->q_count = sector_count<<10;
		free_q->scnt = free_q->q_count>>10;
		free_q->totsleft = free_q->scnt;
		free_q->sectleft = free_q->scnt;
		free_q->q_flag |= DK_TO_MAIN;
		iptr->i_p_proc_count += free_q->q_count;

		bump_sector_mmu(iptr->i_p_first,free_q->scnt,dkptr);
		iptr->i_p_block = iptr->i_p_first->q_devun.block;
		*update_counter -= free_q->q_count;
		
		enter_short_cr;
		sptr = &seekque.s_p_d[free_q->q_devnum];
		
		if(sptr->s_first){
			sptr->s_last->q_next = free_q;
			free_q->q_prev = sptr->s_last;
		}
		else{
			sptr->s_first = free_q;
			sptr->sort_ptr = free_q;
		}
		sptr->s_last = free_q;
		free_q->q_next = 0;
		if((seekque.disk_seek_ptr == (struct seek_per_disk *)0)
			    && (!(seekque.seek_active & 
		        	    BIT(free_q->q_devnum)))) {
			seekque.disk_seek_ptr = sptr;
		}
		sptr->sort_count++;
		exit_short_cr;
	}
	else if(free_q->q_devtype & TAPE){
		if((free_q->q_count > BLKSIZE) && (free_q->q_devtype == TAPE))
			free_q->q_count = BLKSIZE;
		free_q->q_flag |= (free_q->q_cmd == LREAD) ? 
			NO_WAIT|TAPE_TO_LOC : NO_WAIT|MAIN_TO_LOC;
		
		adjmmu(free_q->q_count>>10,&(iptr->i_p_mmutable->mmu1index),
			&(iptr->i_p_mmutable->offset1));
		iptr->i_p_proc_count += free_q->q_count;
		*update_counter -= free_q->q_count;
		enter_short_cr;
		if(*(short *)&iptr->i_p_first->rc1){
			exit_short_cr;
			return(1);
		}
		if(free_q->q_devtype == TAPE){
			if((free_q->local_mem=iptr->freemem_first)==(struct free_mem *)0){
				exit_short_cr;
				return(1);
			}
			iptr->freemem_first=iptr->freemem_first->fm_next;
			free_q->local_mem->fm_next = (struct free_mem *)0;
		}
		else
			free_q->local_mem = NINE_TRACK_MEM;

/* If we are writing to the tape then first we must transfer data from main
   memory to our local buffer
*/
		if(free_q->q_cmd == LWRITE){
			if(dtbque.d_first)
				dtbque.d_last->q_next = free_q;
			else
				dtbque.d_first = free_q;
			dtbque.d_last = free_q;
		}
/* otherwise put the request on the tape que to extract data from the tape*/
		else{
			if(tapeque.t_first)
				tapeque.t_last->q_next = free_q;
			else
				tapeque.t_first = free_q;
			tapeque.t_last = free_q;
		}
		free_q->q_next = (struct devq *)0;
		exit_short_cr;
		
	}
	return(0);

	
}

bump_sector_mmu(dev,count,dkptr)
register struct devq *dev;
register unsigned short count;
register struct dkinf *dkptr;
{

	register unsigned char logdr;
	register struct ld *ldkptr;

	adjmmu(count,&(ipque.i_p_mmutable->mmu1index),&(ipque.i_p_mmutable->offset1));

	dev->q_devun.pdisk.sector += count;
	if ( dev->q_devun.pdisk.sector >= dkptr->sechead ) {
		dev->q_devun.pdisk.sector -= dkptr->sechead;

		if ( ++dev->q_devun.pdisk.head >= dkptr->headcyl ) {
			dev->q_devun.pdisk.head = 0;
			dev->q_devun.pdisk.cyl++;
		}

	/* switch heads and check to see if we need to add in skip
	tracks 
	*/
		logdr = dev->q_priority;
		ldkptr = dkptr->pd_ptr + logdr;
		if ( ldkptr->numskiptrack != 0 ) {
			if ( addtrk1 (dev, dkptr, ldkptr) )
				return (-1);
		}
	}
		
}

