/* tape command to archieve tape drive */
#define TFORW			0xa0
#define TSEL			0x10
#define TENS			0x24
#define TERAS			0x22
#define TREW			0x21
#define TWRITE			0x40
#define TWFM			0x60
#define TREAD			0x80
#define TRFM			0xa0
#define TSTATUS			0xc0
#define TQ11			0x26
#define TQ24			0x27


#define TAPE_MAX_CNT		0x40000
#define FTAPELEN		0x1000		/* byte cnt for fast tape rw */
#define TAPEBLK			0x0200

/* define for ftaperw variable */
#define WAIT_DK			0x1		/* wait for disk to finish */
#define FT_ACT			0x2		/* fast tape in active */

/* tape status byte 0, byte 1 from archive drive */
#define T_EX0		0x80		/* exception byte 0 */
#define T_NOCART	0x40		/* cartridge not in place */
#define T_DRNOT		0x20		/* drive not online */
#define T_WRPROT	0x10		/* write protected */
#define T_EOM		0x08		/* end of media */
#define T_URECOV	0x04		/* unrecoverable data error */
#define T_BIE		0x02		/* BIE not located */
#define T_FMD		0x01		/* file mark detected */

#define T_EX1		0x80		/* exception byte 1 */
#define T_ILLCMD	0x40		/* illegal command */
#define T_NODATA	0x20		/* no data detected */
#define T_8RETRY	0x10		/* 8 or more read retry */
#define T_BOM		0x08		/* beginning of media */
#define T_POWER		0x01		/* reset/power up */


/* tape status for each command */

#define TRD_M0_B (T_EX0 | T_NOCART | T_DRNOT | T_EOM)
#define TRD_M1_B (T_EX1 | T_NODATA | T_8RETRY)

#define TWR_M0_B (T_EX0 | T_NOCART | T_DRNOT | T_WRPROT | T_EOM)
#define TWR_M1_B 0

#define TRD_M0 (T_EX0 | T_NOCART | T_DRNOT | T_EOM | T_URECOV | T_BIE | T_FMD)
#define TRD_M1 (T_EX1 | T_ILLCMD | T_NODATA | T_8RETRY)

#define TWR_M0 (T_EX0 |T_NOCART |T_DRNOT |T_WRPROT |T_EOM |T_URECOV|T_BIE|T_FMD)
#define TWR_M1 (T_EX1 | T_ILLCMD | T_NODATA | T_BOM)

#define TRFM_M0	(T_EX0 | T_NOCART | T_DRNOT | T_EOM| T_URECOV | T_BIE | T_FMD)
#define TRFM_M1	(T_EX1 | T_ILLCMD | T_NODATA)

#define TWFM_M0 (T_EX0|T_NOCART|T_DRNOT|T_WRPROT|T_EOM|T_URECOV|T_BIE | T_FMD)
#define TWFM_M1 (T_EX1 | T_ILLCMD | T_NODATA | T_8RETRY)

#define T_M0	(T_EX0 | T_NOCART | T_DRNOT | T_WRPROT | T_EOM)
#define T_M1	(T_EX1 | T_ILLCMD | T_BOM)
	
#define TST_M0 (T_EX0 | T_NOCART | T_DRNOT |T_WRPROT|T_EOM|T_URECOV|T_BIE|T_FMD)
#define TST_M1 (T_EX1 | T_NODATA | T_8RETRY | T_BOM)

/* tape command from main cpu */

#define tcmd_read		1
#define tcmd_write		2

#define tcmd_rewind		3
#define tcmd_weof		4
#define tcmd_reof		5
#define tcmd_status		6
#define tcmd_tension		7
#define tcmd_erase		8
 
