#define LIGHT(x)	(*DTC_CRL = (dtc_ctl=(dtc_ctl & LEDMASK | x) ) )

#define BID	4		/* board id number */
#define DMACHAN	0		/* DMC channel number */
#define ICBLEVL	1		/* ICB interrupt level to main cpu */

#define SLOTMASK	0x1f	/* slot address mask */

/* value in DTC CONTROL REGISTER */
#define ledoff	 	3
#define redlit	 	2
#define greenlit 	1
#define yellowlit 	0
#define ledon		2
#define LEDMASK		0xfc

#define PROMIN		0x00
#define TAPEINT_EN	0x10
#define DDCINT_EN	0x20
#define PROMOUT		0x40
#define DKINTFEN	0x80	/* disk interface enable */

/* offset to compute dma start & end address */
#define DDCDMA		0	/* DDC dma start address offset */
#define DDADMA		2	/* DDA dma start address offset */
#define CHNDMA		4	/* CHN dma start address offset */
#define DTBDMA		6	/* DTB dma start address offset */
#define TPDMA		8	/* TP dma start address offset */

#define DDABFSIZ	4	/* byte size for DDC alt buffer */

/* value for DMC (main memory <-> DTB) parameters 
  BYTE 0:
	bit 7: dma master mode
	bit 6: dma enable
	bit 4: set means main memory->DTB
		not set means DTB->main memory
	bit 3-0: DTC board id 
 */


#ifndef S90
#define WR_DTB 0xc0		/* local mem/disk -> DTB -> main memory */
#define RD_DTB 0xd0		/* main memory ->DTB ->local mem/disk */
#else
#define WR_DTB 0x80		/* local mem/disk -> DTB -> main memory */
#define RD_DTB 0x0		/* main memory ->DTB ->local mem/disk */
#endif

#define DMC_ABT	0x80		/* abort DMC */

#define DTBP_LEN	8	/* 8 bytes parameters for DTB xfer */

/* value for DTB/DISK data path mode in DBC CONTROL REGISTER (bit 8,9,10) */
#define LOCMDTBX	0x04	/* local memory <-> DTB */
#define DISKDTBX	0x00	/* DISK <-> DTB */
#define WRDTB		0x02	/* write to DTB (disk/local mem -> DTB) */
#define RDDTB		0x00	/* read from DTB (DTB -> disk/local mem) */
#define LOCMEM		0x05	/* DISK <-> local memory */

#define CR_MASK		0xf8	/* mask off bit 8,9,10 */

/* value for DMA enable bit in DBC CONTROL REGISTER */
#define DDC_EN		0x80
#define DDA_EN		0x40
#define CHN_EN		0x20
#define DTB_EN		0x10
#define TP_EN		0x08


/* vale for DMA done in DBC STATUS REGISTER */
#define DDC_DONE	0x80
#define DDA_DONE	0x40
#define CHN_DONE	0x20
#define DTB_DONE	0x10
#define TP_DONE		0x08

#define TP_DMAINT	0x02	/* one of the tape dma completed (9trk) */

/* value for DTB function code in DTB CONTROL REGISTER */
#define FS_WRCHN	0xc1	/* write chained,DTB intfc enable (DTB->mm) */
#define FS_RDCHN	0xc5	/* read chained,DTB intfc enable (mm->DTB) */
#define FS_SINT		0xc9	/* abort DTB transfer */

#define CRRLASTINT	0x0100	/* clear read last int */
#define CRWLASTINT	0x0200	/* clear write last int */
#define CRSNDINT	0x0400	/* clear send interrupt */
#define CRRDSTATINT	0x0800	/* clear read status int */

/* value in DTB STATUS REGISTER */
#define DTBRDLAST	0x01	/* DTB read last cmd interrupt */
#define DTBWRLAST	0x02	/* DTB write last cmd interrupt */
#define DTBSNDINT	0x04	/* DTB send interrupt cmd */
#define DTBRDSTAT	0x08	/* DTB read status cmd */

/* value for OPSEL1 OPSEL 0 in DDC CONTROL REGISTER */
/* stored in dev->opr */
#define OPR_RDID	0x00
#define OPR_WRID	0x01
#define OPR_READ	0x02
#define OPR_WRITE	0x03
#define NO_OP		0x0f

#define INDEX		0x08
#define ENDKDATAC	0x40
#define DK_START	0x80

/* value in DDC STATUS REGISTER */
#define DONEDDC		0x80
#define HEAD_SEARCH	0x40
#define RDYC_FAULT	0x20
#define DATA_OVR	0x04
#define ALT_MODE	0x02
#define CRC_ERR		0x01

/* value in DISK BUS REGISTER WRITE: write enable seek end interrupt bit */
#define ENSEEKEND	0x8000

/* value in DISK STATUS REGISTER READ */
#define SEEKEND		0x4000

/* value in TAPE CONTROL REGISTER (write) */
#define TP_ONLINE	0x8000
#define TP_NONLINE	0x0
#define TP_REQ		0x4000
#define TP_RESET	0x2000
#define TP_DUALEN	0x1000		/* dual dma enable */
#define TP_LSTXFER	0x0800		/* last tranxfer */

/* value in TAPE STATUS REGISTER (read) */
#define TP_EXCPT	0x8000
#define TP_READY	0x4000

#define TP_INFC		0x3000		/* mask bit for interface card */
#define TP_9TRKIF	0x2000		/* 9 track, dual port */
#define TP_ARIF		0x1000		/* arch tape, dual port */
#define TP_DWNIF	0x3000		/* down rev(arch tape)interface card */

#define TP_DMASTP	0x0800		/* tape dma stop */
#define TP_DMACTR	0x0400		/* tape dam ctr select */


/* ******************************************************* */

/* value in read unit status (drive 2312) (DISK STATUS REGISTER READ) */
#define UNIT_RDY	0x01
#define CYLNON		0x02
#define SEEKER		0x04
#define DEVCK		0x08
#define WRPROT		0x10

#define UNIT_NOT_RDY    0x01
#define SEEKMASK	0x0f		/* check bit 0-3 */
#define SEEKOK		0x03		/* unit ready, cyl on = true */

/* value in write control select (drive 2312) (DISK BUS REGISTER WRITE) */
#define REZERO		0x40
#define FAULTCLR	0x10

#define TIMIDCNT	16		/* num of bytes of timing id reg */
#define TIMLCNT		4		/* long word cnt of timing id reg */
