#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"

int *pskip();
/*
	disk cmd = 1,2 (read/write) :
	logical drive, MULTIPLE logical sectors, reprg c,h,s if hit alt sector

	(unix block io)
	it will SKIP bad track if any
 */
ldlogrw(dev,dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	register unsigned char logdr;
	register struct ld *p;
	register struct mmu *m;

	/* ********************************************************** */
	/* contiguous memory - maximum 0xFF sectors(0x3fc00 bytes)     */
	/* non-contiguous memory - maximum 0x100 sectors(0x40000 bytes) */
	/* ********************************************************** */

	logdr = dev->q_devtype;		/* get log drive number */
	dev->q_devtype = DISK;

	/* ***************************************************** */
	/* save logical drive number for adding skip tracks later */
	/* ***************************************************** */
	dev->q_priority = logdr;


	/* if the physical drive is not open, then the drive is not ready */

	if ( ckopdrive(dev, dkptr) )
		return(1);

	/* convert logical sectors within the logical drive to
		absolute logical sectors within the physical drive */

	if ( logdr >= dkptr->pd_ldnum ) {
		dev->rc1 = DER_NLOG;
		return(1);
	}

	/* pointer to logical drive structure */
	p = dkptr->pd_ptr + logdr;

	/* insure that all blocks are within range */
	if ((dev->q_devun.block + (dev->q_count>>BLKSIZBIT)-1) >= p->ld_size ) {
		dev->rc1 = DER_ISEC;
		return(1);
	} 
	dev->q_devun.block += p->ld_strt;

	/* convert absolute logical sector to c,h,s */
	if ( convl2p (dev, dkptr) )
		return(1);

	/* add skip track */
	if ( addtrk ( dev, dkptr, p) )
		return(1);

	/* insure c,h,s is not out of range */
	if ( ckchs (dev, dkptr) )	/* dev->rc1 will be set if error */
		return(1);


	/* ********************************************************* */
	/* dev->scnt = dev->totsleft = total sectors rw in a request */
	/* check to see if the sectors will overlap a track          */
	/* calculate the number of sectors to do for current track   */
	/* ********************************************************* */

	if ( (dev->q_devun.pdisk.sector + (dev->q_count>>BLKSIZBIT) ) > dkptr->sechead )
		dev->scnt = dkptr->sechead - dev->q_devun.pdisk.sector; 


	/* sectors to do on a single track */
	dev->sectleft = dev->scnt;


	return(0);
}


/*
	disk cmd = 3,4 (read/write) :
	physical drive, MULTIPLE physical sectors (c,h,s),
		if hit any alt sector, will just return.
		do not continue to read the rest of c,h,s
		no skip track
		(used by disktest)

	disk cmd = 7,8 (read/write):
	physical drive, MULTIPLE physical sectors (c,h,s),
		if hit any alt sector, will reprg c,h,s and r/w the
		alternate sector, and continue r/w the rest of the sectors.
		NO skip track

 */
phyrw ( dev,dkptr)
register struct devq *dev; 
register struct dkinf *dkptr;
{
	register struct ld *p;

	if ( ckopdrive(dev, dkptr) )
		return(1);

	/* insure multiple sectors don't overlap a track */
	if ( (dev->q_devun.pdisk.sector + dev->scnt) > dkptr->sechead ) {
		dev->rc1 = DER_MULS;
		return(1);
	}


	/* ******************************************** */
	/* no need to get spare for cmd PREADPS/PWRITPS */
	/* ******************************************** */
	if ( (dev->q_cmd == PREADPS) || (dev->q_cmd == PWRITPS) )
		dev->q_flag |= NOALT;

	ckchs (dev, dkptr);
	/* dev->rc1 will be set if error */

	dev->q_mmu = (struct mmutbl *)0;

	return(0);
}


/*
	disk cmd = 5,6 read/write:
	physical drive, reprg c,h,s 
	rw multiple logical sectors in the reserved area, allow sparing 
	and skip track, also check for size of reserved area 
	do not support non-contiguous memory
	
 */
pdlogrw ( dev,dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	unsigned int cyltrack; register unsigned short *ptr;
	

	/* if physical drive not opened,return an error */

	if ( ckopdrive(dev, dkptr) )
		return(1);

/*
	if ( (dkptr->pd_ststat & DK_INIT) == 0){
		dev->rc1 = DER_NRDY;
		return(1);
	}

*/
	/* ****************************************** */
	/* only allow rw sectors within reserved area */
	/* ****************************************** */
	if ( (dev->q_devun.block + dev->scnt - 1 ) > dkptr->rv_size ) {
		dev->rc1 = DER_ISEC;
		return(1);
	}

	/* convert absolute logical sector to c,h,s */
	if ( convl2p ( dev, dkptr) )
		return(1);

	/* ******************************** */
	/* add skip track for reserved area */
	/* ******************************** */
	if ( dkptr->numskiptrack ) {
		printf ("resv skiptrk ");
		ptr = (unsigned short *)&cyltrack;
		*ptr = dev->q_devun.pdisk.cyl;
		*(ptr+1) = dev->q_devun.pdisk.head;

		cyltrack = ppskip(cyltrack, dkptr->skplist,
				dkptr->numskiptrack, dkptr);
		if ( PRINT2 ) {
			prchs (dev);
			printf ("(%x %x)\n", *ptr, *(ptr+1));
		}

		dev->q_devun.pdisk.cyl = *ptr;
		dev->q_devun.pdisk.head = *(ptr+1);
	}

	if ( ckchs (dev, dkptr) )
		return(1);

	/* ********************************************************* */
	/* dev->scnt = dev->totsleft = total sectors rw in a request */
	/* check if sectors rw will overlap track                    */
	/* calculate how many sector to do for current track         */
	/* ********************************************************* */

	if ( (dev->q_devun.pdisk.sector + dev->scnt ) > dkptr->sechead )
		dev->scnt = dkptr->sechead - dev->q_devun.pdisk.sector; 

	/* sector to do on single track */
	dev->sectleft = dev->scnt;

	/* dev->scnt, dev->sectleft = sectors rw on a track */
	/* dev->totsleft = total sectors rw in a request */
	dev->q_mmu = 0;

	return(0);
}




addtrk (dev, dkptr, ldkptr)
register struct devq *dev;
register struct dkinf *dkptr;
register struct ld *ldkptr;
{
	unsigned int cyltrack; register unsigned short *chptr;

	if ( ldkptr->numskiptrack == 0 )
		return(0);


	/* cyl and head each occupy a single word */
	chptr = (unsigned short *)&cyltrack;
	*chptr = dev->q_devun.pdisk.cyl;
	*(chptr+1) = dev->q_devun.pdisk.head;


	/* ************** */
	/* add skip track */
	/* ************** */
	cyltrack = ppskip(cyltrack, ldkptr->skplist,ldkptr->numskiptrack,dkptr);

	if ( PRINT2 ) {
		prchs (dev);
		printf ("(%x %x)\n", *chptr, *(chptr+1));
	}

	dev->q_devun.pdisk.cyl = *chptr;
	dev->q_devun.pdisk.head = *(chptr+1);
	return(0);
}

/* *********************************************************** */
/* return pointer to an entry that is greater than the cyltrack num */
/* *********************************************************** */
int *
pskip(track, skiplist, nel)
register int track;		/* Key to be located */
int *skiplist;			/* Beginning of table */
unsigned nel;			/* Number of elements in the table */
{
	register int *first = skiplist;
	register int *last = &skiplist[nel-1]; /*Last element in table*/
	register int res;

	while(1) {
		register int *p;

		p = first + ((last - first) >> 1);
		res = track - *p;

		if (res == 0)
			return(p+1);	/* Key found */
		if (res < 0)
			last = p-1;
		else
			first = p+1;
		if (last < first)
			return(first);
	}
}

/* track:	high word is cylinder number, low word is head num 
   skiplist:	pointer to the skip track list
   nel:		number of skip track
   dkptr:	pointer to physical drive structure

   output:	new cylinder and head number
 */
ppskip(track,skiplist,nel, dkptr)
register nel,track;
register int *skiplist;
struct dkinf *dkptr;
{
    register int *p,*p1;
    register int checksize, currenti,temp,i;

    p1 = skiplist; checksize = nel;
    currenti = 0;

    while(1) {
	p = pskip(track,p1,checksize);
	i = p - p1;

	/* track += i; <-- special track add is needed */

	track = inctrack ( track, dkptr, i );

	if(i == 0)
	    break;
	currenti += i;

	if ( (temp = nel - currenti) <= 0 )
	    break;
	checksize = i >= temp ? temp : i ;
	p1 = p;
    }

    return(track);
}


ckchs (dev, dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	if ( (dev->q_devun.pdisk.cyl >= dkptr->cyldisk) ||
	     (dev->q_devun.pdisk.head >= dkptr->headcyl)||
	     (dev->q_devun.pdisk.sector >= dkptr->sechead) ) {
		dev->rc1 = DER_ISEC;
		return(-1);
	}
	return(0);
}

inctrack ( track, dkptr, num)
unsigned int track, num;
register struct dkinf *dkptr;
{
	register unsigned short *ptr;
	register unsigned short cyl, headn;
	
	ptr = (unsigned short *)&track;
	cyl = *(ptr);
	headn = *(ptr+1);

	/* increment track num */
	headn += num;
	while ( headn >= dkptr->headcyl ) {
		headn -= dkptr->headcyl;
		cyl++;
	}
	
	return ( ((cyl <<16) & 0xffff0000) | headn );
}

