#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdtextrn.h"
#include "vreg.h"


/* YL command, list save in 0xa000-0xcfff */
#define La000	0xa000
#define MD_LEN	0x3000	
/*
 *	Y <address> <drive> <cyl> <head> <sector> <sector count>
 *
 *	media defected list read into buffer on the stack
 *	for YL command, the entire list saved in buffer La000(for 0x3000 length)
 */
/* read media defect off the drive */
rdefectm(bufptr)
char *bufptr;
{	register char *cptr; register int *sptr;
	register struct devq *dev; register struct dkinf *dkptr;
	register unsigned short cyl; register unsigned char head;
	int dummy; int count; char buf[30];

	dev = &req;
	initdevq (dev);
	dev->q_devtype = DISK;
	cptr = bufptr+1;

	if ( inputarg (bufptr, cptr, dev) )
		return (-1);
	dev->opr = OPR_RDID;

	/* use memory on stack */
	dev->q_mem = (char *)((int)(buf+2) & 0xfffffffc);

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}


	cyl = dev->q_devun.pdisk.cyl;
	head = dev->q_devun.pdisk.head;

	if ( ckformat (dev,dkptr) == 0 ) {
		/* timeout on readid, means disk already formatted,
			 can't read media defect */
		return (0);
	}

	if ( *cptr == 'L' ) {

		/* *********************** */
		/* media list save at La000 */
		/* *********************** */
		setbuf (La000, 0x1000/4, 0);
		dev->q_devun.pdisk.cyl = 0;
		dev->q_devun.pdisk.head = 0;
		cyl = cylsize-1;		/* end limit */
		head = headsize-1;
	}
	else {
		dev->q_devun.pdisk.cyl = cyl;	/* restore cyl,head */
		dev->q_devun.pdisk.head = head;
	}	

	sptr = (int *)La000;

	count=0;
	while ( con_in() != 'Q' ) {
		if ( (*cptr == 'L') && PRINT1 ) {
			prchs (dev);
			printf ("\r");
		}

		setbuf (dev->q_mem, DEFM_LEN/4, 0 );

		/* *********************************************** */
		/* media defect list read into buffer on the stack */
		/* *********************************************** */

		dev->q_flag |= DK_TO_LOC;	/* data into local memory */
		if ( dummy = rwid(dev, dkptr, DEFM_LEN,0) ) {
			printf ("\nnolist");
			printrc(dev);
		}
		else {
			/* check if the list valid */
			if ( (ckmdata(dev) == 0) ) {
				sptr = (int *) (recordmed (dev, sptr, &count));	
				if ( (int)sptr >= La000+MD_LEN )
					sptr = (int *)La000;
			}
		}
	
		if ( (dev->q_devun.pdisk.cyl >= cyl) &&
		(dev->q_devun.pdisk.head >= head) ) {
			setimid (iddata);
			if ( *cptr != 'L' ) 
				prbuf ( dev->q_mem, DEFM_LEN >>1 ); 
			else
				printf ("\ncnt=%x\n",count);
			return (0);
		}
		incchs (dev, &dummy);
	}
}
