#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdata.h"
#include "hsdtstruct.h"
#include "hsdtptm.h"
#include "vreg.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "data_struct.h"

#define NOCHAIN	0

unsigned char new_code=0;


struct errb {
	char err; char errno; char *msgptr;
}errtbl[5] =
{	RDYC_FAULT,	DER_RDYCHG,	"rdychg ",
	HEAD_SEARCH,	DER_HDSR,	"hdersrch ",
	DATA_OVR,	DER_OVR,	"dataover ",
	ALT_MODE,	DER_ALT,	"alt ",
	CRC_ERR,	DER_CRC,	"datacrc ",
};

/* changed order of retries to allow read late and early on old micro code */
unsigned short c_retry[] = {0,0x80,0x100,4,8,0x84,0x88,0x104,0x108};

/*
	interrupts are disabled when entering this routine
	if the operation has the wait for completion option, then interrupts
	will be enabled on return

	return:	1 seek error
		2 read/write error
		0 no error
		3 timeout 
 */
diskrw(dev)
register struct devq *dev;
{
	register struct dkinf *dkptr;
	register struct ddcid *id;
	register struct smdwr *wr;
	struct smdrd *rd;
	struct dtb_que *dptr = &dtbque;
	register retbyte, timeout;
	register unsigned short status;
	register int i;
	unsigned char save_ddc;
	static unsigned char test_microcode =1 ;
	unsigned int chaining;
	int j=0;
	

	enter_short_cr;

/*disable all seekend interrupts until after the read/write has completed */

	if(seekque.seek_active&0xf){
	    for(i=0,wr = (struct smdwr *)DK_BUSW; i<MAX_PDRIVE;i++,wr++){
		if(seekque.seek_active & BIT(i))
			wr->seekend = 0;
	    }
	}
	dkptr = drive_pointer_array[i = dev->q_devnum];

	rd = (struct smdrd *)DK_STSR + i;
	status = rd->unitstus & 0x1f;
	if ((dev->opr == OPR_WRITE) && (status & WRPROT)){
		dev->rc1 = DER_NWR;
		finreq(dev,0);
		dptr->dtb_active &= ~DISK;
		seekque.seek_active &= ~(UPPERBIT(i));
		exit_short_cr;
		return(-1);
	}

	
	time_counter_array[i] = clock_cnt;

	/* load timing register */
	if ( (dkptr->pd_ststat&(DK_INIT|DK_TIMIN)) && 
		((dkptr->pd_ststat&0xf) != present_timing)) {
		/* only load the timing registers if the drive is open and
			there are values in the table */
		setimid (dkptr->timing);
		present_timing = dkptr->pd_ststat&0xf;
	}

	/* **************************** */
	/* save operation code in structure */
	/* load timing register 2       */
	/* load timing register 9 and A */
	/* **************************** */

	*DDC_TR2 = 0x80;

	*DDC_TRA = (dev->opr == OPR_READ) ? 0 : 0xff;

	*DDC_TR9 = 0xff;


	/* clear the interrupt word */
	inturpt &= ~(DTB_INT | DDCDMA_INT | DDADMA_INT | CHNDMA_INT | 
		DTBDMA_INT | DDC_INT);


	/* setup the DMA & enable the DMA */
	chaining = (dev->q_mmu) ? (int)dev->q_mmu : NOCHAIN;
	setupdma(dev, dev->scnt * BLKSIZE, chaining);

	/* setup DDC ID register, DDC sector register */
	id = (struct ddcid *)DDC_IDR;
	id->flag = 0;
	id->cylh = *(char *)&dev->q_devun.pdisk.cyl;
	id->cyll = dev->q_devun.pdisk.cyl;
	id->head = dev->q_devun.pdisk.head;

	*DDC_SCR = dev->q_devun.pdisk.sector << 8 | dev->scnt;
	wr = (struct smdwr *)DK_BUSW + dev->q_devnum;

	/* 20 u sec, delay after this instruction before DK_START */
	wr->head = dev->q_devun.pdisk.head;
	wr->control = 0;

	for (i=0; i<10; i++);	/* delay */

	if(dev->q_flag & RETRY_CRC){
		wr->seekend = ENSEEKEND | (c_retry[dev->q_extdtb]);
		*DDC_TRC = 0xff;
	}


	/* program DDC control register */
	*DDC_CR = dev->opr;
	*DDC_CR = ENDKDATAC | dev->opr; 
	save_ddc = DK_START | ENDKDATAC | dev->opr; 
	*DDC_CR = save_ddc;

	if(test_microcode){
		if(!(*DDC_SR & HEAD_SEARCH)) 
		{
			new_code = 1;
			printf("NEW MICRO CODE 5-19-89\n");
		}
		else
			printf("Micro code out of date: replacement advised\n");
		test_microcode = 0;
	}

	dtc_ctl |= DDCINT_EN;
	*DTC_CRL = dtc_ctl;		/* enable ddc done interrupt */
	

	if(dev->q_flag&RETRY_CRC){
		while(((rd->unitstus & 3) != 3)&&( j++ <= 2000));
		*DDC_CR = save_ddc & ~DK_START;
		*DDC_CR = save_ddc;
	}

	/* ****************************************************** */
	/* program clock to monitor a r/w timeout                 */
	/* If there is a timeout, we need to reset the disk drive */
	dptr->d_tick =  TICK_1SEC;
	/* ****************************************************** */


	/* only return if we sent it to main memory and don't wait */
	if ( (dev->q_flag & OPEN_DISK) == 0){
		/* disk <->mm  and don't wait */
		exit_short_cr;
		return(0);
	}


	dptr->d_tick =  0;

	exit_short_cr;

	/* wait for DDC done (level 6)*/
	/* put in a timeout, incase we are using the wrong timing register */
	timeout = TIMEOUT;
	for ( i=0; i<0x00050000/4; i++) {
		if ( inturpt & DDC_INT ) {
			timeout = 0;
			break;
		}
	}


	/* disable interrupts to check for error */
	enter_short_cr;

	dtc_ctl &= ~DDCINT_EN;		/* turn off ddc interrupts */
	*DTC_CRL = dtc_ctl;

	/* reset the disk channel if there is an error */
	checkrw (dev);
	
	exit_short_cr;

	if ( timeout ) {
		dev->rc1 = DER_ILTIM;
		if((dptr->d_first = dev->q_next) == (struct devq *)0)
			dptr->d_last = (struct devq *)0;
		dptr->dtb_active &= ~DISK;
		seekque.seek_active &= ~(UPPERBIT(dev->q_devnum));
		return (timeout);
	}

	if ( dev->rc1 || dev->rc2 )
		return (-1);
	return (0);


}

/* **************************************************
	return the number of sectors done on that track
	check rc1 rc2 for error
***************************************************** */

checkrw(dev)
register struct devq *dev;
{
	register unsigned char ddcstatus;
	register unsigned short intrptbit;
	register unsigned char sectdone;


	/* ********************** */
	/* turn off tick for disk */
	/* ********************** */
	dtbque.d_tick = 0;

	if ( dev->q_flag & (DK_TO_LOC|LOC_TO_DK) ) {
		intrptbit = DDCDMA_INT; /* disk <-> local memory) */
		dbc_cr &= ~(DDC_EN + DDA_EN);
	}
	else {
		intrptbit = CHNDMA_INT + DTB_INT; /* disk <-> DTB */
		dbc_cr &= ~(CHN_EN + DDA_EN);
	}

	inturpt &= ~( intrptbit + DDADMA_INT + DDC_INT);
	*DBC_CR  = dbc_cr;

	/* may not get ddcdone bit set in DDC_SR */
	ddcstatus = *DDC_SR;

	/* turn off  bits in  DDC control register */
	*DDC_CR = ENDKDATAC;

	/* compute which sector is bad */
	sectdone = dev->scnt - (unsigned char)(*DDC_SCR);
	dev->totsdone += sectdone;
	dev->sectleft -=  sectdone;

	/* no error from disk */
	if ( (ddcstatus & ((unsigned char)~DONEDDC) ) == 0 ) {
		return (sectdone);
	}

	if ( ckddc (dev, ddcstatus) == 0 )
		return(sectdone);

	/* some kind of error, reset DDC */
	*DDC_CR = 0;
	*DDC_CR  = ENDKDATAC;

	/* **************************************************************** */
	/* if ready change error or fault error, need to clear fault/rezero */
	/* **************************************************************** */
	if ( ddcstatus & RDYC_FAULT )
		clrfault(dev);

	/* interrupts are still disabled*/

	if ( (dev->q_flag & (DK_TO_LOC|LOC_TO_DK)) == 0 )
		canceldmc();
	return(sectdone);
}


/*
	read/write ID sector can have data in main memory or
	local buffer, (DK_TO_LOC in dev->q_flag )
	dev->q_flag must have WAIT bit = 1 (always wait to complete)

	DDC timing register is already set 

	read id (E command), format sector, format alt sector,
	read defective media 

	return:	2 if read ID/write ID error
		3 timeout (can't read id)
		0 if no error
 */
rwid(dev, dkptr, dmalength,flag)
register struct devq *dev; struct dkinf *dkptr;
int dmalength;
char flag;
{

	*(short *)&dev->rc1 = 0;

	/* wait for seek and rwid to complete */

	dev->q_flag |= WAIT|RWID;
	dev->totsdone = 0;
	dev->sectleft = dev->scnt;
	dev->q_prev = (struct devq *)dmalength;
	*(char *)&dev->q_mmu = flag;

	setup_and_wait(dev);
	return(1);

}

rw_the_id(dev)
register struct devq *dev;
{
	register struct smdwr *wr;
	register struct dkinf *dkptr = drive_pointer_array[dev->q_devnum];
	register struct dtb_que *dptr;
	struct smdrd *rd;
	register unsigned short i;
	register timeout;
	register unsigned short status;


	/* ************************************ */
	/* insure correct timing register is in */
	/* ************************************ */
	if ( dkptr->pd_ststat & (DK_INIT|DK_TIMIN) )  {
		/* only load timing register if drive is opened and
			there is value in the table */
		setimid (dkptr->timing);
		present_timing = 0;
	}

	enter_short_cr;
	rd = (struct smdrd *)DK_STSR + dev->q_devnum;
	status = rd->unitstus & 0x1f;
	if ( (status & 3 != 0x03) ) {
		printf ("r1");
	}


	/* ****************************** */
	/* load timing register 2         */
	/* load timing register 9 and A   */
	/* ****************************** */
	*DDC_TR2 = 0x80;


	if ( dev->opr == OPR_WRID ) {
		*DDC_TRA = 0xff;
	/* special timing id register (0=write normal id 0xff-write alt id)*/
		*DDC_TRE = *(char *)&dev->q_mmu;
	}
	else {
		*DDC_TRA = 0;
	}
	*DDC_TR9 = 0;

	dev->q_mmu = (struct mmutbl *)0;

	/* ****************** */
	/* no clock for rwid  */
	dtbque.d_tick =  0;
	/* ****************** */
	

	/* ************************************************* */
	/* r/w ID data can be in main memory or local memory */
	/* ************************************************* */
	setupdma ( dev, dev->q_prev, NOCHAIN );

	dev->q_prev = (struct devq *)0;

	/* DDC sector register */
	*DDC_SCR = dev->q_devun.pdisk.sector << 8 | dev->scnt;

	/* program DISK BUS REGISTER for the specified head */
	wr = (struct smdwr *)DK_BUSW + dev->q_devnum;

	/* 20 u sec, delays after this instruction before DK_START */
	wr->head = dev->q_devun.pdisk.head;
	wr->control = 0;

	for (i=0; i<10; i++);		/* delay */

	/* allow ddc done interrupt */
	dtc_ctl |= DDCINT_EN;

	/* program DDC control register */
	*DDC_CR = dev->opr; 
	*DDC_CR = ENDKDATAC  | dev->opr; 
	*DDC_CR = DK_START | ENDKDATAC | INDEX | dev->opr; 



	/* wait for DDCdone bit set in DDC STATUS REGISTER */
	/* wait for 80 m sec(80000 usec)  loop = 0x4e20 */
	/* average instruction takes 1.25usec */

	timeout = TIMEOUT;

	*DTC_CRL = dtc_ctl;
	exit_short_cr;

	for (i=0; i<80000/4; i++) {
		if ( inturpt & DDC_INT ) {
			timeout = 0;		/* able to r/w id */
			break;
		}
	}

	enter_short_cr;

	dtc_ctl &= ~DDCINT_EN;		/* disable ddc interrupts */
	*DTC_CRL = dtc_ctl;

	/* ************************ */
	/* check for any error      */
	/* ************************ */
	ckrwid (dev, dkptr);

	exit_short_cr;			/* enable interrupts again */

	if ( timeout ) {
		*DDC_CR  = 0;
		*DDC_CR  = ENDKDATAC;
		dev->rc1 = DER_TIMEOUT;
		dptr = &dtbque;
		if((dptr->d_first = dev->q_next) == (struct devq *)0)
			dptr->d_last = (struct devq *)0;
		dptr->dtb_active &= ~DISK;
		return (timeout);
	}

	if ( dev->rc1 )
		return (RWERR);		/* there was no timeout, but we got 
					   a disk error */
	return (0);

}

ckrwid(dev,dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	register unsigned char ddcstatus;
	register unsigned short intrptbit;
	register unsigned char sectdone;
	register unsigned short intptbit;


	/* *********************** */
	/* disable certain DMA bits */
	/* *********************** */
	if ( dev->q_flag & (DK_TO_LOC|LOC_TO_DK) ) {
		intrptbit = DDCDMA_INT;			/* disk<->local mem */
		dbc_cr &= ~(DDC_EN + DDA_EN);
	}
	else {
		intrptbit = CHNDMA_INT + DTB_INT;	/* disk <-> DTB */
		dbc_cr &= ~(CHN_EN + DDA_EN);
	}

	intptbit = inturpt;

	inturpt &= ~( intrptbit + DDADMA_INT + DDC_INT);
	*DBC_CR  = dbc_cr;

	/* we may not get ddcdone bit set in DDC_SR */
	ddcstatus = *DDC_SR;

	/* turn off  bits in  DDC control register */
	*DDC_CR = ENDKDATAC;

	/* compute which sector is bad */
	sectdone = dev->scnt - (unsigned char)(*DDC_SCR);
	dev->totsdone += sectdone;
	dev->sectleft -=  sectdone;

	/* set dev->rc1 error code if any */
	ckddc (dev, ddcstatus);

	/* clear the data channel */
	*DDC_CR = 0;
	*DDC_CR  = ENDKDATAC;

	/* **************************************************************** */
	/* if ready change error or fault error, we need to clear fault/rezero */
	/* **************************************************************** */
	if ( ddcstatus & RDYC_FAULT )
		clrfault(dev);

	/* ******************************************************** */
	/* for rwid to main memory, if DTB dma never occurred or rwid */
	/* never completed, or any other error, we need to cancel the DMC  */
	/* ******************************************************** */
	if ( (dev->q_flag & (DK_TO_LOC|LOC_TO_DK)) == 0 ) {
		if ( ((intptbit &(CHNDMA_INT+DTB_INT)) != (CHNDMA_INT+DTB_INT)) 
			|| (sectdone != dev->scnt) || dev->rc1 ) {
			canceldmc();
			/* some kind of error, reset DDC */
			*DDC_CR = 0;
			*DDC_CR  = ENDKDATAC;
			seekque.s_p_d[dev->q_devnum].current_cyl = -1;
		}
	}


}


/* return 0: no error in ddcstatus 
   return -1 for other error
 */
ckddc (dev, ddcstatus)
register struct devq *dev;
register unsigned char ddcstatus;
{
	register struct errb *ptr;
	register unsigned short i;

	/* insure that other bits are not set (check for error) */
	if ( (ddcstatus & ~DONEDDC) == 0 )
		return (0);

	/* print the error */
	if ( PRINT1 ) {
		printf (" ds=%x(b=%x)",ddcstatus, dev->q_devun.block);
		prchs (dev);
	}

	ptr = errtbl;
	for (i=0; i<5; i++) {
		if ( ddcstatus & ptr->err ) {
			dev->rc1 = ptr->errno;
			if ( PRINT1 )
				printf ("%s ", ptr->msgptr);
			break;
		}
		ptr++;
	}

	return (-1);
}


/* ******************************************************************* */ 
/* setup apropriate DMA to rw sector/rw id to main memory/local memory */
/* ******************************************************************* */ 
setupdma(dev, dmalength, chaining)
register struct devq *dev; unsigned int dmalength, chaining;
{
	register unsigned char *bufptr;
	register direction;

	bufptr = dtbbuf;

	if ( (dev->q_flag & (DK_TO_LOC|LOC_TO_DK)) == 0 ) {

		/* setup chain dma for disk <-> main memory */
		if ( (dev->opr == OPR_READ) || (dev->opr == OPR_RDID) )
			direction = WR_DTB;
		else
			direction = RD_DTB;

		if ( chaining || (dev->q_mem == (char *)0))
			/* program multiple chain dma */
			prgdtbchn (dev, direction);
		else {

			*bufptr = direction | bddesc.bd_dtbid;/* boardid num */
#ifndef S90
			*(bufptr+1) = 0;
#else
			*(bufptr+1) = (unsigned char)(((int)dev->q_mem&0xf0000000)>>24);
#endif
			*(short *)(bufptr+2) = dmalength >> 2;/* long word ct */
#ifndef S90
			*(int *)(bufptr+4) = (int)dev->q_mem;

#else
			*(int *)(bufptr+4) = (int)((((int)dev->q_mem&0xfffffff))<<4);
#endif
			/* program CHAIN DMA start & end address with 
				8 bytes buffer containing DTB parameters */
			dmaddr ( bufptr, DTBP_LEN-4, CHNDMA);
		}

		/* setup DDC ALT for spared sectors */
		dmaddr ( altbuf, DDABFSIZ-4, DDADMA);

		/* enable CHAIN DMA, DDA dma program data path */
		mslmdkdtb (direction, DISK);

	}
	else {

		/* ************************* */
		/* disk <-> local memory     */
		/* does not have an MMU structure */
		/* ************************* */

		/* setup DDC dma & DDA ALT dma for disk r/w into local memory */
		dmaddr ( dev->local_mem->fm, dmalength-4, DDCDMA);
		dmaddr ( altbuf, DDABFSIZ-4, DDADMA);

		/* enable DDC & DDC ALT dma, program data path */
		msdklocm ();
	}
}



canceldmc()
{	register unsigned char *bptr;
	register unsigned char status; register i, timeout;
	char buf[10];

	if ( PRINT1 )
		printf ("r3");
	/* disable chain DMA for last request */

	dbc_cr &= ~(CHN_EN);
	*DBC_CR  = dbc_cr ;
	/* *************************************************** */
	/* grab one long word from dtb dma */

	/* disable DTB */
	*DTB_CR = 0;

	/* setup DTB dma to get one long word from main memory */
	dmaddr ( buf, 0, DTBDMA);

	/* DBC control register : local <-> DTB, read from DTB */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;

	dbc_cr |= DTB_EN;		/* enable DTB dma */
	*DBC_CR = dbc_cr;

	/* enable interrupt and return */
	for (i=0; i<10; i++) {
		if ( ((status= *DBC_SR) & DTB_EN) ) {
			if ( PRINT1 )
				printf ("r6");
			break;
		}
	}

	/* disable dtb dma */
	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;

	/* *************************************************** */
	/* abort DMC for last transfer */
	bptr = dtbbuf;

	*bptr = DMC_ABT;

#ifndef S90
	*(bptr+1) = 0;
#endif	
	*((short *)(bptr+2)) = 0;

	dmaddr ( bptr, 0, DTBDMA );

	dbc_cr = (dbc_cr & CR_MASK) | (LOCMDTBX | WRDTB);
	*DBC_CR = dbc_cr;

	*DTB_CR = 0;
	*DTB_CR = FS_SINT;

	dbc_cr = dbc_cr | DTB_EN;
	*DBC_CR = dbc_cr;

	/* *********************************************** */
	/* wait for DTBDMA to happen, no interrupt turn on */
	/* *********************************************** */
	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
		if ( (status = *DBC_SR) & DTB_EN ) {
			timeout = 0;
			break;
		}
	}

	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;

	if ( timeout ) {
		printf ("r5");
		return;
	}

	if ( PRINT1 )
		printf ("r4");
}

clrfault(dev)
register struct devq *dev;
{
	register unsigned short status;
	register struct smdwr *wr; register struct smdrd *rd;


	/*first write to the SMD */
	wr = (struct smdwr *)DK_BUSW + dev->q_devnum;
	wr->control = 0;

	/* then get the status from the SMD */
	rd = (struct smdrd *)DK_STSR + dev->q_devnum;

	status = rd->unitstus;

	if ( status & DEVCK ) {
		wr->control = FAULTCLR;
	}
	else 
		dkrezero (dev->q_devnum,&seekque.s_p_d[dev->q_devnum]);

	dev->rc1 = DER_RDYCHG;
}
