
#	@(#)dsetup.mk	1.3

include $(IROOT)/macdefs
include ../../macdefs

NAME = dsetup
HDR = ../../lib/standhead.o
LIB = -L../../lib -lsc
LIB1 = ../../lib/libsc.a
LDF = ../../lib/ld.util
CRT0 = ../../lib/scrt0.o
SINC = ../../head

CFILES = dsetmain.c dsetsmd.c dsetscsi.c dsetmisc.c dseterr.c \
         dset1.c dset2.c dsetrvio.c dsetldio.c dsetdevq.c
OFILES = dsetmain.o dsetsmd.o dsetscsi.o dsetmisc.o dseterr.o \
         dset1.o dset2.o dsetrvio.o dsetldio.o dsetdevq.o


CFLAG =  -I$(INCRT) -W0,-sp -DSTANDALONE $(CFLAGS)

.SUFFIXES: .c .o

.c.o:
	$(CC) -c -I$(SINC) $(CFLAG) $<

all install:	$(NAME)

$(NAME):	$(LIB1) $(OFILES)
	$(LD) -o $(NAME) -N $(LDF) $(CRT0) $(HDR) $(OFILES) $(LIB)
	nm -xv $(NAME)  > $(NAME).nm
	strip $(NAME)
	../sapatch/sapatch -h $(NAME)

unixstandalone:
	$(MAKE) -ef dsetup.mk "CFLAG=$(CFLAG) -DUNIXSTANDALONE" \
			     "NAME=$(NAME).unix"

clean:
	-rm -f $(OFILES)

clobber: clean
	-rm -f $(NAME) $(NAME).nm

dset.o:		dset.c \
		$(SINC)/dsetup.h \
		$(SINC)/diskconfig.h

dset1.o:	dset1.c \
		$(SINC)/dsetup.h

dset2.o:	dset2.c \
		$(SINC)/dsetup.h \
		$(SINC)/diskconfig.h

rvio.o:		rvio.c \
		$(SINC)/dsetup.h

ldio.o:		ldio.c \
		$(SINC)/diskconfig.h \
		$(SINC)/dsetup.h \
		$(SINC)/dk.h

derror.o:	derror.c \
		$(INCRT)/setjmp.h
