/*----------------------------------------------------------------------------
/ scsidt.h - header for all scsi disktest modules:
/               scsifunc.c
/               scsiinit.c
/               scsitest.c
/
/ Craig J. Kim      June 1988
/ (c) Copyright 1988 ARIX Corp.
/---------------------------------------------------------------------------*/

#define _SCSIDT_

#ifndef _DISKTEST_
#include "disktest.h"                   /* errinfo */
#endif

#ifdef FORMAT
#undef FORMAT
#endif

#ifndef _SCSITEST_
#include "scsitest.h"                   /* _scsi */
#endif

#ifdef DEBUG
#define DBG(statement)  statement
#else
#define DBG(statement)
#endif

extern struct slot_info *scsi_slot;     /* slot pointer needed by PROM */
extern struct devq sc_devreq;           /* device request thru CPU PROM */

extern int      scsi_devtype;           /* device type, e.g. DTDISK */
extern int      scsi_devnum;            /* device unit spec = ctrlr<<4|drv */
extern int      scsi_drvtype;

extern struct _scsi_inquiry     inquiry;
extern struct _scsi_mode_sense  msense;
extern struct _scsi_mode_error  merror;
extern struct _scsi_mode_conn   mconn;
extern struct _scsi_mode_format mformat;
extern struct _scsi_mode_geo    mgeo;
extern struct _scsi_mode_flex   mflex;
extern struct _scsi_read_cap    capacity;
extern struct _scsi_xreq_sense  rerror;
extern struct _scsi_drvparms    scsi_drv[];

/*------------------------------ End of scsidt.h ---------------------------*/
