/*----------------------------------------------------------------------------
/ main.c - disktest
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/
/ Version report for disktest
/
/  1.3
/  allows testing of drives 0-3, fixed initdrive
/  auto update of the bad sector list at the end of the test
/  no format (format code ifdef'd out)
/  this is a release
/
/  special note: a version of this program was given to Penny
/  with format intact as a test program
/
/  1.4
/  format installed permanently
/  allows display of the bad sector list
/  linked at 0x20000
/  code added for startup and return to BOOT
/  many other minor enhancements
/  this is a release
/
/  1.5
/  check for valid track size (30k max)
/  print out disk size info
/  initialize proper size in test_drive
/  fixed logical to physical sector translation
/  fixed extern declaration q_continue in modules dump.c and report.c
/  removed unnecessary argument (sctr_count) from do_op
/
/  2.0
/  new release - new disk format - new prom interface
/  standalone format (scc) - many other changes
/
/  2.1
/  rewrote do_track and retry algorithm fixing multiple errors on single
/      track
/
/  2.2
/  format rewritten (needs new HSDT code).
/  Track buffers now allocated dynamically.
/  2.3
/  added code to clear runt sector ids (a problem with CDC 515Mb disks)
/
/  3.0
/  3/4/86 Peter Logan
/  added code to handle io with both the HSDT and EDT
/
/  3.1
/  5/7/86
/  fixed a bug in pdisk.c which incorrectly loaded timing registers
/  when formatting a drive
/  changed the bits/sector parameter for the 515 meg drive
/
/  4.0
/  12/17/86
/  changed the header files that are used from those in usr/include
/  to those in stand/head
/
/  4.1
/  1/22/87 Peter Logan
/  added parameters to pdisk.c for the Fujitsu 690 MB drive
/
/  4.9
/  04/01/88 Brent Leever
/  Add capability to format and test SCSI devices.
/  Added module headers, comments etc...
/
/  5.0
/  June 1988  Craig J. Kim
/  Complete SCSI support
/---------------------------------------------------------------------------*/

#define MAIN_MODULE

#include "disktest.h"


/*---------------------------------------------------- main() ----------------
/ description:
/
/  A. display copyright, version message
/  B. get unit number from human ( getdrive() )
/  C. call scsitest() or smdtest() depending on drive type
/---------------------------------------------------------------------------*/
main()
{
    printf("\n\nDisktest rev %d.%d\n", version, release);  /* program id.   */

    TrackBuffer = (uchar *) ((uint) &aTrackBuffer[3] & ~0x03);
    CompBuf = (uchar *) ((uint) &aCompBuf[3] & ~0x03);
    BadBuf = (uchar *) ((uint) &aBadBuf[3] & ~0x03);
    badblock = (uint *) BadBuf;         /* for scsi bad block reassign */
    TBsize = MAXSECHEAD * SECTSIZ;

    if (setjmp(MenuBuffer))             /* save this moment in time */
        return;

    if (setjmp(GetDrvJmpBuf) == 0)      /* setting up the jump */
        if (!getdrive())                /* get drive id. from user  */
            return;

    PrevUnitNum = UnitNum >> 4;
    ScsiDrv = isscsi(UnitNum >> 4);     /* test for scsi type drive */
    if (ScsiDrv)
        scsitest();                     /* scsi portion */
    else
        smdtest();                      /* smd portion */

    printf("\n");
    return(0);                          /* normal exit */
}

/*---------------------------------------------------- smdtest() -------------
/
/  A. initialize drive ( initdrive() )
/  B. if drive not initialized then
/        format drive ( format() )
/        goto A.
/  C. print DISKTEST command menu
/  D. accept command from human
/  E. case  command option in
/      CHANGE PARAMETERS:
/          get parameters ( get_params() );
/      READ TEST:
/          forever do
/              display statistics
/              perform read test ( test_drive() )
/          done
/      WRITE TEST:
/          forever do
/              display statistics
/              perform write test ( test_drive() )
/          done
/      READ/WRITE TEST:
/          forever do
/              display statistics
/              perform read test ( test_drive() )
/              perform write test ( test_drive() )
/          done
/      CHANGE READ/WRITE TEST PATTERN:
/          get new pattern from human
/      FORMAT DRIVE:
/          goto A.
/      DISPLAY BAD SECTORS LIST:
/          display bad sector information
/      LIST DRIVE INFORMATION:
/          display sector 0 info.
/      SET DEBUG FLAGS:
/  F. goto D
/
/---------------------------------------------------------------------------*/
smdtest()
{
    register char c;
    register unsigned i;

initdrv:
    while (!initdrive())
        if (getyn("Would you like to format the drive"))
            format();
        else {
            printf("Test aborted\n\n");
            return;
        }

    AltPat = FALSE;
    DBPat = FALSE;
    while (1) {
        setjmp(MenuBuffer);
        Pass = 1;
        i = 0;
        SoftDiskErr = i;                /* init for new test */
        HardDiskErr = i;
        CompErr = i;
        if (DBPat)
            Pattern = 0;                /* initialize the read/write pattern */
        else if (!AltPat)
            Pattern = 0xdbdbdbdb;       /* default pattern */
        ErrRootPtr = ErrListPtr = ErrData;
        Compare = FALSE;                /* init */

        printf(Prompt);
        if ((c = getreply()) < 0)
            return;

        if (isupper(c))
            c = _tolower(c);

        switch (c) {
            case 'a':
                get_params();
                break;
            case 'b':
                q_comp_dump();
                while(1) {
                    test_drive(BeginSector,NumOfSectors,PREADPS);
                    ++Pass;
                }
                break;
            case 'c':
                while(1) {
                    test_drive(BeginSector,NumOfSectors,PWRITPS);
                    ++Pass;
                }
                break;
            case 'd':
                q_comp_dump();
                while(1) {
                    test_drive(BeginSector,NumOfSectors,PWRITPS);
                    test_drive(BeginSector,NumOfSectors,PREADPS);
                    ++Pass;
                    if (!AltPat) { /* do not shift an alternate pattern */
                        i = Pattern;
                        Pattern <<= 1;
                        if (i & 0x80000000)
                            Pattern++;
                    }
                }
                break;
            case 'e':
                DBPat = FALSE;
                AltPat = FALSE;         /* init */
                if (getyn("Debug patterns")) {
                    DBPat = TRUE;
                    break;
                }
                if (getyn("Default pattern"))
                    break;
                Pattern = get_num("Enter pattern");
                AltPat = TRUE;
                break;
            case 'f':
                format();
                goto initdrv;
            case 'g':
                disbad();
                break;
            case 'l':
                printdtype(&MthrBlk);
                break;
            case 'z':
                flipdebug();
                debugflag ^= 1;
                printf("Debug is now %s.\n", debugflag ? "on" : "off");
                break;
            case 13:
            case '?':
                printf("\nDisk Diagnostic Menu  ver %d.%d\n", version, release);
                printf("a: change parameters -- existing drive c%dd%d start 0x%x length 0x%x\n",UnitNum>>4,DriveNum,BeginSector,NumOfSectors);
                printf("b: continuous read\n");
                printf("c: continuous write\n");
                printf("d: read/write test\n");
                printf("e: alter pattern -- existing  ");
                if (DBPat)
                    printf("DEBUG\n");
                else
                    printf("%8x\n",Pattern);
                printf("f: format drive\n");
                printf("g: display bad sector list\n");
                printf("l: list physical disk information\n");
                break;
            default:
                printf(BadCmd);
                break;
        }
    }
}

flipdebug()
{
    debugflag ^= 1;                     /* turn it over */
    printf("Debug is now %s.\n", debugflag ? "ON" : "OFF");
}

/*---------------------------------------------------- initdrive() -----------
/ Determines whether or not drive has been initialized properly
/---------------------------------------------------------------------------*/
initdrive()
{
    register unsigned i, lsect;
    register struct md_list *mdptr;
    register struct badlist *badptr;
    char *nsm_msg = "sectors %d & %d are not equal at byte 0x%x...aborting data initialization\n";
    char *dimsg = "data initialization";

    printf("\nInitializing data areas...");
    autosize = 0;
    /*
     * BRENT
     * inittmreg attempts to find a set of timing registers that
     * will read sector 0
     *
     * here we need to call a module that will read sector 0
     * from a SCSI disk.
        */
    if (!inittmreg(&MthrBlk)) {     /* sector 0 is side effect */
        printf("can't read sector0\n");
        /* BRENT
         * Go Back and do an ARIX Format
         */
        return(FALSE);
    }
    /* BRENT
     * read physical sector 1 here
     * psectop() sets up a DTB request structure and does a devreq()
     *
     * PREADPS is defined in the standalone header 'devcmd.h'
     * PREADPS performs a physical read, do not go to an alternate sector
     */
    if(psectop(PREADPS, 0, 0, 1, TrackBuffer, "sector 1 unreadable") < 0) {
        MthrBlk.id[0] = 0;
        return(FALSE);
    }
    /* BRENT
     * CHECK sector 0
     *
     * if ( the mother block id is not "INIT" ) or
     *    ( the version (low byte of data member) is 0xFF ) or
     *    ( the number of logical drives ( slices ) > LOGDR (16) ) or
     *    ( the number of cyls/disk > 7FF (2047) ) then
     *  {
     *  sector 0 does not contain ARIX formatting information
     *  return (FAILURE)
     *  }
     *
    */
    if (wrdcmp("INIT", MthrBlk.id)!=0 || MthrBlk.date[0]==0xff
       || MthrBlk.pd_ldmaxnum > LOGDR || MthrBlk.cyldisk > 0x7ff) {
        /*
         * BRENT
         * why are we doing this ?
         * i guess this is a flag to some other guys that something
         * is wrong.  I notice some guys ( lsectop() for ex. ) check
         * the id. to make sure things are cool
        */
        if (MthrBlk.date[0] != 0xff)
            MthrBlk.id[0] = 0;
        printf("\nsector 0 not initialized\n");
        return(FALSE);
    }
    /* BRENT
     * Should Sector 0 and Sector 1 be the same ?  Apparently SO!
     * Confirm that sector 0 and sector 1 contain the same information
     * No changes here
     */
    if ((i = comp_bufs(&MthrBlk, TrackBuffer,sectsiz)) < sectsiz) {
        MthrBlk.id[0] = 0;
        printf(nsm_msg, 0, 1, i);
        return(FALSE);
    }
    /* BRENT
     * Find physical disk parameters
     *
     * so far we've been able to read sector 0. The contents are
     * in MthrBlk.
     *
     * Now we are going to read sector 0 again into TrackBuffer
     * and compare the soft parameters in MthrBlk with what has been
     * determined by hsized(). apparently hsized() ( which is unchartered
     * wilderness  to me ) figures out these parameters.
    */
    hsized(TrackBuffer, FALSE);     /* see pdisk.c */
    if ( ((struct sector0 *)TrackBuffer)->cyldisk != MthrBlk.cyldisk
        || ((struct sector0 *)TrackBuffer)->headcyl != MthrBlk.headcyl
        || ((struct sector0 *)TrackBuffer)->sechead != MthrBlk.sechead
        || ((struct sector0 *)TrackBuffer)->bytesec != MthrBlk.bytesec ) {
        MthrBlk.id[0] = 0;
        printf("physical disk parameters disagree with those in sector 0\n");
        return(FALSE);
    }
    /* BRENT
     * ARE we Getting Media Defects here ?
     * starting at logical sector 6 i guess, reading 2 sectors
     *
     * Guess we store Media defects in 6 and 7
     *
     * notice we are using lsectop() here, i guess at this point
     * we are confident that MthBlk contains correct information
     *
    */
    mdptr = (struct md_list *)TrackBuffer;
    for(i=0, lsect = 6; i<2; i++) {
        if(lsectop(PREADPS,lsect+i,mdptr+i,"media defect check") < 0) return(-1);
    }
    /* BRENT
     * check out id, better be our MEDSECID!
    */
    if(mdptr->idfield != MEDSECID || mdptr->seqnum != 0) {
        printf("bad media defect sector...aborting %s\n",dimsg);
        return(FALSE);
    }
    /* BRENT
     * AGAIN we compare the two sectors, i guess they are supposed to be
     * the same ?!
     */
    if ((i = comp_bufs(mdptr,mdptr+1,sizeof(struct md_list))) < sizeof(struct md_list)) {
        printf(nsm_msg,6,7,i);
        return(FALSE);
    }
    /* BRENT
     * now we read logical sectors 16 and 17 to get the bad block list
     *
    */
    badptr = (struct badlist *)TrackBuffer;
    for(i=0, lsect = 16; i<2; i++) {
        if (lsectop(PREADPS,lsect+i,badptr+i,"bad sector check") < 0)
            return(FALSE);
    }
    /*
     * check the id field of the BAD block list block and make sure
     * it's what we expect
    */
    if(badptr->idfield != BADSECID || badptr->seqnum != 0) {
        printf("bad sector list faulty...aborting %s\n",dimsg);
        return(FALSE);
    }
    /* BRENT
     * we compare the buffers again!
     */
    if ((i = comp_bufs(badptr,badptr+1,sizeof(struct badlist))) < sectsiz) {
        printf(nsm_msg,16,17,i);
        return(FALSE);
    }

    i = MthrBlk.sechead * MthrBlk.bytesec;
    if (i > TBsize) {
        printf("Disk too large to test.  Out of memory.\n");
        return(FALSE);
    }

    /* BRENT
     * Inform HUMAN of DEVICE TYPE !!!
    */
    printdtype(&MthrBlk);
    BeginSector = 3 * MthrBlk.sechead;  /* default-all but first 3 tracks */
    NumOfSectors = (MthrBlk.cyldisk * MthrBlk.seccyl) - BeginSector;
    WrdsPerSect = MthrBlk.bytesec >> 1;
    return(TRUE);                       /* all is well now */
}

/*---------------------------------------------------- comp_bufs() -----------
/ compare memory areas, a word at a time, return number of bytes
/ that successfully compare
/ Optimized for speed (cjk)
/---------------------------------------------------------------------------*/
comp_bufs(buf_a, buf_b, buf_bytes)
unsigned *buf_a, *buf_b;
unsigned buf_bytes;     /* number of bytes to compare */
{
    register unsigned *j = buf_a, *k = buf_b, *l;

    l = (unsigned *) ((unsigned) buf_a + buf_bytes); /* buffer end */
loop:
    if (j >= l || *j != *k)
        return((unsigned) j - (unsigned) buf_a);
    j++;
    k++;
    goto loop;
}

/*------------------------------ End of main.c -----------------------------*/
