/*----------------------------------------------------------------------------
/ filerr.c
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

char *errmsgs[] = {
	"",
	"sector zero unwritable",
	"illegal disk/tape command",
	"invalid sector number",
	"disk not formatted",
	"invalid sector 0 information",
	"drive not ready",
	"physical drive not mounted",
	"no such logical drive",
	"phy/log drive out of range",
	"invalid data in request",
	"no partial block r/w",
	"too many bits set in status byte",
	"invalid device",
	"invalid dual drive number",
	"too many sectors",
	"hit alternate sector",
	"data CRC error",
	"SEEK error",
	"device check/ready change/not on cylinder",
	"cannot rezero",
	"???",
	"header id error",
	"end of cylinder",
	"overrun",
	"no data",
	"not writeable",
	"???",
	"header search",
	"read/write timeout",
	"wrong gap length",
	"abnormal termination",
};
	
/* file all errors away for display at end of test */
file_error(type,sector,which_byte,bad_val,pat,retry)
	register unsigned type;
	unsigned which_byte;
	unsigned bad_val,pat;
	register struct sectid *sector;
{
	register struct errinfo *ptr, *datend;

	ptr = ErrRootPtr;
	datend = &ErrData[MAXERR];
	while (ptr < datend) {
		if (ptr < ErrListPtr) { /* has this error occurred already? */
			if ((ptr->sectnum.cyl == sector->cyl) &&
				(ptr->sectnum.head == sector->head) &&
				(ptr->sectnum.sector == sector->sector) &&
				(ptr->errtype == type))
					if ((type == 1) && /* on disk err ret code must be equal */
						(ptr->badvalue != bad_val)) ++ptr; /* bump to next structure */
					else {
						if (retry < RETRYCOUNT) ptr->softerrcount++;
						else {
							ptr->harderrcount++;
							/* compensate for the three soft errors it took to get a hard error */
							ptr->softerrcount -= RETRYCOUNT;
						}
						break; /* error is now recorded */
					}
			else ++ptr; /* bump to next structure */
		} else { /* add a new item to the error list */
			ptr->passnum = Pass;
			ptr->sectnum.cyl = sector->cyl;
			ptr->sectnum.head = sector->head;
			ptr->sectnum.sector = sector->sector;
			ptr->errtype = type;
			ptr->bytnum = which_byte;
			ptr->badvalue = bad_val;
			ptr->pattern = pat;
			ptr->softerrcount = 1; /* a hard error would already be listed */
			ptr->harderrcount = 0;
			++ErrListPtr;
			break; /* error is now recorded */
		}
	}
}


log_to_phys(l_sect,p_sect)
	register unsigned l_sect;
	register struct sectid *p_sect;
{	register unsigned temp;

	p_sect->cyl = l_sect / MthrBlk.seccyl;
	temp = l_sect % MthrBlk.seccyl;
	p_sect->head = temp / MthrBlk.sechead;
	p_sect->sector = temp % MthrBlk.sechead;
}

xprintf(f, a, b, c, d)
{
	if (debugflag)
		printf(f, a, b, c, d);
}

errxit(f, a, b, c, d)
{
	printf("disktest ABORT:");
	printf(f, a, b, c, d);
	exit(1);
}

deverr(rc1, rc2)
{	char *p;
	errno = rc1 ? rc1 : rc2;
	if( errno < sizeof(errmsgs) / sizeof(errmsgs[0]) )
		p = errmsgs[errno];
	else	p = errmsgs[0];
	printf("%s (rc=0x%x.%x)\n", p, rc1, rc2);
}

/*--------------------------------- End of filerr.c ------------------------*/
