
get(buf_ptr,buf_size)
	char *buf_ptr;
	unsigned buf_size;
{
	register char c;
	register unsigned charnum;

	charnum = 0;
	while(1) {
		if ((c = pgchar()) == '\r') break;
		switch (c) {
			case '\b':
				if (charnum) {
					printf("\b \b");
					--charnum; --buf_ptr;
				} break;
			default: ++charnum; putchar(c);
				*buf_ptr++ = c; break;
		}
		if (charnum == buf_size) return(-1);
	}
	*buf_ptr = 0; /* terminate the string */
	putchar('\n');
	return(charnum);
}

getlong(buf_vector,ret_val)
	register char **buf_vector;
	unsigned *ret_val;
{
	register char c, *ptr;
	register unsigned value = 0; /* init */

	skipsp(buf_vector); /* skip over possible spaces */
	ptr = *buf_vector;
	while ((c = asc_to_hex(*ptr)) != -1) { /* convert all valid characters */
		value = (value << 4) + c; /* add in value */
		ptr++;
	}
	if (!isdelimit(*ptr) || ptr == *buf_vector) return(-1); /* invalid character or no arg */
	*buf_vector = ptr; /* point where we left off */
	*ret_val = value;
	return(0);
}

getarg(buf_vector,ret_val,num_args)
	char **buf_vector;
	register unsigned *ret_val;
	register unsigned num_args;
{
	while (num_args--) {
		if (getlong(buf_vector,ret_val++) < 0) return(-1);
	}
	return(0);
}
