
#	@(#)dsetup.mk	1.3

include $(IROOT)/macdefs
include ../../macdefs

NAME = defectlist
HDR = ../../lib/standhead.o
LIB = -L../../lib -lsc
LIB1 = ../../lib/libsc.a
LDF = ../../lib/ld.util
CRT0 = ../../lib/scrt0.o
SINC = ../../head

CFILES = dl.c derror.c get.c init.c strtol.c ctype.c
OFILES = dl.o derror.o get.o init.o strtol.o ctype.o

CFLAG = -I$(INCRT) -W0,-sp -DSTANDALONE $(CFLAGS)

.SUFFIXES: .c .o

.c.o:
	$(CC) -c -I$(SINC) $(CFLAG) $<

all install:	$(NAME)

$(NAME):	$(LIB1) $(OFILES)
	$(LD) -o $(NAME)  -N $(LDF) $(CRT0) $(HDR) $(OFILES) $(LIB)
	nm -xv $(NAME)  > $(NAME).nm
	strip $(NAME)
	../sapatch/sapatch -h $(NAME)

syststandalone:
	$(MAKE) -ef defect.mk "CFLAG=$(CFLAG) -DUNIXSTANDALONE" \
			     "NAME=$(NAME).syst"

clean:
	-rm -f $(OFILES)

clobber: clean
	-rm -f $(NAME) $(NAME).nm
