#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdtc.h"
#include "edtdevdq.h"
#include "devcmd.h"
#include "edterror.h"
#include "vreg.h"
#include "edtextrn.h"
#include "data.h"

#define NOLOOP	0

xfermem (dev)
register struct devdq *dev;
{
	register int direction, reprg, oldpri;
	register char dmachan;

	/* check if it is default */
	if ( dev->q_extdtb != XDDFLT ) {
		/* it is not default, insure is using DMC dma channel */
		if (  (dev->q_extdtb & XDTYPMSK) != XDTYPDMA ) {
			dev->rc1 = DER_INF;
			return;
		}
	}

	if (bd_in_system == S90)
		FIXDEVMEM(dev); /* 880211mft */

	/* insure all on long word boundary */
	direction = (int)dev->mem + dev->q_devun.lbuf + dev->totcnt;
	if ( (direction & 0x3) != 0 ) {
		dev->rc1 = DER_INF;
		return;
	}

	if((dev->cmd!=MREAD)&&(dev->cmd!=MWRITE)&&(dev->cmd!=MSTATUS)&&
	(dev->cmd!=MSTARTREAD)&&(dev->cmd!=MSTARTWRITE)&&(dev->cmd!=MRESET)
	&&(dev->cmd!=MSETUPREAD)&&(dev->cmd!=MSETUPWRITE)&&(dev->cmd!=
	MWRITEUCERR)) {
		dev->rc1 = DER_INF;
		return;
	}
	/* need to reprg dma channel if don't match the one in vreg */
	reprg = 0;

	if ( dev->q_extdtb == XDDFLT )
		dmachan = (bddesc.bd_xdtbid & XDIDMSK); /* ??? does nothing! */
	else {
		dmachan = dev->q_extdtb & XDIDMSK;
		if ( dmachan != (bddesc.bd_xdtbid & XDIDMSK) ) {
			/* board id <<4, or in dma channel */
			*DTB_IDR = (bddesc.bd_dtbid <<4) | dmachan;
			reprg = 1;
		}
	}


	if (( dev->cmd == MWRITE ) || ( dev->cmd == MSTARTWRITE ) 
	|| ( dev->cmd == MWRITEUCERR )) {
		if ( ((int)dev->q_devun.lbuf < (int)&promstart-0x10000) || 
		((int)(dev->q_devun.lbuf+dev->totcnt)>(RAMSTACK-STACKLEN)) ) {
			dev->rc1 = DER_INF;
			return;
		}
		/* write to local buffer, and read from DTB */
		direction = RD_DTB;
	}
	else if ( dev->cmd == MSETUPWRITE ) {
		/* set up a write to local buffer, and read from DTB */
		direction = RD_DTB;
	}
	else if ((dev->cmd == MREAD)||(dev->cmd == MSETUPREAD)||(dev->cmd==MSTARTREAD)) {
		/* read from local buffer, and write to DTB */
		direction = WR_DTB;
		if (dev->cmd==MSETUPREAD) extra2 = dev->totcnt;
	}
	else if (dev->cmd == MSTATUS) {
		oldpri=spl6();
		inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
		dmaddr(dev->q_devun.lbuf,8,DTBDMA); /* set address for status byte */
		dbc_cr = DTB_EN | LOCMDTBX;
		dtb_cr = FS_RDSTAT;
		*DBC_CR = LOCMDTBX;
		*DTB_CR = dtb_cr;
		*DBC_CR = dbc_cr;
		splx(oldpri);
		while ((inturpt & 0x10) != 0x10);
		oldpri = spl6();
		dbc_cr &= ~(CHN_EN + DTB_EN);
		*DBC_CR = dbc_cr;
		dtb_cr=0;
		*DTB_CR=0;
		clean_dbc();
		inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
		splx(oldpri);
		dev->q_key = *(unsigned *)(dev->q_devun.lbuf+4);
		reprog(reprg);
		return;
	}
	else if (dev->cmd == MRESET) {
		canceldmc();
		reprog(reprg);
		return;
	}

	memxfer(dev->q_devun.lbuf,dev->mem,(dev->totcnt>>2),direction,NOLOOP, dev->cmd); 
	reprog(reprg);
}

reprog(reprg)
register int reprg;
{
	if ( reprg )
		*DTB_IDR=(bddesc.bd_dtbid << 4) | (bddesc.bd_xdtbid & XDIDMSK);
}
