
#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edttape.h"
#include "edterror.h"
#include "edtdata.h"
#include "edtptm.h"
#include "edtextrn.h"

#define MTPR(port, val) *port = val	/* move to processor register */
#define MFPR(port) *port		/* move from processor register */

#define TAPENUM		0

prgclk()
{
	/* clock will inturpt every 80 ms */
	MTPR ( TM_MSB3, TICKHZ >> 8);
	MTPR ( TM_LSB3, TICKHZ & 0xff);
	MTPR ( TM_C2, PTM_OE | PTM_DUAL8 | PTM_ECLOCK | PTM_REG3);
	MTPR ( TM_C13, PTM_OE | PTM_IE | PTM_ECLOCK);
}

clockint()
{
	register struct tp *taptr;
	register char i; register oldpri;
	register struct dkinf *dkptr;
	register struct devdq *dev;

	oldpri = spl6();

	/* check any disk activity to timeout */
	dkptr = phydr;
	for ( i=0; i<MAX_PDRIVE; i++ ) {
		if ( dkptr->pd_tick ) {
			if ( (--dkptr->pd_tick) == 0 )
				timeoutdisk(dkptr, i);
		}
		dkptr++;
	}


	/* check any tape activity to timeout */

	dev = curtapreq;

	/* *************************************************** */
	/* make sure the tape is actiually moving              */
	/* when tape is using DTB, it also set curtapreq to -1 */
	/* so don't timeout yet */
	/* *************************************************** */

	if ( (dev != 0) && ((int)dev != -1) ) {
		taptr = &tapdr[dev->devnum];
		if ( taptr->tp_tick ) {
			if ( (--taptr->tp_tick) == 0 ) {
				timeoutape(dev, taptr);
			}
		}
	}

	/* check any DTB activity to timeout */
	if ( dtbreq && ( dtb_tick ) ) {
		if ( --dtb_tick  == 0 )
			timeoutdtb();
	}


	/* led for idle */
	if ( ++ledtick >= TICK_1SEC ) {
		ledtick = 0;
		if ( (dtc_ctl & 0x03) != yellowlit )
			i = yellowlit;
		else
			i = ledoff;
		LIGHT (i);
	}


	/* keep clock ticking */
	i = MFPR (TM_S2);
	i = MFPR (TM_MSB3);
	i = MFPR (TM_LSB3);

	splx(oldpri);
	return;
}

timeoutape(dev, taptr)
register struct devdq *dev;
register struct tp *taptr;
{
	register unsigned short intfcard;

	/* timeout on tape */
	/* check which kind of tape interface card */
	intfcard = *TP_SR & TP_INFC;
#ifdef TRACK9
	if ( intfcard == TP_9TRKIF )
		resetape9();
#endif
#ifdef ARCH
	if ( intfcard != TP_9TRKIF ) {
		resetape();
	}
#endif

	dev->rc1 = TP_HANG;
	dev->totcnt = 0;
	dev->flag &= ~OPRDONE;


	/* don't allow tape to inturpt, disable tape dma bit */
	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	inturpt &= (~TAPEDMA_INT + TAPE_INT);
	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;

	if ( dev->flag & TNOWAIT ) {
		/* send response back to master cpu */
#ifdef ARCH
		if ( intfcard != TP_9TRKIF ) {
			curtapreq = 0;
			dev->flag &= ~OPRDONE;
			finreq (dev);
			/* **************************************** */
			/* archive tape never get multiple tape req */
			/* **************************************** */
			/* ####################### */
		}
#endif
#ifdef TRACK9
		if ( intfcard == TP_9TRKIF ) {
			/* ****************************************** */
			/* curtapreq = 0, finreq(), start next 9tape  */
			/* ****************************************** */
			fint9(dev);
		}
#endif
	}
	else {
		/* for fast tape rw */
		inturpt |= TAPE_INT;
	}

}


timeoutdisk(dkptr, drive)
register struct dkinf *dkptr; register char drive;
{
	register struct devdq *dev, *nextdq;
	register unsigned short intrptbit;
	register i, seekon, sendrqback;

	/* reset disk drive */
	/* what happen to other disk ??????????? */
	*DDC_CR = 0;
	*DDC_CR = ENDKDATAC;

	sendrqback = 0;
	dkptr->curcyl = -1;

	if ( dkptr->pd_opr & DK_SEEK ) {
		/* ******************** */
		/* timeout on disk seek */
		/* ******************** */
		printf ("t1");
		if ( (dev=dkptr->next) == 0 )
			stuck();

		dkptr->pd_opr = 0;
		++dev->retry;

		nextdq = dev->forward;

		/* seek timeout, try rezero, rezero got problem, send req
			back to master cpu, pick up next que */
		

		if ( (dev->flag & TNOWAIT) == 0 ) {
			dkptr->pd_opr = DK_SKDONE;
			return;
		}

		if ( dkrezero (dev->devnum, dkptr) ) 
			sendrqback = 1;
		else if (dev->retry >= RETRY )
			sendrqback = 1;

		if ( sendrqback ) {
			dev->rc1 = DER_TIMEOUT;
			dev->flag &= ~OPRDONE;
			finreq(dev);
			/* start next one */
			dkptr->next = nextdq;
		}


		/* start seek on all drive */
		for ( dkptr= phydr; dkptr < (phydr+MAX_PDRIVE); dkptr++) {
			if ( (dev= dkptr->next) != 0 ) {
				if ( dkptr->pd_opr == 0 ) {
					if ( aseek(dev, dkptr, 0) )
						cancelreq(dev, dkptr);
				}
			}
		}


	}
	else {
		/* ****************** */
		/* timeout on disk rw */
		/* ****************** */
		printf ("t2");
		if ( (dev=curwreq) == 0 )
			stuck();

		/* incase there is tape pending */
		nextdq = curwreq->forward;

		/* timout on disk rw */
		dkptr->pd_opr = 0;
		curwreq = 0;


		/* need to cancel dmc */
		if ( dev->flag & DEST_L ) {
			intrptbit = DDCDMA_INT; /* disk <-> local memory) */
			dbc_cr &= ~(DDC_EN + DDA_EN);
		}
		else {
			intrptbit = CHNDMA_INT + DTB_INT; /* disk <-> DTB */
			dbc_cr &= ~(CHN_EN + DDA_EN);
		}

		inturpt &= ~( intrptbit + DDADMA_INT + DDC_INT);
		*DBC_CR  = dbc_cr;


		/* turn off  bits in  DDC control register */
		*DDC_CR = 0;
		*DDC_CR = ENDKDATAC;
 
		/* don't allow ddc done interrupt */
		dtc_ctl &= ~DDCINT_EN;
		*DTC_CRL = dtc_ctl;

		++dev->retry;

		if ( (dev->flag & DEST_L ) == 0 )
			canceldmc();

		if ( dev->flag & TNOWAIT ) {
			if ( dkrezero (dev->devnum, dkptr) )
				sendrqback = 1;
			else if ( dev->retry >= RETRY )
				sendrqback = 1;

			if ( sendrqback ) {
				dev->rc1 = DER_TIMEOUT;
				dev->totcnt = 0;
				dev->flag &= ~OPRDONE;
				finreq (dev);
			}
			else {
				/* ********************************* */
				/* put que back on, start seek again */
				/* ********************************* */
				/* need to fixup sortque and lastque */
				/* ********************************* */
				/* AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA */
				if ( dkptr->next == 0 ) {
					dkptr->pd_sortdq = dev;
					dkptr->pd_lastdq = dev;
				}

				dev->forward = dkptr->next;
				dkptr->next = dev;
			}
		}
		else {
			/* for local wait for completion */
			inturpt |= DDC_INT;

		}
		/* check any tape pending */
		/* or start disk activity again */

		/* check any tape req data transfer pending */
		if ( nextdq ) {
			printf ("t3");
			/* there is tape req, setup dtb to xfer data */
			/* if ( nextdq->opr == TREAD ) */
		/* ************************************* */
		/* ************************************* */
		/* take care of archive tape and 9 track */
		/* ************************************* */
		/* ************************************* */

			if ( nextdq->cmd == TPREAD )
				/* read from tape, write to DTB */
				i = WR_DTB;
			else
				i = RD_DTB;

			/* there should not be any diskrw */
			tapexfer (nextdq, i);
			return;
		}

		/* check any fast tape waiting for dtb */
		if ( ftaperw == WAIT_DK ) {
			ftaperw = 0;
			return;
		}

		/* no tape req pending */
		/* start drive to seek or rw, may be same que again */
		printf ("t4");
		startdisk();
	}

}

timeoutdtb()
{
	register struct devdq *dev;
	register struct dkinf *dkptr;
	register ushort i;

	printf ("t5");

	inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
	dbc_cr &= ~(CHN_EN + DTB_EN);
	*DBC_CR = dbc_cr;
	canceldmc();


	/* AAAAAAAAAAAAAAAAAAAA */
	/* need to start next tape, or disk */
	/*                        --------- */

	dev = dtbreq;

	dev->totcnt = 0;
	dev->rc1 = DER_TIMEOUT;

	if ( dev == curtapreq ) {
		curtapreq = 0;
		dtbreq = 0;
	}
	else {
		printf ("t6");
	}

	dev->flag &= ~OPRDONE;
	finreq (dev);

	/* AAAAAAAAAAAAAAAAAAAAAAAAAAA */
	
	/* check if any disk is waiting for read/write opr */
	/* only can start rw when there is no SEEK is on */
	dkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		if ( (dev=dkptr->next) != 0 ) {
			if ( dkptr->pd_opr == DK_SEEK )
				return;
		}
		dkptr++;
	}

	/* no seek is on, if drive already on same cyl, then start rw */
 	/* if not on same cyl, should able to start seek on all drive */
	/* no need to do seek here */
	/* AAAAAAAAAAAAAAAAAAA */
	printf ("t7");
	startdisk();

	/* AAAAAAAAAAAAAAAAAAAAAAAAAAA */
}

stuck() 
{
	while (1) {
		printf ("clk");
		blkyellow();
	}
}
