#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edttape9.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtextrn.h"
#include "edtptm.h"

/* must be request from master cpu */
/* when using dtb xfer, also setup dtbreq, so dtb inturpt routine
   know it is slow tape  */

#ifdef ARCH
taperw(dev)
register struct devdq *dev;
{
	register oldpri;

	if ( dev->totcnt >TAPMAXCNT ) {
		if ( dev->cmd == TPREAD )
			extaper(dev);		/* fast tape sw */
		else
			extapew(dev);
		return;
	}

	dev->q_devun.block = (unsigned int)dev->mem;
	dev->mem = (char *)LOC1;	/* use for local memory addr */

	
	if ( dev->cmd == TPREAD ) {
		/* if tprw has error, OPRDONE will be set */
		tprw(dev);
	}
	else {
		oldpri = spl6();
		if ( (curwreq) != 0 )
			/* dtb is busy,when disk rw finished, will start this */
			curwreq->forward = dev;
		else
			/* dtb interupt will start tape write */
			tapexfer (dev, RD_DTB);
		splx(oldpri);
	}
	return;
}

#endif

tapexfer(dev, direction )
register struct devdq *dev;
int direction;
{
	register unsigned char *bufptr;
	register unsigned char cmd = 0x11;

/* DDDDDDDDDDDDDDDD */
	if ( dev->flag & 0x8000 )
		errflag (dev);
/* DDDDDDDDDDDDDDDD */
	/* ******************************************************* */
	/* when transfer data from main memory to local memory for */
	/* tape write, also set -1in curtapreq to lockup the tape  */
	/* ******************************************************* */

	if ( direction == RD_DTB )
		curtapreq = (struct devdq *)-1;

	dtbreq = dev;
	bufptr = (unsigned char *)dtbbuf;
	dtb_tick =  TICK_1SEC;

	/* setup 8 bytes DTB parameters */
	*(short *)(bufptr+2) = dev->totcnt >> 2;/* long word cnt */

	*(int *)(bufptr+4) = (int)dev->q_devun.block;/* mm already shifted */

	/* receive data from main memory into local DTC memory */
	xferdata (bufptr, LOC1, direction, DTBNOWAIT, cmd);
}
#ifdef TRACK9
tape9rw(dev)
register struct devdq *dev;
{
	register struct tp *taptr;
	register struct track9 *t;
	register oldpri;

	/* setup retry count and zero out tp_flag */
	taptr = &tapdr[dev->devnum];
	taptr->tp_flag = 0;

	dev->q_devun.block = (unsigned int)dev->mem;
	dev->mem = (char *)LOC1;
	
	t = &trk9;
	setbuf ( t, sizeof (struct track9) >> 1, 0 );

	/* save total byte cnt, incase of retry */
	t->tp_orgcnt = dev->totcnt;

	if ( dev->cmd == TPREAD ) {
		if ( t9rw(dev) ) {
		/* ********************************************* */
		/* can't start tape read                         */
		/* t9rw already take que off the drive structure */
		/* ********************************************* */
			return(-1);
		}
	}
	else {
		oldpri = spl6();
		if ( (curwreq) != 0 )
			/* dtb is busy, when diskrw finished, will start this */
			curwreq->forward = dev;
		else
			/* dtb interupt will start tape write */
			tapexfer (dev, RD_DTB);
		splx(oldpri);
	}
	return(0);
}
#endif
