#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdevdq.h"
#include "edttape9.h"
#include "edtdtc.h"
#include "edtdata.h"
#include "edterror.h"
#include "edtptm.h"
#include "edtextrn.h"
#include "vreg.h"

#define RDSTAT	0x1		/* except on, status read */
#define LOOPCNT	0x19000

char t9err0[] = {
	0,0,0, TP_BOM, TP_EOM, TP_WPROT, 0, 0,
};
char t9err1[] = {
	0,0,0,0,TP_DATER, TP_CDATER, TP_FMD, TP_OVRUN
}; 

char *t9tbl0[] = {
	"-",
	"-",
	"rewind,",
	"bot,",
	"eot,",
	"wrprot,",
	"hispeed,",
	"fmtbusy",
};
char *t9tbl1[] = {
	"-",
	"-",
	"-",
	"1600BPI,",
	"harderr,",
	"correrr,",
	"fm,",
	"overrun",
};
/* ?????? before send9cmd, clear status byte */

/* ***********************************************************
   Disable interrupt 
   send out SELECT cmd, wait for 9 track to accept the command
   wait for READY or EXCPT set, read status and set rc
   restore interrupt level

   output:
	return -1 if 9 track don't communicate, master cpu
		signal power failure
		set dev->rc1, dev->flag |= OPRDONE
	return 0 if selectcmd ok

   *********************************************************** */
/* selectcmd (format, drive) */
selectcmd (format, dev)
register struct devdq *dev; int format;
{	struct devdq dkreq; register struct devdq *p;

	/* interrupt is disabled in sendt9cmd */
	if ( sendt9cmd (format | ((~dev->devnum) & 0x07), TP_NONLINE, dev) )
		/* rc1 = TP_HANG or TP_ABORT */
		return (-1);

	/* wait for READY/EXCPT to be set */

	/* p = &dkreq; */
	/* initdevq (p); */
	/* p->devnum = drive; */
	/*if ( ckt9excpt(p) ) */

	if ( ckt9excpt (dev) )
		return (-1);
	return (0);
}

/* *****************************************************
	when enter this routine, no tape is active
	after sending command, put dev que on curtapreq
 *******************************************************
 */
t9control (dev)
register struct devdq *dev;
{
	register oldpri;
	register struct tp *taptr;
	register unsigned short status;
        register i, j;

	/* **************************************** */
	/* make sure tape drive is online and ready */
	/* selectcmd() will check except/ready      */
	/* **************************************** */
	if ( ckstatus(dev) ) {
		return (-1);
	}


	/* select correct drive, send select cmd with format enable */
	/* if ( selectcmd (IFEN, dev->devnum) ) { */
	if ( selectcmd (IFEN, dev) ) { 
		return (-1);
	}


	/* send data/control cmd */
	taptr = &tapdr[dev->devnum];
	
	if ( sendt9cmd ( dev->opr, TP_NONLINE, dev ) ) {
		return (-1);
	}

	/* allow tape interrupt */
	oldpri = spl6();

	/* don't use tape dma for control cmd */
	inturpt = (inturpt & ~TAPE_INT) | TAPEDMA_INT;

	/* ************************************************* */
	/* program clock to monitor different tape operation */
	/* ************************************************* */
	taptr->tp_tick = TICK_1MIN;

        if ( dev->opr == T9REW )  {
		i = 2404;
		j = 10000;
                taptr->tp_tick = TICK_5MIN;             /* rewind */
		while (i || j) {
			if (--j == -1) {
				j = 10000;
				i--;
			}
			if (*TP_SR & (TP_READY | TP_EXCPT))
				break;
		}
		t9status(dev,1);
        }
	else if ( (dev->opr == T9ERASE) || (dev->opr == T9FMF) ||
		(dev->opr == T9FMR)  )
		taptr->tp_tick = TICK_20MIN;		/* erase,r FM, rev FM */

	/* ******************************************************** */
	/* put que on curtapreq, for tape interrupt serivce routine */
	/* ******************************************************** */
	curtapreq = dev;

	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	splx (oldpri);

	/* check if need to wait for completion */
	if ( dev->flag & TNOWAIT )
		return(0);

	/* local MONITOR COMMAND */
	/* wait for interrupt to happen, if EXCPT is set */
	/* read status and set rc, then return -1        */

	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	/* tape timer will take care here */
	while ( (inturpt & TAPE_INT) == 0 );

	/* tape inturpt happened */

	oldpri = spl6();
	inturpt &= ~(TAPE_INT+TAPEDMA_INT);
	curtapreq = 0;

	splx(oldpri);

	/* get tape status */
	if ( ckt9excpt (dev) )
		return (-1);
	return (0);
}


/* ********************************************************* */
/* always wait for tape to be completed                      */
/* no tape interrupt involved, just poll the status reg      */
/* output:						     */
/*	return 0 if status read ok                           */
/*		dev->flag |= OPRDONE                         */
/*	return -1 if tape track don't communicate            */
/*		dev->rc1 = TP_HANG, dev->flag |= OPRDONE     */
/*	return -1 if master cpu indicate power fail occur    */
/*		dev->rc1 = TP_ABORT, dev->flag |= OPRDONE    */
/* ********************************************************* */
t9status(dev,flag)
register struct devdq *dev;
register flag;
{
	register char *ptr; register unsigned short status;
	register i, oldpri;
	register count;

	if ( bddesc.tas1 & STOPTPIO ) {
		dev->rc1 = TP_ABORT;
		dev->flag |= OPRDONE;
		return (-1);
	}

	ptr = (char *)tapdr[dev->devnum].tp_stat;
	*(short *)ptr = 0;
	count = LOOPCNT;

	/* disable interrupt */
	oldpri = spl6();


	/* REQ + cmd + set/reset online */
	*TP_CR =  TP_REQ | T9STATUS;
	
	/* wait for READY and EXCPT to be reset, - command accpeted */
	/* wait about 2 min */
	while ( ((*TP_SR & (unsigned int)(TP_READY+TP_EXCPT))!= 0)&&(--count) );
			
	if ( count == 0 ) {
		dev->flag |= OPRDONE;
		dev->rc1 = TP_HANG;
		splx(oldpri);
		return (-1);
	}

	*TP_CR = 0;


	/* get 2 bytes of status */
	for ( i=0; i<2; i++) {	
		if (flag) 
			flag = 336;
wloop:		count = LOOPCNT;
		/* wait for READY to be set */
		while ( (((status = *TP_SR) & TP_READY) == 0) && (--count) );

		if ( count == 0 ) {
			if ((i == 0) && flag) {
				flag--;
				goto wloop;
			}
			dev->flag |= OPRDONE;
			dev->rc1 = TP_HANG;
			splx(oldpri);
			return (-1);
		}

		count = LOOPCNT;
		*ptr++ = status & 0xff;

		*TP_CR = TP_REQ;

		/* wait for READY to be reset */
		while ( (*TP_SR & TP_READY) && (--count) );
		if ( count == 0 ) {
			dev->flag |= OPRDONE;
			dev->rc1 = TP_HANG;
			splx(oldpri);
			return (-1);
		}
		*TP_CR = 0;
	}	

	/* wait for READY to be true */
	count = LOOPCNT;
	while ( ((*TP_SR & TP_READY) == 0) && (--count) );
	if ( count == 0 ) {
		dev->flag |= OPRDONE;
		dev->rc1 = TP_HANG;
		splx(oldpri);
		return (-1);
	}

	splx(oldpri);

	if ( PRINT2 )
		ptap9stat(dev);

	/* check beginning of tape, end of tape, file protected */
	/* check hard error on r/w, corrected error, overrun */
	set9rc (dev, T9_M0, T9_M1);
	dev->flag |= OPRDONE;
	return(0);
}

/* ***********************************************
	when enter this routine, no tape is active
	after sending command, put dev on curtapreq

	return -1 if tape drive don't response or 
			power fail occur
 **************************************************
 */
t9rw(dev)
register struct devdq *dev;
{	register oldpri;
	register unsigned int b0, b1;
	register struct tp *taptr;

/* DDDDDDDDDDDDDDDDDDDDDDDDDDDDDD */
	if ( dev->flag & 0x8000 )
		errflag(dev);
/* DDDDDDDDDDDDDDDDDDDDDDDDDDDDDD */

	/* clear dual tape dma, last xfer bit */
	tp_cr &= ~(TP_DUALEN | TP_LSTXFER);

	if ( ckstatus(dev) ) {		/* insure READY or EXP is set */
		dev->totcnt = 0;
		return (-1);
	}

	/* ************************************* */
	/* select correct drive, and read status */
	/* ************************************* */
	if ( selectcmd ( IFEN, dev) )  {
		dev->totcnt = 0;
		return (-1);
	}

	if ( dev->opr == T9READ ) {
		b0 = TRD9_M0_B;
		b1 = TRD9_M1_B;
	}
	else {
		b0 = TWR9_M0_B;
		b1 = TWR9_M1_B;
	}

	/* set appropriate error code before reading / writing */
	set9rc (dev, b0, b1);
	if ( *(short *)&dev->rc1 ) {
		printf ("p1");
		dev->totcnt = 0;
		return (-1);
	}

	/* **************************************** */
	/* insure the speed and mode still the same */
	/* **************************************** */
	taptr = &tapdr[dev->devnum];
	if ( taptr->tp_stat[2] != curtpmode ) {

		/* ******************** */
		/* reset mode and speed */
		/* ******************** */

		if ( sendt9cmd (taptr->tp_stat[2], TP_NONLINE, dev) ){
			dev->totcnt = 0;
			return (-1);
		}

		/* wait for command being accepted */
		if ( ckt9excpt(dev) ) {
			dev->totcnt = 0;
			return (-1);
		}

		curtpmode = taptr->tp_stat[2];
	}

	/* ************************************************************ */
	/* send select command with format enable before sending rw cmd */
	/* ************************************************************ */
	if ( selectcmd (IFEN, dev) ) {
		dev->totcnt = 0;
		return (-1);
	}

	*(short *)&dev->rc1 = 0;

	/* prg TAPE DMA start & end addr */
	dmaddr ( dev->mem, dev->totcnt, TPDMA);

	taptr = &tapdr[dev->devnum];

	/* enable tape dma */
	oldpri = spl6();

	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	dbc_cr = dbc_cr | TP_EN;
	*DBC_CR = dbc_cr;
	splx (oldpri);

	if ( sendt9cmd ( dev->opr, TP_ONLINE, dev ) ) {
		/* may be in retry , need this */

		dev->totcnt = 0;
		return (-1); 
	}

	oldpri = spl6();
	/* ************************ */
	/* program clock to monitor */
	/* ************************ */
	taptr->tp_tick = TICK_3MIN;

	curtapreq = dev;

	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	splx (oldpri);

	if ( dev->flag & TNOWAIT )
		return (0);		/* don't wait for completion */


	/* wait for tape inturpt */
	while ( (inturpt & TAPE_INT) == 0 );
	

	/* local MONITOR COMMAND */
	/* wait for interrupt to happen, if EXCPT is set */
	/* read status and set rc, then return -1        */

	oldpri = spl6();
	taptr->tp_tick = 0;
	curtapreq = 0;
	splx(oldpri);
	
	if ( (*TP_SR & TP_EXCPT) && PRINT1 )
		printf ("p2");

	dev->flag |= OPRDONE;

	oldpri = spl6();
	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	b0= ck9taperw(dev, taptr);
	splx(oldpri);

	return(b0);

}

/* ************************************ */
/* check any error after tape operation */
/* inturpt is disabled when enter       */
/* ************************************ */
ck9taperw(dev,taptr)
register struct devdq *dev;
register struct tp *taptr;
{
	register unsigned int b0, b1, byteshort;
	register unsigned int left;
	register unsigned short status;
	register struct track9 *t;

	byteshort = 0;

	/* **************************************************** */
	/* check reverse block or erase fix in retry processing */
	/* **************************************************** */
	if ( taptr->tp_flag & (TP_REVFLG|TP_ERSFLG ) )
		return ( retryproc (dev, taptr) );


	t = &trk9;

	/* *************** */
	/* check r/w count */
	/* *************** */
	if ( (dev->cmd == TPREAD) || (dev->cmd == TPWRITE) ) {
		dbc_cr &= ~TP_EN;
		*DBC_CR = dbc_cr;
	
		/* ******************************************* */
		/* must be READ/WRITE, always disable tape dma */
		/* ******************************************* */

		/* if dma count>actual tape blk, there will be NO except */
		/* always check dma address to determine how many bytes rw */

		left = (*TP_DMAE + 1 - *TP_DMAS);

		t->tp_rwdone = dev->totcnt - left;

		if ( left )
			byteshort = 1;

		if ( PRINT1 && byteshort )
			printf ("cnt=%x\n", t->tp_rwdone);

	}

	status = *TP_SR;

	if ( ckt9excpt(dev) ) {
		dev->totcnt = 0;		/* timeout, send req back */
		return(0);
	}


	/* ********************************************************* */
	/* check regular rewind, erase fix, reverse blk .... command */
	/* ********************************************************* */

	if ( (dev->cmd != TPREAD) && (dev->cmd != TPWRITE ) &&
		(dev->cmd != WEOF) && (dev->cmd != REOF) ) {

		set9rc (dev, T9_M0, T9_M1);

		/* ********************************* */
		/* update mode on current tape drive */
		/* ********************************* */
		if ( (dev->cmd == TAPEMODE) || (dev->cmd == TAPESPEED) ) { 
			taptr->tp_stat[2] = dev->opr;
			curtpmode = dev->opr;
		}

		return (0);
	}


	/* ********************************************************** */
	/* check any EXCPT set for read/write and read/write filemark */
	/* ********************************************************** */

	else {
		if ( status & TP_READY ) {
			/* ********************* */
			/* ready is on, no error */
			/* ********************* */
			if ( (dev->cmd == TPREAD) || (dev->cmd == TPWRITE) )
				dev->totcnt = t->tp_rwdone;
			return(0);
		}
	}

	/* ************************ */
	/* EXCPT is set, set rc1    */
	/* tape dma may not be done */
	/* ************************ */

	/* problem with r/w, set appropriate error code, and set
		number of bytes performed */
	if ( dev->opr == T9READ ) {
		b0 = TRD9_M0;
		b1 = TRD9_M1;
	}
	else if ( dev->opr == T9WRITE ) {
		b0 = TWR9_M0;
		b1 = TWR9_M1;
	}
	else if ( (dev->opr == T9FMW) || (dev->opr == T9FMF) ) {
		b0 = T9_M0;
		b1 = T9_M1;
	}

	set9rc ( dev, b0, b1);

	/* ************************************************ */
	/* check for r/w, filemark rw */
	/* retry on hard error and corrected error on write */
	/* ************************************************ */

	if ( (dev->retry < T9_RETRY) && ((dev->flag & NRETRYB) == 0) ) {

		if ( (taptr->tp_stat[1] & T9_LHER) ||
			( (taptr->tp_stat[1]&T9_LCER)&&
				( (dev->opr==T9WRITE)||(dev->opr==T9FMW) ) ) ) {

			printf ("p4");

			/* clear rc, status bytes */
			*((short *)&dev->rc1) = 0;
			taptr->tp_stat[0] &= (T9_IRDY|T9_IONL);
			taptr->tp_stat[1] = 0;

			/* disable tapedma,clr INTURPT,no more tape interrupt */
			inturpt = (inturpt & ~TAPE_INT) | TAPEDMA_INT;

			/* send select command, format enable */
			if ( selectcmd ( IFEN, dev) ) {
				dev->totcnt = 0;
				dev->flag |= OPRDONE;
				dev->rc1 = TP_HANG;
				return (0);
			}

			/* send reverse block command */
			taptr->tp_flag = TP_REVFLG;

			if ( sendt9cmd ( T9RECR, TP_ONLINE, dev ) ) {
				dev->totcnt = 0;
				return (0);		/* send req back */
			}

			/* allow tape interrupt */
			dtc_ctl |= TAPEINT_EN;
			*DTC_CRL = dtc_ctl;
			/* ************************ */
			/* program clock to monitor */
			/* ************************ */
			taptr->tp_tick = TICK_3MIN;

			/* wait for interrupt to happen */
			return (-1);
		}

	}

	/* ***************************** */
	/* no retry if it is other error */
	/* ***************************** */
	if ( (dev->cmd == TPREAD) || (dev->cmd == TPWRITE) )
		dev->totcnt = t->tp_rwdone;
	return (0);
}


/* *********************************************************
   tape finished reverse block for reading/writing error or 
   finished erasefix for writing 
   output:	return (-1) start retry
		return (0)  no retry process, send req back
   *********************************************************
 */

retryproc (dev, taptr)
register struct devdq *dev;
register struct tp *taptr;
{
	register struct track9 *t;

	t = &trk9;

	if ( taptr->tp_flag & TP_REVFLG ) {

		/* finished reverse blk in retry */
		if ( (dev->opr == T9FMF) || (dev->opr == T9READ) ) {
			taptr->tp_flag = 0;
			dev->retry++;

			/* DDDDDDDDDDDDDDDDD */
			printf ("p5");

			if ( dev->opr == T9READ) {
				/* restore totcnt */
				dev->totcnt = t->tp_orgcnt;

				if ( t9rw(dev) )
					/* can't start rw, send req back */
					/* totcnt=0;rc1=TP_HANG;flag|=OPRDONE */
					return(0);
			}
			else {
				if ( t9control(dev) ) 
					return(0);	/* send req back */
			}
				
			/* **************************************** */
			/* don't send response, tape is reading blk */
			/* **************************************** */
			return (-1);
		}


		else {
			/* ****************************** */
			/* must e write or write filemark */
			/* ****************************** */

			/* write got problem, just finished reverse blk, now 
				issue erase fix command */
			/* send select command, format en, should be in READY*/
			if ( selectcmd ( IFEN, dev) ) {
				dev->totcnt = 0;
				return (0);		/* send req back */
			}

			/* send erase fix command */
			taptr->tp_flag = TP_ERSFLG;


			/* DDDDDDDDDDDDDDDDDDDD */
			printf ("p6");

			if ( sendt9cmd ( T9ERAFIX, TP_ONLINE, dev) ) {
				dev->totcnt = 0;
				return (0);		/* send req back */
			}

			/* allow tape interrupt */
			dtc_ctl |= TAPEINT_EN;
			*DTC_CRL = dtc_ctl;
			/* ************************ */
			/* program clock to monitor */
			/* ************************ */
			taptr->tp_tick = TICK_3MIN;

			/* ************************************************* */
			/* don't send response back, tape is doing erase fix */
			/* wait for interrupt to happen */
			/* ************************************************* */
			return (-1);
		}
	}

	else  {	/* must be erase fix */

		/* must be write or write filemark problem */
		/* try reverse blk then erase fix */
		/* just finished erase fix, now issue write again */

		/* DDDDDDDDDDDDDDDDDDDD */
		printf ("p7");

		taptr->tp_flag = 0;
		dev->retry++;

		if ( dev->opr == T9WRITE ) {
			/* restore totcnt */
			dev->totcnt = t->tp_orgcnt;

			if ( t9rw (dev) ) {
				/* can't start rw, send req back */
				/* totcnt=0; rc1=TP_HANG; dev->flag |=OPRDONE */
				return(0);
			}
		}

		else {
			/* write filemark again */
			if ( t9control(dev) ) 
				return(0);	/* send req back */
		}
				
		/* ************************************************* */
		/* don't send response back, tape is doing erase fix */
		/* wait for interrupt to happen, don't send request back */
		/* ***************************************************** */
		return (-1);
	}
}


/* ******************************************************* */
/* insure READY/EXCPT is on, always send tape status cmd   */
/* if READY or EXCPT set, return 0, but don't set OPRDONE  */
/* if READY is set, only keep RDY/ONLINE bit in status     */
/* byte 0						   */
/*                                                         */
/* output:						   */
/*	return 	0 if READY/EXCPT TRUE			   */
/*	return -1 if 9 track don't communiate, drive not   */
/*		ready, or master cpu indicates power fail  */
/*		set dev->rc1, OPRDONE in dev->flag         */
/* ******************************************************* */

ckt9excpt(dev)
register struct devdq *dev;
{	register unsigned short status;
	register struct tp *taptr;
	register i;
	
	for (i=0; i< LOOPCNT; i++) {
		status = *TP_SR;
		if ( status & (TP_EXCPT|TP_READY) ) {

			/* ************************************ */
			/* insure either except or ready is set */
			/* ************************************ */
			if ( t9status (dev,0) )
				return (-1);

			if ( (dev->rc1 == TP_NRDY) || (dev->rc1 == TP_NONL) )
				return (-1);

			if ( status & (TP_READY) ) {
				/* keep READY and ONLINE bit if READY set */
				taptr = &tapdr[dev->devnum];
				taptr->tp_stat[0] &= (T9_IRDY|T9_IONL);
				taptr->tp_stat[1] = 0;
			}

			dev->flag &= ~OPRDONE;
			*(short *)&dev->rc1 = 0;
			return (0);
		}
	}
	dev->flag |= OPRDONE;
	dev->rc1 = TP_HANG;
	return (-1);
}

/* ******************************************
interrupt is disable while sending the cmd
output:
	return 0 if 9 track accept the command

	return -1 if 9 track don't communicate or power fail occur
		dev->rc1 = TP_HANG/TP_ABORT
		dev->flag |= OPRDONE
		
****************************************** */
sendt9cmd ( opr, state, dev )
register unsigned char opr; int state;
register struct devdq *dev;
{
	register oldpri, i;

	
	if ( bddesc.tas1 & STOPTPIO ) {
		/* power fail occur */
		dev->rc1 = TP_ABORT;
		dev->flag |= OPRDONE;
		return (-1);
	}

	i = LOOPCNT;

	/* may also set DUAL DMA ENA bit */
	if ( state & TP_ONLINE )
		tp_cr |= state;

	/* disable interrupt */
	oldpri = spl6();

	/* REQ + cmd + set/reset online */
	*TP_CR = tp_cr | TP_REQ | opr;
	
	/* wait for READY to be reset - command accpeted */

	while ( ((*TP_SR) & TP_READY) && (--i) ); 

	if ( i == 0 ) {
		dev->rc1 = TP_HANG;
		dev->flag |= OPRDONE;
		return (-1);
	}

	/* 0 + set/reset online */
	*TP_CR = tp_cr;

	/* don't wait for READY/EXCPT to be true */
	/* enable disable */
	splx(oldpri);
	return(0);
}

/* ***************************************************** */
/* insure HSDT has 9 track EC and 9 track interface card */
/* powerup, 9 track tape should have READY on            */
/* return 0: every thing ok                              */
/* return TP_NRDY: if 9 track don't communicate          */
/* return TP_INVIF: incorrect io interfacing             */
/* ***************************************************** */
ck9track(drive)
char drive;
{
	struct devdq dkreq; register struct devdq *p;
	register unsigned short status;
	register struct tp *taptr;
	register oldpri; register ushort i;

	/* check if 9 track interface card attached */
	oldpri = spl6();

	taptr = &tapdr[drive];
	taptr->tp_type = TP_9TRK;


	if ( (*TP_SR & (unsigned short)(TP_READY+ TP_EXCPT) ) == 0 ) {
		resetape9();
		if ( (*TP_SR & (unsigned short)(TP_READY+ TP_EXCPT) ) == 0 ) {
			splx (oldpri);
			return(TP_NRDY);
		}	
	}
		

	tp_cr = 0;	/* keep track online bit */

	p = &dkreq;
	initdevq (p);
	p->devnum = drive;

	/* send set mode command :stream and low speed */
	/* if ( s9cmd (p, MODEVAL|LOWSPEED|STREAM, TP_NONLINE ) ) */
/* *******************************
	if ( sendt9cmd (MODEVAL|LOWSPEED|STREAM, TP_NONLINE, p ) )
		goto errexit;
	if ( ckt9excpt (p) )
		goto errexit;
************************************ */
	/* also send out SELECT cmd with drive num, wait for READY set */
	if ( selectcmd (IFEN, p) ) 
		goto errexit;

	/* send 1600bpi density command, wait for READY set */
	/* if ( s9cmd (p, T9SETDENS, TP_NONLINE) ) */
/* ********************
	if ( sendt9cmd (T9SETDENS, TP_NONLINE,p) )
		goto errexit;
	if ( ckt9excpt (p) )
		goto errexit;

*/
	/* get tape status, no interrupt involved */
	if ( t9status (p,0) )
		goto errexit;

	if ( (p->rc1 == TP_NRDY) || (p->rc1 == TP_NONL) ||
	     (p->rc2 == TP_NRDY) || (p->rc2 == TP_NONL)  ) {
		splx (oldpri);
		return(TP_NRDY);
	}

	taptr->tp_type |= TAPEON;

	/* default is low speed, stream mode */
	/* curtpmode = MODEVAL | LOWSPEED | STREAM; */

	taptr = tapdr;
	for (i=0; i< MAX_TDRIVE; i++) {
		taptr->tp_stat[2] = curtpmode;
		taptr++;
	}

	splx (oldpri);
	return(0);

errexit:
	resetape9();
	splx (oldpri);
	return (TP_NRDY);
}

/* *****************************************************
send command :DENSITY, SELECT, SETMODE to 9 track,
and wait for READY/EXCPT
disable interrupt
output:
	return	0 if EXCPT/READY set
		-1 if 9 track don't communicate or power fail occur
		dev->rc1 = TP_HANG/TP_ABORT
		dev->flag |= OPRDONE
 */
/*
s9cmd ( dev, opr, state )
struct devdq *dev;
unsigned char opr; int state;
{
	
	if ( sendt9cmd (opr, state, dev) )
		return (-1);

	if ( ckt9excpt (dev) )
		return (-1);
	return (0);

}
*/
/* ********************************************** */
/* if drive is not online or not ready, return -1 */
/* ********************************************** */
set9rc ( dev, mask0, mask1 )
register struct devdq *dev; register char mask0, mask1;
{
	register num; register unsigned char *ptr;

	ptr = (unsigned char *) tapdr[dev->devnum].tp_stat;
	if ( (*ptr & T9_IRDY) == 0 ) {
		dev->rc1 = TP_NRDY;
		printf ("tape not rdy\n");
		return(-1);
	}
	if ( (*ptr & T9_IONL) == 0 ) {
		dev->rc1 = TP_NONL;
		printf ("tape not onlne\n");
		return(-1);
	}

	*(short *)&dev->rc1 = 0;

	num = 0;
	if ( (num = ckbyte (dev, (*ptr & mask0), num, t9err0)) == 2 )
		return(0);			/* error byte full */
	ckbyte (dev, ((*(ptr+1)) & mask1), num, t9err1);
	return (0);
}

ptap9stat(dev)
register struct devdq *dev;
{
	register char *ptr;

	ptr = (char *)tapdr[dev->devnum].tp_stat;
	printf ("ts=%x ",(*(short *)ptr) & 0xffff);

	/* print the tape status message */
	prtbl (*ptr&0x3f, t9tbl0);
	ptr++;
	prtbl (*ptr&0x1f, t9tbl1);
}


resetape9()
{
	*TP_CR = TP_RESET;
	*TP_CR = 0;

	/* ****************************** */
	/* zero tape speed and mode value */
	/* ****************************** */
	curtpmode = 0;
}

tp9status(dev)
register struct devdq *dev;
{
	/* insure there is EXCPT/READY set */
	if ( ckstatus(dev) )
		return (-1);

	/* ******************************************************* */
	/* send SELECT cmd to select the correct drive, ask status */
	/* ******************************************************* */
	if ( selectcmd (IFEN, dev) ) 
		return (-1);

	t9status (dev,0);
	return (0);

}

ckstatus(dev)
register struct devdq *dev;
{
	if ( (*TP_SR & (unsigned short)(TP_READY+ TP_EXCPT) ) == 0 ) {
		resetape9();
		if ( (*TP_SR & (unsigned short)(TP_READY+ TP_EXCPT) ) == 0 ) {
			dev->rc1 = TP_NRDY;
			dev->flag |= OPRDONE;
			return(-1);
		}
	}
	return(0);
}
errflag(dev)
register struct devdq *dev;
{
	printf ("panic\n");
	prbuf ( dev, 0x18);
lop23:	goto lop23;
}
