#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edtextrn.h"

extern int tstatus(), tapepos(), tprw();
int trdwr();

struct tt {
	char ch; int (*func)(); unsigned short opr;
} ttbl[] = {
	'S', tstatus, TSTATUS,
	'B', tapepos, TREW,
	'E', tapepos, TERAS,
	'T', tapepos, TENS,
	'R', trdwr, TREAD,
	'W', trdwr, TWRITE,
	'P', tapepos, TQ11,
	'Q', tapepos, TQ24,
	0, 0, 0,
};

/*
	monitor command enter from console
 */
tapearch (bufptr)
char *bufptr;
{
	register struct tt *p; register char *ptr;
	register struct devdq *dev;
	register char c2;
	int argu[2];

	ptr = bufptr;		/* point to 2nd char */
	c2 = *(++ptr);

	dev = &req;
	initdevq (dev);
	dev->device = TAPE;

	/* wait for operation to be completed */
	/* dev->flag =0; */

	for ( p = ttbl; p->ch; p++ ) {
		if ( c2 == p->ch ) {
			dev->opr = p->opr;
			if ((c2 == 'R') || (c2 == 'W')) {
			    if ((*p->func)(dev,bufptr))
				return(-1);
			}
			else {
			
				/* pick up tape drive number */
				if ( getarg(bufptr, argu, 1) < 0 )
					return (-1);
				if ((argu[0]<0)||(argu[0]>3))
					return(-1);
				dev->devnum = argu[0];

				(*p->func)(dev);
			}

			if ( *(short *)&dev->rc1 )
				printrc (dev);
			return (0);
		}
	}

	return (-1);
}

/*
	tape read/write
	tape read filemark/tape write filemark
 */
trdwr( dev, bufptr)
register struct devdq *dev;
char *bufptr;
{
	register char *ptr; register char c2, c3;
	int argu[3];

	ptr = bufptr;		/* point to 2nd char */
	c2 = *(++ptr); c3 = *(++ptr);
	if (c3 == 'F') {
	    if (getarg(bufptr,argu,1)<0)
		return(-1);
	    if ((argu[0]<0)||(argu[0]>3))
	    	return(-1);
	    dev->devnum = argu[0];
	}

	if ( (c2 == 'R') && (c3 == 'F') ) {
		dev->opr = TRFM;
		trwfm(dev);		/* tape read filemark */
		return (0);
	}

	else if ( (c2 == 'W') && (c3 == 'F') ) {
		dev->opr = TWFM;
		trwfm(dev);		/* tape write filemark */
		return (0);
	}
	
	/* tape read/tape write command */
	else {
		if ( getarg(bufptr, argu, 3) < 0)
			return (-1);
		if ((argu[0]<0x1000) || ((argu[0]+argu[2])>0xc000))
			return(-1);
		dev->mem = (char *)argu[0];		/* local address */
	        if ((argu[1]<0)||(argu[1]>3))
			return(-1);
	        dev->devnum = argu[1];

		/* check byte count, must be multiple of 0x200 */
		dev->totcnt = argu[2];		/* byte count */
		if ( dev->totcnt % TAPEBLK )
			return (-1);

		tprw (dev);
		return (0);
	}
}

