# 1 "mprom.x"
# 1 "./edtcpu.h"

	set    RAMSTACK%,0xE000
	set    PROMOUT%,0x40
	set    TEXTSIZE%,0x10000


	set	IMEMCMD%, 0x81
	set	IWJCMD%, 0x0c
	set	IILLEG%, 0x88

	set	ram_start%,0x400000
	set	ram_size%,0x03fff8 # * bytes reserve for reset and bd_in_system	
#	set	 ram_size%,0x040000	
	set	 prom_ram%,0x410000
	set	    stack%,0x410000

	set	ledoff%,3
	set	redlit%,2
	set	greenlit%,1
	set	yellowlit%,0

	set	ICB_SR%,0x800000		
	set	ICB_IR%,0x800002		

	set	DTB_CR%,0x800004		
	set	DTB_SR%,0x800004		
	set	DTB_IDR%,0x800006	

	set	DBC_CR%,0x600000		
	set	DBC_SR%,0x600000		

	set	DDC_DMAS%,0x600040	
	set	DDA_DMAS%,0x600042	
	set	CHN_DMAS%,0x600044	
	set	DTB_DMAS%,0x600046	
	set	TP_DMAS%,0x600048	

	set	DDC_DMAE%,0x600060	
	set	DDA_DMAE%,0x600062	
	set	CHN_DMAE%,0x600064	
	set	DTB_DMAE%,0x600066	
	set	TP_DMAE%,0x600068	
	set	DMABNKSEL%,0x6000E0	

	set	DDC_CR%,0x8000b0		
	set	DDC_SR%,0x8000b0		

	set	DDC_TR%,0x800081		

	set	DDC_IDR%,0x8000a1	

	set	DDC_SCR%,0x800032	
	set	TP_CR%,0x800038		
	set	TP_SR%,0x800038		
	set	DTC_CRL%,0x800001	
	set	SWITCHES%,0x800031	


	set	ACIA_CNTRL%,0x8000c1	
	set	ACIA_STAT%,0x8000c1	
	set	ACIA_DATA%,0x8000c3	



	set	TM_C13%,0x8000e1		
	set	TM_C2%,0x8000e3		
	set	TM_S2%,0x8000e3		
	set	TM_MSB1%,0x8000e5	
	set	TM_LSB1%,0x8000e7	
	set	TM_MSB2%,0x8000e9	
	set	TM_LSB2%,0x8000eb	
	set	TM_MSB3%,0x8000ed	
	set	TM_LSB3%,0x8000ef	




	set	DK_WCY%,0xc00000		
	set	DK_WHD%,0xc00002		
	set	DK_WCTL%,0xc00004	
	set	DK_WSI%,0xc00006		

	set	DK_RUS%,0xc00000		
	set	DK_RSCS%,0xc00002	
	set	DK_RRWC%,0xc00004	
	set	DK_RACS%,0xc00006	

# 6 "mprom.x"
	text


global stop
global promstart,retmon,wmjump
global buserr%,addrerr%,illinst%,zerodiv%
global chkinst%,trapvst%,privviol%,trace%
global l1010em%,l1111em%
global unas30%,unas34%,unas38%,unintvec%
global unas40%,unas44%,unas48%,unas4c%,unas50%,unas54%,unas58%,unas5c%
global spurint%,icbpend%,inttape%,sertime%,intdtbdma%,intseek%,intddc%,nmaskint%
global trap0%,trap1%,trap2%,trap3%,trap4%,trap5%,trap6%,trap7%
global trap8%,trap9%,trap10%,trap11%,trap12%,trap13%,trap14%,trap15%
global reserved%


promstart:

#				this code is loaded at 0x10000 so that it will run
#				correctly after being moved to RAM at that address.
#				It works on power up and reset because address bit 16
#				is ignored by the PROM.


	mov.w	&0,%d0
	mov.w	%d0,DMABNKSEL%
	mov.l	&peripheral_table%,%a0
	mov.l	&p_table_end%,%a2

init_loop%:
	mov.l	(%a0)+,%a1		
	add.l	&1,%a0			
	mov.b	(%a0)+,(%a1)		
	cmp.l	%a2,%a0			
	bne.b	init_loop%		

# write / read RAM test
	mov.l	&ram_start%,%a0
	mov.l	%a0,%a1
	mov.l	&ram_size%,%d2
	mov.l	%d2,%d3
	mov.l	&0x5a5a0f0f,%d0		
wr_ram%:
	mov.l	%d0,(%a0)+		
	sub.l	&4,%d2			
	bne.b	wr_ram%


rd_ram_1%:
	cmp.l	%d0,(%a1)			
	bne.b	ram_error%
	clr.l	(%a1)+			
	sub.l	&4,%d3			
	bne.b	rd_ram_1%


rd_done%:
	mov.l	&0,%a1				# prom base
	mov.l	&ram_start%,%a0  	# 0x400000
	mov.l	&promstart-0x10000,%d0		
mlop%:		# if promstart is at 0x10000, this will move 64kb
	mov.l	(%a1)+,(%a0)+
	sub.l	&4,%d0
	bpl.b	mlop%


	mov.l	&0,%a1				# prom base
	mov.l	&prom_ram%,%a0		# 0x410000
	mov.l	&TEXTSIZE%,%d0		
mlop1%:
	mov.l	(%a1)+,(%a0)+
	sub.l	&4,%d0
	bpl.b	mlop1%


	mov.l	&RAMSTACK%,%sp		
	mov.b	&PROMOUT%,DTC_CRL%	# flip
	mov.w	&PROMOUT%,dtc_ctl

retmon:
	mov.l	&RAMSTACK%,%sp		
	and.w	&0xf8ff,%sr		


	jsr	main
	bra.b	~





ram_error%:
	cmp.l	%d3,&0x20000
	beq.b	rd_done%	#if d3 = 0x20000 then we must have only had 128k
#						 ram, so continue

# loop forever blinking the red led.
stop:
	mov.w	%sr,%d0
	and.w	&0xf8ff,%d0
	or.w	&0x0700,%d0
	mov.w	%d0,%sr

mm0%:
	mov.b	&redlit%,DTC_CRL%
	mov.w	&0xffff,%d0
mm1%:
	sub.w	&1,%d0
	bne.b	mm1%
	mov.b	&ledoff%,DTC_CRL%
	mov.w	&0xffff,%d0
mm2%:
	sub.w	&1,%d0
	bne.b	mm2%
	bra.b	mm0%



wmjump:
	mov.w	%sr,%d1			
	and.w	&0xf8ff,%d1
	or.w	&0x0700,%d1
	mov.w	%d1,%sr
icbw%:
	mov.b	ICB_SR%,%d0		
	btst	&7,%d0
	beq.w	icbw%

	mov.w	ICB_IR%,%d0		
	and.w	&0xfff,%d0
	cmp.w	%d0,&IMEMCMD%		
	bne.w	icberr%


	mov.l	%a2,%a5  # a2 points to the global structure bddesc
	mov.l	64(%a5),%a4		
	cmp.b	(%a4),&IWJCMD%		
	bne.w	icberr%

	mov.l	&0,%a2
	mov.w	8(%a4),%d2		

	mov.l	4(%a4),%a1		

	mov.l	&10,%a0
	add.l	64(%a5),%a0		


	mov.l	4(%a0),%fp		
	mov.l	(%a0),%sp			
reloc%:
	mov.b	(%a0)+,(%a1)+
	sub.w	&1,%d2
	bne.b	reloc%
	jmp	(%fp)




icberr%:
	clr.l	%d0
	mov.b	21(%a5),%d0		
	mov.l	&13,%d1
	lsl.l	%d1,%d0
	or.l	&IILLEG%,%d0		
	mov.w	%d0,ICB_IR%

m0%:
	mov.b	&PROMOUT%+redlit%,DTC_CRL%
	mov.w	&0xffff,%d0
m1%:
	sub.w	&1,%d0
	bne.b	m1%
	mov.b	&PROMOUT%+ledoff%,DTC_CRL%
	mov.w	&0xffff,%d0
m2%:
	sub.w	&1,%d0
	bne.b	m2%
	bra.b	m0%


illinst%:
zerodiv%:
chkinst%:
trapvst%:
privviol%:
trace%:
l1010em%:
l1111em%:
unas30%:
unas34%:
unas38%:
unintvec%:
unas40%:
unas44%:
unas48%:
unas4c%:
unas50%:
unas54%:
unas58%:
unas5c%:
spurint%:



exhandler%:
	mov.w	(%sp)+,%d0
	mov.l	&1,-(%sp)
	bra.b	printmes%




trap0%:
trap1%:
trap2%:
trap3%:
trap4%:
trap5%:
trap6%:
trap7%:
trap8%:
trap9%:
trap10%:
trap11%:
trap12%:
trap13%:
trap14%:
trap15%:



traphandler%:
	mov.w	(%sp)+,%d0
	mov.l	&2,-(%sp)
	bra.b	printmes%

addrerr%:
	mov.l	&0x4,-(%sp)
	bra.b	printmes%


reserved%:
	mov.w	(%sp)+,%d0
	mov.l	&0,-(%sp)
printmes%:
	jsr	message
	bra.b	~


icbpend%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	icbint
	bra.b	restor%
	
	



inttape%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	tapeint
	bra.b	restor%
	
	



sertime%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	serint
	bra.b	restor%
	
	



intdtbdma%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	dtbdmaint
	bra.b	restor%
	
	



intseek%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	seekint
	bra.b	restor%
	

intddc%:
	movm.l	&0xc0c0,-(%sp)		
	jsr	ddcint
restor%:
	movm.l	(%sp)+,&0x0303		
	rte


nmaskint%:
	mov.l	&0x3,-(%sp)
	bra.b	printmes%
	
	
buserr%:
	mov.l	&0xff,drivein
	add.l	&0x8,%sp
	rte


	text
peripheral_table%:

	long	ACIA_CNTRL%
	short	0x0003		

	long	TM_C13%
	short	0x0000		

	long	TM_C2%		
	short	0x0087		
				
	long	TM_C13%		
	short	0x0000		

	long	TM_MSB2%		
	short	0x0000

	long	TM_LSB2%
	short	0x0004

	long	ACIA_CNTRL%	
	short	0x0095		
				
p_table_end%:
	
