#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdevdq.h"
#include "edtdtc.h"
#include "edttape.h"
#include "edttape9.h"
#include "edtdata.h"
#include "edterror.h"
#include "edtstruct.h"
#include "edtextrn.h"

/* tape code only work with single drive */
#define TAPENUM	0

#define MM_MASK	 (DDC_INT + CHNDMA_INT + DTB_INT)
#define MMA_MASK (DDC_INT + CHNDMA_INT + DDADMA_INT)	
#define MME_MASK (DDC_INT + CHNDMA_INT)

#define DTB_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)


/* ************************************** */
/* icb interrupt service routine  LEVEL 1 */
/* ************************************** */

icbint() {
	/* insure it is icb interrupt from main cpu */
	if ( ICB_IBUSY == 0 )	 {
		printf ("i1");
		return;
	}
	if(printflag & 0x10){
		*tail++ = *ICB_IR;		/*  put char in queue */
		if (tail == &input_q[sizeof input_q])
			tail = &input_q[0];  /* wrap around */
	}else{

		icbdata = *ICB_IR;

		inturpt |= ICB_INT;	/* indicate 68cpu interrupt thru ICB */
	}
}


/* ************************************** */
/* tape interrupt service routine LEVEL 2 */
/* ************************************** */

tapeint() {
	register unsigned short stat; register oldpri;
	register struct tp *taptr; register struct devdq *dev;
	register struct devdq *nextdq;

	stat = *TP_SR;
	oldpri = spl6();

	if ( (stat &(TP_EXCPT + TP_READY))== 0 ) {
		splx(oldpri);
		return;
	}

	/* READY may be true for archive tape drive between 512 blk */
	/* ????????? problem if tapedma come later */
/* ????????? seem like tape dma come first */

	taptr = tapdr;

	if ( (taptr->tp_type & TP_ARCH) 
		&& ( stat & TP_READY ) && ((inturpt & TAPEDMA_INT)==0) ) {
		splx (oldpri);
		return;
	}


	dev = curtapreq;
	taptr = &tapdr[dev->devnum];

	while ( dev == 0 ) {
		printf ("i2");
		/* ************************** */
		blkyellow();
		/* ************************** */
	}

	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;


	inturpt |= TAPE_INT;

	/* *********************** */
	/* turn off TICK for tape */
	taptr->tp_tick = 0;
	/* *********************** */
	if ( (dev->flag & (TNOWAIT+FASTAPE)) == TNOWAIT ) {

		/* ************************************* */
		/* ************************************* */
		/* take care of archive tape and 9 track */
		/* ************************************* */
		/* ************************************* */
#ifdef ARCH
		if ( taptr->tp_type & TP_ARCH ) {
			ckarchtape(dev);
			/* ************************************************ */
			/* return archive status at dev->q_extdtb, dev->opr */
			/* ************************************************ */
			*((short *)&dev->q_extdtb)= *((short *)taptr->tp_stat);

		}

#endif
#ifdef TRACK9
		if ( taptr->tp_type & TP_9TRK ) {
			if ( ck9taperw(dev, taptr) ) {
				/* **************************************** */
				/* retry for 9 track, don't response to cpu */
				/* **************************************** */
				splx (oldpri);
				return(-1);
			}
		}
#endif

		/* disable tape dma enable bit */
		inturpt &= ~(TAPEDMA_INT + TAPE_INT);
		dbc_cr &= ~TP_EN;
		*DBC_CR = dbc_cr;

		/* ********************************** */
		/* no more tape operation in progress */
		/* ********************************** */

		if ( (dev->cmd == TPREAD) && dev->totcnt ) {
			/* send data to master cpu */
			if ( curwreq ) {
				/* disk rw is using dtb bus */
				/* when disk finish rw, will start this dtb */
				curwreq->forward = dev;
				splx(oldpri);
				return;
			}
			/* ********************************* */
			/* dtb bus is free, set dtbreq = dev */
			/* still lockup curtapreq            */
			/* got data from tape, send to main memory */
			/* ********************************* */
			tapexfer (dev, WR_DTB);
			splx(oldpri);
			return;
		}

		/* *************************** */
		/* 1 tape write                */
		/* 2 tape read with no data    */
		/* 3 tape position cmd         */
		/* send req back to master cpu */
		/* *************************** */

		dev->flag &= ~OPRDONE;

		/* ********************************** */
		/* free up tape for next tape request */
		/* ********************************** */
		curtapreq = 0;

		finreq (dev);

#ifdef TRACK9

		/* ********************************* */
		/* start next 9 track request if any */
		/* ********************************* */
		if ( taptr->tp_type & TP_9TRK )
			startape9();

#endif
	}

	splx(oldpri);
	return;
}

struct dmab { 
	unsigned char dmabit; unsigned short intbit;
} dmatable[5] =
{	DDC_EN, DDCDMA_INT,
	DDA_EN, DDADMA_INT,
	CHN_EN, CHNDMA_INT,
	DTB_EN, DTBDMA_INT,
	TP_EN,  TAPEDMA_INT,
};

/* ******************************************* */
/* dtb & dma interrupt service routine LEVEL 4 */
/* ******************************************* */

dtbdmaint() {
	register unsigned char status;
	register i; register unsigned char value;
	register struct  dmab *dptr;
	register oldpri;
	register struct devdq *dev;

	oldpri = spl6();
	if ( status=(*DTB_SR & (DTBRDSTAT|DTBSNDINT|DTBWRLAST|DTBRDLAST)) ) {
		*DTB_CR = (status << 8) | dtb_cr;
		inturpt |= DTB_INT;

		/* check either disk rw or tape data transfer finished */
		ckdisktape();

		splx(oldpri);
		return;
	}


	/* disable dma interrupt */

	status = *DBC_SR;		/* status of DMA done */

	value = 0;
	dptr = dmatable;

	for (i=0; i<5; dptr++,i++) {
		if ( dbc_cr & dptr->dmabit ) {	/* check which dma did enable */
			if ( status & dptr->dmabit ){/* check that dma done */
				value |= dptr->dmabit;
				inturpt |= dptr->intbit;
			}
		}
	}

	if ( value == 0 ) {
		if ( PRINT1 )
			printf ("i3(%x %x)", dbc_cr, status);
		splx(oldpri);
		return;
	}
	dbc_cr &= ~value;
	*DBC_CR = dbc_cr;

	/* check either disk rw or tape data transfer finished */
	ckdisktape();

	splx(oldpri);
}


/* ************************************** */
/* seek interrupt service routine LEVEL 5 */
/* ************************************** */

seekint() {
	register struct smdwr *wr;
	register struct devdq *dev, *nextdq;
	register struct dkinf *dkptr, *ndkptr;
	register oldpri, i;
	register struct smdrd *rd;
	register seekfound;

	oldpri = spl6();

	/* need to determine which drive is completed seek */

	seekfound = 0;
	rd = (struct smdrd *)DK_STSR;
	dkptr = phydr;
	for ( i=0; i<MAX_PDRIVE; i++) {
		if ( dkptr->pd_opr & DK_SEEK ) {
			/* drive is seeking, check if done */
			if ( rd->unitstus & SEEKEND ) {
				seekfound = 1;
				break;
			}
		}
		dkptr++;
		rd++;
	}
	if ( (seekfound == 0) || ((dev= dkptr->next) == 0) ) {
		while ( 1 ) {
			printf ("i4");
			/* ************************** */
			blkyellow();
			/* ************************** */
		}
	}

	/* variable i has the phy drive num */

	/* disable 'enable seek end' interrupt bit */
	wr = (struct smdwr *)DK_BUSW + i;
	wr->seekend = 0;

	dkptr->pd_opr = DK_SKDONE;
	if ( (dev->flag & TNOWAIT) == 0 ) {
		splx(oldpri);
		return;
	}

	/* next que waiting on same drive */
	nextdq = dev->forward;

	/* check any error on seek, set pd_tick = 0, pd_opr = 0 */
	if ( checkseek (dev, dkptr) ) {
		dkptr->curcyl = -1;
		/* ************************ */
		/* check if retry is needed */
		/* ************************ */
		if ( (dev->flag & NRETRYB) || (++dev->retry >= RETRY) ) {
			/* ******************************* */
			/* no need to retry, send req back */
			/* ******************************* */
			dkptr->next = nextdq;

			dev->flag &= ~OPRDONE;
			finreq (dev);		/* inturpt mst cpu for req */

			/* start next que on same drive */
			dev = nextdq;
		}
		else {
			/* ************************************ */
			/* retry, rezero first, then seek again */
			/* ************************************ */
			if ( dkrezero (dev->devnum,dkptr) ) {
				/* ********************************** */
				/* rezero got problem, cancel all req */
			 	/* dkptr->next, pd_opr, pd_tick = 0 */
				/* ********************************** */
				cancelreq (dev, dkptr);
				splx(oldpri);
				return;
			}
		}

		/* either seek on new que or retry on the same que */
		if ( dev != 0 ) {
			if ( aseek (dev, dkptr, 0) )  {
				/* can't even start seek, cancel all req
					on that drive */
				/* dkptr->next, pd_opr, pd_tick = 0 */
				cancelreq (dev, dkptr);
			}
		}

		splx(oldpri);
		return;
	}

	/* seek ok */

	/* check if any fast tape waiting for dtb */
	if ( ftaperw == WAIT_DK ) {
		ftaperw = 0;
		splx(oldpri);
		return;
	}
	/* insure no dtb busy (tape not using dtb) */
	if ( dtbreq ) {
		/* can't start rw */
		splx(oldpri);
		return;
	}

	/* no seek error,insure no other drive has seek pending */
	ndkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		if ( ndkptr->pd_opr & DK_SEEK ) {
		/* other disk is seeking,when last seekdone,will start rw */
			splx(oldpri);
			return;	
		}
		ndkptr++;
	}

	/* if seek just finished, for sure no disk is rw */
	/* no other seek, start rw */
	/* take req off the dkptr->next, and will put on curwreq by diskrw */

	dkptr->next = dev->forward;
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	if ( dkptr->pd_sortdq == dev ) 
		dkptr->pd_sortdq = dev->forward;
	if ( dkptr->pd_lastdq == dev )
		dkptr->pd_lastdq = dev->forward;
	/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
	diskrw (dev, dkptr, 0);
	splx(oldpri);

}

/* ************************************* */
/* ddc interrupt service routine LEVEL 6 */
/* ************************************* */

ddcint() {

	dtc_ctl &= ~DDCINT_EN;
	*DTC_CRL = dtc_ctl;

	inturpt |= DDC_INT;
	
	while (  curwreq == (struct devdq *)0 ) {
		printf ("i5");
		/* ************************** */
		blkyellow();
		/* ************************** */
	}
	if ( curwreq->flag & TNOWAIT ) {
		if ( ( (inturpt & MM_MASK) == MM_MASK ) ||
		     ( (inturpt & MMA_MASK) == MMA_MASK) ||
		     ( (inturpt & MME_MASK) == MME_MASK) )
			/* disk rw finish with DTB, will pick up tape if any */
			finrw ();
	}
}



/* interrupt is disabled */
cancelreq (dev, dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	register struct devdq *nextdq;

	/* have not start seek, drive got problem */
	/* send all pending req back */
	/* inturrpt still disable */

	printf ("i6");
	nextdq = dev->forward;
	dev->flag &= ~OPRDONE;
	finreq (dev);

	dkptr->next = 0;
	dkptr->pd_tick = 0;
	dkptr->pd_opr = 0;

	/* *************************** */
	/* reset sort que and last que */
	/* *************************** */
	dkptr->pd_sortdq = 0;
	dkptr->pd_lastdq = 0;

	while ( (dev = nextdq) != (struct devdq *)0 ) {
		nextdq = dev->forward;
		dev->rc1 = DER_SEEK;
		dev->flag &= ~OPRDONE;
		finreq (dev);
	}
}

blkyellow()
{	
	if ( (dtc_ctl & 0x03) != yellowlit )
		LIGHT (yellowlit);
	else
		LIGHT (ledoff);
}

startdisk()
{
	register seekon; register struct dkinf *dkptr;
	register struct devdq *dev;

	seekon = 0;			/* no drive is seeking */

	for ( dkptr = phydr; dkptr < (phydr+MAX_PDRIVE); dkptr++) {

		if ( (dev=dkptr->next) != 0 ) {
			if ( dkptr->curcyl != dev->q_devun.pdisk.cyl ) {
				if ( aseek (dev, dkptr, 0) )
				/* dkptr->next, pd_opr, pd_tick = 0 */
					cancelreq (dev, dkptr);
				else
					seekon = 1;
			}
			else {
				/* insure there is no drive seeking */
				if ( seekon == 0 ) {
					dkptr->next = dev->forward;
					/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
					if ( dkptr->pd_sortdq == dev ) 
						dkptr->pd_sortdq = dev->forward;
					if ( dkptr->pd_lastdq == dev )
						dkptr->pd_lastdq = dev->forward;
					/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
					diskrw (dev, dkptr, 0);
					return;
				}
			}
		}
	}
}

/* ****************************************************************** */
/* Level 4 interrupt, can be DTB_INT or CHN_EN or DTB_EN or ....      */
/* if curwreq is active, then check to see if disk rw is completed    */
/*								      */
/* if dtbreq is active, must be arch tape drive or 9 track tape drive */
/*    finished with DTB transfer for tape write */
/* ****************************************************************** */
 
ckdisktape()
{
	register struct devdq *dev;
	register struct dkinf *dkptr; register i;
	register struct tp *taptr;

	/* ********************************************************* */
	/* if disk rw is active, check if it is done                 */
	/* completed rw: ddc interrupt, chain dma done, dtb dma done */
	/* hit alt sector: ddc interrupt,chain dma done,alt dma done */
	/* data overrun: ddc interrupt, chain dma done               */ 
	/* ********************************************************* */

	if ( ((int)curwreq) && (curwreq->flag & TNOWAIT) ) {
		if ( ( (inturpt & MM_MASK) == MM_MASK ) ||
		     ( (inturpt & MMA_MASK) == MMA_MASK) ||
		     ( (inturpt & MME_MASK) == MME_MASK) )
		/* disk rw finish with DTB, will pick up tape if any */
			finrw();
	}

	/* ************************************************* */
	/* if DTB active, must be tape request transfer data */
	/* check if done */
	/* ************************************************* */

	else if ( dtbreq  && ( (inturpt & DTB_MASK) == DTB_MASK) ) {

		/* inturpt is disable, tape req is finished sending or 
			receive data from main memory
		if tape read, then put que on resp, inturpt master cpu,
			then check if any disk io pending
		if tape write, start the tprw, if error, then put
			que on resp, inturpt master cpu, then check if any
			disk io pending */


		/* *************************** */
		/* take care archive & 9 track */
		/* *************************** */
		dev = dtbreq;

		dtbreq = 0;

		/* AAAAAAAAAAAAAAAAAAAAAAA */
		dtb_tick = 0;
		/* AAAAAAAAAAAAAAAAAAAAAAA */
		taptr = &tapdr[dev->devnum];

		if ( dev->cmd == TPREAD ) {

			/* finish send tape data to main memory,send response */
			/* *************** */
			curtapreq = 0;
			/* *************** */
			dev->flag &= ~OPRDONE;
			finreq (dev);
		}	
		else {
			/* just start tape to write, don't care of disk */
			/* ************************************* */
			/* ************************************* */
			/* take care of archive tape and 9 track */
			/* ************************************* */
			/* ************************************* */
			i = 1;
#ifdef ARCH
			if  ( taptr->tp_type & TP_ARCH ) 
				i = tprw (dev);
#endif
#ifdef TRACK9
			if ( taptr->tp_type & TP_9TRK )
				i = t9rw (dev);
#endif
			/* ************************************** */
			/* having problem to start tape operation */
			/* ************************************** */
			if ( i ) {
				dev->flag &= ~OPRDONE;
				finreq(dev);
			}
		}

		/* check if any disk is waiting for read/write opr */
		/* only can start rw when there is no SEEK is on */
		dkptr = phydr;
		for (i=0; i<MAX_PDRIVE; i++) {
			if ( (dev=dkptr->next) != 0 ) {
				if ( dkptr->pd_opr == DK_SEEK )
					return;
			}
			dkptr++;
		}

		/* no seek is on, if drive already on same cyl, then start rw */
 		/* if not on same cyl, should able to start seek on all drive */
		/* no need to do seek here */
		startdisk();
	}

	return;
}

#ifdef ARCH
ckarchtape(dev)
register struct devdq *dev;
{
	register b0, b1;

	if ( (dev->opr == TREAD) || (dev->opr == TWRITE) ) {
		/* ???? assume tapedam done ,follow by tapeint??? */
		/* check if tape has any error, set rc */
		/* tape drive might TIMEOUT */
		/* if ( cktaperw(dev) == -1 ) { */
		if ( cktaperw(dev) ) {
			dev->totcnt=dev->totcnt-(*TP_DMAE+1- *TP_DMAS);

			if ( (dev->rc1 == TP_EOM) || (dev->rc2 == TP_EOM) )
				dev->totcnt--;
			if ( PRINT1 )
				printf("RWEX(%x)",dev->totcnt); 
		}
	}

	else {
		/* rewind, tension, erase, Q11/Q24 commands */
		/* read file mark, write file mark */
		/* ckexcpt(dev); */

		if ( ckexcpt (dev) )
			return;		/* tape hang or power fail */

		if ( dev->opr == TRFM ) {
			b0 = TRFM_M0;
			b1 = TRFM_M1;
		}
		else if ( dev->opr == TWFM ) {
			b0 = TWFM_M0;
			b1 = TWFM_M1;
		}  
		else {
			b0 = T_M0;
			b1 = T_M1;
		}
		setrc ( dev, b0, b1 );
	}
	return;
}
#endif

#ifdef TRACK9
fint9(dev)
register struct devdq *dev;
{
	curtapreq = 0;
	dev->flag &= ~OPRDONE;
	finreq(dev);
	startape9();
}

/* ********************************************************* */
/* start next 9 track request if any                         */
/* if tape read or position or status command, just start    */
/* if tape write and dtb is busy with disk, chain at curwreq */
/* ********************************************************* */
startape9()
{
	register struct devdq *dev;
	register struct tp *taptr;

startagain:
	for ( taptr = tapdr; taptr < (tapdr+MAX_TDRIVE); taptr++) {
		if ( (dev = taptr->next) != 0 ) {
			/* ************************************** */
			/* take que off from tape drive structure */
			/* ************************************** */
			taptr->next = dev->forward;

			if ( dev->cmd == TAPESTAT ) {
				tap9status(dev);

				dev->flag &= ~OPRDONE;
				finreq(dev);
				goto startagain;
			}
			else if ( (dev->cmd==TPREAD) || (dev->cmd==TPWRITE) ) {
				if ( tape9rw (dev) ) {
					/* can't start 9 track rw */

					dev->flag &= ~OPRDONE;
					finreq(dev);
					goto startagain;
				}
				/* if tape write, DTB interrupt will start
				 	tape writing 
				   if tape read, tape interrupt will xfer
					data to main memory
				*/
				return;
			}
			else {
				/*  other 9 track operation */
				if ( t9control(dev) ) {
					/* having problem to start */

					dev->flag &= ~OPRDONE;
					finreq(dev);
					goto startagain;
				}
				/* tape interrupt should take care the rest */
				return;
			}
		}
	}

}
#endif
