#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "icbcmd.h"
#include "edttape.h"
#include "edtdevdq.h"
#include "edtextrn.h"
#include "edtvern.h"
#include "vreg.h"


#define TD0	0
extern end;
unsigned short *esc_flag = (unsigned short *)0x3fff8;
unsigned char *system_flag = (unsigned char *)0x3fffa;

initedt()
{
	register unsigned short intfcard;
	register struct bd_desc *bd;
	register struct dkinf *dkptr;
	register struct devdq *bptr, *rptr;
	register i, j;
	register struct dev_desc *devptr;
	struct tp *taptr;

	bd = &bddesc;

	/* setup DTC board id number & DMA channel # for DTC */
	*DTB_IDR = (BID<<4) | DMACHAN;

	/* enable disk interface card, prom in, and yellow lit */
	dtc_ctl = (dtc_ctl | DKINTFEN) & LEDMASK;
	*DTC_CRL = dtc_ctl;

	/* reset, enable disk data channel */
	*DDC_CR  = 0;
	*DDC_CR  = ENDKDATAC;

	/* setup disk ID0 */
	*DDC_ID0 = 0;

	/* reset all dma */
	*DBC_CR = 0;
	/* rest DTB function code */
	*DTB_CR = 0;

	/* setup default TIMING id value */
	setimid (iddata);

	/* clear all physical drive information with 0xffff */
	setbuf (dtbbuf, ((int)&end-(int)dtbbuf) >>1, 0 );


	/* limited printout */
	printflag = 1;

	/* setup board descriptor information */
	bd->bd_info	= BDIIOP;
	bd->bd_stst	= STCMPLT;
	
	bd->bd_icbint	= ICBLEVL;
	irqlevl		= ICBLEVL << 13;
	bd->bd_cpu	= MOT68K;

	
	bd->bd_dtbid	= BID;			/* board id */
	bd->bd_xdtbid	= XDTYPDMA | DMACHAN;	/* lower nibble: dma channel */
	bd->bd_stst	= STCMPLT;		/* self test completed */

	/* check which kind of interface card */
	intfcard = *TP_SR & TP_INFC;

	if ( intfcard == TP_9TRKIF ) 
		bd->bd_ifcard = IFC_TRK9;

	else 
		bd->bd_ifcard = IFC_ARCH;

	*(int *)BDVECT	= (int)bd;

	/* disk size: default to 84 meg disk */
	cylsize = CYL84_DRV;
	headsize = HEAD84_CYL;
	sectsize = SEC84_HEAD;

	/* check tape device on */

	if (intfcard == TP_9TRKIF)
		for (i=0; i<MAX_TDRIVE; i++)
			ck9track(i);

	else cktapeon(TD0);

	bd->bd_frev	= (EDT_VER<<4) | EDT_REL;

	bd->bd_memst	= (char *) (((unsigned)(&promstart)-0x0fffc) & 0xfffffffc);
	bd->bd_szmem	= ((RAMSTACK-STACKLEN) - (unsigned)bd->bd_memst); 
	bd->bd_dvptr	= devdesc;

	bd->freefst	=  nq;
	rptr = (struct devdq *)bd->freefst;

	bptr = 0;
	for (i=0; i< NQNUM; i++) {
		rptr->backward = bptr;  	/* current */
		bptr = rptr;
		bptr->forward = ++rptr;
	}
	bptr->forward = 0;
		

	/* init keyboard buffer pointer */
	init_q();

	dkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		dkptr->curcyl = -1;
		dkptr++;
	}

	/* determine which device is ready */
	devptr = devdesc;
	if ( tapdr[TD0].tp_type & TAPEON ) {
		devptr->dd_type = DTTAPE;
		devptr->dd_count = 1;
		devptr->dd_un.dd_tape = tapdr;
		bd->bd_devs++;
		devptr++;
	}

	if (*esc_flag == 0x7273)		/* "rs" reset magic # */
		bd->bd_opt = *system_flag;

	/* device is disk and seekable */
	bd->bd_devs++;
	devptr->dd_type = DTDISK | DTISK;
	devptr->dd_un.dd_pdisk = (struct pd *)phydr;

	dkptr = phydr;
	printflag = 0;
	for ( i=0; i<MAX_PDRIVE; i++) {
		if ( ckdrready (i) == 0 ) {
			devptr->dd_count++;	/* # of disk ready */
			/* indicate drive is ready */
			dkptr->pd_ststat = DK_READY;
		}
		dkptr++;
	}

	/* DDDDDDDDDDDDDDDDDDD */
	/* temporay fix, assume drive 0 is ok to boot */

	phydr[0].pd_ststat = DK_READY;

	printflag = 1;
	

	/* clear TAS */
	*DTC_CRH = 1;

}

ckdrready (drive)
char drive;
{	register i, j;

	for ( i=0; i<10; i++) { 
		if ( unitsel (drive) == 0 )
			return(0);
		j = 100;
		while ( j-- );
	}
	printf ("drive %x not ready\n",drive);
	return (-1);
}


setbuf (ptr, wcnt, data)
register short *ptr; register int wcnt; short data;
{
	while ( wcnt -- )
		*ptr++ = data;
}

printrc(dev)
register struct devdq *dev;
{
	printf (" rc(%x)", *(short *)&dev->rc1);
}

initdevq (dev)
struct devdq *dev;
{
	setbuf ( dev, (sizeof (struct devdq))/2, 0 );
}

prchs(dev)
register struct devdq *dev;
{
	printf ("C=%3x H=%2x S=%2x ",dev->q_devun.pdisk.cyl,dev->q_devun.pdisk.head,dev->q_devun.pdisk.sector);
}

printlf()
{	printf ("\n");
}

blinkled()
{
	register oldpri;
	oldpri = spl6();
	/* blink leds yellow, red */
	if ( (dtc_ctl & 0x03) == 0 )
		dtc_ctl |= redlit;
	else
		dtc_ctl &= LEDMASK;
	
	*DTC_CRL = dtc_ctl;
	splx (oldpri);
}

prbuf ( bufptr, wcnt)
register short *bufptr; register wcnt;
{
	printlf();
	while ( wcnt--) 
		printf ("%4x ", (*bufptr++)& 0xffff);
}

loadeag(bufptr)
char *bufptr;
{
	if ( *(bufptr+1) == '0' )
		setimid (egdata);
	else if ( *(bufptr+1) == '1' )
		setimid (iddata);
	else if ( *(bufptr+1) == '2' )
		setimid (esmd);
	else
		return (-1);
	return (0);
}
