#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "edtdevdq.h"
#include "edtdata.h"
#include "vreg.h"
#include "icbcmd.h"
#include "edtextrn.h"


/*
	pick up icb command
 */

icbparse()
{	register unsigned short icbcmd;
	register int oldpri;
	register struct icbcmdhdr *p;
	struct devdq dkreq; register struct devdq *dev;
	register struct dkinf *dkptr;

	oldpri = spl6();		/* only allow interrupt 7 */
	inturpt &= ~ICB_INT;		/* allow more icb interrupt later */
	splx(oldpri);


	/* LIGHT (greenlit); */

	icbcmd = (icbdata) & ICBI_MASK;	/* get interrupt word */


	switch ( icbcmd ) {
		case IDWNLD:		/* go into download mode */
			dwnldmode();	/* don't even return */
			break;
		case IVRUPDT:		/* updated vreg */
			upvreg(); 
			break;
		case IMEMCMD:		/* process memory resident cmd */
			p = bddesc.bd_imcptr;
			if ( p->command == IBTINFO ) {
				p->status = ICMPLT;
				if ( p->information >= MAX_PDRIVE ) {
					p->information = 0;
					intr_cpu (IMEMCMD);
					break;
				}

				/* insure sector 0 is read first */
				dev = &dkreq;
				/* clear the  dev rq */
				initdevq (dev);
				dev->device = DISK;
				dev->devnum = p->information;
			
				/* get pointer to physical drive data */
				dkptr = (struct dkinf *)getphptr(dev);
				if ( ckopdrive (dev, dkptr) ) {
					p->information = 0;
				}
				else {
					bootinf(dev, dkptr,p);
				}
			}
			else {
				p->status = IILLEG;
				p->information = 0;
			}
			intr_cpu (IMEMCMD);
			break;
		default:
			intr_cpu (icbcmd);
			break;
	}

	/* LIGHT(ledoff); */
	return;
}


upvreg()
{
	/* check icb interrupt level num */
	irqlevl = bddesc.bd_icbint <<13;

	/* check dtb id & external dtb device */
	if ( (bddesc.bd_xdtbid & XDTYPMSK) != XDTYPDMA )
		printf ("baddtb(%x)\n", bddesc.bd_xdtbid);
	else	{
		if (bd_in_system == S90)
			dma_used = bddesc.bd_xdtbid & XDIDMSK;
		*DTB_IDR=(bddesc.bd_dtbid << 4) | (bddesc.bd_xdtbid & XDIDMSK);
	}

	intr_cpu ( IVRUPDT );
}


bootinf(dev,dkptr,p)
register struct icbcmdhdr *p;
register struct devdq *dev;
register struct dkinf *dkptr;
{
	char buf[0x404]; register char *bptr;

	bptr = (char *)( (int)(buf+2) & 0xfffffffc);

	dev->opr = OPR_READ;
	if ( rsydata (dev, dkptr, BOOTSEC, bptr ) ) {
		p->information = 0;
		return;
	}

	/* get logical sector # and sector count */
	p->information = *((int *)bptr);	/* logical sector # */
	return;
}

/* send byte value to main cpu thru ICB interrupt register */
intr_cpu( intbyte )
unsigned char intbyte;
{
	register unsigned wordv;
	/* wait until DTC interrupt main cpu bit not set */
	wordv = 0x1000;
	while ( ICB_OBUSY ) {
		if ( --wordv == 0 ) {
			printf (".");
			wordv = 0x1000;
		}
	}

	*ICB_IR =(short )(irqlevl | intbyte);
	return;
}

