/* dtbxfer.c
	870511m.tassano		add dma word0 setup bit, board #
*/
#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdtc.h"
#include "edtdata.h"
#include "devcmd.h"
#include "vreg.h"
#include "edtextrn.h"

fixdevmem(tdev)
struct devdq *tdev;
{
	mem_slot = (unsigned short)(((int)tdev->mem & 0xf0000000) >> 28 & 0x0f);
	tdev->mem = (char *)(((int)tdev->mem & 0x0fffffff) << 4);
}

#define XFER_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)
/*	
	dtbptr : (DTB parameter) pointer to 8 bytes buffer containing
			dtbptr+0: bit31 0=read,1=write; sbus r/w ; i/o DTB ID#
			dtbptr+1: 1:7-1:4 Memory board Sbus slot#
			dtbptr+2,3: long word cnt
			dtbptr+4,5,6,7: main memory address >>2
	locmem:		pointer to DTC local data buffer
	direction:	RD_DTB: DTB -> local mem (receive data from main mem)
			WR_DTB: local memory -> DTB (send data to main memory)

	transfer a blk of data between main memory and DTC memory

	in S90 system 
	setup DTB param byte 0 :DMC control byte (direction & boardid)
	setup DTB param byte 1: mem_slot << 4 | dma_used
	program CHAIN DMA address with DTB parameters address (8 bytes buffer)
	program DTB DMA address with DTC local buffer address
	setup data path mode for DTB <-> main memory transfer

*/
xferdata(dtbptr, locmem, direction, wait, cmd)
char *dtbptr, *locmem, cmd; int wait;
{	register char *ptr; register oldpri, i;
register char combo;
	oldpri = spl6();
	inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
	/* splx(oldpri); */

	ptr = dtbptr;

	/* setup DTB parameter: DMC dma msb byte count/control
		main memory -> DTB */
	/* add test for direction, use only bit 31 of long word. 870511 */
	/* high byte, bits 31-24 */

	if (bd_in_system == S90) {
		combo = (char)bddesc.bd_dtbid | dma_used;
		if(direction & 0x10)
			*ptr++ = combo;
		else
			*ptr++ = combo | 0x80;
	
		*ptr++ = (unsigned char)(mem_slot << 4 ); 	/* byte 2 */
		*DTB_IDR = (char)( combo << 4 | dma_used); 
	}
	else {
		*ptr++ = (char)(direction | bddesc.bd_dtbid);/* edt boardid */
		*ptr++ = 0;
	}

	if ((cmd == MSETUPREAD) || (cmd == MSETUPWRITE)) {
		splx(oldpri);
		return;
	}

	/* program DTB DMA start & ending address with 
		DTC local data buffer address */
	if ((cmd==MSTARTREAD)||(cmd==MSTARTWRITE))
		dmaddr ( locmem, extra2, DTBDMA); /* byte count */
	else
		dmaddr ( locmem, (*(short *)ptr) << 2, DTBDMA); /* byte count */

	/* program CHAIN DMA start & end address with 
		8 bytes buffer containing DTB parameters */
	dmaddr ( dtbptr,  DTBP_LEN, CHNDMA);		/* byte count=8 */

	/* program DTB/DISK data path mode for local memory <->DTB */
	mslmdkdtb (direction, ~DISK);

	if ( wait == DTBNOWAIT ) {
		splx(oldpri);
		return;
	}

	splx(oldpri);

	/* wait for inturpt DTB interrupt, DMA interrupt */
	/* while ( (inturpt & (DTB_INT | CHNDMA_INT | DTBDMA_INT) )== 0 ); */
	/* while ( (inturpt & DTBDMA_INT) == 0 );  */
	if (((cmd==MSTARTREAD)||(cmd==MSTARTWRITE))&&(((*(short *)ptr)<<2)>extra2))
		while ( (inturpt & 0x30) != 0x30);
	else while ( (inturpt & XFER_MASK) != XFER_MASK) {
		i++;
		if ((i > 2000) && (cmd == MWRITEUCERR) && ((inturpt & 0x20)
		== 0x20)) break;
	}

	/* clear both CHAIN DMA & DTB DMA done bit */
	oldpri = spl6();
	dbc_cr &= ~(CHN_EN + DTB_EN);
	*DBC_CR = dbc_cr;
	inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
	splx(oldpri);

	return (0);
}
/*
	DTB can't be busy
	setup data path for DTB <-> local memory/disk
	DTB function code
	enable DTB dma & CHN dma for local memory <-> DTB
	enable CHN dma & ALT dma for disk <-> DTB
	input: direction : RD_DTB = DTB -> local memory (receive data from
					main memory)
			   WR_DTB = local memory -> DTB (send data to 
					main memory)
		type= 	DISK ( disk <-> DTB )
			LOCM (local memory <-> DTB)
 */

mslmdkdtb (direction, type)
int direction, type;
{
	register ctrldata, oldpri;

	/* send data to main memory */
	if ( direction == WR_DTB) {
		dtb_cr = FS_WRCHN;
		/* local memory/disk -> DTB (write DTB) */
		if ( type == DISK )
			ctrldata = WRDTB;
		else
			ctrldata = LOCMDTBX | WRDTB;
	}
	else {
	/* receive data from main memory */
		dtb_cr = FS_RDCHN;
		/* DTB -> local memory/disk (read DTB) */
		if ( type == DISK )
			ctrldata = RDDTB;
		else
			ctrldata = LOCMDTBX | RDDTB;
	}

	/* disable interrupt */
	oldpri = spl6();

	/* DBC control register : DTB/DISK data path mode */
	dbc_cr = (dbc_cr & CR_MASK) | ctrldata;
	*DBC_CR = dbc_cr;

	/* DTB control register : DTB function code */
	*DTB_CR = dtb_cr;

	/* DBC control register:
		local memory : enable DTB dma, CHAIN dma
		disk:		enable CHN dma, DDA dma 
	*/
	if ( type == DISK )
		dbc_cr = dbc_cr | CHN_EN | DDA_EN;
	else
		dbc_cr = dbc_cr | DTB_EN | CHN_EN; 
	*DBC_CR = dbc_cr;

	/* enable interrupt and return */
	splx (oldpri);
	return;
}

/*
	setup data path for disk <-> local memory
	enable DDC dma & DDC ALT dma
 */
msdklocm()
{	register oldpri;

	/* disable interrupt */
	oldpri = spl6();

	/* data path with DISK <-> local memory */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMEM;
	*DBC_CR = dbc_cr;

	/* DBC control register: enable DDC dma & DDC ALT dma */
	dbc_cr = dbc_cr | DDC_EN | DDA_EN;
	*DBC_CR = dbc_cr;

	/* enable interrupt */
	splx (oldpri);
}


/*
	setup data path for disk <-> local memory
	enable DDC dma
msxdkloc()
{	register oldpri;

	oldpri = spl6();

	dbc_cr = (dbc_cr & CR_MASK) | LOCMEM;
	*DBC_CR = dbc_cr;

	dbc_cr = dbc_cr | DDC_EN;
	*DBC_CR = dbc_cr;

	splx (oldpri);
}
*/
dmaddr (ptr, bytcnt, dmatype)
int ptr; int bytcnt, dmatype;
{
	register short *addrstart, *addrend;

	addrstart = (short *)((int)DDC_DMAS + dmatype);
	addrend = (short *)((int)DDC_DMAE + dmatype);

	*addrstart = (short)ptr;

	if ( dmatype == TPDMA )
		*addrend = (short)((int)ptr + bytcnt -1);
	else
		*addrend = (short)((int)ptr + bytcnt - 4);
}
