#include "edtccpu.h"
#include "edtdtc.h"
#include "icbcmd.h"
#include "edtextrn.h"
#include "vreg.h"

/*
	reset available memory size in vreg
	send interrupt back to mastercpu
	poll on interrupt reg, only understand IMEMCMD command
	(process a memory resident command packet:IWJCMD write mem & jump)
	relocate code and jump to PC addressed by 4
*/

dwnldmode() {
	register struct bd_desc *bd;
	register struct icbcmdhdr *p;
	register char *dest, *src;

	bd = &bddesc;
	locktas();

	bd->bd_memst	= (char *) (((unsigned)(&promstart)-0x0fffc) & 0xfffffffc);
	bd->bd_szmem	= ((RAMSTACK-STACKLEN) - (unsigned)bd->bd_memst); 

	/* clear TAS */
	*DTC_CRH = 1;

	/* interrupt master cpu */
	while ( ICB_OBUSY );
	*ICB_IR = (bd->bd_icbint << 13) | IDWNLD;

	/* jump back to prom code at 0x400000, red light */
	/* need to disable inturpt */
	*DTC_CRL = (dtc_ctl & LEDMASK) | redlit;

 	asm("	mov.l	&wmjump,%a0");
 	asm("	add.l	&0x400000,%a0");
	asm("	jsr	(%a0)");
}
