#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtextrn.h"


/* 12 bytes of each sector ID field */
#define SECID_LEN	12


/* ************************************************************ */
/* max have space for 0x55 (85) sectors per track               */
/* format any number of sector on the same track                */
/* input:	dev->q_devun.pdisk.sector = starting sector num */
/* 		dev->scnt = total sector to format on the track */
/* output:	return 0 if ok
/* ************************************************************ */

wridsec (dev, dkptr)
register struct devdq *dev;
struct dkinf *dkptr;
{
	register char *ptr, *bptr;
	register short  num; register ushort i;
	register uchar startsec;
	char buf[0x400];
 
	ptr = (char *)((int)(buf+2) & 0xfffffffc);
	bptr = ptr;

	num = dev->scnt;			/* # of sec */
	startsec = dev->q_devun.pdisk.sector;	/* first sector number */

	/* write sector ID from local buffer, and wait for operation */
	dev->flag = (dev->flag | DEST_L) & ~TNOWAIT;

	/* create sector ID in local buffer */
	/* each sector takeup 3 long words */
	while ( num-- ) {
		*ptr++ = FMTFLAGS;
		*ptr++ = *(char *)&dev->q_devun.pdisk.cyl;	/* cyl hi */
		*ptr++ = dev->q_devun.pdisk.cyl;		/* cyl low */
		*ptr++ = dev->q_devun.pdisk.head;
		*ptr++ = dev->q_devun.pdisk.sector++;
		*ptr++ = 0;
		*ptr++ = 0;
		*ptr++ = 0;
		*(int *)ptr = FORMDATA;
		ptr += 4;
	}
	dev->mem = (char *)bptr;
	dev->opr = OPR_WRID;
	dev->q_devun.pdisk.sector = startsec;

	/* *************************** */
	/* retry on any write ID error */
	/* *************************** */

	for (i=0; i<RETRY; i++) {
		dev->q_devun.pdisk.sector = startsec;

		if ( rwid (dev,dkptr,INDEX, dev->scnt*SECID_LEN, 0) == 0 )
			return(0);

		if ( PRINT1 ) {
			printf ("FM:IDER(%x %x %x)",
				dev->q_devun.pdisk.cyl, dev->q_devun.pdisk.head, dev->badsecn);
			printrc (dev);
		}
		/* force to reseek again */
		dkptr->curcyl = -1;
	}
	return(-1);
}



/*	format single sector ID with alt sector num

	---------------------
	|Flag| CH | CL | H  |
	|S   | ACH| ACL| AH |
	|AS  | 0  | 0  | 0  |
	|0   | 0  | 0  | 0  |
	---------------------
 */

prgalt(dev, dkptr, sprptr)
register struct devdq *dev;
register struct dkinf *dkptr;
register struct sprs *sprptr;
{
	char buf[20]; register char *iptr;

	setbuf ( buf, sizeof buf >> 1, 0 );
	iptr = (char *)( (int)(buf+2) & 0xfffffffc);

	*(int *)&dev->q_devun.pdisk.cyl = *(int *)&sprptr->cyl;
	/* dev->q_devun.pdisk.head = sprptr->head; */
	/* dev->q_devun.pdisk.sector = sprptr->sector; */

	dev->mem = (char *)iptr;
	dev->opr = OPR_WRID;
	dev->flag = (dev->flag & ~TNOWAIT) | DEST_L;
	dev->scnt = 1;

	/* character buffer */
	*iptr++ = ALTFLAG;
	*iptr++ = *(char *)&sprptr->cyl;	/* cyl hi */
	*iptr++ = sprptr->cyl;			/* cyl low */
	*iptr++ = sprptr->head;
	*iptr++ = sprptr->sector;

	*iptr++ = *(char *)&sprptr->altcyl;	/* acyl hi */
	*iptr++ = sprptr->altcyl;		/* acyl low byte */
	*iptr++ = sprptr->althead;		/* ahead */
	*iptr = sprptr->altsector;		/* asector */

	/* special timeing id register */
	*DDC_TRE = 0xff;
	
	if ( rwid (dev, dkptr,INDEX, ALT_LEN, 0) ) {
		printf ("f3");
		printrc(dev);
	}		

	*DDC_TRE = 0;
	return (0);
}
