#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edterror.h"
#include "edtextrn.h"

/*
	disk cmd = 1,2 (read/write) :
	logical drive, SINGLE logical sector, reprg c,h,s if hit alt sector
	(unix block io)
	it will SKIP bad track if any
 */
ldlogrw(dev, dkptr)
register struct devdq *dev; register struct dkinf *dkptr;
{
	register unsigned char logdr;
	register struct ld *p;

	if ( dev->scnt != 1 ) {
		dev->rc1 = DER_MULS;
		return;
	}
	/* dev->device has log drive num */
	/* dev->devnum has phy drive num */

	logdr = dev->device;
	dev->device = DISK;


	/* if physical drive not opened, read sector 0,2 in */
	if ( ckopdrive(dev, dkptr) )
		return;

	/* convert logical sectors within logical drive to
		absolute logical sectors within physical drive */

	if ( logdr >= dkptr->pd_ldnum ) {
		dev->rc1 = DER_NLOG;
		return;
	}

	p = dkptr->pd_ptr + logdr;
	/* p = p + logdr; */

	if ( dev->q_devun.block >= p->ld_size ) {
		dev->rc1 = DER_ISEC;
		return;
	} 
	dev->q_devun.block += p->ld_strt;

	/* convert absolute logical sector to c,h,s */
	if ( convl2p (dev, dkptr) )
		return;

	/* add skip track */
	if ( addtrk ( dev, dkptr, p) )
		return;

	ckchs (dev, dkptr);
	/* dev->rc1 will be set if error */
}


/*
	disk cmd = 3,4 (read/write) :
	physical drive, MULTIPLE physical sectors (c,h,s),
		if hit any alt sector, will just return.
		do not continue to read the rest of c,h,s
		no skip track
		(used by disktest)

	disk cmd = 7,8 (read/write):
	physical drive, MULTIPLE physical sectors (c,h,s),
		if hit any alt sector, will reprg c,h,s and r/w the
		alternate sector, and continue r/w the rest of the sectors.
		NO skip track

	disk cmd = 1a,1b (read/write):
	physical drive, MULTIPLE physical sectors (c,h,s),
		if hit any alt sector, will reprg c,h,s and r/w the
		alternate sector, and continue r/w the rest of the sectors.
		it will skip bad track if any, log drive num is temporary
		store in dev->q_mmu
		(use by raw io)
 */
phyrw ( dev, dkptr)
register struct devdq *dev; register struct dkinf *dkptr;
{
	register struct ld *p;
	register unsigned char logdr;

	/* if physical drive not opened, read sector 0,2 in */
	if ( ckopdrive(dev, dkptr) )
		return;


	/* insure multiple sector don't overlap track */
	if ( (dev->q_devun.pdisk.sector + dev->scnt) > dkptr->sechead ) {
		dev->rc1 = DER_MULS;
		return;
	}

	if ( (dev->cmd == PRSKALT) || (dev->cmd == PWSKALT) ) {
		logdr = (uint)dev->q_mmu % LOGDR;
		if ( logdr >= dkptr->pd_ldnum ) {
			dev->rc1 = DER_NLOG;
			return;
		}
		/* XXXXXXXX need log drive num,special for raw io */
		/* p = dkptr->pd_ptr + (dev->q_mmu/LOGDR); */

		p = dkptr->pd_ptr + logdr;
		if ( addtrk ( dev, dkptr, p ) )
			return;
	}
	else if ( (dev->cmd == PREADPS) || (dev->cmd == PWRITPS) )
		dev->flag |= NOALT;

	ckchs (dev, dkptr);
	/* dev->rc1 will be set if error */

}


/*
	disk cmd = 5,6 read/write:
	physical drive, SINGLE absolute logical sector, reprg c,h,s 
	if hit alt id sector
	(r/w into reserved area)
 */
pdlogrw ( dev, dkptr )
register struct devdq *dev; register struct dkinf *dkptr;
{
	unsigned int cyltrack; register unsigned short *ptr;
	
	/* ****************************************** */
	/* only allow rw sectors within reserved area */
	/* ****************************************** */
	if ( (dev->q_devun.block + dev->scnt - 1 ) > dkptr->rv_size ) {
		dev->rc1 = DER_ISEC;
		return(1);
	}

	if ( dev->scnt != 1 ) {
		dev->rc1 = DER_MULS;
		return;
	}

	/* if physical drive not opened, read sector 0,2 in */
	if ( ckopdrive(dev, dkptr) )
		return;

	/* convert absolut logical sector to c,h,s */
	if ( convl2p ( dev, dkptr) )
		return;

	/* ******************************** */
	/* add skip track for reserved area */
	/* ******************************** */
	if ( dkptr->numskiptrack ) {
		printf ("resv skiptrk ");
		ptr = (unsigned short *)&cyltrack;
		*ptr = dev->q_devun.pdisk.cyl;
		*(ptr+1) = dev->q_devun.pdisk.head;

		cyltrack = ppskip(cyltrack, dkptr->skplist,
				dkptr->numskiptrack, dkptr);
		if ( PRINT2 ) {
			prchs (dev);
			printf ("(%x %x)\n", *ptr, *(ptr+1));
		}

		dev->q_devun.pdisk.cyl = *ptr;
		dev->q_devun.pdisk.head = *(ptr+1);
	}

	ckchs (dev, dkptr);
	/* dev->rc1 will be set if error */
}




addtrk (dev, dkptr, ldkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
register struct ld *ldkptr;
{
	register unsigned char i; register struct badtrck *bt; register change;
	register unsigned short cyl; register unsigned short head;

	if ( ldkptr->numskiptrack == 0 )
		return(0);

	bt = ldkptr->skplist;

	change = 0;
	cyl = dev->q_devun.pdisk.cyl;
	head = dev->q_devun.pdisk.head;

	for (i=0; i<ldkptr->numskiptrack; i++) {
		if ( cyl < bt->cyl )
			break;
		if ( (cyl > bt->cyl) || ((cyl==bt->cyl)&&(head>=bt->head)) ) {
			change = 1;
			if ( ++head >= dkptr->headcyl ) {
				head = 0;
				cyl++;
			}
		}
		bt++;
	}
	if ( change == 0 )
		return(0);
	if ( PRINT2 ) {
		prchs (dev);
		printf ("(%x %x)\n", cyl, head);
	}

	if ( cyl >= dkptr->cyldisk ) {
		dev->rc1 = DER_SKTRK;
		return (-1);
	}

	dev->q_devun.pdisk.cyl = cyl;	dev->q_devun.pdisk.head = head;
	return(0);
}

ckchs (dev, dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	if ( (dev->q_devun.pdisk.cyl >= dkptr->cyldisk) ||
	     (dev->q_devun.pdisk.head >= dkptr->headcyl)||
	     (dev->q_devun.pdisk.sector >= dkptr->sechead) ) {
		dev->rc1 = DER_ISEC;
		return(-1);
	}
	return(0);
}



/* *********************************************************** */
/* return pointer to an entry that is greater than the cyltrack num */
/* *********************************************************** */
int *
pskip(track, skiplist, nel)
register int track;		/* Key to be located */
int *skiplist;			/* Beginning of table */
unsigned nel;			/* Number of elements in the table */
{
	register int *first = skiplist;
	register int *last = &skiplist[nel-1]; /*Last element in table*/
	register int res;
	while(1) {
		register int *p;

		p = first + ((last - first) >> 1);
		res = track - *p;

		if (res == 0)
			return(p+1);	/* Key found */
		if (res < 0)
			last = p-1;
		else
			first = p+1;
		if (last < first)
			return(first);
	}
}

/* track:	high word is cylinder number, low word is head num 
   skiplist:	pointer to the skip track list
   nel:		number of skip track
   dkptr:	pointer to physical drive structure

   output:	new cylinder and head number
 */
ppskip(track,skiplist,nel, dkptr)
register nel,track;
register int *skiplist;
struct dkinf *dkptr;
{
    register int *p,*p1;
    register int checksize, currenti,temp,i;

    p1 = skiplist; checksize = nel;
    currenti = 0;

    while(1) {
	p = pskip(track,p1,checksize);
	i = p - p1;

	/* track += i; <-- special track add is needed */

	track = inctrack ( track, dkptr, i );

	if(i == 0)
	    break;
	currenti += i;

	if ( (temp = nel - currenti) <= 0 )
	    break;
	checksize = i >= temp ? temp : i ;
	p1 = p;
    }

    return(track);
}


inctrack ( track, dkptr, num)
unsigned int track, num;
register struct dkinf *dkptr;
{
	register unsigned short *ptr;
	register unsigned short cyl, headn;
	
	ptr = (unsigned short *)&track;
	cyl = *(ptr);
	headn = *(ptr+1);

	/* increment track num */
	headn += num;
	while ( headn >= dkptr->headcyl ) {
		headn -= dkptr->headcyl;
		cyl++;
	}
	
	return ( ((cyl <<16) & 0xffff0000) | headn );
}
