#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "devcmd.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtextrn.h"
#include "vreg.h"


#define DISKIO	1

int dkopen(), diskclose(), dkcmder(), dkcompl();

extern ldlogrw(),	phyrw(),	pdlogrw();
extern pformat(),	diskio(),	formatio();
extern diskopen();
extern getbdblk(),	nextrvsec(),	phspare(),	meddef();
extern hwspare(),	getaltblk(),	swapdev();
extern fddisksz(),	fmtrack(),	unspare();
extern wrsysec(),	setiming(),	seekio();

struct dcmd {
	int (*func)(); uchar io; uchar opr;
} dcmdtbl[] = {
#ifdef PROM
	dkcmder,	0,	0,	/* 0 */
	ldlogrw,	DISKIO,	OPR_READ, /* 1 log dr,log sec(1),spare lookup */
	ldlogrw,	DISKIO,	OPR_WRITE,
	phyrw,		DISKIO,	OPR_READ, /* 3 phydr,c,h,s(multiple),no spare */
	phyrw,		DISKIO, OPR_WRITE,
	pdlogrw,	DISKIO, OPR_READ, /* 5 phydr,log sect(1),spare lookup */
	pdlogrw,	DISKIO, OPR_WRITE,

	phyrw,		DISKIO,	OPR_READ, /* 7 phy dr,c,h,s(mult)spare lookup */
	phyrw,		DISKIO,	OPR_WRITE,

	dkcmder,	0,	0,	/* 9 */
	dkcmder,	0,	0,	/* a */
	dkcmder,	0,	0,	/* b */
	dkcmder,	0,	0,	/* c */

	dkcmder,	0,	0,	/* d format drive */

	dkopen,		0,	0,	/* e (reopen) read sector 0 */
	diskclose,	0,	0,	/* f erase table for phy drive */

	dkcmder,	0,	0,	/* 10 size disk */
	dkcmder,	0,	0,	/* 11 get bad blk list */
	dkcmder,	0,	0,	/* 12 next avail rv sector */

	dkcmder,	0,	0,	/* 13 prg alt, set spare tbl */
	dkcmder,	0,	0,	/* 14 med list */
	dkcmder,	0,	0,	/* 15 total bad blk num */

	dkcmder,	0,	0,	/* 16 prg alt sect to -1 */
	dkcmder,	0,	0,	/* 17 total alt sect num */
	dkcmder,	0,	0,	/* 18 get alt sect list */
	dkcmder,	0,	0,	/* 19 swap devices */

	phyrw,		DISKIO,	OPR_READ, /* 1a,1b: pdr,chs(mult)spare lookup */
	phyrw,		DISKIO,	OPR_WRITE,/* skip track */

	dkcmder,	0,	0,	/* 1c fmt track */
	dkcompl,	0,	0,	/* 1d wait for all diskio completed */

#else
	dkcmder,	0,	0,	/* 0 */
	ldlogrw,	DISKIO,	OPR_READ, /* 1 log dr,log sec(1),spare lookup */
	ldlogrw,	DISKIO,	OPR_WRITE,

	phyrw,		DISKIO,	OPR_READ, /* 3 phydr,c,h,s(multiple),no spare */
	phyrw,		DISKIO, OPR_WRITE,
	pdlogrw,	DISKIO, OPR_READ, /* 5 phydr,log sect(1),spare lookup */
	pdlogrw,	DISKIO, OPR_WRITE,

	phyrw,		DISKIO,	OPR_READ, /* 7 phy dr,c,h,s(mult)spare lookup */
	phyrw,		DISKIO,	OPR_WRITE,

	dkcmder,	0,	0,	/* 9 */
	dkcmder,	0,	0,	/* a */
	dkcmder,	0,	0,	/* b */
	dkcmder,	0,	0,	/* c */

	pformat,	0,	OPR_WRID, /* d */

	dkopen,		0,	0,	/* e (reopen) read sector 0 */
	diskclose,	0,	0,	/* f erase table for phy drive */


	fddisksz,	0,	0,	/* 10 size disk */
	getbdblk,	0,	0,	/* 11 get bad block list */
	nextrvsec,	0,	0,	/* 12 next available rv sector */
	phspare,	0,	0,	/* 13 prg alt, set spare table */

	meddef,		0,	0,	/* 14 med list */
	getbdblk,	0,	0,	/* 15 total bad blk number */

	hwspare,	0,	0,	/* 16 prg alt sector to -1 */
	getaltblk,	0,	0,	/* 17 total alt sectors number */

	getaltblk,	0,	0,	/* 18 get alt sectors list */
	swapdev,	0,	0,	/* 19 swap device */
	
	phyrw,		DISKIO,	OPR_READ, /* 1a,1b: pdr,chs(mult)spare lookup */
	phyrw,		DISKIO,	OPR_WRITE,/* skip track */
	fmtrack,	0,	0,	/* 1c format single track */

	dkcompl,	0,	0,	/* 1d wait for all diskio completed */

	unspare,	0,	0,	/* 1e unspare sector */
	setiming,	0,	0,	/* 1f setup timing parameters */
	wrsysec,	0,	0,	/* 20 write system sectors */
	seekio,		0,	0,	/* 21 seek to specify cyl number */
#endif

};
	
dkparse(dev)
register struct devdq *dev;
{
	register unsigned char operation; register temp;
	register struct dkinf *dkptr; register struct dcmd *p;

	if ( bddesc.tas1 & STOPDKIO )
		stop();

	/* check for valid disk command */
	if ( dev->cmd >= (sizeof dcmdtbl / sizeof(struct dcmd)) ) {
		dev->rc1 = DER_ILLCMD;
		dev->flag |= OPRDONE;
		return (-1);
	}

	p = &dcmdtbl[dev->cmd];

	/* only convert for read write command */
	operation = p->opr;

	if ( (operation == OPR_READ) || (operation == OPR_WRITE) ) {
		/* can't take care of partial sectors */
		if ( (dev->totcnt < BLKSIZE) || (dev->totcnt & (BLKSIZE-1))
|| (dev->totcnt == 0) || (((int)dev->mem & 0x03) && (bd_in_system == A1000))) {
			dev->rc1 = DER_CNT;
			dev->flag |= OPRDONE;
			return (-1);
		}
		/* convert total count to sector count, main memory shifted */
		dev->scnt = dev->totcnt >> 10;
		dev->sectleft = dev->scnt;
		dev->totsdone	= 0;
	}

	*((short *)&dev->rc1) = 0;	/* zero return code */

	dev->opr = operation;		/* set operation code */

	/* special case log drive */
	if ( (dev->cmd == LREAD) || (dev->cmd == LWRITE) ) {
		/* use device to store log drive */
		dev->device= dev->devnum % LOGDR;
		dev->devnum = dev->devnum / LOGDR;
	}
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		dev->flag |= OPRDONE;
		return(-1);
	}

	(p->func) (dev, dkptr);

	if ( *(short *)&dev->rc1 ) {
		dev->flag |= OPRDONE;
		return (-1);
	}


	/* perform io */
	if ( p->io == DISKIO )
		diskio(dev, dkptr);
	else 
		dev->flag |= OPRDONE;

}

dkcmder(dev,dkptr)
struct devdq *dev; struct dkinf *dkptr;
{
	dev->rc1 = DER_ILLCMD;
	dev->flag |= OPRDONE;
}
/*
dum(dev, dkptr)
struct devdq *dev;
{
	dev->flag |= OPRDONE;
	return;
}
*/

/* read sector 0, 2 in data area again */
dkopen (dev, dkptr)
struct devdq *dev; struct dkinf *dkptr;
{
	diskclose (dev, dkptr);
	diskopen (dev, dkptr);
}


diskclose (dev, dkptr)
register struct devdq *dev; register struct dkinf *dkptr;
{
	register struct ld *ldkptr;
	register ushort stat;

	/* keep other bits */
	stat = dkptr->pd_ststat &  (~DK_INIT);

	setbuf ( dkptr, sizeof (struct dkinf) >> 1, 0);

	dkptr->curcyl = -1;
	dkptr->pd_ststat = stat;

	ldkptr = &log[(short)(dev->devnum * LOGDR)];
	setbuf ( ldkptr,((sizeof(struct ld))*LOGDR)>>1, 0);
}


/*
	request to wait for all disk io to be completed, then
	send back the response to the master cpu
 */
dkcompl (dev, dptr)
register struct devdq *dev; struct dkinf *dptr;
{
	register ushort i, j; register oldpri;
	register struct dkinf *dkptr;

	dkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		while (1) {
			oldpri = spl6();
			if ( dkptr->next == 0 ) {
				splx(oldpri);
				break;		/* no que, check next drive */
			}
			splx(oldpri);
			j = 1000;
			while (j--);	/* wait, then ckeck again */
		}
		dkptr++;
	}

	/* also check there is no que on curwreq */
	while (1) {
		oldpri = spl6();
		if ( curwreq == 0 ) {
			splx(oldpri);
			break;
		}
		splx(oldpri);
		j = 1000;
		while (j--);	/* wait, then ckeck again */
	}

}
