#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtextrn.h"


/*	format sector ID with alt sector num

	---------------------
	|Flag| CH | CL | H  |
	|S   | ACH| ACL| AH |
	|AS  | 0  | 0  | 0  |
	|0   | 0  | 0  | 0  |
	---------------------
 */

/*  	ZS <D> <C> <H> <S> <AC> <AH> <AS> */

fmtasect(dev, bufptr)
register struct devdq *dev;
char *bufptr;
{
	int argu[7]; register struct dkinf *dkptr;
	struct sprs spbuf; register struct sprs *sprptr;

	if ( getarg (bufptr, argu, 7) < 0 )
		return (-1);

	dev->devnum = argu[0];
	sprptr = &spbuf;
	sprptr->cyl = argu[1];
	sprptr->head = argu[2];
	sprptr->sector = argu[3];
	sprptr->altcyl = argu[4];
	sprptr->althead = argu[5];
	sprptr->altsector = argu[6];
	
	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 )
		return(0);

	prgalt(dev, dkptr, sprptr);

	return(0);
}

