#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtdtc.h"
#include "edtextrn.h"

#define STARTCYL	1


/*
	seek cylinder in a loop
	KL  <drive number>
	K <drive number > <cyl>
 */

seek(bufptr)
char *bufptr;
{
	int argu[3]; register loopcnt;
	register struct devdq *dev;
	register struct dkinf *dkptr;
	register oldpri;

	dev = &req;
	initdevq (dev);

	if ( *(bufptr+1) == 'L' ) {
		if ( getdrive(bufptr) )
			return(-1);
		dev->q_devun.pdisk.cyl = STARTCYL;
	}
	else {
		if ( getarg(bufptr, argu, 2)<0 )
			return (-1);
 		if ( argu[0] >= MAX_PDRIVE )
			return (-1);

		dev->devnum = argu[0];
		dev->q_devun.pdisk.cyl = argu[1];
	}

	loopcnt = 0;

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}

	/* no read/write */
	dev->opr = 0xff;

	/* stop if receiving character 'Q' */
	while ( con_in() != 'Q' ) {
		if ( dev->q_devun.pdisk.cyl >= cylsize )
			return (-1);

		if ( PRINT1 )
			printf ("C=%x loop=%x  \r", dev->q_devun.pdisk.cyl, loopcnt);
		oldpri = spl6();
		if ( aseek (dev,dkptr,oldpri) ) 
			/* seek problem, drive already rezero */
			break;
	
		/* inturpt will be enabled by aseek */
		if ( *(bufptr+1) != 'L' )
			break;		/* not loop mode */

		dev->q_devun.pdisk.cyl += 0x10;	/* increment cylinder # */

		if ( dev->q_devun.pdisk.cyl >= cylsize ) {
			loopcnt++;
			dev->q_devun.pdisk.cyl = (STARTCYL + loopcnt) & 0x001f;
			blinkled();
		}
	}
	printlf();
	return (0);
}

/* rezero drive
	RZ <drive>
 */
rezerodr (bufptr)
char *bufptr;
{	register struct devdq *dev;
	register struct dkinf *dkptr;
	register ret, oldpri;

	if (*(bufptr+1) != 'Z')
		return(-1);
	if ( getdrive(bufptr) )
		return(-1);
	dev = &req;

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}

	oldpri = spl6();

	dkrezero (dev->devnum,dkptr);

	splx(oldpri);
	return (0);
}



/*
 * XR/W[L]  <addrress>  <drive>  <cyl>  <head>  <sector>  <sector count>
 */

rwdisk (bufptr)
char *bufptr;
{	register char *cptr;
	register struct devdq *dev;
	register struct dkinf *dkptr;
	register unsigned int numsec, num;
	register char flag = 1;
	int loopcnt;

	dev = &req;
	initdevq (dev);
	dev->device = DISK;

	bufptr++;
	cptr = bufptr;
	cptr++;

	if ( *bufptr == 'R' )
		dev->opr = OPR_READ;
	else  {
		/* write & read loop if "WRL"  */
		if ((*(bufptr+1) == 'R') && (*(bufptr+2) == 'L' ))
			return (wrloop(bufptr));

		/* get password on write loop */
		if ( *cptr == 'L' ) {
			if ( getpasswd() )
				return (-1);
		}
		dev->opr = OPR_WRITE;
	}

	loopcnt = 0;
	if ( inputarg (bufptr, cptr, dev, flag) )
		return (-1);

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}


	/* can't overlap track, insure input C,H,S is valid */
	if ( cklimit (dev) == -1 )
		return (-1);

	if ( *cptr != 'L' ) {
		if ( diskio(dev, dkptr) )
			printrc(dev);
		return(0);
	}


	numsec = dev->scnt;

	while ( con_in() != 'Q' ) {
		num = numsec; dev->q_devun.pdisk.sector = 0;
		while ( num ) {
			if ( num > SEC84_HEAD ) {
				dev->scnt = SEC84_HEAD;
				num -= SEC84_HEAD;
			}
			else {
				dev->scnt = num;
				num = 0;
			}

			printchs (dev, loopcnt);

			/* read or write sector */
			diskio(dev, dkptr);

			dev->q_devun.pdisk.sector += dev->scnt;
		}
		incchs (dev,&loopcnt);
	}
	printlf();
	return (0);
}

/*
 * E <addrress>  <drive>  <cyl>  <head>  <sector>  <sector count>
 */

readid (bufptr)
char *bufptr;
{	register char *cptr;
	register struct devdq *dev;
	register struct dkinf *dkptr;
	int loopcnt; register ret;
	register int *ptr; register int i; register temp;
	register char flag1=0;
	short flag = 1;

	dev = &req;
	initdevq (dev);
	dev->device = DISK;

	cptr = bufptr+1;

	loopcnt = 0;
	if ( inputarg (bufptr, cptr, dev, flag1) )
		return (-1);

	dev->opr = OPR_RDID;

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return(0);
	}

	/* can't overlap track, insure input C,H,S is valid */
	if ( cklimit (dev) == -1 )
		return (-1);

	while ( con_in() != 'Q' ) {
		if ( *cptr == 'L' ) {
			printchs (dev, loopcnt);
		} else flag = 3;

		/* seek to cyl, read id */
		ret = rwid (dev,dkptr,INDEX, dev->scnt*8, flag);

		if ((ret != 5) && ((*cptr != 'L') || ret))
			break;			/* get out of while loop */
		if ((ret == 0) && (dev->scnt == sectsize)) 
			checkid (dev);
		
		/* each sector has 8 bytes id field */
		setbuf (dev->mem, dev->scnt * 4, 0 );
		setbuf (dev->mem+dev->scnt*8, dev->scnt * 4, 0 );
		if (ret != 5) {
			dev->q_devun.pdisk.sector = 0;
			dev->scnt = sectsize;
			incchs ( dev, &loopcnt);
		}
	}
	printlf();
	return (0);
}

checkid (dev)
register struct devdq *dev;
{
	register int i; register short *ptr;
	ptr = (short *)dev->mem;

	for (i=0; i<dev->scnt; i++) {
		ptr+=2;
		if ( *ptr++ != dev->q_devun.pdisk.cyl ) {
			printf ("\nCYL id error, cyl=%3X, head=%2X\n",dev->q_devun.pdisk.cyl,
			  dev->q_devun.pdisk.head);
			return (-1);
		}
		if ( *ptr++ != (short)((dev->q_devun.pdisk.head<<8)|i) ){
			printf ("\nHD or SECTR id error, cyl=%3X, head=%2X\n",dev->q_devun.pdisk.cyl,
			  dev->q_devun.pdisk.head);
			return (-1);
		}
	}
	return (0);
}

inputarg( bufptr, cptr, dev, flag)
char *bufptr; register char *cptr; register struct devdq *dev;
register char flag;
{
	int argu[6];

	dev->flag = DEST_L;		/* assume local memory */

	if ( *cptr == 'L' ) {
		if  ( getarg(bufptr, argu, 1) < 0)
			return (-1);
		dev->mem = (char *)LOCA;
		dev->devnum = (char)argu[0];
		dev->q_devun.pdisk.cyl = STARTCYL;
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.sector = 0;
		dev->scnt = sectsize;
	}
	else if  ( *cptr == ' ' || *cptr == 'M' ) {
		if  ( getarg(bufptr, argu, 6) < 0)
			return (-1);
		if ((argu[0]<0x1000) || (argu[0]>0xc000))
			return(-1);
		dev->mem = (char *)argu[0];
		if (argu[1]>3)
			return(-1);
		dev->devnum = (char)argu[1];
		dev->q_devun.pdisk.cyl = argu[2];
		dev->q_devun.pdisk.head = argu[3];
		dev->q_devun.pdisk.sector = argu[4];
		if (flag && ((argu[0]+(argu[5]<<10))>0xc000))
			return(-1);
		dev->scnt = argu[5];
		if ( *cptr == 'M' ) {
			dev->flag &= ~DEST_L;	/* main memory */
			dev->mem = (char *)((int)dev->mem >> 2);
		}
	}
	else 
		return (-1);
	return (0);
}


cklimit(dev)
register struct devdq *dev;
{
	if ( ((dev->q_devun.pdisk.sector+dev->scnt) > sectsize) || 
	(dev->q_devun.pdisk.cyl >= cylsize) || 
	(dev->q_devun.pdisk.head >= headsize) )
		return (-1); 
	return (0);
}


getdrive(bufptr)
char *bufptr;
{	int argu[2]; register struct devdq *dev;
	if ( getarg(bufptr, argu, 1)<0 )
		return (-1);
 	if ( argu[0] >= MAX_PDRIVE )
		return (-1);

	/* initialize the device que to zero */
	dev = &req;
	initdevq (dev);
	dev->devnum = argu[0];
	dev->device = DISK;
	return (0);
}

/* 
	input default disk size
	N    <# of cyl/drive> <# of head/cyl> <# of sectors/head>
 */
disksize(bufptr)
char *bufptr;
{
	int argu[3];
	if  ( getarg(bufptr, argu, 3) < 0)
		return (-1);
	cylsize = argu[0];
	headsize = argu[1];
	sectsize = argu[2];
	return (0);
}

printchs(dev, loopcnt)
struct devdq *dev; int loopcnt;
{
	if ( PRINT1 ) {
		prchs (dev);
		printf ("loop=%x   \r",loopcnt);
	}
}

getpasswd()
{
	char buf[10];
	printf ("password:");
	if ( get(buf, sizeof buf -1) < 0 )
		return (-1);
	if ( *(int *)buf != 'ETER' )
		return (-1);
	return(0);
}

wrloop (bufptr)
char *bufptr;
{	register char *cptr; register short *sptr;
	register struct devdq *dev;
	register struct dkinf *dkptr;
	register i, compflag, num, numsec; int loopcnt;
	register char flag;

	dev = &req;
	initdevq (dev);
	dev->device = DISK;

	cptr = bufptr+2;

	loopcnt = 0;

	if ( inputarg (bufptr, cptr, dev, flag) )
		return (-1);

	if ( getpasswd() )
		return (-1);

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}

	/* clear area to record error */
	sptr = (short *)LOCA;
	setbuf ( LOCA, 0x1000/2, 0 );
	numsec = dev->scnt;	/* num of sec per head */

	while ( con_in() != 'Q' ) {
		dev->q_devun.pdisk.sector = 0;
		printchs(dev,loopcnt);

		dev->opr = OPR_WRITE;
		compflag = 1;

		/* write sector and read sector */
		for ( i=0; i<2; i++) {
			num = numsec; dev->q_devun.pdisk.sector = 0;
		
			/* may split into 2 times > 18 sectors/head */
			while ( num ) {
				if ( num > SEC84_HEAD ) {
					dev->scnt = SEC84_HEAD;
					num -= SEC84_HEAD;
				}
				else {
					dev->scnt = num;
					num = 0;
				}
				if ( dev->opr == OPR_WRITE )
					filldata (dev);
			
				if (diskio(dev,dkptr)||(*(short *)&dev->rc1)) {
					compflag = 0;	/* don't compare data */
					sptr =(short *) (recordchs (dev, sptr));
				}
				/* compare data if there is no error on r/w */
				if ( (dev->opr == OPR_READ) && compflag ) {
					if ( compdata (dev) )
						return (0);
				}
				dev->q_devun.pdisk.sector += dev->scnt;
			}
			dev->opr = OPR_READ;
		}
		incchs (dev,&loopcnt);
	}
	printlf();
	return (0);
}

filldata( dev)
register struct devdq *dev;
{	register i,j, data, sectnum; register int *ptr;

	ptr = (int *)dev->mem;
	sectnum = dev->q_devun.pdisk.sector;
	for (i=0; i<dev->scnt; i++) {
		data = (dev->q_devun.pdisk.cyl << 16) | (dev->q_devun.pdisk.head << 8) | (sectnum++);
		for ( j=0; j< BLKSIZE/4; j++)
			*ptr++ = data;
	}
}

compdata( dev)
register struct devdq *dev;
{	register i, j, sectnum; register int *ptr; register int data;

	ptr = (int *)dev->mem;
	sectnum = dev->q_devun.pdisk.sector;

	for (i=0; i<dev->scnt; i++) {
		data = (dev->q_devun.pdisk.cyl << 16) | (dev->q_devun.pdisk.head << 8) | (sectnum++);
		for ( j=0; j<BLKSIZE/4; j++) {
			if ( *ptr++ != data ) {
				printf ("\ndata don't match (sec=%x)\n",data);
				return (-1);
			}
		}
	}
	return (0);
}

recordchs (dev, sptr)
register struct devdq *dev;
register short *sptr;
{
	*sptr++ = dev->q_devun.pdisk.cyl;
	*sptr++ = (dev->q_devun.pdisk.head <<8) | dev->badsecn;
	*sptr++ = *((short *)&dev->rc1);
	*sptr++ = dev->opr;
	if ( (int)sptr >= LOCB )
		sptr = (short *)LOCA;
	return ((int)sptr);
}
