#include "vreg.h"
#include "edtextrn.h"
#define ESCAPE 0x1b  /* ascii ESCAPE character */
typedef int (*PFI)();
extern char *skiparg();

union location {
	unsigned char byte;
	unsigned short word;
	unsigned lword;
};

/* defines for magic number */
#define BYTE	1
#define WORD	2
#define LWORD	4

getmagic(ptr)
	char **ptr;
{
	switch(*(*ptr-1)) {
		case 'L':
			return(LWORD);
		case 'B':
			return(BYTE);
		default:
			return(WORD);
	}
}

compare(ptr)
	register char **ptr;
{
	register int magic = getmagic(ptr);
	register union location *addr0, *addr1, *end;
	register unsigned dat0, dat1;
	unsigned temp[3];

	if (gtarg(ptr,temp,3) < 0) argerr(ptr);
	else {
		addr0 = (union location *)temp[0];
		addr1 = (union location *)temp[1];
		end = (union location *)(temp[0] + temp[2]);
		if (((int)addr0 & (magic-1)) || ((int)addr1 & (magic-1)))
			return(-1);
		while(addr0 < end) {
			switch(magic) {
				case BYTE:
					dat0 = addr0->byte;
					dat1 = addr1->byte;
					if(dat0 != dat1)
						printf("%06x = %02x    %06x = %02x\n",addr0,dat0,addr1,dat1);
					break;
				case WORD:
					dat0 = addr0->word;
					dat1 = addr1->word;
					if(dat0 != dat1)
						printf("%06x = %04x    %06x = %04x\n",addr0,dat0,addr1,dat1);
					break;
				case LWORD:
					dat0 = addr0->lword;
					dat1 = addr1->lword;
					if(dat0 != dat1)
						printf("%06x = %08x    %06x = %08x\n",addr0,dat0,addr1,dat1);
					break;
			}
			addr0 = (union location *)((int)addr0 + magic); /* bump the address */
			addr1 = (union location *)((int)addr1 + magic); /* bump the address */
		/* former abort check */
		}
	}
	return(0);
}

move(ptr)
	register char **ptr;
{
	register int magic = getmagic(ptr);
	register union location *addr0, *addr1, *end, *lastwrt;
	unsigned temp[3];
	unsigned resp;

	if (gtarg(ptr,temp,3) < 0) argerr(ptr);
	else {
		addr0 = (union location *)temp[0];
		addr1 = (union location *)temp[1];
		end = (union location *)(temp[0] + temp[2]);
		lastwrt = (union location *)(temp[1] + temp[2]);
		if (((int)addr0 & (magic-1)) || ((int)addr1 & (magic-1)))
			return(-1);
		if (((int)addr1<0x1000) || (((int)addr1>0xc000) && ((int)addr1<0x20000)) ||
		((int)lastwrt<0x1000) || (((int)lastwrt>0xc000) && ((int)lastwrt<0x20000))) {
			printf("WARNING - doing this will alter program code/data space\n");
			printf("do you want to continue? (y/n)");
			resp=getchar();
			printf("\n");
			if (resp != 'y') return(0);
		}
		while(addr0 < end) {
			switch(magic) {
				case BYTE:
					addr1->byte = addr0->byte;
					break;
				case WORD:
					addr1->word = addr0->word;
					break;
				case LWORD:
					addr1->lword = addr0->lword;
					break;
			}
			addr0 = (union location *)((int)addr0 + magic); /* bump the address */
			addr1 = (union location *)((int)addr1 + magic); /* bump the address */
			/* former abort check */
		}
	}
	return(0);
}

fill(ptr)
	register char **ptr;
{
	register int magic = getmagic(ptr);
	register union location *addr0, *end;
	register unsigned value;
	unsigned temp[3];
	unsigned resp;

	if (gtarg(ptr,temp,3) < 0) argerr(ptr);
	else {
		addr0 = (union location *)temp[0];
		end = (union location *)(temp[0] + temp[1]);
		value = temp[2];
		if ((int)addr0 & (magic-1))
			return(-1);
		if (((int)addr0<0x1000) || (((int)addr0>0xc000) && ((int)addr0<0x20000)) ||
		((int)end<0x1000) || (((int)end>0xc000) && ((int)end<0x20000))) {
			printf("WARNING - doing this will alter program code/data space\n");
			printf("do you want to continue? (y/n)");
			resp=getchar();
			printf("\n");
			if (resp != 'y') return(0);
		}
		while(addr0 < end) {
			switch(magic) {
				case BYTE:
					addr0->byte = value;
					break;
				case WORD:
					addr0->word = value;
					break;
				case LWORD:
					addr0->lword = value;
					break;
			}
			addr0 = (union location *)((int)addr0 + magic); /* bump the address */
			/* former abort check */
		}
	}
	return(0);
}

display(ptr)
	register char **ptr;
{
	register int magic = getmagic(ptr);
	register union location *addr0, *end;
	register unsigned char c;
	register int i;
	char inbuf[10];
	char *c_ptr;
	unsigned temp, length;

	if (gtlong(ptr,&temp) < 0) argerr(ptr);
	else {
		addr0 = (union location *)temp;
		if ((int)addr0 & (magic-1))
			return(-1);
		if (gtlong(ptr,&length) < 0) { /* no length specified, one byte at a time */
			if (((int)addr0<0x1000) || (((int)addr0>0xc000) && ((int)addr0<0x20000)))
			  printf("this is program code/data space, use extreme caution when modifying\n");
			while(1) {
				printf("%06x = ",addr0);
				switch(magic) {
					case BYTE:
						printf("%02x",addr0->byte);
						break;
					case WORD:
						printf("%04x",addr0->word);
						break;
					case LWORD:
						printf("%08x",addr0->lword);
						break;
				}
				printf(" > ");
				c_ptr = inbuf;
				gt(c_ptr,sizeof(inbuf));
				ptchar('\n');
				/* former abort check */
				switch(*c_ptr) {
					case 'q': return(0); /* quit */
					case 'p':
						addr0 = (union location *)((int)addr0 - magic); /* previous location */
						continue;
					case 0: break; /* next location */
					default:
						if(gtlong(&c_ptr,&temp) < 0) {
							argerr(&c_ptr);
							continue; /* same location again */
						} else {
							switch(magic) {
								case BYTE:
									addr0->byte = temp;
									break;
								case WORD:
									addr0->word = temp;
									break;
								case LWORD:
									addr0->lword = temp;
									break;
							}
						}
						break; /* next location */
				}
				addr0 = (union location *)((int)addr0 + magic); /* bump the address */
			}
		} else {
			end = (union location *)(temp + length);
			while(addr0 < end) {
				/* round down to paragraph boundary */
				addr0 = (union location *)((int)addr0 & 0xfffffff0);
				printf("%06x  ",addr0);
				for (i=0; i<16;) {
					switch(magic) {
						case BYTE:
							printf("%02x ",((union location *)((int)addr0 + i))->byte);
							i++;
							break;
						case WORD:
							printf("%04x ",((union location *)((int)addr0 + i))->word);
							i += 2;
							break;
						case LWORD:
							printf("%08x ",((union location *)((int)addr0 + i))->lword);
							i += 4;
							break;
					}
				}
				for (i=0; i<16; i++) { /* ascii representation */
					c = ((union location *)((int)addr0 + i))->byte;
					ptchar((c > ' ') && (c < 0x7f) ? c : '.');
				}
				ptchar('\n');
				addr0 = (union location *)((int)addr0 + 16);
				/* former abort check */
			}
		}
	}
	return(0);
}

jump(ptr)
	register char **ptr;
{

	PFI dest;

	if (getlong(ptr,&dest) < 0) argerr(ptr);
	if ((int)dest & 3)
		return(-1);
	else (*dest) ();
}

help(bufptr) 
char *bufptr;
{
	printf("\n\n\
COMMAND SUMMARY - all numeric values must be entered in hex - size in bytes -\n\
    d <addr> <size><ret>        (display specified range in hex)\n\
    d <addr><ret>               (display and allow alteration of location)\n\
        <ret>                   (skip to next location)\n\
        <val><ret>              (alter this location and go on to next)\n\
        p<ret>                  (skip back to previous location)\n\
        q<ret>                  (quit)\n\
    c <addr1> <addr2> <size><ret>    (compare specified range)\n\
    m <addr1> <addr2> <size><ret>    (move specified range)\n\
    f <addr> <size> <val><ret>  (fill range)\n\
note: all above commands may be suffixed with 'l','w', or 'b' (dl,dw, or db)\n\
        to specify longword, word, or byte respectively (default is word)\n\
    j <address><ret>            (jump to address)\n\
    n <# cyls/drive> <#tracks/drive> <#sectors/drive> <ret>\n\
	     (specify the physical size of the drive -\n\
             for 84MB disk use  - 24d  7 12\n\
	     for 168MB disk use - 337  a 12\n\
	     for 337MB disk use - 337  a 24\n\
	     for 515MB disk use - 2c7 24 1a\n\
	     for eagle disk use - 349 14 19\n\
	     for eagle x-p disk use - 349 14 24)\n\
");
	if (bd_in_system == S90)
	printf("\
    i <memslot><main memory addr><EDT memory address><# of long words><ret>\n\
	     (transfer data from main memory to EDT local memory)\n\
");
    else
	printf("\
    i <main memory addr><EDT memory address><# of long words><ret>\n\
	     (transfer data from main memory to EDT local memory)\n\
");
	printf("\
press any key to continue, [ESC] to quit ");

	getchar();

	printf("\r");
	if (bd_in_system == S90)
	printf("\
    o <memslot><EDT memory addr><main memory address><# of long words><ret>\n\
	    (transfer data from EDT local memory to main memory)\n\
    q <memslot><EDT memory addr><main memory address><# of long words><ret>\n\
	    (transfer data from edt to main memory and back and compare)\n\
    s <dma number>              (set the dma channel number to be used)\n\
");
    else
	printf("\
    o <EDT memory addr><main memory address><# of long words><ret>\n\
	    (transfer data from EDT local memory to main memory)\n\
    q <EDT memory addr><main memory address><# of long words><ret>\n\
	    (transfer data from edt to main memory and back and compare)\n\
");
	printf("\
    ts <drive><ret>             (tape status)\n\
    tb <drive><ret>             (rewind tape)\n\
    te <drive><ret>             (erase tape)\n\
    tt <drive><ret>             (tension tape)\n\
    trf <drive><ret>            (tape read file mark)\n\
    twf <drive><ret>            (tape write file mark)\n\
    tcf <drive><ret>            (9t tape forward a record)\n\
    tcr <drive><ret>            (9t tape reverse a record)\n");
    printf
("    tsm <drive><argu 1><argu 2><ret> (9t set drive mode and speed)\n\
	  argu 1) 0 - set stream mode, 1- set start & stop mode\n\
	  argu 2) 0 - set high speed, 1- set low speed\n\
    tcf <drive><ret>            (9t reverse to last file mark)\n\
    tr <addr> <drive> <size><ret>    (tape read)\n\
    tw <addr> <drive> <size><ret>    (tape write)\n\
press any key to continue, [ESC] to quit ");

	getchar();


	printf("\r\
    rz <drive><ret>              (rezero drive)\n\
    k <drive><cylinder><ret>     (seek to cylinder)\n\
    e <EDT address><drive><cyl><head><sector><sector count><ret>\n\
	  (read sector id(s))\n\
    g  <n><ret>   where 'n' = 0 for the eagle, 1 for the smd,\n\
             and 2 for the esmd (load disk timing registers)\n\
    xr <addr> <drive> <cyl> <head> <sect> <sector count><ret> (disk read)\n\
    xw <addr> <drive> <cyl> <head> <sect> <sector count><ret> (disk write)\n\
    y <address> <drive> <cyl> <head> <sector> <sector count><ret>\n\
	     (read media defect list)\n\
    zt <drive> <c> <h> <scnt> <datapattern><ret> (format track)\n\
    \n\
        note: commands i, o, q, k, e, xr, xw, and y can be suffixed\n\
	   with 'l' for loop mode in which case the only argument\n\
	   that may be specified is the drive number (if required)\n\
");
   return(0);
}

gt(buf_ptr,buf_size)
	char *buf_ptr;
	unsigned buf_size;
{
	register char c;
	register unsigned charnum;

	charnum = 0;
	while(1) {
		if ((c = getchar()) == '\r') break;
		switch (c) {
			case '\b':
				if (charnum) {
					printf("\b \b");
					--charnum; --buf_ptr;
				} break;
			default: ++charnum; ptchar(c);
				*buf_ptr++ = c; break;
		}
		if (charnum == buf_size) return(-1);
	}
	*buf_ptr = 0; /* terminate the string */
	return(charnum);
}

gtlong(buf_vector,ret_val)
	register char **buf_vector;
	unsigned *ret_val;
{
	register char c, *ptr;
	register unsigned value = 0; /* init */

	skpsp(buf_vector); /* skip over possible spaces */
	ptr = *buf_vector;
	while ((c = asc_to_hex(*ptr)) != -1) { /* convert all valid characters */
		value = (value << 4) + c; /* add in value */
		ptr++;
	}
	if (!isdelimit(*ptr) || ptr == *buf_vector) return(-1); /* invalid character or no arg */
	*buf_vector = ptr; /* point where we left off */
	*ret_val = value;
	return(0);
}

gtarg(buf_vector,ret_val,num_args)
	char **buf_vector;
	register unsigned *ret_val;
	register unsigned num_args;
{
	while (num_args--) {
		if (getlong(buf_vector,ret_val++) < 0) return(-1);
	}
	return(0);
}

argerr(ptr)
	register char **ptr;
{
	if(**ptr == 0) printf("missing argument\n");
	else printf("bad argument:  %s\n",*ptr);
	while(1) {
		switch(**ptr) {
			case 0:
			case ';':
				return;
			default:
				(*ptr)++;
				break;
		}
	}
}

skpsp( vector ) register char **vector; {
	while( **vector == ' ' ) (*vector)++;
}

isdelimit( c ) register char c; {
	switch (c) {
		case ' ':
		case ';':
		case  0 : return(1);
		default : return(0);
	}
}

asc_to_hex( c ) register char c; {
	if (c >= '0' && c <= '9') return(c - '0');
	if (c >= 'A' && c <= 'F') return(c + (10 - 'A'));
	if (c >= 'a' && c <= 'f') return(c + (10 - 'a'));
	return(-1);
}

ptchar(c)
	register char c;
{
	if (c != ESCAPE) {
		con_out (c);
		if (c == '\n') con_out ('\r');
	}
	return;
}
