#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtdata.h"
#include "vreg.h"
#include "edtextrn.h"

ckreq()
{	register struct devdq *dev, *nextdq;
	register struct dkinf *dkptr;
	register int oldpri;

	while ( 1 ) {
		oldpri = spl6();
		if ( (inturpt & ICB_INT) && ((icbdata & ICBI_MASK)== 0) ) {
			inturpt &= ~ICB_INT;
			icbdata = 0xff;
		}
	
		locktas();
		if ( (int)bddesc.reqfst == 0 ) {
			/* clear TAS */
			*DTC_CRH = 1;
			splx(oldpri);
			return;
		}
	
		dev = (struct devdq *)bddesc.reqfst;
		if ( bddesc.reqlst == (struct devq *)dev )
			bddesc.reqlst = 0;
		
		bddesc.reqfst = (struct devq *)dev->forward;

		/* clear TAS */
		*DTC_CRH = 1;
	
		LIGHT(greenlit);
		splx(oldpri);
	
	
	/* ****************************************** */
		if ( PRINT2 )  {
			printlf();
			prbuf ( dev, (sizeof (struct devq)) >> 1 );
		}
	
		/* only keep 2 bits */
		dev->flag &= (NRETRYB + NOALT);
	
		dev->forward = 0;
		dev->backward = 0;
	
		/* check for valid device */
		if ( dev->device == DISK ) {
			dev->flag |= TNOWAIT; 
			dev->retry = 0;
			dkparse(dev);
		}
 		else if ( (dev->device == TAPE) || (dev->device == TAPE9) ) {
			dev->flag |= TNOWAIT;
			dev->retry = 0;
			taparse(dev);
		}
		else if ( dev->device == DTLBUF )  {
			xfermem (dev);
			dev->flag |= OPRDONE;
		}
	 	else {
			dev->rc1 =  DER_INF;
			dev->flag |= OPRDONE;
		}
	
		/* **************************************** */
		/* check if need to send response back here */
		/* **************************************** */

		oldpri = spl6();
		if ( dev->flag & OPRDONE ) {
			finreq( dev);
		}

		splx(oldpri);
	}
}

/* inturpt is disable when enter here */
finreq(ndevq)
register struct devq *ndevq;
{
	register struct devq *dq;
	register oldpri;

	ndevq->q_next = 0;
	ndevq->q_prev = 0;

	ndevq->q_flag |= 0x8000;

	
	if ( PRINT2 )
		prbuf ( ndevq, (sizeof (struct devq)) >> 1 );
	
	if ( PRINT1 && (*(short *)&ndevq->rc1) )
		printrc(ndevq);

	/* put req on response que */
	locktas();

	if ( bddesc.rsfst == 0 ) {
		bddesc.rsfst = ndevq;
		bddesc.rslst = ndevq;
	}
	else {
		/* put que at the end */
		dq = bddesc.rsfst;
		while ( dq->q_next != (struct devq *)0 )
			dq = dq->q_next;
		dq->q_next = ndevq;
		ndevq->q_prev = dq;

		bddesc.rslst = ndevq;
	}

	/* clear TAS */
	*DTC_CRH = 1;

	/* inturpt master cpu to examine the return code */
	intr_cpu (ICB_ACK);

	LIGHT(ledoff);
	return (0);
}
locktas()
{	register first;
	first = 1;
	while ( ICB_TAS ){
		if ( first && PRINT2 )
			con_out ('*');
		first = 0;
	}
}

