#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>

#ifdef QDOS
# include <qdos.h>
char _prog_name[] = "PGP for SMS/QDOS";
char _copyright[] = "(c) Philip Zimmermann et al";
char _version[] = "2.62i/jh";
long _stack = 8192;
void (*_consetup) () = consetup_title;

struct WINDOWDEF _condetails = {2, 1, 0, 7, 484, 256, 8, 0};

char * stpcpy(char *d, const char *s)
{
    while(*d++ == *s++)
	; /* Null loop */
    return --d;
}

/* Access seems to be *always* broken in c68 */
/* Not accurate, just works */

int access (char *f, int mode)
{
    struct stat st;
    int fd;
    
    if((fd = stat(f, &st)) == 0)
    {
	switch(fd)
	{
	case F_OK:
	    break;
	case R_OK:
	    fd = (st.st_mode & 0444) == 0;
	    break;
	case W_OK:
	    fd = (st.st_mode & 0222) == 0;
	    break;
	case X_OK:
	    fd = (st.st_mode & 0111) == 0;
	    break;
	default:
	    fd = -1;
	    break;
	}
    }
    return fd;
}

#endif

static const char UnixLib[] = "/usr/local/lib/";

/* Fixup a Mickey Mouse file naming system */

void Unix2MM (char *name)
{
    char path[64];
    char *q, *r, *s;
    
    if((r = strstr(name, UnixLib)))
    {
	r = name + sizeof(UnixLib)-1;
	getcwd(path, sizeof(path));
	q = path + strlen(path);
	if(*(q-1) != '_')
	{
	    *q++ = '_';
	}	    
    }
    else if(*name == '~')
    {
	r = name+1;
	getcwd(path, sizeof(path));
	q = path + strlen(path);
	getcwd(path, sizeof(path));
	q = path + strlen(path);
	if(*(q-1) != '_')
	{
	    *q++ = '_';
	}	    
    }
    else
    {
	q = path;
	r = name;
    }
    
    if(*r == '/')
    {
	r++;
    }
    
    strcpy(q, r);

    while (*q)
    {
        if(*q == '/' || *q == '.')
	    *q = '_';
	q++;
    }
    strcpy(name, path);
}

void MM2Unix (char *name)
{
    struct stat st;
    int sts;
    char *p, *r, *s;
    char path[64];
    
    strcpy(path, name);
    
    if(isdirdev(name) && *(name+4) == '_')
    {
	p = name+5;
	*(path+4) = '/';
    }
    else
    {
	p = name;
    }

    if(s = strrchr(p, '_'))
    {
	*s = 0;
	sts = stat(name, &st);
	if(sts ==0 && (st.st_mode & S_IFDIR))
	{
	    *(path+(s-name)) = '/';
	}
	else
	{
	    *(path+(s-name)) = '.';
	}
    }

    for(r = p; *r; r++)
    {
        if(*r == '_')
	{
	    *r = 0;
	    sts = stat(name, &st);
	    if(sts ==0 && (st.st_mode & S_IFDIR))
	    {
		*(path+(r-name)) = '/';
	    }
	    else
	    {
		*(path+(r-name)) = '_';
	    }
	    *r = '_';
	}
    }
    strcpy(name, path);
}

int ql_access(char *name, int mode)
{
    int res;
    
    Unix2MM(name);
    res = access(name, mode);
#ifdef QLTEST
    fprintf(stderr,"ACCESS: %s = %d\n", name, res);
#endif
    MM2Unix(name);
    return res;
}

int ql_stat (char *name, struct stat *s)
{
    int res;
    Unix2MM(name);
    res = stat (name, s);
#ifdef QLTEST
    fprintf(stderr,"STAT: %s = %d", name, res);
#endif
    MM2Unix(name);
    
    return res;
}

FILE *ql_fopen(char *name, char *mode)
{
    FILE *fp;

    Unix2MM(name);
#ifdef QLTEST
    fprintf(stderr,"FOPEN: %s\n", name);
#endif
    fp = fopen(name, mode);
    MM2Unix(name);
    return fp;
}
int ql_open(char *name, int mode,...)
{
    int fd;

    Unix2MM(name);
#ifdef QLTEST
    fprintf(stderr,"OPEN: %s\n", name);
#endif
    fd = open(name, mode);
    MM2Unix(name);
    return fd;
}

ql_rename(char *src, char *dest)
{
    int r;
    
    Unix2MM(src);
    Unix2MM(dest);
    r = rename(src, dest);
    MM2Unix(src);
    MM2Unix(dest);
    return r;
}

ql_unlink(char *src)
{
    int r;
    
    Unix2MM(src);
    r = unlink(src);
    MM2Unix(src);
    return r;
}


#ifdef TEST
int main(int ac, char **av)
{
    char name[40];
    
    while(fputs(" Name : ", stdout), gets(name))
    {
	MM2Unix(name);
	puts(name);
	Unix2MM(name);
	puts(name);
    }
    return 0;
}
#endif




