




    QFAX
    =========================================================================
                            Facsimile System for Class 2.0/Class 2 fax modems
                                                       and SMS/QDOS computers
                                                             QFAX Version 2.8
                                                                 October 1996











































    -------------------------------------------------------------------------
    by Jonathan R Hudson





































    Copyright (C) 1993-1996 Jonathan R Hudson.


    This edition of the QFAX documentation is consistent with version 2.8 of
    QFAX.



    Published by
    Jonathan R Hudson
    Copse View,
    Priestlands Close,
    Woodlands,
    Southampton,
    Hants SO40 7GD.

         Permission is granted to make and  distribute  verbatim  copies  of
    this manual provided the copyright notice and this permission notice are
    preserved on all copies.


QFAX Class 2.0/Class 2 Facsimile System                                    i


                               Table of Contents


    1    QFAX Copying Conditions ......................................    1
    2    Overview of QFAX .............................................    3
    2.1      System Requirements ......................................    3
    2.2      Class 2.0/Class 2 ........................................    3
    2.2.1    EIA Class One software ...................................    4
    2.3      Media for reception ......................................    5
    3    How Fax Works ................................................    6
    3.1      Standard Fax Machine .....................................    6
    3.2      Fax Software Components ..................................    6
    4    The jargon this far ..........................................    8
    4.1      Encoding caveat ..........................................    9
    4.2      G3 Bit Order .............................................    9
    5    Configuring QFAX .............................................   11
    5.1      CLASS2.0 keyword .........................................   11
    5.2      ID keyword ...............................................   11
    5.3      SIGNATURE keyword ........................................   12
    5.4      RES keyword ..............................................   12
    5.5      SERDEV keyword ...........................................   12
    5.6      SERBAUD keyword ..........................................   12
    5.7      MODEM keyword ............................................   13
    5.8      RMODEM keyword ...........................................   13
    5.9      CODE keyword .............................................   13
    5.10      VIA keyword .............................................   14
    5.11      EXITBAUD keyword ........................................   15
    5.12      PREINIT keyword .........................................   15
    5.13      INIT keyword ............................................   15
    5.14      INDIR keyword ...........................................   15
    5.15      INFO keyword ............................................   16
    5.16      SENDBITS keyword ........................................   16
    5.17      WAIT2SEND keyword .......................................   16
    5.18      STARTCHAR keyword .......................................   16
    5.19      FONT keyword ............................................   16
    5.20      PATHFONT keyword ........................................   16
    5.21      TEMP keyword ............................................   16
    5.22      DELAY keyword ...........................................   17
    5.23      PRINT keyword ...........................................   17
    5.24      Modem Setup Options .....................................   17
    5.24.1    Dial and Modem Reset ....................................   18
    5.24.2    Modem Setup Commands ....................................   18
    5.25      PHONEBOOK keyword .......................................   20
    5.25.1    International aliasing ..................................   22
    5.26      Preset Command Options ..................................   22
    5.27      Text Equivalents for Dates ..............................   22
    5.28      LEFTMARGIN keyword ......................................   23
    5.29      PRVIEW keyword ..........................................   23
    5.30      HANGUPOK keyword ........................................   24
    5.31      Page and Paper Options ..................................   24
    5.32      Fax file Suffix .........................................   25
    5.33      PPR_TRY .................................................   25
    5.34      UNLIMITED keyword .......................................   25


ii                                   QFAX Class 2.0/Class 2 Facsimile System


    5.35      MONO keyword ............................................   25
    5.36      SAVETHING ...............................................   25
    5.37      XDIAL keyword ...........................................   25
    5.38      RCLASS,SCLASS ...........................................   26
    5.39      GDELAY ..................................................   26
    5.40      DATA ....................................................   26
    5.41      CHILDLOG ................................................   27
    5.42      FAA .....................................................   27
    5.43      STARTSCRIPT .............................................   27
    5.44      STOPSCRIPT ..............................................   27
    5.45      RSFLAG ..................................................   28
    5.46      SCRIPTLOG ...............................................   28
    5.47      APRES ...................................................   28
    5.48      NOPOLL ..................................................   28
    5.49      GFLAG ...................................................   28
    5.50      LSB .....................................................   29
    5.51      MSB .....................................................   29
    5.52      PRESCAN .................................................   29
    5.53      EDR .....................................................   29
    5.54      ECM .....................................................   29
    5.55      Default values ..........................................   29
    5.56      G3 File formats .........................................   31
    6    Pages and Paging .............................................   33
    6.1      Fax Page Sizes ...........................................   33
    6.2      QFAX_DAT keywords for paging .............................   33
    6.3      How text2g3 handles page sizes ...........................   34
    6.4      How qfax handles page size ...............................   35
    6.5      How the decoder handles Page Size ........................   35
    6.6      How qfv handles page size ................................   36
    6.7      Page and Paper sizes printfax ............................   36
    6.7.1    HP Printer features ......................................   36
    6.7.2    Epson Printers ...........................................   37
    7    Using text2g3 ................................................   38
    7.1      text2g3 Overview .........................................   38
    7.1.1    QFAX font ................................................   38
    7.1.2    Changing QFAX font .......................................   38
    7.2      text2g3 formatting .......................................   38
    7.2.1    ~; .......................................................   39
    7.2.2    ~# width_code page_code ..................................   39
    7.2.3    ~P .......................................................   39
    7.2.4    ~I filename ..............................................   39
    7.2.5    ~C filename ..............................................   39
    7.2.6    ~S screen_dump ...........................................   39
    7.2.6.1  fsPIC dithering options ..................................   41
    7.2.7    ~Q PIC_Image .............................................   41
    7.2.8    ~q & ~s Image ............................................   41
    7.2.9    ~B & ~b pbm_file .........................................   42
    7.2.10    ~d, ~D Date Formatting ..................................   42
    7.2.11    ~F & ~0 ... ~9 User defined Fonts .......................   44
    7.2.12    ~m Macros ...............................................   45
    7.2.12.1  Recursion ...............................................   46
    7.2.12.2  Example Macro Files .....................................   47
    7.2.13    ~X Include Fax ..........................................   47


QFAX Class 2.0/Class 2 Facsimile System                                  iii


    7.2.14    Other text2g3 Examples ..................................   48
    7.3      Running text2g3 ..........................................   48
    7.3.1    T2G3INI ..................................................   50
    8    Using qfax ...................................................   51
    8.1      qfax Overview ............................................   51
    8.2      Running qfax send ........................................   51
    8.2.1    Polling (requests) .......................................   52
    8.2.2    ALIAS and qfax ...........................................   52
    8.3      qfax receive .............................................   53
    8.3.1    Manual receive ...........................................   54
    8.3.2    Automatic Answer .........................................   54
    8.3.3    Shared ...................................................   55
    8.3.4    qfax MONITOR mode ........................................   56
    8.4      Polling (responding) .....................................   57
    8.5      qfax Server ..............................................   57
    8.5.1    Using qfaxClient .........................................   59
    8.5.2    QFAXINI ..................................................   59
    9    qfv ..........................................................   60
    9.1      qfv Overview .............................................   60
    9.2      Running qfv ..............................................   60
    9.2.1    Menu .....................................................   60
    9.2.2    qfv command options ......................................   62
    9.3      Bad lines ................................................   64
    10   printfax .....................................................   65
    10.1      printfax Overview .......................................   65
    10.2      Running printfax ........................................   65
    10.2.1    PFAXINI .................................................   68
    10.3      Printer specific features ...............................   68
    10.3.1    HP Optimisations ........................................   68
    10.3.2    HP Reduced Image mode ...................................   69
    10.3.3    HP 150 dpi ..............................................   69
    10.3.3.1  HP Compressed Data ......................................   69
    11   QFAX supplied Examples .......................................   71
    12   Utility Programs .............................................   73
    12.1      Overview ................................................   73
    12.2      SwapQfax ................................................   73
    12.3      qparse ..................................................   73
    12.4      fsPIC ...................................................   73
    12.5      qfxfnt ..................................................   73
    12.6      pcl2g3 ..................................................   73
    12.7      Obsolete programs .......................................   73
    13   Miscellaneous ................................................   74
    13.1      Media size for reception ................................   74
    13.2      Supported Modems ........................................   74
    13.3      Reporting Problems ......................................   74
    13.4      With grateful thanks to .................................   75
    13.5      See Also ................................................   76
    13.6      If it works for you .....................................   76
    13.7      Author ..................................................   77
    A    QFAX Modem commands.  ........................................   78
    B    Caveat floppy disk Users .....................................   79
    C    QFAX File Format .............................................   81
    C.1      General ..................................................   81


iv                                   QFAX Class 2.0/Class 2 Facsimile System


    C.2      Header Fields ............................................   81
    C.2.1    Header title .............................................   81
    C.2.2    Header version ...........................................   81
    C.2.3    Header width .............................................   82
    C.2.4    Header resolution ........................................   82
    C.2.5    Header coding ............................................   82
    C.2.6    Header page ..............................................   82
    C.2.7    Header pagemax ...........................................   82
    C.2.8    Header stamp .............................................   82
    C.2.9    Header tsi ...............................................   82
    C.2.10    Header hint .............................................   82
    C.2.11    Header offset ...........................................   83
    C.2.12    Header lsb ..............................................   84
    D    QFAX Font Format .............................................   85
    D.1      QFAX Font pre v2.7 .......................................   85
    D.2      QFAX Font v2.7+ ..........................................   85
    E    QFAX Supplied Fonts ..........................................   87
    F    QFAX Thing ...................................................   88
    F.1      QFAX Thing Introduction ..................................   88
    F.2      Thing Components .........................................   88
    F.2.1    QFAXThing ................................................   88
    F.2.2    Thing Load Command .......................................   88
    F.2.3    Thing Kill Command .......................................   89
    F.2.4    Thing Save Command .......................................   89
    F.3      Thing QFAX_DAT ...........................................   89
    F.4      Thing (LFAX users) .......................................   89
    F.4.1    FLOG program .............................................   90
    F.5      Thing Technical Reference ................................   90
    F.5.1    LoadNT ...................................................   90
    F.6      qfaxview .................................................   91
    F.7      Thing Example ............................................   91
    G    QFAX and QBOX ................................................   92
    G.1      QBOX Initialisation ......................................   92
    G.2      FAX/DATA examples ........................................   93
    G.3      Setting Data Mode in QBOX ................................   93
    H    About this manual ............................................   95
    Index .............................................................   96


















QFAX Class 2.0/Class 2 Facsimile System                                    1


    1.  QFAX Copying Conditions

         The programs  currently  being  distributed  that  relate  to  QFAX
    include  qfax,  text2g3,  printfax,  qfv,  plus  other separate programs
    (including fsPIC, qfxfnt, and examples). These programs are  free;  this
    means that everyone is free to use them and free to redistribute them on
    a free basis. There are restrictions on their  distribution,  but  these
    restrictions  are  designed to permit everything that a good cooperating
    citizen would want to do.  What is not allowed is to try to prevent oth-
    ers  from  further sharing any version of these programs that they might
    get from you.

         Specifically, I want to make sure that you have the right  to  give
    away  copies  of  the programs that relate to QFAX, that you can get the
    source code if you want it, that you can change these  programs  or  use
    pieces  of them in new free programs, and that you know you can do these
    things.

         To make sure that everyone has such rights, I have to forbid you to
    deprive  anyone  else  of  these rights.  For example, if you distribute
    copies of the QFAX related programs, you must give  the  recipients  all
    the  rights that you have.  You must make sure that they, too, know that
    they can get the source code.  And you must tell them their rights.

         Also, for my own protection, I  must  make  certain  that  everyone
    finds  out  that  there  is  no warranty for the programs that relate to
    QFAX. If these programs are modified by someone else and  passed  on,  I
    want  their  recipients  to  know that what they have is not what I dis-
    tributed, so that any problems introduced by others will not reflect  on
    my reputation.

         The following precise conditions pertain to QFAX.


         1.   QFAX is copyright (c) Jonathan Hudson. All rights reserved.

         2.   NO  WARRANTY.  Every  effort  has been made to ensure that the
              programs described operate correctly. No guarantee of any kind
              is  given  that  the program(s) described in this document are
              reliable. You use this material at your own risk.

         3.   QFAX may be distributed in user group  or  public  domain  li-
              braries, and posted on public access BBS provided:


              1.   You  may  not  profit  by distributing QFAX. You may only
                   charge for  your  time,  media  and  postage  costs.  Any
                   charges, excluding postage, shall not exceed US$6.00.

              2.   You  may  not  claim  ownership of, or any rights to, the
                   software.




2                                    QFAX Class 2.0/Class 2 Facsimile System


              3.   You may not place any restriction on the further  distri-
                   bution of the software.



         If you find QFAX useful you are encouraged to make a small donation
    to an animal welfare charity.
















































QFAX Class 2.0/Class 2 Facsimile System                                    3


    2.  Overview of QFAX

         QFAX is a system for preparing,  transmitting,  receiving,  viewing
    and  printing  facsimiles  using SMS and QDOS compatible computers and a
    Class 2.0 or Class 2 command set fax modem. The  software  will  run  on
    most  SMS/QDOS  platforms,  including  SMS2, SMSQ/E, QL (& Trump Card or
    better, Gold and Super Gold Cards), QXL, and ST QL Emulator.

         Class 2.0 support is a late edition to QFAX, many of  the  examples
    in  the  manual  assume a Class 2 command set. All QFAX functionality is
    available for both command sets.

    2.1.  System Requirements

         QFAX requires a SMS/QDOS system with at least 640Kb memory. On Sin-
    clair  QL  hardware,  the  standard standard QL serial chip (the '8049')
    must be replaced with the "Hermes", or  preferably  the  '`superHermes''
    serial  chip  (1) or equivalent hardware capable of supporting reception
    at 19200 baud. QFAX is not supported on '8049' serial chips. The  under-
    lying  QL  hardware  may  still not cope well with V.17 (14,400 bps) fax
    reception with the qfax transport program.

         The qfv, printfax programs require a minimum of 550 Kb free memory.

         The  qfv program requires the QJump "Pointer Environment" (the PE).
    The text2g3, qfax and printfax programs do not require, but are enhanced
    by, the presence of the PE.

         The  process of converting text and images to and from the CCITT G3
    fax format required for fax  transmission  and  reception  is  very  CPU
    intensive.  Running  the  conversion  program text2g3 (ASCII files to G3
    format) and printfax or qfv (G3 to screen or printer) requires a lot  of
    CPU  power;  you  may  find using these programs on a 68008 machine very
    frustrating; an SMS, (Super) GoldCard, QXL, ST/QL, or  Am/QL  system  is
    desirable. The program to send and receive faxes qfax is governed by the
    efficiency of the serial port. It  is  possible  to  send  international
    faxes  using qfax, a 68008 QL, Trump Card, 2xflp_ and Hermes, but recep-
    tion on such low-end hardware is, at times, problematical.

    2.2.  Class 2.0/Class 2

         QFAX supports Class 2.0 and Class 2 fax  modems.  The  default  is,
    (for historic and compatibility reasons), Class 2.  I recommend that you
    use Class 2.0 mode if your modem supports it.  Class  2  is  essentially
    obsolete  and  any new developments (for example BFT (binary file trans-
    fer) will be in Class 2.0 only). See section CLASS2.0 keyword.

         If you are unsure if your fax modem supports either of these  stan-
    dards, do the following.
____________________
   1. Available from TF Services




4                                    QFAX Class 2.0/Class 2 Facsimile System


         1.   Read the (manufacturer's) fine manual (RTFM).

         2.   Connect modem to computer.

         3.   Use  QeM,  QTPI, QLT or other terminal software to communicate
              with the modem.

         4.   Type in ATZ<RET>(2)

         5.   The modem should reply OK. (3)

         6.   Type in AT+FCLASS=2.0<RET>.

         7.   If  the  modem  replies OK then you've got a Class 2.0 command
              set modem. If it replies ERROR then you haven't.

         8.   Type in AT+FCLASS=2<RET>.

         9.   If the modem replies OK then you've got a Class 2 command  set
              modem. If it replies ERROR then you haven't.

         10.  Type in ATZ<RET> again to reset the modem.

    If your modem fails both the above tests then, unfortunately, you cannot
    use the transport part of QFAX (qfax).

    2.2.1.  EIA Class One software

         There is a SMS/QDOS Class  One  transport  (send/receive)  program,
    LFAX, written by Lester Wareham. The LFAX program is also available free
    of charge.

         If you want to know if you modem supports Class  One  fax,  replace
    step  6 above with AT+FCLASS=1<RET>. If you get OK back, then your modem
    supports EIA Class One and you should use LFAX as  your  transport  pro-
    gram. You may still need the QFAX support programs (text2g3, qfv, print-
    fax) or equivalent functionality to prepare and display faxes.

         The LFAX program may offer different or enhanced functionality com-
    pared  to  the QFAX/qfax transport program, however in a rare display of
    synergetic cooperation, Lester and I have ensured that the file  formats
    are  compatible  and  the  fax  support  programs work equally well with
    either transport program.




____________________
   2. <RET> means the ENTER or RETURN key
   3. If it does not, then there is most likely a connection problem between
computer and modem




QFAX Class 2.0/Class 2 Facsimile System                                    5


    2.3.  Media for reception

         You should attempt to receive to the fastest device on your system.
    For most users this will be a (volatile) ram disk.

         Reception  to  permanent  (disk) storage is a desirable feature; it
    provides data security in the event of system or power failure or opera-
    tor error. QFAX implements this using an optional, automated backup sys-
    tem whereby faxes are initially received to a ram device, and  once  the
    end  of  document  handshake has completed, the fax is copied to a disk.
    This mode of operation is invoked using the `VIA' parameter to  describe
    an  intermediate  reception  path in your `QFAX_DAT' configuration file.
    See section VIA keyword.

         You should use the VIA parameter if you  are  receiving  to  floppy
    disk  or  to a slow hard disk on a slow CPU.  (e.g. Miracle Hard Disk on
    68008 CPU).

         Reception directly to hard disk may be entirely satisfactory  using
    a fast disk on SMS, ST/QL, (S)GC or QXL system.



































6                                    QFAX Class 2.0/Class 2 Facsimile System


    3.  How Fax Works

    3.1.  Standard Fax Machine

         This  section  describes  some  basic concepts, and the interaction
    with QFAX components. You may choose to skip this chapter.

         When you send a fax using a standalone fax machine, it goes through
    a number of steps.


         1.   You  prepare  a  paper copy of the fax, using paper and a pen,
              computer etc.

         2.   The fax machine accepts your document and:


              1.   Dials the remote machine and  negotiates  parameters  for
                   transmission.

              2.   Scans  your  document and converts it into a digital for-
                   mat. This digital data is compressed using a complex  al-
                   gorithm  into a CCITT G3 format compressed pixel bit map.


         3.   The G3 format data is transmitted over the phone line using  a
              modem built into the fax machine.

         4.   The machines sign off when complete


         When a fax machine receives a fax, the following happens:


         1.   The machine answers the phone.

         2.   The  machine  (modem)  establishes contact with the sender and
              negotiates parameters for reception of the fax.

         3.   As the G3 format data arrives, it is unpacked into a pixel bit
              map and printed.

         4.   The machines sign off when complete


    3.2.  Fax Software Components

         QFAX currently consists of the following components:


         1.   text2g3  This program takes a text file (created with the edi-
              tor of your choice) and converts it into  a  CCITT  G3  format
              (compressed  bitmap)  file.   You can include graphics in your


QFAX Class 2.0/Class 2 Facsimile System                                    7


              document using some simple control sequences. This  is  analo-
              gous to the fax machine scanner.

         2.   qfax.  This  program transmits the CCITT G3 format (compressed
              bitmap) file using your modem. This program instructs the  mo-
              dem  to  dial the remote fax, supplies parameters for negotia-
              tion with the remote machine, configures your modem and  sends
              the data. It reports the success of the fax transmission.

              The qfax program can also receive G3 format files via your mo-
              dem. It instructs your modem to answer the  phone,  configures
              your  modem  for  negotiation  with the remote machine and re-
              ceives the G3 data. If reports the result of the fax reception
              and maintains a log file.

         3.   qfv.  A PE program that displays faxes on the screen or prints
              them using either HP pcl (i.e. LaserJet/DeskJet), Epson 24 bit
              (LQ850  and  similar/compatible), Epson 9 or Postscript print-
              ers.  Some 'file-format' devices (pbm, pic, gif) are also pro-
              vided.

         4.   printfax.  This  program  allows  you to print G3 format files
              (either prepared by text2g3 or received using qfax)  to  a  HP
              pcl  (i.e.  LaserJet/DeskJet),  Epson  24 bit (LQ850 and simi-
              lar/compatible), Epson 9 or Postscript printer.   Some  'file-
              format' devices (pbm, pic, gif) are also provided.

    The  mechanism  of  sending and receiving faxes using a conventional fax
    machine may involve some degradation of the original quality due to  the
    scanning of the picture by the sending machine and its printing on (typ-
    ically) a low quality thermal printer in the receiving fax  machine.  If
    you  transmit  and  receive  by  computer, you retain the quality of the
    original fax (about 200 dpi). In addition, you have the option of encod-
    ing  your  faxes  at  a higher resolution than most low end fax machines
    default to. Using fax software and a laser or inkjet printer will give a
    high quality plain paper system.



















8                                    QFAX Class 2.0/Class 2 Facsimile System


    4.  The jargon this far

         So far I've mentioned a bit of jargon without really explaining it,
    before I describe the configuration necessary to use QFAX,  here's  some
    explanation.


         QFAX
              (in  capitals) is a suite of programs, comprising, inter alia,
              qfax, (lower case), a program for  sending  and  receiving  G3
              facsimile documents using a Class 2.0/Class 2 fax modem.

         CCITT
              International  Telegraph and Telephone Consultative Committee.
              A international body that standardises communications methods.
              This organisation is now known as the ITU-TSS, but is referred
              to as the CCITT in some parts of this document.

         G3   Describes the format of facsimile and the physical  method  of
              transmission.  There were earlier standards known as G1 (Group
              One) and G2 (Group Two), and there is also a proposal  for  G4
              (Group  Four), which will handle such complexities as ISDN and
              grey scales; that is if the G4 standard ever emerges in a form
              that  can  actually  be  implemented. G3 is the method used by
              just about every fax machine and fax modem is use today.

              G3 also defines methods of encoding facsimile documents,  that
              is  the  process  of  converting a bitmap (the black and white
              dots) into the compressed form that is transmitted.  This  en-
              coding  (and  hence  compression)  is  one of the factors that
              makes G3 six times faster than G1 and three times faster  than
              G2.  G3 supports two types of encoding.

         1-D  1-D  encoding compresses individual pixel lines in a document.
              It uses run length encoding, that is a  scheme  of  describing
              the  length  of  a run of consecutive dots. The values used to
              describe a run of a particular colour have been  statistically
              derived from analysis of typical fax documents to minimise the
              size of the resultant G3 encoded file (for example, white runs
              are  more  common  (and  usually longer) than black runs). The
              downside of the efficient packing is that  complex  algorithms
              are required.

         2-D  2-D  encoding uses 1-D to compress a 'reference line' and then
              encodes a number of subsequent lines as differences  from  the
              reference  line. This can result in encoded files that are 30%
              smaller than 1-D files, (hence  shorter  transmission  times),
              but  the  encoding  and decoding algorithms are very much more
              complex and slower. There is also the risk that if a reference
              line  gets corrupted during transmission, then every line that
              depends on it will also be corrupt.




QFAX Class 2.0/Class 2 Facsimile System                                    9


              Very few existing facsimile machines support 2-D encoding. 2-D
              is supported by all QFAX programs.

         EIA  Electronic  Industries  Association. A standards body that has
              (allegedly) standardised, inter alia, command  sets  for  con-
              trolling  fax  modems.  The  earlier Class One command set re-
              quires that the computer software does much of the  work.  The
              Class  2.0/2  command  set  places  this  burden  on the modem
              firmware.


    4.1.  Encoding caveat

         When fax is sent using standalone fax machines,  the  two  machines
    negotiate  capabilities  and  'agree' on a method they both support. For
    example, if you had a 2-D capable machine and tried to fax a 1-D capable
    machine, the two machines would negotiate to use 1-D, as this is all the
    receiving machine can handle; this is done before the machine scans  and
    encodes the document.

         When  you  send  a  fax  using  a  computer and fax modem, you have
    encoded the G3 data before the modems start negotiating.  Therefore  the
    sending  program,  qfax, cannot adapt the document coding to that of the
    receiving machine. In this case, qfax will report that the  remote  does
    not  support  the  necessary  options if your fax encoding surpasses the
    capability of the remote machine.

         I strongly recommend that you only use 1-D coding unless  you  know
    you  are corresponding with a machine (or software) that can handle 2-D.

    4.2.  G3 Bit Order

         Due to differences between modem chip set manufactures, fax  modems
    may  require  data either with least significant bit (lsb) first or most
    significant bit (msb) first. If you send or receive data from your modem
    with  the  wrong bit order, then you (or your respondent) will be unable
    to decode it. Your fax modem manual may tell you the setting you need.

         In Class 2 mode. fax modems require you send data to the modem  lsb
    first  but return it to you msb first. This is the QFAX default mode for
    Class 2.

         In Class 2.0 mode. fax modems default to lsb for send and  receive.
    This is the QFAX default mode for Class 2.0.

         QFAX  v2.5  and later can handle both MSB and LSB format fax files,
    see `QFAX File Format'. QFAX 2.6 will automatically  determine  received
    bit order.

         This is unlikely to be an issue for Class 2.0 modems.

         QFAX  also  includes  a  utility swapqfax that will reverse the bit
    order in a G3 file.


10                                   QFAX Class 2.0/Class 2 Facsimile System


         You may have to determine the bit  order  your  modem  requires  by
    experimentation!  For  example,  get  a friend to send you a fax. Try to
    view it using qfv. If this fails, reverse the bit order using  swapqfax.
    OK now ?  If so, change the setting in your `qfax_dat' file.



















































QFAX Class 2.0/Class 2 Facsimile System                                   11


    5.  Configuring QFAX

         QFAX  is controlled by a (simple) text file that defines parameters
    used to describe the fax quality and the protocols used by your computer
    and modem. Defaults are built in that should minimise the amount of work
    you have to do. The file is  called  `qfax_dat'  in  your  default  data
    directory  or  defined  by the environment variable QFAX_DATA (sic). The
    name of the `qdax_dat' file may also be changed  in  all  QFAX  programs
    using the QJUMP `Config' program.


        SETENV "QFAX_DATA=win1_fax_qfax_stuff"

    A `qfax_dat' example file might be:


        ID = +968-699407
        RES = HIGH
        SIGNATURE = Jonathan Hudson
        SERDEV = ser2hr
        SERBAUD = 19200
        MODEM = 5
        RMODEM = 3
        CODE = 0

    The general format is KEYWORD = VALUE.

    5.1.  CLASS2.0 keyword

         The  CLASS2.0 keyword determines whether QFAX operates in Class 2.0
    or Class 2 mode. To use Class 2.0 mode, place the following in qfax_dat.
    The default (without this key) is Class 2 mode.


        CLASS2.0 = 1



    5.2.  ID keyword

         This describes the ID transmitted by your fax machine and logged by
    the remote machine.  If you don't give this keyword, it defaults  to  ""
    (null string). In the example above, the value is my fax number. It is a
    requirement of many fax machines that this value only  uses  the  format
    allowed  for  phone  numbers (i.e.0-9,-+) etc. This value is transmitted
    between the fax machines / modems during the initial negotiation  stage.
    The text2g3 program will also include this value on the top line of each
    page it creates.  It is a legal requirement (FCC part  68)  in  the  USA
    that  facsimile  messages  are  identified  with caller number, "name of
    entity", and a time stamp.

         Note that many modems require the "ID" to be given in quotes.



12                                   QFAX Class 2.0/Class 2 Facsimile System



        ID = "+968-699407"

        You can test this interactively by trying

        AT+FLID=123456
        and
        AT+FLID="12345"

    and seeing which one (if any) the modem accepts. Note that if the  modem
    rejects  all  variations of the ID (AT+FLID) command, you can still give
    an ID (for use by text2g3) and over-ride the AT+FLID command.  See  sec-
    tion Modem Setup Options. Class 2.0 uses AT+FLI.

    5.3.  SIGNATURE keyword

         This  describes the "name of entity" (individual or business) send-
    ing the fax. The text2g3 program will include this value on the top line
    of  each page it creates. It is a legal requirement in the USA that fac-
    simile messages are identified with caller number, "name of entity", and
    a time stamp.

    5.4.  RES keyword

         This is the maximum resolution at which your fax modem will negoti-
    ate with the remote machine. Faxes may be encoded  at  two  resolutions,
    HIGH  7.7  line  / mm (200 dpi), or LOW which is 3.85 line/mm (100 dpi),
    with some loss of definition.  If this parameter is not given,  then  it
    defaults to high resolution. Most low end "home" fax machines default to
    the lower resolution unless you use the "Fine" or similar button. If you
    select  high resolution, then twice as much data is transmitted, You can
    define the resolution  at  which  individual  faxes  are  encoded  using
    text2g3 or gs (PostScript to fax) programs; this parameter should there-
    fore define the maximum capability of your machine; it should remain  at
    the default of HIGH.

    5.5.  SERDEV keyword

         This describes the serial device.  The default if this parameter is
    not supplied is ser2hr.


        SERDEV = ser3_b38.4k_u2k # superHermes
        SERDEV = ser1dhr # SMS2, no TRA



    5.6.  SERBAUD keyword

         This is the baud rate  between  the  DTE  (computer)  and  the  DCE
    (modem).  If  this  parameter  is  not supplied, the SMS/QDOS default is
    19200 bps.



QFAX Class 2.0/Class 2 Facsimile System                                   13


         If the baud rate defined by "SERBAUD = " is followed by a colon and
    a  second  rate,  then  the first value will be used for receive and the
    second for send. If only one value is defined, then  that  is  used  for
    both send and receive.


        SERBAUD = 19200       # Use 19200 for receive and send
        SERBAUD = 19200:9600  # Use 19200 for receive,9600 for send



    5.7.  MODEM keyword

         This  parameter  describes  the maximum DCE rate of the modem (it's
    the value of the br parameter in the AT+FDCC command passed between  the
    modems during the negotiation phase). The values it can take are:



            MODEM        Max DCE speed
              0             2400 bps
              1             4800 bps
              2             7200 bps
              3             9600 bps
              4            12000 bps
              5            14400 bps


      If  you  have  a v.32 fax modem (to 9600 bps), select 3, if you have a
    v.32 bis (fax to 14400 bps) modem, select 5.  This  parameter  describes
    the  maximum  capability  of your modem. If you are communicating with a
    "normal" fax machine, then it will  only  run  at  9600  bps,  and  your
    v.32bis modem will be negotiated down to this speed.  QFAX defaults to 5
    for this parameter if it isn't defined.  With a QL using  Hermes  and  a
    v.32 modem, you might set MODEM = 3 and SERBAUD = 19200.

    5.8.  RMODEM keyword

         Normally, the MODEM parameter is used for send and receive, but you
    may find, with some hardware options, that you can send faster than  you
    can  receive.  The  RMODEM command may be used to limit the receive baud
    rate, in the `qfax_dat' example I use  RMODEM  =  3,  which  limits  fax
    reception  to  9600  bps.  If  this command is not given, then the MODEM
    value is used for both send and receive.

    5.9.  CODE keyword

         This defines the type of encoding you wish to support.


         CODE
              Result



14                                   QFAX Class 2.0/Class 2 Facsimile System


         0    1-Dimensional. Each pixel line is encoded separately

         1    2-Dimensional. Pixel lines may be encoded  as  the  difference
              from a "Reference" line.

    2-D  coding  is  more  efficient  than 1-D coding (the file is typically
    15-30% smaller), but 2-D is not widely supported on fax machines. If you
    know  your  correspondent  can handle it, 2-D will save you transmission
    time.  If this parameter is not given, QFAX defaults to CODE  =  0  (1-D
    coding).

         The  qfax encoding program, text2g3, defaults to 1-D coding; I rec-
    ommend that you set CODE=1 to permit reception of 2-D fax; you can force
    text2g3  to use 2-D coding to those respondents that you know support it
    by a command line option (-2).

    5.10.  VIA keyword

         The VIA parameter describes an intermediate device or path that  is
    used for reception of fax on slow disk systems (that's either slow disks
    or slow CPUs or both). This is best illustrated by example. If  you  are
    using  a  twin  flp_ system, then you may want your received faxes to be
    stored to a directory on, say flp2_, to provide security against  system
    crashes,  power  failure or even operator error. In this case, you might
    define


        INDIR = flp2_faxIn_
        LOG = flp2_myfax_log
        VIA = ram2_

     When an incoming fax is received, qfax will receive it to scratch files
    ram2_XXXXXXXX_fax,  where  XXXXXXX is a random number. When reception is
    complete, qfax will move  the  fax  to  `win1_FaxIn_ppppppppp_mmmmm_fax'
    where  pppppppp  represents  the caller's phone number or a user-defined
    name. mmmmm is a machine generated sequence number. The  temporary  file
    (`ram2_XXXXXXXX_fax')  is  deleted when the fax has been moved to INDIR.
    The suffix fax may be changed using the  SUFFIX  keyword,  `SUFFIX  key-
    word'.

         +    The  VIA  mechanism is only effective using qfax generated fax
              names, (qfax -R) if you invoke qfax -r pattern, then your sup-
              plied file pattern overrides the VIA mechanism.

         +    The  qfax  incoming naming convention is described in the qfax
              receive section of this document. See section qfax receive.

         +    The default setting is that VIA is not defined, it is not  the
              default  behaviour.   If you are using QFAX with a floppy disk
              system (or Miracle Hard Disk & 68008 QL), the use VIA.


        Direct Reception of fax to floppy disk is not  supported.  while


QFAX Class 2.0/Class 2 Facsimile System                                   15


        qfax  will  let  you  do  it,  it  is  an  extremely anti-social
        operation and will annoy  your  respondents  (and  probably  you
        too).

         The  QFAX aliasing feature will automatically substitute meaningful
    names for the phone number part of the file name.

    5.11.  EXITBAUD keyword

         If this parameter is defined, than qfax will reset the baud rate to
    the  value  defined  by this parameter on exit. If this parameter is not
    given, then qfax will reset the baud rate to that in force when the pro-
    gram was invoked.


        EXITBAUD = 9600



    5.12.  PREINIT keyword

         You  can  use  the PREINIT keyword to define modem command(s) to be
    sent to your modem when qfax initialises the modem. qfax will add a car-
    riage return to the command string. For information on the commands qfax
    sends by default, see `QFAX Modem commands'. If this  parameter  is  not
    given,  then  no  additional  modem  command  is  sent.  Also  see `qfax
    Overview'. PREINIT commands are sent before any CLASS 2 commands.


        PREINIT = ATM1 L3          ; Speaker on at volume level 3



    5.13.  INIT keyword

         You can use the INIT keyword to define modem command(s) to be  sent
    to  your modem when qfax initialises the modem. qfax will add a carriage
    return to the command string. For information on the commands qfax sends
    by  default,  see `QFAX Modem commands'. If this parameter is not given,
    then no additional modem command is  sent.  Also  see  `qfax  Overview'.
    INIT commands are sent after default QFAX Class 2.0/2 commands.


        INIT = AT+FCQ=2         ; Copy quality check



    5.14.  INDIR keyword

         This  defines  a  directory  where  incoming  faxes are stored. The
    default is ram1_fax_. qfax will store the received fax in a unique  file
    name, see `qfax receive' for format.  See also `VIA keyword'.



16                                   QFAX Class 2.0/Class 2 Facsimile System


    5.15.  INFO keyword

         This  defines  a  log  file  that  records details of both sent and
    received  faxes  including  the  caller  number  and  time,  default  is
    ram2_fax_log.

    5.16.  SENDBITS keyword

         This  takes  the  values  lsb or msb and defines the bit order that
    your modem requires when sending faxes. The default, if the parameter is
    not given, is SENDBITS = LSB

         You  only  need  this parameter in the unlikely event of your modem
    requiring msb first (SENDBITS = MSB).

    5.17.  WAIT2SEND keyword

         Most fax modems will return a start character when they  are  ready
    to  transmit data to the remote fax device. The QFAX default is that the
    modem will return the start character DC2 (hex 12) when it is ready,  it
    will  also  accept  XON  (hex 11). In the unlikely event that your modem
    does not return DC2 or XON, set WAIT2SEND = NO.

    5.18.  STARTCHAR keyword

         This defines the start character required  before  the  modem  will
    return  received  fax data to the computer; the default is DC2 (hex 12),
    but some modems may require XON (hex 11) or none. In the unlikely  event
    that your your modem requires XON, then set STARTCHAR = XON.  (STARTCHAR
    = NONE, if none required, even more unlikely).

    5.19.  FONT keyword

         The name of of the default font used by  text2g3.  The  default  is
    FONT = flp1_QFax_font.

    5.20.  PATHFONT keyword

         The  path to search if a font is not found under the name supplied.


        PATHFONT = win1_qfaxfnts



    5.21.  TEMP keyword

         The directory where text2g3 writes converted files. The default  is
    TEMP = ram2_.






QFAX Class 2.0/Class 2 Facsimile System                                   17


    5.22.  DELAY keyword

         qfax  pauses, by default, for 0.2 seconds before sending an AT com-
    mand to your modem, this is to give the modem a chance  to  process  any
    previous  command.  This  default delay may be too short for your modem,
    and result in errors or qfax timeout reading the modem reply.   You  can
    change this timeout using the delay parameter.


        DELAY = nnn



    where  nnn  is the required delay in 20 mSec (1/50 sec) units. For exam-
    ple, to give a one second delay, DELAY = 50. If you have  problems  with
    qfax initialising your modem, set DELAY to a large value (say 200), work
    down until it fails, and then increase it slightly. You don't need to be
    connected  to  the  phone  system for this, just invoke qfax;'-v -R' and
    wait until qfax returns 'NO CARRIER'. Using a good modem (ZyXEL)  and  a
    fast system, it is possible to set DELAY=0 to minimise startup times.

    5.23.  PRINT keyword

         You  may configure qfax to automatically print out your fax when it
    has been received. This will only be a practical option for users with a
    powerful  CPU  (16Mhz  68000 at minimum, 2Mb RAM, a hard disk and a real
    parallel port (i.e. not a converter from a serial port)). This parameter
    takes  the  printfax  command,  excluding  the  file name, which will be
    appended by qfax, that you need to print fax. The default is that it  is
    undefined (i.e. no automatic printing). An example might be


        PRINT = printfax -q -a

    The  command  is  run as given followed the the name of the fax file; it
    does not have to be a fax print program.

    The command is defined as it would be on a UNIX computer,  i.e.  without
    ex,  ; , or quotes. printfax may use the PFAXINI keyword to obtain other
    default options. See section PFAXINI.

        Caution:Another fax may arrive while the first is being printed,
        your  hardware must be robust enough to support this possibility
        and have sufficient memory (at least 2Mb to be comfortable).


    5.24.  Modem Setup Options

         By default, qfax has used the following "Hayes" (tm)  and  Class  2
    commands:


        Dial prefix       ATD


18                                   QFAX Class 2.0/Class 2 Facsimile System


        Reset Modem       ATZ
        Setup Command 1   AT +FCLASS=2
        Setup Command 2   AT +FBOR=0 +FCR=1 +FAA=0
        Setup Command 3   AT +FLID = %s
                          (%s replaced by the ID parameter)
        Setup Command 4   AT +FDCC=%d,%d,%d,%d,%d,%d,0,0
                          (%d replaced by RES MODEM WIDTH_S PAGE_S,CODE,ECM)

    It  is  now apparent that a number of allegedly Hayes/Class 2 compatible
    modems cannot accept the format of these commands.  All  these  commands
    can be over-ridden by `qfax_dat' options.

         Class 2.0 modems use:


        Dial prefix       ATD
        Reset Modem       ATZ
        Setup Command 1   AT +FCLASS=2.0
        Setup Command 2   AT+FBO=0 +FCR=1 +FLO=2 +FAA=1 +FNR=1,1,1,0
        Setup Command 3   AT +FLI = %s
                          (%s replaced by the ID parameter)
        Setup Command 4   AT +FCC=%d,%d,%d,%d,%d,%d,0,0
                          (%d replaced by RES MODEM WIDTH_S PAGE_S,CODE,ECM)



    5.24.1.  Dial and Modem Reset


        DIAL = <dial command prefix>

        e.g.    DIAL = ATDP    (for pulse dial)

        ATZ  = <modem reset command>

        e.g.    ATZ = AT&F     (Reset to factory setting)



    5.24.2.  Modem Setup Commands    Format is MDMx = <value>, x is (1-4).

         These are governed by the following rules:


         1.   If the MDMx command is not given, then the usual qfax value is
              used.

         2.   If the MDMx command  is  given  without  a  value,  then  that
              command will be ignored completely.

         3.   If  the MDMx command is given with a value, then that value is
              used to replace the built in command.



QFAX Class 2.0/Class 2 Facsimile System                                   19


    Note that qfax will not attempt to do  any  parameter  substitution  for
    user  defined  commands. The following examples are for the Class 2 com-
    mand set.



            MDM1 = <1st Modem setup string>
            to
            MDM4 = <4th Modem setup string>

            e.g.

            # for modems that expect semi-colon as command delimiter

            MDM1 = ATS0=0;S2=255;S7=120;S12=255;+FCLASS=2

            # We don't give a MDM2, so qfax value is used

            # Ignore +FLID command completely
            # (text2g3 will still put any ID on fax head line)

            MDM3 =

            # Use my specific G3 parameters

            MDM4 = AT+FDCC=0,3,0,0


    Using the above examples, to send a fax, with  the  following  lines  in
    QFAX_DAT



            ATZ = AT&F
            DIAL = ATDP
            MDM1 = ATS0=0;S2=255;S7=120;S12=255;+FCLASS=2
            MDM3 =
            MDM4 = AT+FDCC=0,3,0,0


    the following commands would be sent to the modem



            AT&F
            ATS0=0;S2=255;S7=120;S12=255;+FCLASS=2
            AT+FBOR=0 +FCR=1 +FAA=0
            AT+FDCC=0,3,0,0
            ATDP699407


    As  with  other  user defined qfax modem commands, you need not give the
    AT.


20                                   QFAX Class 2.0/Class 2 Facsimile System


         The lines:



            ATZ = &F
            DIAL = DP
            MDM1 = S0=0;S2=255;S7=120;S12=255;+FCLASS=2
            MDM3 =
            MDM4 = +FDCC=0,3,0,0

            are equivalent.




    5.25.  PHONEBOOK keyword

         The PHONEBOOK keyword defines the (optional) QFAX phone book.


        PHONEBOOK = win1_qfax_phone



         The PHONEBOOK format uses a KEY=value system. The keys are:


         NAME
              The name of the respondent, used as  the  directory  name  for
              receive.

         ALIAS
              An alias that may be used for dialling.

         TSI  The TSI returned by the respondent's fax machine.

         DCODE
              A  dial  code  that is prepended to the TSI to give a dial out
              number for the respondent.

         FULL
              The full (dial out) number of the  respondent.  For  occasions
              when the number cannot be constructed from DCODE and TSI.

         2D   A  flag  that  indicated  2D  capability. This may just be for
              reference or maybe used by text2g3 to determine optimum coding
              method.


         For example:


        NAME=RacingSailboats, ALIAS=rsb, TSI=01712231448, FULL=00441712231448


QFAX Class 2.0/Class 2 Facsimile System                                   21


        NAME=IMTAC, TSI=968797709, FULL=797709, 2D
        NAME=JochenMerz, ALIAS=jm, TSI=49203502012, DCODE=00-
        NAME=Jonathan, ALIAS=jrh, TSI=1703867843, DCODE=00-



         In  your  entry  for me (`jrh'), the TSI is the cleaned up ID (i.e.
    numbers only) that I send out with faxes The NAME field is the directory
    where  the  inbound faxes are to be stored, ALIAS is an abbreviation you
    can use when sending, DCODE is any additional dial  information  not  in
    the TSI. As you may sometimes get my 1-D answer-machine, this entry does
    not have 2D set.

         Note that any TSI values should only contain  numbers  and  letters
    (no  punctuation).  If the user's ID setting is +44 (0)1703-867843, then
    use TSI=4401703867843.


        ex qfax;'-s jrh ram2_jrh_fax'

        You could also

        ex qfax;'-s Jonathan ram2_jrh_fax'

        or even

        ex qfax;'-s 00-44-1703-867843 ram2_jrh_fax'



         Somehow I think I'd use the first one. Faxes now go into the  named
    directory,  much  easier  than numbers, where an PHONEBOOK entry exists.
    So. in the above example, with an INDIR = flp1_ and the above  entry  in
    `QFAX_PHONE', a fax from me, would be stored as:


        flp1_Jonathan_nnnnn_fax

        where nnnnn represent the current numbering scheme.

        flp1_Jonathan_00000_fax
        flp1_Jonathan_00001_fax         etc

         You  should  be  aware of the following implementation details that
    influence name matching.


         +    The phone book linked list in memory is the reverse  order  of
              `qfax_phone' entries.

         +    Each  entry  is  checked  for  ALIAS  then NAME. cAsE does not
              matter, but length does (  jon != Jonathan ,  fred == FRed  ).



22                                   QFAX Class 2.0/Class 2 Facsimile System


    Given (in `qfax_phone')


        NAME=John,ALIAS=JJ,TSI=123456
        NAME=JimJohnson,ALIAS=John,TSI=78778

        then 'qfax -s John ...' would dial 78778

    You  must  also ensure that ALIAS names do not result in file names that
    exceed the file system limits.

    5.25.1.  International aliasing

         There are many instances where a respondent gives a national  phone
    number  in  the  TSI that is incompatible with international dialling in
    your country. The FULL field allows for this. For example, a  respondent
    in  the  UK might set their TSI to 01703-123456, and to dial that number
    from overseas, I need to dial 00-44-1703-123465. The combination of  TSI
    and  dial code will not do this, but I can override this by setting FULL
    to 00-44-1703-123456.

    5.26.  Preset Command Options

         Programs in the QFAX suite (qfax, text2g3, qfv,  printfax)  take  a
    number  of  sometimes  arcane  and  immemorable command options, many of
    which you will need every time you use the program. To save  you  having
    to type these options in every time, default options can be preset using
    the following keywords in `qfax_dat'.  The keys are:


         QFAXINI
              default options for qfax

         QFVINI
              default options for qfv

         PFAXINI
              default options for printfax

         T2G3INI
              default options for text2g3

    The usage of these keys is described in the chapters  referring  to  the
    specific programs.

    5.27.  Text Equivalents for Dates

         text2g3  provides  two  macros  to automatically insert the date in
    faxes.  These default to the full names for days and months  in  English
    in  standard  Unix  usage. These keys may be used to define native (non-
    English) language date fields.  Usage of these keys is described in  the
    text2g3  section.   See  section Using text2g3, and `~d, ~D Date Format-
    ting'.


QFAX Class 2.0/Class 2 Facsimile System                                   23


         DAYS
              days text string

         MONTHS
              months text string


    5.28.  LEFTMARGIN keyword

         QFAX/text2g3 by default imposes a 160 pixel (c. 20mm) left  margin.
    This  may be altered using the LEFTMARGIN keyword. This takes a value in
    either G3 pixel units (7.7 pix/mm), mm  or  inches.   If  no  units  are
    given, G3 pixels are assumed.


        examples

        LEFTMARGIN = 160
        LEFTMARGIN = 0.815in
        LEFTMARGIN = 20.8mm

    should all have the same effect.

    5.29.  PRVIEW keyword

         The  PRVIEW  keyword  defines  programs and/or file or device names
    that are associated with printfax devices. Printfax device are conceptu-
    ally split into two types, printers and file formats.

         Format  'devices'  may have a program associated with them, that is
    invoked after the first page of the fax has  been  decoded,  giving  the
    facility to use an alternative fax viewer.

         The  format  is PRVIEW = name, program, file. If the file name con-
    tains a 'C' numeric format, then the page number is inserted. The print-
    fax  'pbm'  and  'pic' types decode each page to a separate file. If the
    output device name starts with a vertical bar, then the output of print-
    fax is piped to the standard input of that program.

         For example:


        PRVIEW = hp-pcl, ,prt
        PRVIEW = ps, ,|lpr -l
        PRVIEW = pic-scaled, win1_viewers_qspv,win1_tmp_fax_%03d_pic




         1.   Write HP pcl output to the device prt.

         2.   Pipe postscript output to an "lpr" spooler program.



24                                   QFAX Class 2.0/Class 2 Facsimile System


         3.   Write  pages  to  fax_001_pic, fax_002_pic etc in the win1_tmp
              directory. The qspv PIC viewer would be invoked  on  the  file
              fax_001_pic after the first page is decoded.


         The  output file specification may be overridden by a printfax com-
    mand option.

         The default is no PRVIEW entries are defined.

         The full list of device names supported by printfax is described in
    `Running printfax'

    5.30.  HANGUPOK keyword

         The  Class  2  standard requires that all AT commands issued by the
    fax software have replies from the modem terminated by a string such  as
    OK  or  CONNECT  ... unless you have an ELSA 28.800 modem, which doesn't
    work like this. This 'intelligent' modem assumes that a  AT+FDR  command
    can  be  terminated  by +FHNG:0, when the standard requires +FHNG:0 fol-
    lowed by OK. If you have one of these modem, set HANGUPOK in QFAX_DAT.

    5.31.  Page and Paper Options

         QFAX supports (from v2.0) all the ITU-TSS page sizes  and  combina-
    tions  thereof  and various paper sizes (including ISO A4, US Letter and
    US Legal), depending  on  your  printer  type.  These  capabilities  are
    defined  through  the  keys listed below and explained in some detail in
    `Pages and Paging'.

         The keys are:


         WIDTH_S
              default page width for text2g3 encoding.

         PAGE_S
              default page length for text2g3 encoding.

         WIDTH_R
              advertised capability for qfax reception.

         PAGE_R
              advertised capability for qfax reception.

         PAPERSIZE
              The size of paper used to print fax.

    The usage of these keys, and implications are described the the  section
    `Pages and Paging'.





QFAX Class 2.0/Class 2 Facsimile System                                   25


    5.32.  Fax file Suffix

         The  SUFFIX  keyword  defines  a  suffix that text2g3 and qfax will
    append to fax file names. The default suffix is fax.

    5.33.  PPR_TRY

         The PPR_TRY keyword defines the number of attempts qfax  will  make
    to  send  a fax when the modem returns a ppr (post-page response) error.
    In previous releases of QFAX, qfax would make four  attempts,  in  v2.0,
    the default is three (PPR_TRY = 3).

    5.34.  UNLIMITED keyword

         The PAGE_S keyword (or text2g3 command options defines how you wish
    to page faxes you create. In many cases, you will create these paged  to
    ISO A4 size (PAGE_S = 0), but you wish qfax to transmit these as "unlim-
    ited". You can achieve this by placing the key


        UNLIMITED

    in the qfax_dat file.

    5.35.  MONO keyword

         The MONO keyword forces  qfv,  text2g3  and  printfax  to  adopt  a
    monochrome colour scheme.


        MONO = Y



    5.36.  SAVETHING

         QFAX can save details of a user defined number of received fax in a
    "Thing" for rapid access of recent fax in qfv. This information may also
    be  saved  to  disk to ensure it survives system shutdown. The SAVETHING
    keyword defines a file to be used for this.


        SAVETHING = win1_qfax_savething_dat

    Details of QFAX Thing functionality is described in `QFAX Thing'.

    5.37.  XDIAL keyword

         The character '[' in a phone number inserts the string given by the
    key XDIAL.


        so:


26                                   QFAX Class 2.0/Class 2 Facsimile System


        # In QFAX_DAT
        XDIAL = 00-44-1

        #In QFAX_PHONE
        NAME=RacingSailboats, ALIAS=rsb, TSI=0712231448, FULL=[712231448
        then

        ex qfax;"-s rsb rsb.fax"
        will dial 00-44-1712231448



    5.38.  RCLASS,SCLASS

         The  keys  RCLASS  and SCLASS define the value used for receive and
    send +FCLASS commands. The default is RCLASS = 2, SCLASS = 2. Most  peo-
    ple  don't  need  this.  These option was added for a feature of a Supra
    modem. They are ignored for Class 2.0.

    5.39.  GDELAY

         The GDELAY key defines the timeout for an 'OK'  response  from  the
    modem following a 'BBS Grab' invocation of QFAX. The default is GDELAY =
    10 (seconds).

    5.40.  DATA

         The DATA key defines a program that is invoked when QFAX answers  a
    data  call.  The  default is DATA = (none). If DATA is defined, and does
    not start '@', then it is taken to be a program to be invoked as:


        ex prog,ser,log,ser;



         If the qfax_dat DATA = option starts with an '@', then on data con-
    nect,  a file may be displayed telling the caller why they cannot make a
    data connect. Your modem must support  adaptive  answer  for this.


        DATA = @win1_qfax_nologin_txt



         The +FAA parameter is  automatically  set  to  +FAA=1  if  DATA  is
    defined.  A suitable program as a DATA client may be found as SMBX (Sim-
    ple Mail Box).  SMBX is (was?) maintained by Dave Woodman; he once could
    be contacted on his dedicated QFAX/SMBX line (+ 44 1628 541753).

         Note  this  functionality may only work in this release with modems
    that return "CONNECT FAX / CONNECT speed etc" for fax/data  in  adaptive
    (+FAA=1) mode. This may be configurable in a future version.


QFAX Class 2.0/Class 2 Facsimile System                                   27


         A  suitable  'serial  monitor' front end that may be configured for
    this or other modem responses is available as  SMBOX_BAS.  This  may  be
    compiled  with  QLib  (I  am  informed  by  a normally reliable source).
    SMBOX_BAS is not subject to the QFAX (or SMBX)  licence  and  is  public
    domain.

         SMBX  is  not intended as a QBOX replacement or in competition with
    it.  It is intended to provide simple data/e-mail/file transfer  facili-
    ties  for  "QBOX  Refugees" (or is that "QBOX refusees") who do not need
    the full capabilities of a traditional BBS.

    5.41.  CHILDLOG

         When an external data mode program is  invoked,  its  stderr  (log)
    channel  defaults  to  the current QFAX log channel. This may be changed
    using the CHILDLOG key.


        CHILDLOG = ram2_smbx_log



    5.42.  FAA

         The key FAA forces a setting of the +FAA parameter for receive.


        FAA = 2



         For (example) Supra 'silent' answer. If this key  is  not  defined,
    QFAX uses its defaults for +FAA (0 or 1).

    5.43.  STARTSCRIPT

         If  you have CSM ('Client Server Manager') on your system, QFAX can
    run a startup script, for example to check for the  existence  of  other
    programs  that  might  be  using  the  serial  port. The STARTSCRIPT key
    defines such a program file (BASIC if you have Minerva, compiled for all
    OS  types)  .  The script is always run before a WAIT or MONITOR session
    (-w, -W, -m, -M). The script is never run for a  GRAB  (-G)  or  spawned
    send (-z) session. The key RSFLAG controls whether the script is run for
    receive (-r, -R) or send (-s, -S).

         The only QFAX CSM REQUEST that a startup script can make  is  EXIT-
    PARAM.

    5.44.  STOPSCRIPT

         If you have CSM on your system, QFAX can run a shutdown script, for
    example to reinstate any other program that might be  have  been  previ-
    ously  using  the serial port. The STOPSCRIPT key defines such a program


28                                   QFAX Class 2.0/Class 2 Facsimile System


    file (BASIC if you have Minerva, compiled for all OS types) . The script
    is  always  run  after  a  WAIT or MONITOR session (-w, -W, -m, -M). The
    script is never run for a GRAB (-G) or spawned send  (-z)  session.  The
    key  RSFLAG  controls  whether the script is run for receive (-r, -R) or
    send (-s, -S).

    5.45.  RSFLAG

         The RSFLAG key defines if any defined startup or shutdown script is
    run  during  startup or shutdown processing for receive (-r, -R) or send
    (-s, -S) sessions. The key may take the values R, S or RS (or SR).


        RSFLAG = RS



         The default is RSFLAG is blank (no scripts invoked).

    5.46.  SCRIPTLOG

         The SCRIPTLOG key defines the name of a  log  file  (stdout,  PRINT
    channel) or QFAX scripts. The default is ram2_script_log.

    5.47.  APRES

         The APRES command (if defined) is sent after modem HANGUP. Confused
    ZyXEL owners may set


        APRES=+FREV



         to remind themselves of their current ROM (a)version.

    5.48.  NOPOLL

         The NOPOLL key will prevent QFAX from issuing any polling commands.
    For  modems  that  do  not  support polling commands (+FSPL, +FLPL). The
    default is to support poll commands.

    5.49.  GFLAG

         Some Class 2 modems (like mine)  appear  very  tolerant  about  the
    padding  and  alignment  of  fax lines. Others may not be, the GFLAG key
    controls the padding and alignment.


         GFLAG = 0
              (the default, standard text2g3 conformance) Adds  a  byte  pad
              before EOL, starts new lines on byte boundary.



QFAX Class 2.0/Class 2 Facsimile System                                   29


         GFLAG = 1
              Starts new lines on byte boundary

         GFLAG = 2
              Does no padding or alignment.


    5.50.  LSB

         qfax  attempts  to  determine  received fax bit order from the data
    stream. The key LSB will override this automatic detection and  tag  the
    received dat as LSB.

    5.51.  MSB

         qfax  attempts  to  determine  received fax bit order from the data
    stream. The key MSB will override this automatic detection and  tag  the
    received dat as MSB.

    5.52.  PRESCAN

         When  printfax  or  qfv  prints or displays a fax, it works sequen-
    tially through the file, displaying pages as it finds them. This  strat-
    egy  may  (in rare circumstances) fail on badly corrupt fax. The PRESCAN
    key causes qfv and printfax to prescan the fax for end of  page  markers
    before  it is displayed/printed. This mode provides more accurate recog-
    nition of EOP for such faxes at a small time cost (around 2 sec/page for
    a 16Mhz/68000 system , considerably more from 68008 from flp_) .

    5.53.  EDR

         The  EDR  keyword  defines  a  EDR RINGn value for use by ZyXEL EDR
    mode.


        EDR=1   # RING1 is fax



    5.54.  ECM

         The ECM keyword defines a whether Class  2  error  correction  mode
    should be used. Not all modems support ECM.


        ECM=1   # Use ecm



    5.55.  Default values

         QFAX  supplies  defaults for many keywords, so you can ignore them,
    and accepts abbreviations for most keywords, the following table defines


30                                   QFAX Class 2.0/Class 2 Facsimile System


    this


        Parameter       Minimum Abbreviation    Default

        APRES           APRES                   (none)
        ATZ             ATZ                     Z
        CHILDLOG        CHILDLOG                (none)
        CLASS2.0        CLASS2.0                (not defined (Class 2)
        CODING          COD                     0
        DATA            DATA                    (none)
        DAYS            DAYS                    Sunday,Monday etc
        DELAY           DELAY                   10
        DIAL            DIAL                    D
        APRES           APRES                   (none)
        APRES           APRES                   (none)
        ECM             EC                      (none)
        EDR             EDR                     (none)
        EXITBAUD        EXIT                    (none)
        FAA             FAA                     0 or 1
        FONT            FONT                    flp1_QFax_font
        GDELAY          GDELAY                  10 (seconds)
        GFLAG           GFLAG                   0
        HANGUPOK        HANGUPOK                (none)
        IDENTIFICATION  ID                      (none)
        INDIR           IND                     ram1_fax_
        INFO            INF                     ram2_fax_log
        INIT            INI                     (none)
        LEFTMARGIN      LEFTMAR                 160 pixels
        LSB             LSB                     (none)
        MDM1            MDM1                    (use QFAX default)
        MDM2            MDM2                    (use QFAX default)
        MDM3            MDM3                    (use QFAX default)
        MDM4            MDM4                    (use QFAX default)
        MODEM           MOD                     5
        MONTHS          MONTHS                  January,February etc
        MSB             MSB                     (none)
        NOPOLL          NOPOLL                  (none) (i.e. poll is allowed)
        PAGE_RECEIVE    PAGE_R                  2
        PAGE_SEND       PAGE_S                  0
        PAPERSIZE       PAPERS                  A4
        PATHFONT        PATHFO                  (none)
        PFAXINI         PFAXINI                 (none)
        PHONEBOOK       PHONEBOOK               QFAX_PHONE
        PPR_TRY         PPR                     3
        PREINIT         PREINI                  (none)
        PRESCAN         PRESCAN                 (none)
        PRINT           PRINT                   (none)
        PRVIEW          PRVIEW                  (none)
        QFAXINI         QFAXINI                 (none)
        QFVINI          QFVINI                  (none)
        RCLASS          RCLASS                  2
        RESOLUTION      RES                     1


QFAX Class 2.0/Class 2 Facsimile System                                   31


        RMODEM          RMODEM                  (none)
        RSFLAG          RSFLAG                  (none)
        SAVETHING       SAVET                   (none)
        SCLASS          SCLASS                  2
        SCRIPTLOG       SCRIPTLOG               ram2_script_log
        SENDBITS        SEND                    LSB
        SERBAUD         SERB                    19200
        SERDEV          SERD                    ser2hr
        SIGNATURE       SIG                     QFAX System
        STARTCHAR       STARTC                  DC2
        STARTSCRIPT     STARTS                  (none)
        STOPSCRIPT      STOPS                   (none)
        SUFFIX          SUFFIX                  fax
        T2G3INI         T2G3INI                 (none)
        TEMP            TEMP                    ram2_
        UNLIMITED       UNLIM                   (none)
        VIA             VIA                     (none)
        WAIT2SEND       WAIT                    YES
        WIDTH_RECEIVE   WIDTH_R                 0
        WIDTH_SEND      WIDTH_S                 0
        XDIAL           XDIAL                   (none)

    The  keywords may occur in any order in the file. Any line that does not
    start with a key word is assumed to be a comment. If you just wanted the
    defaults other than the ID, then your file could be:


        # This is a comment in my QFAX File
        # I use a hash as it can't be mistaken for much else

        ID = +44 123 456789
        # End of QFAX File

    I  recommend  you use something like a hash to define comments, it makes
    it simple to see what is in the file. A utility qparse is  available  to
    display the effect that any given `qfax_dat' will have on QFAX programs.

        Please note: The above may seem like heavy going. in many  cases
        the default values will be suitable for your modem.


    5.56.  G3 File formats

         It  is possible to say create one G3 format file using a given cod-
    ing and resolution and then change your `qfax_dat' file (or just  change
    the  `QFAX_DATA' environment variable to point to another file) and then
    create more G3 files with different coding or resolution before they get
    sent.  In  order that the sending program is not dependent on a previous
    setting, this information is recorded in the header of QFAX G3 files.

         This header is also filled in, when receiving, by the qfax  program
    from  the  parameters negotiated with the sending fax machine, so if you
    receive  a  fax  encoded  in  low  resolution  into  your  default  high


32                                   QFAX Class 2.0/Class 2 Facsimile System


    resolution  environment,  the  qfv  and printfax programs don't get con-
    fused.

         The QFAX file format is described in `QFAX File Format'.



















































QFAX Class 2.0/Class 2 Facsimile System                                   33


    6.  Pages and Paging

    6.1.  Fax Page Sizes    QFAX v2.x supports all the ITU-TSS  combinations
    of page sizes and widths in text2g3, qfax, qfv and printfax.

                                     Page Widths


        Key     Pixels      mm      Descriptive

        0       1728        215     A4 (note 1)
        1       2048        255     B4 (note 1)
        2       2432        303


                                  Page Lengths


        Key     Pixels      mm      Descriptive

        0       2286        297     A4 (note 1)
        1       2804        364     B4 (note 1)
        2                           Unlimited (note 2)



                           Table 1.0 ITU-TSS G3 page sizes


         1.   Well almost !

         2.   text2g3 imposes an arbitrary limit of 16.7 million pixel lines
              per page

    The  guaranteed  printable area defined by  the  ITU-TSS  is  less  than
    these limits, text2g3 will automatically page  files  at  the  following
    pixel  sizes,  unless  the length is set to unlimited, or you page manu-
    ally.


        Size    Pixels
          A4    2240
          B4    2760



    6.2.  QFAX_DAT keywords for paging

         WIDTH_S
              Defines  the  default   page  width  that  text2g3  uses  when
              encoding fax. The values are a numeric key as in table 1.  The
              default is A4 width.



34                                   QFAX Class 2.0/Class 2 Facsimile System



                  WIDTH_S = 0



         PAGE_S
              Defines  the  default   page   length  that  text2g3  uses
              when encoding fax. The values are  a  numeric  key  as  in
              table 1. The default is A4 page length.


                  PAGE_S = 0



         WIDTH_R
              Defines   the   maximum  page  width  that  you negotiate.
              This does not necessarily mean that either your modem   or
              the   remote will be limited to this size for receive. The
              default is G3 A4.


                  WIDTH_R = 0



         PAGE_R
              Defines  the  maximum  page  length  you   negotiate   for
              receive,  the default is unlimited.


                  PAGE_R = 2



         I  can see no practical reason for change this unless you have par-
    ticular antipathy towards members of the legal profession.

    6.3.  How text2g3 handles page sizes

         Page size parameters in text2g3 are taken from the WIDTH_S,  PAGE_S
    (and  LEFTMARGIN)  keywords  in  'qfax_dat',  but you can override these
    using the -w -h and -l command line options.


         -w   page width in G3 Key values (0,1,2)

         -h   page length in G3 Key values (0,1,2)

         -l   left margin in G3 pixel units.

    Although text2g3 will fill a page size to extreme margins,  many  "stan-
    dalone" fax machines will not print to these margins. The header margins


QFAX Class 2.0/Class 2 Facsimile System                                   35


    used by text2g3, (60 pixels), should be considered a minimum.

         Using the standard text2g3 default left margin of  160  pixels  and
    assuming  and  equivalent right margin and a standard QFAX ID-line, then
    the page sizes in character sizes (for the default  font)  are  approxi-
    mately.


        A4      85 characters x 67 lines
        B4     101 characters x 85 lines
        303mm  124 characters x (Approximately 524200 lines in unlimited)

    text2g3  pages  the  fax  by  inserting RTC code words at the pixel line
    counts given in table 1.0. The page size and width parameters are stored
    in the header, as is the number of pages (RTC sequences inserted).

         text2g3 v2.5 (and later) can include pages of varying size and res-
    olution in a fax. This is described in `Header offset'.

    6.4.  How qfax handles page size

         qfax send uses the page size parameters in the header (from text2g3
    or  ps2g3  (ghostscript))  to  negotiate with the remote device. The fax
    file is parsed during transmission and end of page  negotiation  invoked
    when an RTC sequence is found.

         qfax  receive  uses  the WIDTH_R and PAGE_R parameters to negotiate
    with the remote device. The negotiated parameters are stored in the file
    header.  qfax recognises page breaks from data stream (DLE ETX); it will
    add RTC if the modem does not return it. The number of pages received in
    stored  in  the  file  header  and the file name is recorded in the file
    'INDIR_QFAX-lastfax', where INDIR is your top level inbound  fax  direc-
    tory  (IN_DIR).   This  is overwritten with each new fax, and is used by
    qfv and printfax for their "last fax" options.

    6.5.  How the decoder handles Page Size

         The decoder is common to both qfv and printfax. It has undergone  a
    number of changes for v2.x to cope with variable page sizes.

         Faxes  do not always conform to the sizes specified by the ITU-TSS.
    For example, I frequently receive faxes from a machine that I know is  a
    manual,  A4  page  feed,  that exceed the nominal 2286 pixel lines.  The
    decoder is necessarily page based  and  uses  a  number  of  algorithms,
    including  ratio  of  black  to  white pixels, number of scan lines, and
    proximity to next RTC or end of file to  determine  the  validity  of  a
    potential  page. These algorithms have proved reliable, but there may be
    faxes that break them.

         The fax viewer, qfv, can "band" faxes into  available  memory.  The
    printing utility, printfax, currently requires that contiguous memory is
    available for a complete fax page.



36                                   QFAX Class 2.0/Class 2 Facsimile System


    6.6.  How qfv handles page size

         When qfv starts up it tries to allocate page memory for the largest
    page  size  in  the  first  fax file that it is to display. This has two
    effects, firstly it only uses memory as necessary and secondly,  if  you
    subsequently  try to view a fax with a larger page size, qfv will "band"
    the fax to fit available memory.

         You can force qfv to use a reduced memory allocation  (thus  saving
    memory  and  "banding"  fax  using  the "-X memsize" option. The minimum
    value of "memsize" is 120000 bytes.


        ex qfv;"-X 204800" : Use 200K for fax image decoding

    qfv tries to be flexible in the allocation of page memory without  being
    profligate or encouraging fragmentation; if your fax exceeds its claimed
    page size, then qfv will still attempt to  allocate  enough  memory  and
    display the fax.

    6.7.  Page and Paper sizes printfax

         printfax uses a similar paging scheme to qfv. The page memory allo-
    cation is taken from the page dimensions recorded in the fax header,  so
    printfax  only  ever takes sufficient memory for the fax it is printing.
    printfax however requires sufficient contiguous  memory  to  decode  the
    largest page in a fax.

         printfax  defaults  to  ISO  A4  paper size on HP printers and 11in
    forms on Epson.  The default paper size may  be  set  using  either  the
    'QFAX_DAT' PAPERSIZE key word, with values of A4, Letter or Legal.


        PAPERSIZE = legal

    The  paper  size may be defined (HP) by the printfax command line option
    -f, with numeric values of 0 = ISO A4, 1 = US Letter and 2 =  US  Legal.
    The  way  the  printer handles different page and paper sizes depends on
    the model. Epson printer drivers do not currently support the  PAPERSIZE
    keyword.

    6.7.1.  HP Printer features

         Full  support  is  provided  for  ISO  A4  (297x210mm),  US  Letter
    (11x8.5in) and US Legal (14x8.5in) paper sizes. Faxes are always  scaled
    with  respect  to  the  ITU-TSS  width parameter to fit within the paper
    size.  Faxes of ISO aspect ratio (sqrt(2) : 1), (G3 A4xA4,  B4xB4,  *  x
    unlimited),  i.e.  the G3 width parameter is equal to the G3 page length
    parameter or the length is unlimited, are scaled to  completely  fit  on
    either ISO A4 or US Letter paper depending on your PAPERSIZE setting (in
    this instance US Legal is considered to be US Letter, as  the  width  is
    the scaling factor).



QFAX Class 2.0/Class 2 Facsimile System                                   37


         If  the  both  the  G3  width  and  the  page length parameters are
    defined, then the scaling is taken from the width, and the  printout  is
    paged  according  to your paper size, so if you receive a G3 A4 wide, G3
    B4 page length fax, and select US Legal paper, then each fax  page  will
    be  printed on a single sheet. If you print the same fax on ISO A4 or US
    Letter paper, then each fax page will be printed over 2 sheets of  paper
    with  about  the last 1/4 of the fax page on the second sheet.  Each fax
    page will start on a new sheet.

         When printfax takes the paper size from 'QFAX_DAT' (either  defined
    or  by  default  ISO A4), it assumes that the printer default is set for
    this size of paper. If you use the -f command line  option  to  override
    the  QFAX  default, then printfax will send a printer command to use the
    -f selected paper size and send a printer command to set the paper  size
    back to default when the fax has been printed.

         printfax  defaults to 300dpi on HP printers; 150dpi printing may be
    selected with the printer specific flag -s 2. This will be necessary  to
    print A4 x B4 length fax to US Legal paper on a 1Mb LaserJet. The 150dpi
    algorithm has been chosen for ease of implementation  and  speed  rather
    that quality, it is however (almost) readable.

         All combinations of fax sizes may be printed with the -s 1 specific
    flag to print at pixel size. Note that at 303mm,  unlimited  (2432x3218)
    pixels,  the  last 32 pixels of each line are clipped by the printer and
    the page length will exceed the reproducible size on US Letter paper.

         The -s flags may be OR'ed to do unscaled 150dpi printouts (-s 3).

    6.7.2.  Epson Printers

         The Epson drivers only support A4 widths and will refuse  to  print
    anything wider. They will however print B4 lengths without introducing a
    page break.  If this causes a problem on  page  printers  (Stylus  etc),
    please  let me know, and a form feed will be added. A future release may
    support wider sizes.  The Epson drivers currently ignore  the  PAPERSIZE
    parameter.

         I do not have access an Epson printer printer of any description. A
    future release of QFAX will use external printer  drivers,  making  user
    development  of better drivers for hardware other than HP a more practi-
    cal proposition.













38                                   QFAX Class 2.0/Class 2 Facsimile System


    7.  Using text2g3

    7.1.  text2g3 Overview

         text2g3 takes an ASCII text file (prepared by a standard text  edi-
    tor  such as MicroEmacs, QED, Ed, QD etc) and converts it into a G3 for-
    mat file (with a QFAX header).  It is also possible to use QUILL or sim-
    ilar  word processor to produce formatted faxes and use underline, bold,
    and italics. User defined fonts are also supported.

    7.1.1.  QFAX font

         Text is converted using one of the QFAX fonts.  text2g3 expects  to
    find  these in the default data directory, as directly defined or in the
    directory described by the PATHFONT key.

         The QFAX fonts include both monospaced and proportional fonts. QFAX
    imposes  a  20mm  left margin, and allows 85 characters per line (in A4)
    with  the  smaller  fonts  and  around  42  characters  per  line   with
    `qfaxbig_font'. You can define the left margin (`LEFTMARGIN keyword').

         The  default  font (QFAX_FONT) has 256 characters, some of the con-
    trol characters print out as graphics symbols; the  upper  half  of  the
    character  set  is  an IBM character set. You can use text2g3 and qfv or
    printfax to see what this looks like  by  processing  the  example  file
    `Qfont_txt'.  A  utility is provided to edit monospaced fonts, `Changing
    QFAX font'.

         Many of the other fonts contain less than the full ASCII  character
    set.  The  qfxfnt utility currently only works with monospaced fonts.  A
    list of fonts is supplied, `QFAX Supplied Fonts'.


        ex text2g3;'flp2_qfont_txt -o ram1_'
        ex printfax;'-o ser1hr -t eps-24 ram1_qfont_fax_001'



    See the later descriptions for the parameters to the programs.

    7.1.2.  Changing QFAX font

         A QFAX Utility program qfxfnt allows you to  remap  to  `qfax_font'
    and other monospaced qfax fonts to the SMS/QDOS keyboard and design your
    own characters. The qfxfnt documentation gives examples for  German  and
    Norwegian  character sets and some example replacement characters (phone
    symbol and check box).

    7.2.  text2g3 formatting

         You can include a number of special commands in the text file  that
    instruct  text2g3  to  take  special  actions.  The  special actions are
    flagged by a tilde "~" character at the start of  the  line.  The  tilde


QFAX Class 2.0/Class 2 Facsimile System                                   39


    commands supported by text2g3 are:

    7.2.1.  ~;

         These commands ~; and ~: define comments, ~: comments are displayed
    on the screen.

    7.2.2.  ~# width_code page_code

         This command may be used in a fax to  define  the  width  and  page
    length parameters for the fax. It must occur before any text or graphics
    to be encoded. It may be included in the fax  from  a  ~I(nclude)  file.
    The code values must be in the range 0-2.

    7.2.3.  ~P

         Start a new page.

    7.2.4.  ~I filename

         Includes  the  file  defined  by  `filename'.  Include files may be
    nested up to a depth of seven (i.e.  include  files  may  include  other
    include  files that may contain tilde command sequences (or even include
    files), see ~I parameter).

    7.2.5.  ~C filename

         Chains to the file defined by `filename'. QFAX will not  return  to
    the calling text file.

    7.2.6.  ~S screen_dump


        ~S screen_dump [position] [magnification] [invert] [square]

         This  command includes a SMS/QDOS screen image as a graphic in your
    fax. The command assumes that the image is based on a  screen  width  of
    128  bytes  (i.e. the 512 pixel width format), but does not restrict you
    to a 256 line image, the program just reads 128 byte screen lines  until
    it hits end of file. The screen is distorted (pixels are extended verti-
    cally), so text2g3 repeats some screen lines to  give  images  that  are
    about 98% square on paper.


         position
              Defines  a  offset  from the left edge of the page in G3 pixel
              units (note left text margin is offset by ten characters which
              is  160  pixel units, the G3 page widths are show in `Fax Page
              Sizes'.  text2g3 will prevent you  from  placing  graphics  so
              they  do  not  fit  on  the  page.  The  position  value has a
              granularity of eight pixels.




40                                   QFAX Class 2.0/Class 2 Facsimile System


         magnification
              May take values of 1,2,3 and is a linear magnification of  the
              image.  If  the magnification is negative, then it has special
              significance.  This  tells  text2g3  to  ignore  the  position
              argument   and   centre  the  image  on  the  screen  in  that
              magnification.

         invert
              Makes a negative image. Zero means do not  invert,  any  other
              value means invert.

         square
              Ignores  the aspect ratio and copies the image verbatim.  Zero
              means  compensate  for  video  distortion,  any  other   value
              signifies the original image is square (4),



        Here is a SMS/QDOS screen graphic:
        ~S  flp1_worm_scn 0 -2

        It's centred and double size (also not inverted and not square so we
        compensate for video distortion)

        ~S flp2_test_scn 160 1 1

        This one is starts on the text margin and is not magnified (512
        pixels across), but it's inverted (assumed not square).

    text2g3  employs a very simple algorithm for including SMS/QDOS screens,
    any black screen pixel will be black on the paper and other colour  will
    be  white. In you use inverse, then any black screen pixel will be white
    and anything else will be black.  An example is supplied, `worm_scn'.  I
    suggest you display this on the monitor


        lbytes worm_scn, hex("20000")  : REMark on a QL



    then  print  it  out  using text2g3 and printfax to see the differences.
    (It's included as `eg_test_fax').  Note that the  solid  red  and  green
    areas are white on paper, but the stipples used to shade the 'mountains'
    are reproduced as a grey pattern they mix black and  a  colour.  If  you
    want  stippled  patterns  in the fax, then use black/colour stipple pat-
    terns on the screen. I found `worm_scn' on an old disk somewhere; it's a
    good example, I hope I have not offended the copyright holder.


____________________
   4. A number of the examples were created from 'square' sources




QFAX Class 2.0/Class 2 Facsimile System                                   41


    7.2.6.1.  fsPIC dithering options

         The  QFAX  utility  program  fsPIC will dither PIC images to give a
    simulated grey scale. The pbm images produced by  this  program  may  be
    included  in faxes using text2g3 and give much more detailed images. Try
    it on the worm image and see.

    7.2.7.  ~Q PIC_Image


        ~Q PIC_Image [position] [magnification] [invert] [square]

         This option allows the inclusion of graphics  in  the  PIC  format.
    This  format  has  a header to the screen image that defines the x and y
    pixel dimensions of the image.  QFAX does not restrict  such  images  to
    the  any given size, and the image does not have to be a standard screen
    size. The header format is described in the QPTR manual.  The QFAX pack-
    age  includes  four  such images, (PIC format). They have been converted
    from other (PD) sources and are square, so they can be used as follows:


        ~Q HeadTms_pic 0 -1 0 1
        The "Facsimile Message" graphic in Times-Roman
        font.

        ~Q HeadHlv_pic 0 -1 0 1
        The "Facsimile Message" graphic in  Helvetica font.

        ~Q QFax1_pic 0 -1 0 1
        The QFAX logo on one line (note this is about 1400 pixels across).

        ~Q QFax2_pic 0 -1 0 1
        The QFAX logo on two lines.



    The worm_pic graphic is the worm_scn  graphic  in  PIC  format,  it  has
    graphic  distortion  (i.e.  non-square  pixels)  so it does not have the
    'square' argument.


        ~Q worm_pic 160 2



    7.2.8.  ~q & ~s Image


        ~q PIC_Image [position] [magnification] [invert] [square]
        ~s SCN_Image [position] [magnification] [invert] [square]

    These additional commands allow you to overlay text and graphics in  the
    same  horizontal area. By combining the position parameter and spaces in


42                                   QFAX Class 2.0/Class 2 Facsimile System


    the text, it is possible to surround a graphic with  text.  The  example
    files  `test_txt'  and  `test_fax' show the results that can be obtained
    using these commands. It isn't desktop publishing, but the  results  are
    quite  good.  When calculating screen positions, use the following sizes
    for the default qfax_font:


        Character width  = 17 pixels (inc char spacing)
        Character height = 34 pixels (inc line spacing)



    The graphic features may allow you to create (semi-)professional looking
    faxes without access to DTP programs.

    7.2.9.  ~B & ~b pbm_file


        ~b pbm_file [position]
        ~B pbm_file [position]

         It  is  also  possible  to include bitmaps in pbm (Portable Bitmap)
    format. QFAX/text2g3 supports the raw, P4, (that  is  monochrome  binary
    variation)  of  pbm.  This  is  included as a aid to importing black and
    white graphics that have been generated from  external  sources  without
    the trouble of using native screen formats with the inherent overhead of
    extra size and video scaling. An example of an external source might  be
    a  utility to convert Epson printer dumps to pbm. The ~B command inserts
    and ~b command overlays.

         The example `test_txt' has been changed from QFAX v1.5 to include a
    pbm  file.   Note  that  this  image  is half the size of the PIC format
    `frog_pic' in earlier versions.


        ~b frog_pbm 560         ; overlay frog



    7.2.10.  ~d, ~D Date Formatting

         text2g3 can automatically include the current date in the body of a
    fax. The flags are ~d and ~D, formatted as:


         ~d   day month year

         ~D   weekday, day month year


    So, if today is 27th September, for the two flags, the results would be:




QFAX Class 2.0/Class 2 Facsimile System                                   43


        ~d   27 September 1994
        ~D   Tuesday,  27 September 1994



    QFAX allows you to define the textual names for the months and days in a
    `qfax_dat',  so,  a non-English user does not have to have English dates
    in a native language fax. The `qfax_dat' key words are MONTHS and  DAYS.
    The  equivalents supplied for these keywords are a comma separated list.
    Do not surround the text with quotation marks.

         For example, to use three character month and day names:


        MONTHS = Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec
        DAYS = Sun,Mon,Tue,Wed,Thu,Fri,Sat

        DAYS=dimanche,lundi,mardi,mecredi,jeudi,vendredi,samedi

     text2g3 supports bold, underline and italic by the following ~ switches
    that may appear anywhere on a line. A tilde "~" may be included by spec-
    ifying it twice "~~".  The commands are :


         ~E   Emphasis (Bold) on

         ~e   Emphasis (Bold) off

         ~U   Underline on

         ~u   Underline off

         ~O   Oblique (Italics) on

         ~o   Oblique (Italics) on

    ~O had previously been used an alternative code for Overlay  PIC  format
    graphic. The ONLY codes for PIC graphics now are:


        ~Q parameters    : Insert PIC graphic
        ~q parameters    : Overlay PIC graphic

      Example  QUILL  / XCHANGE files are included in the archive as `quill-
    fax_doc' and `quillfax_txt'.  The  example  (XCHANGE)  print  driver  is
    `xchange_dat_qfax'.

         The  `xchange_dat_qfax'  file  was  constructed using the following
    criteria:


        The output device is set to alternate (none).
        Lines/page are set to   60 (this depends on your use of graphics in the fax).


44                                   QFAX Class 2.0/Class 2 Facsimile System


        Char/line is set to     82
        Continuous forms set to Yes
        EOL set to              LF
        Emphasis On             ~E
        Emphasis Off            ~e
        Underline On            ~U
        Underline Off           ~u
        SubScript On            ~O              ) for Italics
        SubScript Off           ~o              )

     In QUILL, use Design to set the top and bottom margins  to  a  suitable
    value  (zero), and set the left and indent margins to zero and the right
    margin to 80. The footer was set to none. The interaction  between  page
    size  in  QUILL,  page  length  in  the driver and what you actually get
    depends on your usage of graphics in the fax, which QUILL does not  know
    about.

         For  output,  F3  P(rint) to a file, and use text2g3 to process the
    file into a fax.

         This method should work with any word processor that allows you  to
    define  escape sequences for bold, underline etc. You can add additional
    features using the 'user defined font' feature. If you wish to  generate
    flush right margin faxes, you now have a means to do so.

    7.2.11.  ~F & ~0 ... ~9 User defined Fonts

         QFAX/text2g3  supports user defined fonts. Fonts must be conform to
    the QFAX font format specification.

         text2g3 allows any number of fonts in a document. These  fonts  are
    referred  to  below  as  font0 to font9. If you do not define any fonts,
    then font0 is defined by text2g3 as the normal `qfax_font' font.  It  is
    recommended  that  font  0 is a monospaced font of similar dimensions to
    qfax_dat in order to maintain the format of the fax header  inserted  by
    text2g3.

         A  font is defined for subsequent use using ~F, with parameters of
    font file
     and  font number So given font0 is the standard  QFAX  font,  we  could
    define font1 and font99 as:


        ~F flp2_afont_font 1
        ~F flp2_bfont_font 99



    where the files `flp2_afont_font' and `flp2_bfont_font' are user defined
    font files. We can then use these fonts in a fax using the ~N  notation,
    where  N  is  the  font  number  (for  example) ~1 switches to font1. ~0
    switches to the default font (`qfax_font' if you haven't redefined  it).



QFAX Class 2.0/Class 2 Facsimile System                                   45



        ~F flp2_afont_font 1
        ~F flp2_bfont_font 99
        This is an example of ~1font one~0 and ~99font two~0. OK ??

     => This is an example of font one and font two. OK ??

         The  text  would  start  in the normal font, the phrase font one is
    encoded using the font from the file `flp2_afont_font', the ` and  '  is
    back  in  the `qfax_font', and phrase font two is encoded using the font
    from  the  file  `flp2_bfont_font',  and  the  last  part  is  back   in
    `qfax_font'. The fax header is always in font 0, usually the `qfax_font'
    default, but you can define your own default font if  you  want,  either
    using  FONT = in `QFAX_DAT', -f on the text2g3 command line or  ~F file-
    name 0
     in a text file.

         The Bold, Underline and Italic commands  may  be  applied  to  user
    defined fonts.

         The  ~number  command to indicate a change of font is terminated by
    the first non-numeric character. If you want to change the font and then
    print  a  numeric  character immediately, then you can put a exclamation
    mark after the number. This is ignored.


        ~12!1234567890    (change to font 12, output "1234567890")
        ~13!!He exclaimed (change to font 13, output "!He exclaimed")



         Font numbering does not have to be sequential.

    7.2.12.  ~m Macros

         text2g3 supports up to 16 user defined macros. This means you  can,
    for example, prepare a text file with macro markers in it, then, using a
    macro file, send the same file to a number of respondents, each one per-
    sonally addressed.

         The  macros  are  indicated in the text file using ~mN where N is a
    hexadecimal digit in the range (0 - f), for example, ~m0  ~m9  ~ma  ~mf.
    The  macro expansions are defined in another file, in the format N:text;
    where N is the macro number and text is the macro  text.  You  pass  the
    name of the macro file to text2g3 with the -m flag.

         So, to put this all together:


        => In the text file:

                To: ~m0



46                                   QFAX Class 2.0/Class 2 Facsimile System


                Dear ~m1,
                ...
                ~m3, ~m2

        => in a file macros_bc

                0:Bill Clinton
                1:Mr President
                2:Jonathan Hudson
                3:Yours faithfully

          then  ex text2g3;'-m macros_bc test_txt'

        => In the fax

                To: Bill Clinton

                Dear Mr President,
                ...
                Yours faithfully, Jonathan Hudson

        => in a second macros_gg file

                0:Graham Goodwin, Fur~EST~e Ltd.
                1:Graham
                2:Jonathan
                3:Best Regards

          then  ex text2g3;'-m macros_gg test_txt'

        => In the fax

                To: Graham Goodwin, FurST Limited        (note ST in BOLD)

                Dear Graham,
                ...
                Best Regards, Jonathan



    7.2.12.1.  Recursion

         A  macro  may contain a reference to a macro (which may contain ...
    etc), see `Recursion'.


        0:this is a macro
        1:Also, ~m0 as well



    Then, in a fax, ~m1 will expand to "Also, this is a macro as well".



QFAX Class 2.0/Class 2 Facsimile System                                   47


         A macro may contain references to other  formatting  (~)  commands,
    including those that are only recognised at the start of a line, such as
    ~Q to include graphics. Where such a reference is made, then the  refer-
    ence must be at the start of the line.


        0:~Q mysignature_pic 160 1 1 1



    then  ~m0 at the start of a line, will cause the graphic to be included.
    In the above example, I could have had a fifth macro,  ~m4,  defined  in
    macros_bc  as  4:~Q jrhsig_pic, which a formal signature ("Jonathan Hud-
    son"),  while  in  macros_gg,  4:~Q  jsig_pic,  which  is  an   informal
    "Jonathan".

    7.2.12.2.  Example Macro Files

         Two  BASIC  example programs are provided to further illustrate the
    usage of text2g3 macros. The files are `demofax_bas' and `demofax1_bas'.
    These  examples  are  very similar, they take a text file, `demofax_txt'
    and write out a personalised fax message to a number of people, which is
    then  sent  using  qfax.  `demofax_bas' uses the qfaxServer mode and can
    retry on busy, `demofax1_bas' runs a standalone qfax for  each  fax  and
    will break the BASIC program on error.

         In  the example, the data is taken from DATA statements in the pro-
    gram; a more practical example might read an EXPORT file  from  Archive,
    or  data extracted by some means obvious to users of DataDesign or DBAS.

         Note that the examples may generate quite a long command line.

    7.2.13.  ~X Include Fax

         text2g3 can include existing fax files in a fax. A special case  of
    "~X" without a filename instructs text2g3 to finishing processing.  This
    can be used to prevent extraneous blank lines from being included  after
    including  an  old fax file. Included fax files start on a new page, and
    any new material after an included fax file will also start a new  page.
    text2g3 headers will not be added to included pages, for various techni-
    cal reasons (i.e. it's difficult).

         Included fax do not need to be of the same  coding,  resolution  or
    length as the new fax.


        given the existing files

        demo1_fax
        demo2_fax

        if the file new_txt contains



48                                   QFAX Class 2.0/Class 2 Facsimile System


         ~X demo1_fax
         ~X demo2_fax
         ~X
         Never gets here

        then 'ex text2g3;"new_txt"'

    will  create  a  fax  file  'new_fax' that incorporates the existing fax
    files demo1_fax and demo2_fax.


        if the file newer_txt contains

         Let's go.
          ...
         This is a fax file. This is the first page
         ~X new_fax
         This is a fax file. This is the last page
          ...
         The end

        then 'ex text2g3;"newer_txt"'

        will create a fax file 'newer_fax'.

    The file "newer_fax" will contain an initial page from the text starting
    "Let's  go",  then  the  included  pages  of  the existing fax "new_fax"
    (itself made from the old "demo1_fax" and  "demo2_fax"  files),  then  a
    final  page  ending  "The end". The page starting "Let's go" will have a
    new headline with the current time/date (and P.001/002), the final  page
    will  also  have  the  the  current time/date (and P.002/002).  Included
    files retain their original header line.

         Included pages will have the bit order of the current coding  envi-
    ronment.

    7.2.14.  Other text2g3 Examples

         QFAX   includes  an  example  in  both  text  and  QFAX  G3  format
    `test_txt', `test_fax'). You can display or print  the  `test_fax'  file
    using  qfv  or  printfax You can create `test_fax' from `test_txt' using
    text2g3. Note that the fax image has been created in low  res  `-r0'  to
    minimise the archive size.

    7.3.  Running text2g3

         text2g3 is invoked as:


        ex text2g3;'[-f fontfile] [-v] [-x] [-r res] [-o outdir] [-2]
                    [-w N] [-h N] [-l N] [-m macrofile] [-u stemname]
                    [-a name] [-M]
                    file1 ... fileN'


QFAX Class 2.0/Class 2 Facsimile System                                   49


    where:


         -f   defines an alternative font file

         -v   invokes verbose mode

         -x   suppresses the c68 'Any key to exit' message

         -o   defines  a  device  /directory for the G3 file. The default is
              `ram2_'.

         -r   defines the resolution, 0 for normal low res, 1 for fine  high
              If you don't give this parameter, the value from `qfax_dat' is
              used.

         -u   defines the stem name for the output file.


                  ex text2g3;'-m macro_fred -u fred faxmerge_txt'
                          => fred_fax_001
                  ex text2g3;'-m macro_bill -u bill faxmerge_txt'
                          => bill_fax_001



         -m   defines a macro file

         -2   use 2-D encoding.

         -w   defines the width (as CCITT code 0,1,2).

         -h   defines the width (as CCITT code 0,1,2).

         -l   defines the left margin in fax pixels.

         -a   Checks the name in QFAX_PHONE for encoding  method  (1  or
              2D).

         -M   By default, text2g3 produces lsb format files (the default
              for Class 2 modems), -M forces MSB files.

    file1 ... fileN defines the files to process, wildcards  are  supported.
    for example:


        ex text2g3;'-r 0 -f flp1_qfax_font -o ram3_G3_ flp2_*_txt'

    The output file has the extension `_fax'.


        ex text2g3;'-r 0 -o ram3_G3_ flp2_test_txt'



50                                   QFAX Class 2.0/Class 2 Facsimile System


    gives a files ram3_G3_test_fax.

         text2g3  includes  a header on the top line of each page giving the
    SIGNATURE and ID fields from your `qfax_dat' file and a time stamp. This
    is  a  legal  requirement  is some countries (i.e. USA).  Other encoding
    programs (for example the gs fax driver) may not do this. This  line  is
    of the form


        Jonathan Hudson   +968-699407   19/01/94 19:05   P. 001/001
        SIGNATURE         ID            TIME STAMP       Page counts



    7.3.1.  T2G3INI

         The T2G3INI keyword in the `qfax_dat' file can preset command argu-
    ments for text2g3, for example, if you always wanted immediate exit  (no
    Press   any   key   message,   and   an   output   directory   of,  say,
    `win1_fax_output_', then you might use:


        T2G3INI = -x -o win1_fax_output_
































QFAX Class 2.0/Class 2 Facsimile System                                   51


    8.  Using qfax

    8.1.  qfax Overview

         The qfax program transmits or receives G3 format (QFAX) files.

         The qfax program supports many options, you can force Class 2.0  or
    Class 2 mode from the command line. This option applies to all examples,
    but is not repeated below.


        ex qfax;'[-2] [-2.0] etc




         -2   forces Class 2 mode.

         -2.0
              forces Class 2.0 mode.


    8.2.  Running qfax send


        ex qfax;'[-i ini] [-l logfile] [-v] [-x] [-eN] [-bN]
                     [-s phone file | -S phone [file] | -z phone file'




         -v   displays progress/debug information  on  the  console  (stderr
              device)

         -l   defines a log file for process/debug info.

         -x   suppresses the c68 'Any key to exit' message

         -i   defines  additional Hayes commands to be sent before dialling.
              (appended to the INI string in  the  `qfax_dat',  so  if  this
              defines  a  command  starting  AT,  you  don't need another AT
              here).

         -e   qfax emits a status code when it terminates. If  the  transfer
              was  successful, this will be 0, and on error, ERR_IU, ERR_FE,
              ERR_TE, ERR_BP or ERR_NF. You can use the -e option to  change
              the  error result code. For example, if you were invoking qfax
              from a QLIB program, you might want it  to  always  return  0,
              regardless of status; in this case -e 0.

         -b   defines  a maximum MODEM value for sending. If your respondent
              is using high speed modem on hardware that cannot  cope,  this
              will provide a "one-off" speed limit.


52                                   QFAX Class 2.0/Class 2 Facsimile System


         -s   followed  by  phone  number  to  dial.  In a valid 'Hayes' ATD
              format or NAME or ALIAS from QFAX_PHONE.

         -S   followed by phone number to  POLL.  In  a  valid  'Hayes'  ATD
              format  or NAME or ALIAS from QFAX_PHONE.

         -z   followed  by  phone  number  to  dial.  In a valid 'Hayes' ATD
              format or NAME or ALIAS from QFAX_PHONE. Uses  stack  supplied
              channels:


                  ex qfax,#serial_channel,#dontcare,#info;'-z etc'




         file file to send to the phone number.

         for example


        ex qfax;'-v -l ram2_sfax_log -s 010-968-699407 ram2_jh_fax'
            (Send jh a fax, log information to screen and to ram2_sfax_log)

            ex qfax;'-i M1 -v -s graham  ram2_Graham_fax'



    You  can have up to 30 '-i' parameters, these are sent after the default
    qfax initialisation, so you can over-ride the defaults.

         Caution: The -s TelNo File or -S TelNo  [File]  must  be  the  last
    parameter to this command. The -s and -S options are mutually exclusive.

    8.2.1.  Polling (requests)

         The -S version of the qfax command allows  you  to  poll  a  remote
    machine that supports polling. In this case you make the initial connec-
    tion (and pay for the call), and  you  receive  the  fax.  This  command
    requires  a  phone  number (or alias) and optionally a file name; if you
    supply a file name, qfax will send your file before receiving the polled
    fax.

    8.2.2.  ALIAS and qfax

         qfax  send  supports  ALIAS.  Given  a  suitable  ALIAS  or NAME in
    `qfax_phone', and QFAXINI = -v -l ram2_sfax_log, you could do the  first
    example as:


        ex qfax;'-s jh ram2_jh_fax'




QFAX Class 2.0/Class 2 Facsimile System                                   53


    8.3.  qfax receive

         qfax can receive faxes in a number of modes


         +    After the phone has been answered manually.

         +    Wait for rings, answer phone, receive fax and exit

         +    Wait   for   rings,  answer  phone,  receive  fax  and  repeat
              (background operation until RJOB'd)

         +    Background operation with popup (requires PE)

         +    Grab serial line (from BBS or similar)

    In each case, qfax will create a  file  for  each  received  page  using
    either  a given pattern (-r option only) or using a default pattern. The
    default pattern is:


         1.   the root for inbound fax is described by the  INDIR  parameter
              in the `qfax_dat' file.

         2.   A subdirectory is created from the caller TSI (essentially the
              caller's  phone  number).   qfax   removes   any   non-numeric
              characters  to  create  the  directory.  If  you  have an NAME
              defined for the TSI, the NAME is used for the directory  name.

         3.   qfax  creates a sequential sequence number for the file (and a
              file `seq_dat' to store sequence numbers). The sequence number
              is  a  zero  filled  five  digit  number.  The fax file suffix
              (`SUFFIX keyword') is appended.


        INDIR = ram1_infax_

        and I sent you a fax, with my ID setting as +968-699407, it
        should be received as:

        ram1_infax_968699407_00000_fax

        dir RAM1_infax_968699407_
        gives the faxes received from +968-699407

        Two subsequent faxes would be received as:

        ram1_infax_968699407_00001_fax
        ram1_infax_968699407_00002_fax

        With a suitable PHONEBOOK NAME, these files may be received as

        ram1_infax_jonathan_00001_fax


54                                   QFAX Class 2.0/Class 2 Facsimile System


        ram1_infax_jonathan_00002_fax

    A log file is maintained for sent and received faxes, giving caller num-
    ber, pages, time, baud rate, resolution etc.

         qfax can receive in a number of modes.

    8.3.1.  Manual receive

         Answer  fax  after  manual pickup of phone. This would be used when
    you have a normal voice line shared with your fax modem. You pick up the
    phone,  hear  a fax tone and then start qfax in this mode. When you hear
    qfax negotiating with the remote modem, put down the handset.

         Caution you may need to invoke qfax from a ram disk to  avoid  disk
    I/O related problems on low end SMS/QDOS systems.


        ex qfax;'[-p] [-v] [-x] [-l logfile] [-i ini] [-e N] [-P poll] -R'
        ex qfax;'[-v] [-x] [-l logfile] [-i ini] [-e N] [-P poll] -r pattern'

                  -v, -l, -x, -i, -e function as for send




         -R   receives using qfax file naming conventions.

         -r   pattern receives to `pattern_001', `pattern_002' etc

         -p   Print the fax on completion (after any move if VIA is defined)
              You must have defined PRINT = in  `qfax_dat'  and  use  -p  to
              print.

         -P   defines  the  name  of  a fax file that you will transmit when
              polled.


    8.3.2.  Automatic Answer

         Let the modem answer the phone after a given number of rings.  qfax
    uses  its  internal file naming convention. qfax can either exit after a
    single fax, or continue to answer and receive until you RJOB it, or  let
    qfax ask you want you want to do.


        ex qfax;'[-p] [-v] [-x] [-l logfile] [-i ini] [-e N] [-P poll] -w 2'
        ex qfax;'[-p] [-v] [-x] [-l logfile] [-i ini] [-e N] [-P poll] -W 3'
        ex qfax;'[-p] [-v] [-x] [-l logfile] [-i ini] [-e N] [-P poll] -m 3'

        where -v, -l, -x, -i, -e, -P function as above




QFAX Class 2.0/Class 2 Facsimile System                                   55


         -p   Print  the  fax  on  completion  (after  any  move  if  VIA is
              defined). You must have defined `PRINT ='  in  `qfax_dat'  and
              use `-p' to print.

         -w N
              answers  after  N  rings  (2  in  the  above example). Program
              terminates after receiving.

         -W N
              answers after N rings (3 above), after receiving, the  program
              waits for another call.

         -m N
              answers  after N rings (3 above), after receiving, the program
              waits for another call. You are asked if you want to answer as
              fax or voice. This is described below as `Monitor' mode.


    8.3.3.  Shared

         In  this  mode  qfax  assumes that another program has answered the
    phone and issued a modem `ATA' command to go online. This parent program
    has  then  received a `+FCON' (Class Two FAX connect) message and forked
    (i.e. invoked using the equivalent of EX/EW) the qfax program. qfax  may
    then be invoked in one of two modes.


         -g   When  qfax  is  invoked -g. it assumes that the parent program
              has closed the serial port. qfax will open  the  serial  port,
              perform  fax specific initialisation and then receive the fax.
              After reception, qfax will close the serial port and exit,  it
              supplies an exit status of 0 for success, non-zero on error.


                  ex qfax;'[-p] [-v] [-x] [-i ini] [-e N] [-l logfile0]
                                                          [-P poll] -g'

                  where -v, -l, -x, -e, -i, -p, -P function as above



         -G   When  qfax  is  invoked -G, it assumes that the parent has
              passed the open serial channel as standard SMS/QDOS  stack
              channels,  with an additional channel(s) for log messages.
              The stdin channel is the open serial channel,  the  stderr
              channel  for verbose qfax messages, the stdout channel may
              be nul or a temporary (gash) file. qfax will not close the
              serial  port  on  exit; but will honour exit baud settings
              and supplies an exit status of 0 for success, non-zero  on
              error.


                  ew qfax,#c4,nul,#c1;[-p] [-v] [-x] [-i ini] [-e N] [-l log]


56                                   QFAX Class 2.0/Class 2 Facsimile System


                                                              [-P poll] -G
                  where -v, -l, -x, -e, -i, -p, -P function as above

                  open #4, 'ser2hr'
                  open #5, 'con'
                   ...
                  ew qfax,#4,#5,nul;'-p -v -G'
                   ...
                  close #4
                  close #5




         With  QBOX BBS, the something like the following may be specified:.


        win1_qfax %>>nul %>ram1_fax_log %< -xvG

    The stderr channel is used for the verbose qfax status message; the std-
    out channel is used for the two information messages.


        Connect at 9600 bps to xxxx xxxxxx (SomeLuckyPerson)
        Sending:0, connect time 40 secs, [xxxx xxxxxx] (SomeLuckyPerson)

    You  may choose to supply either a stdout or stderr channel depending on
    the volume of messages required.

         Addition information is given in `QFAX and QBOX'.

    8.3.4.  qfax MONITOR mode

         This is only applicable if you use the  QJump  Pointer  Environment
    (PE).   qfax has a `-m (monitor)' option. This takes a "number of rings"
    parameter, just like `-W (wait)', but when ring  is  detected,  a  popup
    window  is  displayed,  with  the legend `QFAX Answer ?'  and options of
    `Yes' and `No'.

         There are then (at least) the following possibilities.


         +    The number of rings specified in the `-m' (monitor) command is
              reached.  qfax then attempts to answer the call as a fax (i.e.
              just like `-W'). The popup is removed.

         +    You hit Yes, without picking up the handset. qfax will attempt
              to answer in fax mode.

         +    You  hit  No,  without  picking  up  the handset. qfax will be
              confused and probably pop up the window  again,  on  the  next
              ring. If will eventually time out.



QFAX Class 2.0/Class 2 Facsimile System                                   57


         +    You pickup the handset (so the phone stops ringing)


              -    You  (hear a fax tone and) hit Yes.  qfax will attempt to
                   answer in fax mode.

              -    You hit No. qfax does nothing, awaiting  next  call.  The
                   popup is removed. You may talk with a human caller.

              -    You  do  nothing  (this does not preclude conversing with
                   any human caller).  The popup will timeout and be removed
                   approximately one minute after the last ring. This should
                   give sufficient time for you to decide if the call  needs
                   answering in fax mode.


    This  facility  is  only available if you are using the Pointer Environ-
    ment.

    8.4.  Polling (responding)

         Through the receive  mechanism,  qfax  can  also  respond  to  poll
    requests  and  send  a  fax  to  a  caller. You indicate your ability to
    respond to poll requests by defining your poll response  fax  file  with
    the  -P  option. This file will be sent by any of the qfax receive modes
    when the phone is answered to a  remote  poll  request.  qfax  may  also
    receive  a  fax  from the poller before sending its poll response fax if
    requested.


        ex qfax;'-v -W 2 -P  ram7_qfaxpoll_fax'

    In the example, qfax answers after two rings, will receive a fax if  the
    caller   sends   one  and  will  return  the  poll  fax  from  the  file
    ram7_qfaxpoll_fax if the caller makes a poll request.

         qfax records the full  path  name  of  the  last  fax  successfully
    received,  in  a  file  `INDIR_QFAX-LastFax' (INDIR being your top level
    inbound fax directory). The file just contains the full path name of the
    last  received fax, terminated with LF (line feed). The qfv and printfax
    programs can easily access the last received fax.

    8.5.  qfax Server

         It is possible to run qfax in `-m (monitor)' or `-W (wait)'  modes,
    and  issue commands to it via a "Client Server Manager" (CSM) interface.
    The interface allow you to send a fax without first removing `qfax', put
    it  into  a sleep mode, where it releases the serial channel (so you can
    use, say, QTPI), wake it from sleep (get  the  serial  device  back  and
    wait/monitor  again);  qfax  can  send the results of commands back to a
    client application.  A example PE qfax client  application  (qfaxClient)
    is supplied.



58                                   QFAX Class 2.0/Class 2 Facsimile System


         The qfax server commands are


         send
              send fax (can use aliases)

         grab
              as -g

         sleep
              close serial

         wake
              only valid after sleep, reopens serial

         exit
              exits qfax

         poll
              polls a remote, may also send and poll.

    These are illustrated by examples below:



        ex qfax;'-m 3'
        (ex cview;'qfax -m 3')                   even better

        client 'QFAX'                            send commands to qfax server
        request 'QFAX','send jrh ram2_*_fax',a$  tell qfax to send
        print a$                                 read result from qfax
        (qfax returns command result)
        (now qfax goes back to -m mode)
        (qfax receives some faxes here)
        ...
        request 'qfax','quit'                    tell qfax to stop
        freeclient 'qfax'


      The  send  command requires a phone number (or NAME/ALIAS) and a file.
    The poll command requires a phone number and optionally a file  name  if
    you wish to send as well.


        send jrh ram2_f1_001 ram2_x_fax
        send 00-968-699407 ram1_test_g3
        poll 699407
        poll 699407 ram1_demo_fax

    When  a `sleep' command has been issued, any commands other than `wake',
    `quit' and `exit' are ignored.




QFAX Class 2.0/Class 2 Facsimile System                                   59


         CSM is a system extension to facilitate simple, cooperative, client
    server  applications. CSM is free and freely distributable and available
    from the usual freeware sources.

    8.5.1.  Using qfaxClient

         qfaxClient is a simple PE application that can be used in  conjunc-
    tion with qfax in server mode.

         Now move the pointer into the qfaxClient program.

         Now,  assuming  you  have  an  alias  `jrh'  set  up and a fax file
    `ram1_test_fax', hit F3 and type send jrh ram_test_fax<RET>.  qfax  will
    start  to send the fax, and when it's finished, a message will appear in
    the qfaxClient window to inform you. If a fax is  received  while  qfax-
    Client is running, then you will also get a message.

         You  use  all  the  qfax  server commands (send, grab, sleep, wake,
    quit, exit) from the qfaxClient application.

        Please  note  that  qfaxClient  is   a   simple,   demonstration
        application.  The  'C'  source  code  is available with the QFAX
        distribution. It is not a supported part of the QFAX suite.


    8.5.2.  QFAXINI

         This keyword may be used in `qfax_dat' to define qfax options  that
    are processed before any command line options. For example:


        given QFAXINI = -p -l ram7_qfax_log -R -v -P ram7_poll_fax
        then
        ex qfax
        is the same as
        ex qfax;'-p -l ram7_qfax_log -R -v -P ram7_poll_fax'
        and
        ex qfax;'-W 3'
        is the same as
        ex qfax;'-p -l ram7_qfax_log -v -W 3 -P ram7_poll_fax'

    The `-W 3' argument on the command line overrides the contradictory `-R'
    in the QFAXINI definition. The `-p' option would be ignored in:


        ex qfax;'-s jh ram2_test_fax'

    where `jh' is an alias and the full equivalent command might be:


        ex qfax;'-l ram7_qfax_log -v -s 00-968-699407 ram2_test_fax'




60                                   QFAX Class 2.0/Class 2 Facsimile System


    9.  qfv

    9.1.  qfv Overview

         qfv is a Pointer Environment (PE) viewer for QFAX format G3  files.
    qfv supports both 1-D and 2-D format files.

    9.2.  Running qfv

         qfv  may  be invoked with or without command options.  The simplest
    invocation is:


        ex qfv
        or
        ex qfv;'test_fax'

     There are two (disguised) buttons below the title bar.  The  first  one
    is called `MENU', the command key is `F3'.

         The second one is the number after the `MAG' text. Key selection is
    `M'.

    9.2.1.  Menu

         Here you can load a G3 format QFAX file  (from  text2g3  or  qfax).
    When  the fax is loaded the first screen-full is displayed in magnifica-
    tion '0' (i.e. 1/4 the actual pixel size), unless  you  have  instructed
    qfv  to  use  a different magnification. If you use MENU_REXT (C) Jochen
    Merz, then the FILE_SELECT file requester  is  used.  The  default  file
    extension for FILE_SELECT is taken from the `QFAX_DAT' SUFFIX value.

         It  is  possible  to load a fax at a specific page from within qfv,
    just add @page to the file name (either from the File Select  'F3'  line
    or   the   qfv   file   requester   prompt).   For   example,   to  load
    win1_faxin_multipage_fax at  page  5,  enter  the  name  into  the  file
    requester as:


        win1_faxin_multipage_fax@5



         If your fax file is a part of a QFAX multi-page fax then, depending
    on where you are in the file qfv may offer options of  `Next  Page'  and
    `Prev Page'.

         The  `Info'  option  displays  information about the fax. The final
    number is the time in seconds the fax decoder took.

         The `Last Fax' option causes qfv to load the last received fax  (as
    defined by the `QFAX-LastFax' file).



QFAX Class 2.0/Class 2 Facsimile System                                   61


         The  `Invert'  option  will  flip  a  fax image if the fax has been
    transmitted upside down.

         qfv has a "Goto page" menu option.

         The Files menu also  offers  `Print',  you  must  (obviously)  have
    loaded  a  fax to be able to do this. You are prompted for output device
    and printer type. qfv  supports  HP  PCL  3/4/5  (LaserJet  II  /III/IV,
    DeskJet),   Epson  24  pin  (and  good  emulations),  Epson  9  pin  and
    Postscript.  On a slow system, be prepared for a long wait, particularly
    if  you  are  using a serial printer and 24 pin or HP PCL; the output to
    the printer will typically be 300 - 400 Kb per A4 page, unless you  have
    a  modern HP printer that supports compression, in which case it will be
    around 35Kb.

         The print options allow you to define specific  `printfax'  options
    (for  example, to defined special printer options such as HP compression
    or sizing (-s 3)).  and print either the current page, the whole fax  or
    the rest of the fax.

         qfv  honours the printfax PFAXINI (see section  PFAXINI) options as
    well as its own qfvINI options.

         qfv print supports the  same  print  page  range  format  (via  its
    "Print" menu option) as described for printfax.

         When  printing,  a  box  appears  with the legend `Abort', `Remove'
    `Cancel'. If you hit abort or cancel, the printout is  aborted.   Remove
    merely  removes the dialogue box, printing will continue.  This box dis-
    appears (miraculously) when printing has finished.

         The Review item will display a list of the recently  received  fax,
    assuming you have the QFAX Thing loaded. See section QFAX Thing.

         The  other  icon is `Magnify'. You can enter (single key, like Sys-
    def) the values 0,1 or 2.


        Magnification 2     1 fax pixel  = 1 screen pixel
        Magnification 1     2 fax pixels = 1 screen pixel
        Magnification 0     4 fax pixels = 1 screen pixel



    You can navigate around using the scroll/pan bars or ALT and arrow  key.

         qfv  also  supports  PE move, size and wake. Wake just redraws from
    the top left corner. You can size up to the maximum your  hardware  per-
    mits  or  full  size  (mag  =  2),  (2432x(a lot) pixels), which ever is
    smaller.

         You can invoke some qfv actions from the keyboard.



62                                   QFAX Class 2.0/Class 2 Facsimile System


         F3   Files Menu

         M    Magnification

         ALT down
              Page Down

         ALT up
              Page Up

         ALT left
              Page left

         ALT right
              Page right

         TAB  Move pointer to/from scroll bar

         SHIFT-TAB
              Move pointer to/from pan bar

    Error trapping is minimal, if it cannot load a G3 file (i.e. not  enough
    memory), it gives a message and then refuses.

         Details of the way that qfv supports different page sizes are given
    in `How qfax handles page size'.

         If you have insufficient free memory to decode a complete fax  page
    (or  use the -X option), a requester will be displayed on reporting that
    the fax is being "banded" and the amount of  extra  memory  required  to
    decode a full page.

    9.2.2.  qfv command options

         qfv supports the following command line options


        ex qfv;'[-X n][-m n] [-w xs] [-h ys] [-o dev] [-t name] [-p]
                [-q] [-b] [-g page] [-J|j jump] [-P eol]  [-l | file_name]'




         -x   Limit the memory allocation to a size defined by 'n' Normally,
              QFAX will try  to  allocate  memory  based  on  the  fax  page
              requirements.

         -m n
              Startup magnification level

         -w xs
              Window x-size



QFAX Class 2.0/Class 2 Facsimile System                                   63


         -h ys
              Window y-size

         -i dir
              Set input directory (if no file given)

         -q   Queries ESC exits (but not HIT/DO on exit button)

         -o dev
              defines print device

         -t name
              defines printer name

         -b   suppress bad line substitution.

         -l   Causes qfv to print the last received file.

         -j skip

         -J skip
              These options cause printfax to skip a number of scan lines at
              the top of either the first page (-j) or all pages (-J).  This
              may be used to remove a "From" line inserted by the remote fax
              machine when producing an image format. A value of "-J 100" is
              a good starting value for typical "From line" removal.

         -P eol
              The  -P  eol  parameter  defines the number of consecutive EOL
              (end of line) codes to be considered an  end  of  pager  (EOP)
              marker.  A  standards  compliant fax will use 5 EOL markers to
              signify EOP, and 'qfax' has always  inserted  sufficient  EOLs
              when the remote machine did not supply them. Some fax machines
              may not supply the correct EOLs, and early  versions  of  LFAX
              did not supply the extra markers.

         -g page
              Causes   qfv   to   display   page  'page'.  Other  pages  may
              subsequently be displayed by the menu options.

    qfv honours the following printfax options from a  `PFAXINI'  option  in
    `qfax_dat'.


         -c n
              HP compression mode (0/2/3)

         -s n
              Specific actions (only used by HP mode)

         -t name
              printer name



64                                   QFAX Class 2.0/Class 2 Facsimile System


         -o dev
              printer device

         -p   Causes  the  window to appear at (or near) the current pointer
              position rather than centred.

    HIT'ing resize works as a  normal  resize.  DO'ing  resize  will  toggle
    between  making  the display full screen, and reverting to the last none
    full-screen size.

    9.3.  Bad lines

         The QFAX decoder has previously included "bad lines" in  fax  docu-
    ments  (a bad line being one where the decoded number of pixels does not
    equal the G3 page width). In this release  of  QFAX,  the  decoder  will
    replace  bad  lines with the previous line. This gives (in my opinion) a
    better print or display. This behaviour may be revoked (i.e. the bad old
    way) with a -b command option to printfax or qfv.





































QFAX Class 2.0/Class 2 Facsimile System                                   65


    10.  printfax

    10.1.  printfax Overview

         printfax  enables  you  to print out QFAX G3 files, either produced
    using text2g3 or received using qfax or LFAX.   printfax  supports  four
    widespread  printers  standards,  HP  PCL3  (and  better),  (LaserJet  &
    DeskJet), Epson 24 bit and Epson 9 pin, and  compatible  emulations  and
    Postscript.

         Details  of the way that printfax supports different page and paper
    sizes are given in `Page and Paper sizes in printfax'

         printfax also includes some pseudo devices such as PIC in full  and
    half sizes and GIF.

    10.2.  Running printfax

         The program is invoked as:


        ex printfax;'-o dev [-t name] [-x] [-a] [-c n] [-s n] [-q] [-b]
                    [-v] [-r range] [-J|j jump] [-P eol] [-l | file]'
        where




         -o dev
              is a device or file for output.

         -t name
              is the printer or output format name.

         -x   Suppresses the c68 'Any key to exit' message

         -a   Enables  a PE popup, giving the name of the file being printed
              and options 'Cancel', `Remove', `Abort'.  `Cancel'  stops  the
              current fax being printed. 'Remove' just removes the requester
              (printing continues). 'Abort' aborts all fax pages printing or
              queued  for printing. This option is most useful when printfax
              is invoked automatically by qfax  for  automatic  printing  of
              received  fax;  you then get notification of the sender TSI or
              name (depending of your use of `ALIAS') in the popup.

         -sn  Enables printer specific options. At present the only specific
              support is for HP compatible printers.

         -cn  Enables   HP  data  compression.  This  can  result  in  large
              reductions in the amount of data sent to the printer

         -q   No progress indicator



66                                   QFAX Class 2.0/Class 2 Facsimile System


         -v   Force progress indicator

         -b   Suppresses bad line replacement.

         -l   Causes printfax to print the last received file.

         -r range
              printfax  supports  a  print  range,  using  comma  and   dash
              as  separators.  For example, to print pages 3,5,7,8,9,12 of a
              fax.


                  ex printfax;'-r3,5,7-9,12 somefile_fax'

                  Ranges  are  denoted  by  '-',  with  individual  pages  and ranges
                  separated by a comma (e.g. 1-4,8-10).

         -j skip

         -J skip
              These options cause printfax to  skip  a  number  of  scan
              lines  at  the  top  of  either the first page (-j) or all
              pages (-J). This may be  used  to  remove  a  "From"  line
              inserted by the remote fax machine when producing an image
              format. A value of "-J 100" is a good starting  value  for
              typical "From line removal".

         -P eol
              The -P eol parameter defines the number of consecutive EOL
              (end of line) codes to be considered an end of pager (EOP)
              marker.  A  standards compliant fax will use 5 EOL markers
              to signify EOP, and 'qfax' has always inserted  sufficient
              EOLs when the remote machine did not supply them. Some fax
              machines may  not  supply  the  correct  EOLs,  and  early
              versions of LFAX did not supply the extra markers.

         file
              is a QFAX G3 file or output from text2g3.

    Due to Pointer Environment overheads, the -a and -v options are mutually
    exclusive, printfax will  display  the  progress  indicator  unless  you
    request  the  popup, if it is possible (i.e. the stdout device is a con-
    sole). The popup is only displayed if you have the Pointer  Environment.

         Printer names are denoted as


         hp-pcl
              (Laser/Deskjet 300 dpi, the default)

         eps-24
              (Epson 24 pin, 180 dpi)



QFAX Class 2.0/Class 2 Facsimile System                                   67


         eps-9
              (Epson  9 pin, 120x72 dpi)

         ps

         ps-ltr
              Postscript

    Some pseudo-devices are also defined.


         pbm  Portable bit map (P4, raw)

         pic  PIC (1:1) pixel scale

         pic-scaled
              PIC (1:2) pixel scale

         gif  GIF, whole fax in one file

         gif-paged
              GIF, each page in separate file

    The pseudo-devices allow alternative fax viewers, for example the `qspv'
    PIC viewer using name pic-scaled. See section PRVIEW keyword

         These devices may be used as:


        ex printfax;'-t pic-scaled myfax_fax'

    The output from this command would be a number of half scale PIC  files,
    one file per page, as follows (for a three page fax).


        pfax001_pic-scaled  : REM 1st page
        pfax002_pic-scaled
        pfax003_pic-scaled  : REM last page



         When  a  alternate  viewer (PRVIEW) is defined, it will display the
    first page of the fax;  printfax  will  continue  to  decode  subsequent
    pages.

         The    file    name    (for    paged    devices)    is   fixed   as
    pfax[pageno]_[type_name], unless it is defined using the PRVIEW  keyword
    or  -o  option.  A 'C' numeric format string in the file name will cause
    the page number to be substituted. Single file  devices  (hp-pcl,  eps*,
    ps,  gif) have a default output name of prtqfax_[type-name], (e.g. prtq-
    fax_ps]).




68                                   QFAX Class 2.0/Class 2 Facsimile System


         The Postscript option will give better results than the  HP  option
    on  >300dpi printers (for example HP-LJ4M+). It also means that printing
    is possible, via 'ghostscipt' (gs), for printers not support in printfax
    (for example, the Canon BJ range, Epson Stylus at 360 dpi (in preference
    to printfax Epson 24 mode (180dpi))).

         Users should not that the author's knowledge of Postscript is  lim-
    ited and may not work on non-A4 faxes.

         The  `type' argument is optional, the default is HP-pcl. (i.e. it's
    optional if you have an HP printer)



            REMark to a ram file using EPS24 mode

            ex printfax;'-o ram1_test_dmp -t eps-24 win1_test_fax*'
            copy ram1_test_dmp, ser1h

            ex printfax;'-o prt ram2_test_fax_001'      : REM to HP printer on prt

            ex printfax;'-tpic-scaled -oram1_pf_%02x'   : REM named PIC files
                                                        : automatic viewing if
                                                        : PRVIEW configured




    10.2.1.  PFAXINI

         printfax options may be  supplied  using  the  PFAXINI  keyword  in
    `qfax_dat'.

    10.3.  Printer specific features

         The  printfax  Epson  9  pin  emulation  is  fairly  simple. It was
    designed for ease of implementation and compatibility.  The  quality  is
    not great, but it is readable.

         If  printfax is used to print faxes automatically then is runs as a
    independent low priority job. It will wait until the  output  device  is
    free  before  it tries to allocate its large memory buffers and decode a
    fax. You can RJOB it if you want to abort  it.  It  does  not  open  any
    screen windows in this non-interactive mode.

    10.3.1.  HP Optimisations

         printfax (and via `PFAXINI', qfv) include a number of optimisations
    for HP LaserJet compatible printers (LJ II, III, IV, and Deskjets).






QFAX Class 2.0/Class 2 Facsimile System                                   69


    10.3.2.  HP Reduced Image mode

         A reduced image is printed using the `-s' (specific flag) set to  1
    (`-s1'). In this mode, printfax/qfv does not scale the image, but prints
    it at pixel size (fax is 200 dpi, HP is 300 dpi), so the image is 2/3 of
    full  size, but will only require half the memory both to be transmitted
    to the printer and to be printed. This should make it possible to  print
    complex fax on a 1Mb laser printer.

    10.3.3.  HP 150 dpi

         HP  mode  defaults  to 300dpi, you can set 150 dpi with `-s 2' (and
    reduced and 150 dpi) with `-s 3'. The 150 dpi option  is  optimised  for
    ease of implementation, not quality.

    10.3.3.1.  HP Compressed Data

         printfax and qfv support HP Method 2 (TIFF packbits) compression as
    an option `-c 2'. This is the most supported of the various  HP  schemes
    (i.e IIP, all Deskjets, IIIx, IV series).

         printfax and qfv also support HP Method 3 (Delta) compression as an
    option `-c 3'. This is supported by later HP models (PCL5  devices,  i.e
    IIIP,  IV,  DeskJet 500 series (500, 500C, 550 etc) and presumably other
    (newer) models as well).

         In this mode, printfax/qfv chooses the most efficient method  0/2/3
    (none,  TIFF,  Delta) for each line. This is denoted this below as Adap-
    tive.

         In QFAX v2.5 (and later), HP compression mode 9 (-c9)is  also  sup-
    ported.

         Compression also works with `-s1, -s2 -s3', so this mode may give a
    large saving in transmission time.

         For example, for a typical 2000 scan line fax.


        Invocation            HP Printer       Comment
                              data size

        printfax file         298115 bytes   ; full file
        printfax -c2 file     180967 bytes   ; full file, TIFF compression
        printfax -c3 file      35516 bytes   ; full file, Adaptive compression

        printfax -s1 file     143597 bytes   ; reduced file
        printfax -c2 -s1 file  96599 bytes   ; reduced file, TIFF compression
        printfax -c3 -s1 file  27596 bytes   ; reduced file, Adaptive compression

    The fax decoding and PCL encoding times (to a ram disk) are  essentially
    the  same  for  each compression method so with a serial printer connec-
    tion, this may result in a  large  time  saving.  The  savings  will  be


70                                   QFAX Class 2.0/Class 2 Facsimile System


    particularly  good  for PCL5 devices (LJ IIIP and later, and Deskjet 500
    etc).

         The adaptive mode (none/TIFF/Delta) is very efficient  with  normal
    resolution faxes, as it only sends four bytes for every other line.


















































QFAX Class 2.0/Class 2 Facsimile System                                   71


    11.  QFAX supplied Examples

         The following examples are provided:


         qfax_dat
              Example QFAX_DAT file

         qfax_font
              Font for text2g3

         test_txt
              An example text file for input to text2g3

         test_fax
              The QFAX G3 format file from `test_txt'

         qfont_txt
              Complete character set, run though text2g3 and then either qfv
              or printfax to see the full text2g3 character set.

         HeadTms_pic
              PIC format (~Q) file,  Facsimile  Message.  Correct  G3  pixel
              ratio,  so  define  the  'square'  parameter as 1 for text2g3.
              Times-Roman font.

         HeadHlv_pic
              PIC format (~Q) file,  Facsimile  Message.  Correct  G3  pixel
              ratio, so
               define  the  'square'  parameter  as 1 for text2g3. Helvetica
              font.

         QFax1_pic
              PIC format (~Q, square = 1) file, QFAX logo on one line.

         QFax2_pic
              PIC format (~Q, square = 1) file, QFAX logo on two lines.

         worm_scn
              32 Kb standard screen format image

         worm_pic
              PIC format (~Q, square = 0) file.

         frog_pbm
              Picture of a frog (really) in portable bitmap format.

         quill
              The QUILL subdirectory contains a  QUILL  printer  driver  for
              QFAX and an example QUILL generated fax.

         client
              The  `client'  subdirectory contains examples and code for the


72                                   QFAX Class 2.0/Class 2 Facsimile System


              qfaxClient example program.

         merge
              The  `merge'  subdirectory  contains  example  BASIC  programs
              illustrating macros and fax mail-merge.

    There may also be some other graphics, try them and see.
















































QFAX Class 2.0/Class 2 Facsimile System                                   73


    12.  Utility Programs

    12.1.  Overview

         The  `util'  subdirectory contains some QFAX utility programs.  The
    majority of these programs have separate documentation files.

    12.2.  SwapQfax

         This program reverses the bit order in a QFAX file


        ex swapqfax;'infile outfile'



    The QFAX header is preserved. This program may be useful for identifying
    the correct bit order setting.

    12.3.  qparse

         qparse  is  a  utility  to print out the values and defaults that a
    `qfax_dat' file will supply to the QFAX suite.

    12.4.  fsPIC

         This program will dither a four colour PIC type image into a  simu-
    lated greyscale `_pbm' file for inclusion in a fax using text2g3.

    12.5.  qfxfnt

         Font manipulation program for `qfax_font'.

    12.6.  pcl2g3

         Program  to convert HP pcl format files to QFAX G3 format or to pbm
    format to include in QFax G3 files using text2g3.

    12.7.  Obsolete programs

         The qfu program has not (yet) been updated for qfax v2.x.   It  has
    been  withdrawn  from  the distribution set. The previous program should
    still work for single page A4 fax; it required, such  functionality  may
    be added as pseudo devices to printfax.











74                                   QFAX Class 2.0/Class 2 Facsimile System


    13.  Miscellaneous

    13.1.  Media size for reception

         It is not possible to predict the storage requirement for an incom-
    ing fax, other than to say that short, low resolution faxes with  a  lot
    of  white space take up much less room than long, complex, blacker, high
    resolution faxes. For example, a half page, low res, A4  text  may  need
    10-20  Kb,  while  the  infamous  PostScript golfing lady at A4 high res
    requires around 125 Kb,  and  a  G3  encoding  of  `tiger.ps'  from  the
    GhostScript  distribution  would  require  286 Kb; this would generate a
    reception error on many standalone fax devices (wonder how I  know  that
    ?),  presumably  because they buffer pages in RAM, and don't have 286 Kb
    to spare.  You must ensure that your reception  media  has  enough  free
    space  for  any  unattended  use (a 720 Kb flp_ disk will typically hold
    12-15 A4 pages), and if you are using the VIA parameter, your intermedi-
    ate device has plenty of free space (RAM).

    13.2.  Supported Modems

         QFAX  has  been  developed  using a ZyXEL 1496E+ modem. It works on
    ZyXEL products with default settings in  both  Class  2  and  Class  2.0
    modes.

         QFAX  should work on any fax modem that is EIA Class 2 or Class 2.0
    compliant.  I have received the following information from Dave  Woodman
    concerning Supra v.32bis Fax Modems.


         +    The ID must be in quotes (AT+FLID="123456")

         +    There  is  no receive handshake, use `RMODEM=1' to limit br to
              4800 (Supra will honour this setting). On a  fast  CPU  (SGC),
              the hardware will support faster settings (3 or 4 may be worth
              trying).

         +    The modem/computer link must run at 19200 bps.


         Due to contention for the serial hardware (on a QL), you cannot use
    qfax  with  another program that also uses serial input, like the other-
    wise excellent SerMouse. If you use SerMouse, then  you  must  `sermoff'
    and preferably remove the mouse cable from the computer.

         superHermes  provides  a reliable serial mouse interface that works
    very well.

    13.3.  Reporting Problems

         If you have a problem with this software, then contact me by  email
    (qfax-bugs@jrhudson.demon.co.uk),  BBS,  fax,  phone  or  letter. I will
    probably need the following information to investigate most problems:



QFAX Class 2.0/Class 2 Facsimile System                                   75


         1.   A log file (-l option in qfax).

         2.   A photocopy of the Class 2.0/Class 2 commands from your  modem
              manual (unless you have a ZyXEL).

         3.   For  problems  with received faxes, the received data file and
              info file.

         4.   If the problem is receiving to floppy,  Don't do it.

         5.   Machine type (SMS, QL, GC, ST, QXL etc)

         6.   Serial port (Sinclair, Hermes, superHermes, other)

         7.   Modem manufacturer and model

         8.   `qfax_dat' settings.

         9.   Version numbers of relevant software

    You may imagine that I will know exactly what versions of  hardware  and
    software  you  are  using; I don't. If you can't be bothered to give the
    information I need to investigate the problem, then it is unlikely  that
    I will do so.

    13.4.  With grateful thanks to

         I  am grateful to Graham Goodwin, Wayne Weedon, Don Walterman, John
    Impellizzeri, Davide Santachiara, Dave  Woodman,  Phil  Borman  and  Jim
    Gilmour  and many others for providing the information that has made the
    development of QFAX possible.  QFAX has been influenced  by  some  other
    fax  programs including the Unix NetFax software by David M Siegel, efax
    by Ed Casas, the Atari HackFax software by Helmut  E  Neumann.   Without
    the  generosity  of  these  programmers  making  their  work freely dis-
    tributable, QFAX would not have been written.

         If you are interested in developing  freely  distributable  fax  or
    QFAX  compatible software and would like to use QFAX source code, please
    contact me with your requirements. The latest code will be  made  avail-
    able without obligation.

         If  you are developing commercial (or shareware) software and would
    like to include QFAX code then  you  should  contact  me  for  licensing
    details.

         Graham  Goodwin  has beta tested innumerable versions to, and often
    beyond, destruction; and has suggested many of  the  features  in  QFAX.
    Without  Graham's  enthusiasm  for  a Class 2 fax solution, this project
    would not have been completed.

         Tony Firshman supplied FOC a "developer's upgrade" to Minerva,  the
    Minerva manual, and a superHermes to play with.



76                                   QFAX Class 2.0/Class 2 Facsimile System


         The  `qfax_font' is copyright (C) ZyXEL Communications Corporation,
    it is the same font as provided with  their  PC  'ZFax'  utility.  I  am
    grateful  to  ZyXEL  Corp.  for permission to include this font with the
    QFAX system. I am also pleased to recommend their modems, QFAX is devel-
    oped and tested using a ZyXEL U1496E+ modem.

         QFAX  is  written  using c68 'C', running as a cross-compiler under
    Linux.

    13.5.  See Also

         The following programs are not part of the QFAX  distribution,  but
    maybe of interest.


         gs   GNU  ghostscript,  Postscript  to  fax  (and many printers). A
              'QFAX' aware version is  available  from  the  usual  freeware
              sources. Requires > 2Mb ram.

         fax2tiff
              A  QFAX  aware  version  (plus  full  libtiff  source code) is
              available. QFAX images converted using  this  program  may  be
              imported into (inter alia), the following TIFF aware programs.

                  ADPRO (Amiga)
                  MS Word (IBM PC & Mac)
                  Adobe Photoshop (Mac)
                  xv (X-Window (UNIX, VMS etc))

                  These are programs I have access to.


         class2_txt
              Supra Corp  document  describing  Class  2  protocols  and
              commands, available from TFS (QBBS), my BBS and others.

         class2_doc
              ZyXEL  Corp  document  describing  Class  2  protocols and
              commands, available from my BBS and others.

         Quintessenial Voice Mail
              Digital  voice/fax  answering  machine  for  ZyXEL.  Needs
              reliable 38400 bps or better serial device (i.e. reception
              at this speed without hardware handshake).


    13.6.  If it works for you

         I will be delighted to hear from QFAX users, particularly  by  fax,
    and  I  would like to maintain a list of modems known to work with QFAX.
    So, if QFAX works on your modem, why not send me a fax ?




QFAX Class 2.0/Class 2 Facsimile System                                   77


         I am intrigued by how many people  might  actually  be  using  this
    software.  On  the basis of correspondence, the number seems to be about
    25. If a fax is too much trouble (too expensive), then a post card (pic-
    ture of where you live) would be nice. And if you're using Lester's LFAX
    for a Class One modem, send him a post card as well. If  we  feel  we're
    wasting  our  time,  we might not bother again. (Ok, you know I'm bluff-
    ing).

         Thanks to Frits Hotsteenge for the postcard (so there is  one  QFAX
    user!).

    13.7.  Author

        Jonathan Hudson,
        Copse View,
        Priestlands Close,
        Woodlands,
        Southampton,
        Hants SO40 7GD.

        Email: jrh@jrhudson.demon.co.uk
        Tel/Fax : +44 (0)1703 867843
        FidnoNet: 2:251/126.11
































78                                   QFAX Class 2.0/Class 2 Facsimile System


    A.  QFAX Modem commands.

         When qfax starts, it initialises the modem as follows:


        ATZ                                     (unless -g option)
        <QFAX PREINIT command if defined>
        AT +FCLASS=2
        AT+FBOR=0 +FCR=1 +FAA=0                 depends on DATA
        AT+FLID=<ID field>                      from qfax_dat
        AT+FDCC=vr,br,wd,ln,df,0,0,0
        <QFAX INIT command if defined>

        vr = vertical resolution [0/1],         qfax_dat RES parameter
        br = baud rate value [1-5]              qfax_dat MODEM parameter
        wd = page width [0-2]                   qfax_dat WIDTH_x parameter
        ln = page length [0-2]                  qfax_dat PAGE_x parameter
        df = coding type [0-2]                  qfax_dat CODE parameter

        where :-

        ATZ                     reset the modem
        +FBOR=0                 disable bit reversal
        +FCR=1                  enable fax reception
        +FAA=0                  disable fax auto answer
        +FLID= ...              local identification
        +FDCC= ...              resolution, baud, width, page length, coding etc

      QFAX  Assumes  that  your  modem defaults to hardware handshake in fax
    mode. if you are not sure of this, set the `qfax_dat'  `init'  parameter
    to include:


        INIT = AT&H3 (ZyXEL, your modem may be different)

    Note you can over-ride all this with the MDM1 --- MDM4 `qfax_dat' param-
    eters.


















QFAX Class 2.0/Class 2 Facsimile System                                   79


    B.  Caveat floppy disk Users

         A considerable amount of testing has gone into various  methods  of
    receiving  fax  directly  to  disk  (or via memory buffers) using floppy
    disks. While this is possible for a single page  fax,  the  overhead  of
    SMS/QDOS  floppy disk I/O has resulted in the fax protocol timing out on
    multi-page faxes for every method that has been investigated.

         The most likely outcome of direct reception to  disk  is  that  you
    will  receive  all the first page (but slowly, at the sender's expense),
    but the overhead of closing the file (flushing slave blocks)  will  mean
    that  the modem's end of page or end of document handshake will timeout.
    A transmission error will be generated on the sender's machine, and they
    may  decide to retransmit the fax, which is not only unnecessary, but if
    it is a long distance or international call, expensive for  the  sender,
    and  if it happens too often, they may decide not to fax you again. This
    condition is identifiable by

        multiple resends of faxes
        the +FHNG:100 reply in a session log.


    The normal +FHNG parameter is 0. (+FHNG:0), any non-zero value indicates
    an error as described in the EIA Class 2 specification.

         Reception to disk is a desirable feature, as it provides data secu-
    rity in the event of system or power failure. QFAX implements this using
    an optional automated backup system whereby faxes are initially received
    to a ram_ device, and once the end of document handshake has  completed,
    the fax is copied to a disk. This mode of operation is invoked using the
    VIA parameter  to  describe  an  intermediate  reception  path  in  your
    `qfax_dat'  file.  qfax  does  not  release the phone line (although the
    caller will have hung up), until the copy has completed.

         You should use the VIA parameter if you  are  receiving  to  floppy
    disk  or  to  a  slow hard disk on a slow CPU (e.g. Miracle Hard Disk on
    68008 CPU).  See section VIA keyword.

         Reception directly to hard disk  should  be  entirely  satisfactory
    using a fast disk on a ST emulator, SMS system, or QXL .

         A  typical  A4  fax page will occupy between 30-60K bytes.  A Trump
    Card with 600 Kb free will allow you to receive a ten page fax using the
    VIA  parameter, while on a Gold Card with 1 Mb free, you could receive a
    17 page fax without error. Once the fax has been received, the memory is
    freed  as  the data is copied to disk. Note that a blank 720 Kb disk can
    only hold 12 A4 pages (at 60 KB/page). If you expect to receive  fax  at
    significantly  higher volume than this I would recommend that you invest
    in either a standalone fax machine or a fast CPU  and  large  hard  disk
    system.

         If  your fax modem supports the Class 2 AT+FPCTO parameter, setting
    AT+FPTO = 255 in the modem `init' string may allow reception  to  floppy


80                                   QFAX Class 2.0/Class 2 Facsimile System


    disk.

         Sending  of fax may also be effected by floppy disk I/O. If you are
    sending a document and qfax is reporting reception of unexpected charac-
    ters,  then  this  is  symptomatic  of  such  problems.  The sequence of
    received characters (during send) :



            [2b] received while sending data           (+)
            [46] received while sending data           (F)
            [48] received while sending data           (H)
            [4e] received while sending data           (N)
            [47] received while sending data           (G)
            [3a] received while sending data           (:)
            [20] received while sending data           ( )
            [34] received while sending data           (4)
            [33] received while sending data           (3)

            is an error report from the modem +FHNG: 43.


     So, if you receive the [2b 46 48 4e 47 3a] sequence while sending,  you
    probably have a data flow problem due to floppy disk delays.

         This  is  a fundamental feature of the way SMS/QDOS I/O works; when
    the operating system is servicing the floppy disk it cannot also service
    the serial ports. For reliable fax operation, particularly at v.17/14400
    bps) you must use a fast device (or Atari or QXL hardware) .

         For some users this means using a `ram_' disk and VIA ram.
























QFAX Class 2.0/Class 2 Facsimile System                                   81


    C.  QFAX File Format

    C.1.  General

         The QFAX file format consists of a 64 byte header and a  stream  of
    G3  data  as defined by the CCITT specification. The data may be encoded
    lsb or msb first, as defined by the header lsb field. The features of  a
    particular fax file is defined by the version field.

         The header is described by the 'C' fragment.


        typedef struct
        {
            long title;
            long version;
            short width;
            short page;
            short pagemax;
            unsigned char resolution;
            unsigned char coding;
            int  stamp;
            char tsi[24];
            int hint;
            long offset;
            char lsb;
            char dummy[11];

        } QFAXHEADER, *PQFAXHEADER;

        #define QFAXTITLE   'QFAX'
        #define QFAXVERS    '0.07'

        #define QFAXHEADLEN sizeof(QFAXHEADER)



    C.2.  Header Fields

    C.2.1.  Header title

         The title field contains QFAXTITLE.

    C.2.2.  Header version

         The version field describes the functionality required to process a
    QFAX file.


         0.04
              Minimum supported version, multiple pages in  a  single  file.
              All  pages  are  same coding and resolution. All pages are MSB
              encoded, the lsb, hint and offset fields are not supported.


82                                   QFAX Class 2.0/Class 2 Facsimile System


         0.05
              The hint field defines the size of the largest page  (in  scan
              lines) in a fax file.

         0.06
              The  lsb  field  defines  the  bit  order  of the file. If the
              version is >= 0.06 and lsb != 0, then the file is LSB  format.
              All pages are the same bit order.

         0.07
              The  offset field defines pages where the coding or resolution
              differs from that given in the header.


    C.2.3.  Header width

         The width field contains one of the CCITT G3 pixel line  widths  of
    1728, 2048 or 2432 (stored as codes 0,1,2).

    C.2.4.  Header resolution

         The  resolution field has value 0 for low resolution (3.85 line/mm)
    or 1 for high (7.7 line/mm).

    C.2.5.  Header coding

         The coding field has values 0 for 1-D coding, 1 for 2-D coding.

    C.2.6.  Header page

         The page field defines the page size (0=A4, 1=B4, 2=unlimited).

    C.2.7.  Header pagemax

         The pagemax field define the number of pages in the fax.

    C.2.8.  Header stamp

         The stamp field holds the system time ('C' time_t value) when a fax
    was received using qfax or encoded using text2g3.

    C.2.9.  Header tsi

         The  TSI field holds the transmitting station ID, this is filled in
    by qfax when receiving and set to the local ID (`QFAX_DATA'  ID  parame-
    ter) by text2g3. The values set by text2g3 are for convenience, they are
    not used elsewhere.

    C.2.10.  Header hint

         The hint field defines the maximum number of lines in any  page  in
    the  fax. It is used as a "hint" by QFAX decoding programs to decide how
    much memory is required. Applications that do  not  support  this  field


QFAX Class 2.0/Class 2 Facsimile System                                   83


    should  either  set the hint value to zero set the version field to 0.04
    (or, preferably do both).

    C.2.11.  Header offset

         The fax file header will be version number '0.07'  or  greater  for
    variable page size support.

         The  offset  field  holds  offset  from the beginning of file to an
    array of "page descriptors" that describe any fax pages in the file that
    differ  in  coding or resolution from that described by the file header.
    If all the pages in the file have the same coding  and  resolution  then
    the  offset  value  will be zero. The offset parameter is only valid for
    file version '0.07' and greater. The "page descriptors"  will  be  after
    all valid T.4 fax data in the file and be followed by EOF.

         A  v0.07  file  with  a  non-zero  offset parameter might therefore
    appear as


        Header         high res, 1-D, offset != 0

        Page 1 data     high res, 1-D
        RTC
        Page 2 data     high res, 2-D
        RTC
        Page 3 data     low  res, 1-D
        RTC
        Page 4 data     high res, 1-D
        RTC
        Descriptor, page 2  (at file position = offset)
        Descriptor, page 3
        EOF

    The 'page descriptor' structure is described by the following 'C'  frag-
    ment.


        typedef struct
        {
            long  offset;       // Offset from start of file
            short pageno;       // Page number
            short code;         // Coding value (0/1)
            short res;          // Resolution (0/1)
            short page;         // Page length (0/1/2)

        } OFFREC;

    The following should be carefully noted.


         1.   v2.5  qfax,  qfv  and printfax recognise a change of format by
              the OFFREC.offset value rather than the  OFFREC.pageno  value.


84                                   QFAX Class 2.0/Class 2 Facsimile System


              The   OFFREC.pageno   and  OFFREC.page  values  are  currently
              maintained  for  information  only.  All  offset  fields   are
              absolute [lseek(fd, offset, SEEK_SET)] values.

         2.   The  QFAXHEADER.hint  value  is always defined in terms of the
              QFAXHEADER.resolution value, so  if  QFAXHEADER.resolution  is
              zero  (i.e.   normal resolution) and a high resolution page of
              2285 lines were the largest page  received  in  a  multi-page,
              varying format fax, then QFAXHEADER.hint would be 1143.

         3.   All  pages  will  be  stored  LSB  or  MSB  as  defined by the
              QFAXHEADER.lsb field.

    The following BASIC code may be used to determine the number of pages in
    a QFAX format fax.


        ch = FOP_IN(tfax_fax)
        GET #ch\12,maxp%
        CLOSE #ch
        PRINT "Number of pages in fax file : ";maxp%



    C.2.12.  Header lsb

         The  lsb field defines the bit order of the file. If the version is
    >= 0.06 and lsb != 0, then the file is LSB format, otherwise it is  MSB.
    All pages are the same bit order.


























QFAX Class 2.0/Class 2 Facsimile System                                   85


    D.  QFAX Font Format

    D.1.  QFAX Font pre v2.7

         Prior  to  QFAX  v2.7,  the QFAX font comprised 16 horizontal by 28
    vertical pixels per character. Each character is thus defined  by  fifty
    six  consecutive  bytes  arranged  in ascending address from top left to
    bottom right.


         ---------------
        | n+0   | n+1   |       (top pixel line)
        |-------+-------|
        | n+2   |       |
        |-------+-------|
            .......
        |       |       |
        |-------+-------|
        | n+54  | n+55  |       (bottom pixel line)
         ---------------

    where the starting address, (n, from the base of the font) is given  for
    ASCII code X as X * 56. Thus the character 'A' (ASCII 65) is offset 3640
    (65 * 56) bytes from the start of the font  and  the  complete  font  is
    14336 bytes.

         Within  each character 'cell', the leftmost pixel is represented by
    the most significant bit. The character 'A' (ASCII 65) is represented by
    the sequence of hex bytes:


        (offset 3640)
        |
        V
        00 00 00 00 01 80 07 e0 0f f0 1e 78 3c 3c
        78 1e 70 0e 70 0e 70 0e 70 0e 70 0e 70 0e
        70 0e 7f fe 7f fe 70 0e 70 0e 70 0e 70 0e
        70 0e 70 0e 00 00 00 00 00 00 00 00 00 00
                                               ^
                                               |
                                               Offset 3695



    D.2.  QFAX Font v2.7+   I am extremely reluctant to add yet another font
    format to a world that is already overflowing with them,  however  I  am
    unable  to  find a publicly documented, freely available source of suit-
    able fonts for SMS/QDOS. At least this format is documented.

         New format QFAX fonts (v2.7 and greater) can be any reasonable size
    and may be proportional. These fonts have a header as follows.




86                                   QFAX Class 2.0/Class 2 Facsimile System


            typedef struct
            {
                char flag[8];       /* "QfaxFont" */
                unchar xpix;        /* Char width in pixels */
                unchar ypix;        /* Char height in pixels */
                unchar first;       /* ASCII value of first char */
                unchar last;        /* ASCII value of last char */
                unchar top_l;       /* Top margin */
                unchar bot_l;       /* Bottom margin */
                unchar right;       /* Right margin */
                unchar mode;        /* Mode, '\0' = mono, 'P' = proportional */
                long  fsize;        /* Size of character bitmap (bytes)
                unchar font[1];     /* Bitmap data */

            } QFONTHDR;




         The  rest  of  the  data  is the font bit map. This is organised as
    above, i.e. the leftmost pixel on screen  occupies  the  leftmost  (high
    bit)  (0x80).  The  data is packed (i.e. no alignment to any byte bound-
    ary).

         For proportional fonts, the xpix field is the average width, and  a
    table describing the width of each character (1 byte per character) fol-
    lows immediately after the font bitmap (for example,  if  the  font  has
    characters 32 through 127, then the proportional width table would be 96
    bytes long.


























QFAX Class 2.0/Class 2 Facsimile System                                   87


    E.  QFAX Supplied Fonts

         The following freely distributable fonts are  supplied  with  QFAX.
    Fonts suffixed "F" are monospaced, the others are proportional.


        Name                    Size    Range         File size
        ----------------------------------------------------------
        qfax.font               16x28   (0 - 255)       14336   F
        qfaxbig.font            32x56   (0 - 255)       57364   F
        qfaxnew.font            16x32   (0 - 255)       16404   F

        aachen26.font           14x26   (0 - 255)       12406
        animax55.font           31x55   (32 - 122)      19930
        beaufort28.font         12x28   (32 - 255)      9474
        bodini26.font           14x26   (0 - 255)       12370
        bodini38.font           21x38   (0 - 255)       26288
        brush50.font            28x50   (32 - 122)      16064
        bullock32.font          12x32   (32 - 127)      4704
        campanile36.font        11x36   (0 - 255)       13097
        castlefont48.font       21x48   (0 - 246)       31520
        eurostile26.font        14x26   (0 - 255)       12149
        giotto36.font           12x36   (0 - 255)       14114
        gregorian24.font        12x24   (0 - 255)       9494
        helen32.font            20x32   (32 - 127)      7756
        hobo26.font             13x26   (0 - 255)       11473
        mac26.font              10x26   (32 - 255)      7671
        mfc31.font              31x31   (32 - 92)       7348
        miami32.font            23x32   (32 - 127)      9004
        pavenue26.font          11x26   (0 - 255)       9884
        penta29.font            11x29   (32 - 255)      8981
        pica32.font             13x32   (32 - 122)      4944
        pica62.font             28x62   (32 - 122)      20542
        pixie29.font            10x29   (32 - 122)      3584
        reprise30.font          17x30   (32 - 122)      5923
        rscript48.font          15x48   (0 - 213)       19412
        rstamp48.font           31x48   (0 - 224)       43004
        sans24.font             13x24   (32 - 255)      9368
        sans30.font             16x30   (32 - 255)      13745
        sans36.font             20x36   (32 - 255)      20999
        serif24.font            13x24   (32 - 255)      8987
        serif30.font            15x30   (32 - 255)      13348
        serif36.font            20x36   (32 - 255)      20306
        seville48.font          22x48   (0 - 255)       35162
        sherbert48.font         26x48   (32 - 122)      14732
        surfstyle36.font        21x36   (0 - 214)       20464
        temp29.font             20x29   (32 - 122)      6767
        zscript36.font          19x36   (0 - 255)       22120







88                                   QFAX Class 2.0/Class 2 Facsimile System


    F.  QFAX Thing

    F.1.  QFAX Thing Introduction

         There  is  an optional QFAX THING (you need to have loaded HOT_REXT
    on QDOS systems) that maintains a list of the full path  name  and  time
    stamp  for  received  fax.  The  number of entries is definable when the
    THING in loaded. The default list size is 20. Once the number of entries
    reaches  the  list size, old entries are replaced. qfv has a menu option
    'Review' that displays the THING list (file name and time), a fax may be
    'picked' from this list for display and print.

         The  THING list may be saved as a file and reloaded when the system
    is rebooted.

         qfax will maintain the list  for  fax  received  without  error.  A
    workaround is provided that may add similar functionality for LFAX users
    without necessarily requiring a new version of LFAX.

    F.2.  Thing Components

    F.2.1.  QFAXThing

         The 'qfaxthing' program installs, loads, saves and removes the QFAX
    THING. It takes the following options.

    F.2.2.  Thing Load Command

         The  load  command installs the QFAX THING and initialises its data
    structures.


        ex qfaxthing;'load [ListSize] [SavedData]'

    Running 'qfaxthing' with the command 'load'  takes  two  optional  argu-
    ments,  the  number  of entries in the list table and an existing 'saved
    THING list' file to load the THING with  data.  If  both  arguments  are
    given, they must be in the order specified.


        examples:
        ex qfaxthing;'load 40 flp2_arrivals_dat' ; from saved file, 40 entries
        ex qfaxthing;'load 16'                   ; blank, 16 entries
        ex qfaxthing;'load win1_inbound_dat'     ; from file, entries as file
        ex qfaxthing;'load'                      ; blank, default (20) entries

    The  QFAX  THING  is not recognised by ANY QFAX programs unless you have
    first run 'qfaxthing;"load"'. The QFAX THING should not be  loaded  when
    qfaxthing  is  run.  The QFAX THING maybe 'preloaded' from your existing
    received fax files using the 'LoadNT' program. See section LoadNT.





QFAX Class 2.0/Class 2 Facsimile System                                   89


    F.2.3.  Thing Kill Command

         The 'kill' command removes the QFAX THING from the system


        ex qfaxthing;'kill'



    F.2.4.  Thing Save Command

         The 'Save' command saves the content of the QFAX THING to a file


        ex qfaxthing;'save filename'
        example:
        ex qfaxthing;'save win1_inbound_dat'



    F.3.  Thing QFAX_DAT

         The usage of the QFAX  THING  within  the  QFAX  transport  program
    'qfax' is defined by the additional QFAX_DAT key.


        SAVETHING = filename

    Where  SAVETHING  defines the name of the THING save file. If this entry
    is defined, then 'qfax' will save the THING data to the file every  time
    the THING is updated (i.e. after a fax is received). If SAVETHING is not
    defined, then the THING is still updated but the data is not saved to  a
    file.

         Note  that  the 'qfaxthing' program does not use this QFAX_DAT key;
    this is to minimise the overhead when 'qfaxthing' is run as  part  of  a
    BOOT file.

         So, if in your BOOT file you have


        ew qfaxthing;'load win1_faxdata_arrivals_dat'
        you may wish to define
        SAVETHING = win1_faxdata_arrivals_dat

    in QFAX_DAT to ensure the latest inbound fax information survives a sys-
    tem crash or otherwise unexpected shutdown.

    F.4.  Thing (LFAX users)

         I am not aware of the degree of support (if any) for QFAX Thing  in
    the  LFAX transport program. The FLOG utility is provided to give access
    to the QFAX Thing if the transport program does not.


90                                   QFAX Class 2.0/Class 2 Facsimile System


    F.4.1.  FLOG program

         A utility FLOG is provided (FLOG stands for FaxLOG).

         FLOG may be run as the 'RXJOB' by LFAX after  a  fax  is  received.
    When  FLOG  has  updated the QFAX THING, it can save the QFAX THING data
    and then run an (optional) user defined command.


        ex FLOG;'-f path [-s savefile] [user_command]'

        where
          path         is the name of the received fax file
          savefile     is the name of a THING save file
          rest of line is a user command

    For example:

         Putting the following line in an LFAX_CGF file may update the  QFAX
    THING  and  save  the  THING  data  before printing the fax.  LFAX users
    should check the syntax with the LFAX manual, I do not have  a  copy  of
    this.


        RXJOB = FLOG
        JOBCMD = -swin1_faxdata_arrivals_dat%s-f%f%sprintfax%s-c9%s%f

    Note  that the timestamp in the QFAX THING will be the time that FLOG is
    run, not the time when the fax was received, but for practical  purposes
    should be close enough.

    F.5.  Thing Technical Reference

         A  file, `flog.c.zip' is available. This file defines the structure
    of the QFAX THING and provides example 'C' code for updating QFAX  THING
    data and saving THING data to a file.

         QFAX  users  will  find  FLOG'ing futile (and double entries in the
    THING).

    F.5.1.  LoadNT

         The program "LoadNT" (NT = Nice  Thing)  will  scan  your  existing
    received  faxes  and create a QFAX THING containing the last 20 received
    fax. The QFAX THING must *not* exist for this. You supply name  of  your
    top  level inbound directory, the fax files MUST have the suffix '_fax'.
    If you had, for example, used SUFFIX=G3, then  you  will  find  you  are
    truly  stuffixed  and  will  have to endure a good FLOG'ing to load your
    existing fax.

         Assuming that my inbound fax dir is flp2_ then




QFAX Class 2.0/Class 2 Facsimile System                                   91



        EW qfaxthing;'kill'           : REM ensure noTHING exists
        EW loadNT;'flp2_'             : REM Make the list
                                        (this will also search sub-dirs)
        EW qfaxthing;'save myfax_thg' : REM Save it
        EX qfaxview                   : REM View some THING

         If, for example, you have inbound  fax  in  win1_infax_  (and  sub-
    directories thereof), then:


        EW loadNT;'win1_infax_'

    would be appropriate.

         Note  that  this process may take some time if you have a large fax
    database. LoadNT displays the sub-directories found, your top twenty and
    some search statistics.

    F.6.  qfaxview

         qfaxview  displays  the contents of a fax thing in a scrollable PTR
    window. HITing or DOing an entry will result  in  the  file  name  being
    STUFFED  in the hot key 'stuffer buffer'. The freeeware *BASIC extension
    "GetStuffed" may be used to return data from the  STUFFER  buffer  to  a
    user *BASIC program.

    F.7.  Thing Example

         I  have  included an example, example_thg, of a saved thing. If you
    are curious to see who faxes me (and incidentally if this works, then):


        EW qfaxthing;'kill'              : REM ensure noTHING exists
        EW qfaxthing;'load example_thg'  : REM Load it
        EW qfaxview                      : REM View some THING
        a$ = GetStuffed                  : REM stuffed data
        EW qfaxthing;'kill'              : REM ensure noTHING exists

















92                                   QFAX Class 2.0/Class 2 Facsimile System


    G.  QFAX and QBOX

    G.1.  QBOX Initialisation

         In order to receive fax into a BBS, you must have set up  some  FAX
    modem  commands  in  your  BBS  modem  initialisation file. When the BBS
    passes control to QFAX, the fax protocol is already running so QFAX can-
    not do its own initialisation. The following fields are important.


         +FCLASS=2
              to answer FAX

         +FAA=n (0,1)
              Answer mode


                  0 - Just returns +FCON for fax

                  1 - Returns CONNECT FAX then
                             +FCON        for fax

                              and
                               CONNECT speed for data



    You  should have set +FAA=1, some C2 modems will ONLY recognise FAX con-
    nects without this set (+FAA=1), ZyXEL will probably  be  OK  regardless
    (C2 is *NOT* a standard).


         +FDCC=1,,2,,1
              Negotiate up to high res, unlimited page length, 2D coding.

         +FCR=1
              Allow receive (important !)

         +FLID=xxxxxxxx
              Your ID

    These must be set up in the QBOX environment. When QFAX is 'grabbed' the
    fax negotiation has already started and the MDMn options DO NOT get run.

         For  ZyXEL  modems, setting S38.3=1 toggles a DCD option that makes
    this more reliable.

         If you then use the modem for either specific  FAX  or  data  (dial
    out)  connects,  you must reset some of these parameters. In particular,
    if you then use QFAX directly, you must reset the +FAA  parameter  (=0),
    otherwise  the  modem  will  return CONNECT FAX before +FCON, which QFAX
    does not like. One way to do this is using the  default  QFAX  (i.e.  No
    MDMn  commands in QFAX_DAT) commands, which will do the necessary resets


QFAX Class 2.0/Class 2 Facsimile System                                   93


    (that's why they are the default), via ATZ.

         If you then want to make a data dial out (a  mailer  for  example),
    then  you must reset +FCLASS. Again ATZ does this. When you go back into
    QBOX, you must restore Class 2 adaptive answer (+FCLASS=2 +FAA=1).

    G.2.  FAX/DATA examples

         Some scenarios might be


         > == your commnds
         < == modem responses

        1. Start QBOX
         > +FCLASS=2
         > +FAA=1

        2. Data call (inbound)
         < CONNECT 14400 etc

        3. In bound fax call
         < CONNECT FAX
           QBOX forks QFAX
         < +FCON

        4. Mailer outbound call
         > ATZ   (or +FCLASS=0 at minimum)
         < CONNECT 9600
           get/send mail packets
         > +FCLASS=2
         > +FAA=1

        5. Outbound fax call
         > ATZ           )
         > +FCLASS=2     )       done by QFAX defaults
         > +FAA=0        )
         < +FCON                 Note no CONNECT FAX
         send fax
         > +FCLASS=2 +FAA=1      BBS initialisation again

        6. Outbound data call (using QTPI/QeM etc)
         > ATZ (or +FCLASS=0)
         < CONNECT 12000
         do data connect
         > +FCLASS=2 +FAA=1      BBS initialisation again



    G.3.  Setting Data Mode in QBOX

         The QSPHAYES filename is configurable in MAIL.  Therefore  you  can
    have  a  'QSPHAYES'  (for  QBOX)  and  a 'QSPHAYES_mail' (for MAIL). The


94                                   QFAX Class 2.0/Class 2 Facsimile System


    latter simply does an ATZ or AT+FCLASS=0.

         There is also a pre-dial string in the QSPHAYES modem command  file
    that  is sent when MAIL uses QSPHAYES.  So you could put the AT+FCLASS=0
    etc in there and avoid  having  a  QSPHAYES  for  each  program.   After
    dialling  and disconnecting, QBOX also re-initialises the modem with its
    INIT parameters so it gets put back into fax mode.

         The default QTPI dial initialisation (ATZ) will reset data mode.














































QFAX Class 2.0/Class 2 Facsimile System                                   95


    H.  About this manual

         This manual is prepared using the GNU texinfo macro package for the
    TeX  typesetting  system.  This  facilitates  the  production of typeset
    (*.dvi or Postscript) documents (using TeX  and  dvips),  indexed  ASCII
    documents   using   texi2roff  and  groff  and  hypertext  (HTML)  using
    texi2html. If you have access to a TeX system or DVI viewer/printer or a
    Postscript  printer  and would like the typeset files (.texinfo, .dvi or
    .ps format), please let me know.

         The typeset manual is designed to  be  printed  double  sided.  The
    Postscript  file  can  be provided as two (odd/even) files, or two files
    can be generated by dvips from the qfax.dvi file.

         The groff/troff file is also available  and  may  be  typeset  with
    grops. You will need the -me macro package.

         If  you  have  access  to TeX, a .dvi print program or a PostScript
    printer or software interpreter, I strongly recommend you get the  type-
    set  manual.  These programs are available on most platforms (Amiga, PC,
    Unix, VMS, Atari etc  etc  etc).  The  complexity  of  the  program  and
    resource requirements have, to date, precluded an SMS/QDOS version.

         The QFAX Postscript document may be printed using ghostscript under
    SMS/QDOS. The archive also contains the psselect program  to  facilitate
    splitting  the ps file into odd and even page files for duplex printing.
    The PSUtils package for SMS/QDOS contains the pstops  program  to  print
    the manual as a neat A5 booklet format.



























96                                   QFAX Class 2.0/Class 2 Facsimile System

    Index

    +FHNG errors ................ 79     DELAY keyword ............... 17 
                                         Dial and Modem Reset ........ 18 
    1-D coding .................. 14     DIAL keyword ................ 18 
    1-D jargon ................... 8     Dithering greyscales ........ 40 
                                         DTE Rate .................... 12 
    2-D coding .................. 14                                      
    2-D jargon ................... 8     ECM ......................... 29 
                                         Ed .......................... 38 
    Abort printout .............. 61     EDR ......................... 29 
    Acknowledgments ............. 75     EIA jargon ................... 9 
    ALIAS ....................... 53     Encoding methods .......... 13,9 
    Alias matching .............. 21     Epsom printers .............. 68 
    APRES ....................... 28     Epson Printers .............. 37 
    Author ...................... 77     Error retrys ................ 25 
    Automatic Answer ............ 54     Escaping Tildes ............. 43 
    Automatic printing .......... 17     European fonts .............. 38 
                                         Example configuration ....... 11 
    Bad lines ................... 64     Example Macro Files ......... 47 
    banding ............... 35,36,62     Examples of Client .......... 58 
    BASIC examples .............. 47     Examples of Server .......... 58 
    Baud Rate ................ 12,13     EXITBAUD keyword ............ 15 
    Bit order ................. 16,9                                      
    Bold type ................ 38,43     FAA ......................... 27 
    Busting the jargon ........... 8     Fax headline ................ 50 
                                         Fax log ..................... 16 
    C file header ............... 81     Fax Page Sizes .............. 33 
    Caveat flp .................. 79     Fax Resolution ........... 12,82 
    CCITT Encoding methods ...... 13     Fax Timestamp ............... 82 
    CCITT jargon ................. 8     FAX/DATA examples ........... 93 
    Chaining files .............. 39     fax2tiff .................... 76 
    Changing QFAX font .......... 38     FCC part 68 .............. 11,12 
    Character sizes ............. 42     File Format,General ......... 81 
    CHILDLOG .................... 27     FLOG program ................ 90 
    Class 2 ..................... 51     Floppy disks ................ 75 
    Class 2.0 ................... 51     floppy disks ................ 79 
    Class One modems ............. 4     Font file ................... 16 
    CLASS2.0 keyword ............ 11     Font format ................. 44 
    Client examples .......... 58,71     FONT keyword ................ 16 
    CODE keyword ................ 13     Font mapping ................ 38 
    Colour matching ............. 40     Font path ................... 16 
    Conditions for copying QFAX .. 1     forty two plus one .......... 80 
    Config program .............. 11     fsPIC utility ............... 40 
    Configuration (general) ..... 11                                      
    Configuration file .......... 11     G3 Bit order .............. 16,9 
    Copying conditions ........... 1     G3 File formats ............. 31 
    Courtesy .................... 76     G3 jargon .................... 8 
                                         GDELAY ...................... 26 
    DATA ........................ 26     German font ................. 38 
    Date Formatting ............. 42     GFLAG ....................... 28 
    DAYS keyword ............. 23,43     ghostscript .............. 68,76 
    decoder, Page Size .......... 35     Graham Goodwin .............. 75 
    Default modem settings ...... 17     Graphic overlays ............ 41 


QFAX Class 2.0/Class 2 Facsimile System                                   97



    Greyscale dithering ......... 40     LEFTMARGIN keyword .......... 23 
    gs .......................... 76     Lester Wareham ............... 4 
                                         LFAX ...................... 4,77 
    Handshake ................... 78     Limiting Send speed ...... 13,51 
    HANGUPOK keyword ............ 24     LoadNT ...................... 90 
    Hayes modem settings ........ 17     Log file .................... 16 
    Header coding ............... 82     LSB ......................... 29 
    Header Fields ............... 81     LSB format fax files ........ 84 
    Header hint ................. 82                                      
    Header lsb .................. 84     Macro definition ............ 45 
    Header offset ............... 83     Macro examples .............. 72 
    Header page ................. 82     Macro file .................. 45 
    Header pagemax .............. 82     Macro recursion ............. 46 
    Header resolution ........... 82     Macros ...................... 45 
    Header stamp ................ 82     Manual receive .............. 54 
    Header title ................ 81     Margins ..................... 38 
    Header tsi .................. 82     MDMx keywords ............... 18 
    Header version .............. 81     Media for reception ......... 14 
    Header width ................ 82     Media size .................. 74 
    Hermes ...................... 13     MENU_REXT ................... 60 
    Hewlett Packard printers .... 68     Merge examples .............. 72 
    Hint ........................ 82     MicroEmacs .................. 38 
    Home fax machines ........... 12     Modem baud rate ............. 13 
    How text2g3, page sizes ..... 34     MODEM keyword ............... 13 
    HP 150 dpi .................. 69     Modem problems,delay ........ 17 
    HP Compressed Data .......... 69     Modem Setup Commands ........ 18 
    HP Optimisations ............ 68     Modem Setup Options ......... 17 
    HP Printer features ......... 36     Modem speeds ................ 13 
    HP Reduced Image mode ....... 69     Monitor mode ................ 56 
                                         MONO keyword ................ 25 
    ID formats .................. 11     MONTHS ...................... 23 
    ID keyword .................. 11     MONTHS keyword .............. 43 
    If it works for you ......... 76     MSB ......................... 29 
    Inbound directory ........... 15                                      
    Inbound path ................ 15     National dialcodes .......... 22 
    Including files ............. 39     Native language dates ....... 43 
    Including PBM files ......... 42     Nice Thing .................. 90 
    Including PIC graphics ...... 41     NOPOLL ...................... 28 
    Including screens ........... 39     Norwegian font .............. 38 
    INDIR keyword ............ 15,53                                      
    INFO keyword ................ 16     Obsolete programs ........... 73 
    INIT keyword ................ 15     Other fax software .......... 75 
    International aliasing ...... 22     Other text2g3 examples ...... 48 
    Introduction ................ 88     Overlay graphics ............ 41 
    Italic type ................. 38     Overview of QFAX ............. 3 
    ITU-TSS, what the **** ....... 8                                      
                                         Page and Paper Options ...... 24 
    Jochen Merz ................. 60     Page size options ........... 25 
    Jonathan Hudson ............. 77     Page width table ............ 33 
                                         Pages and Paging ............ 33 
    Kill Command ................ 89     PAGE_R ...................... 34 
                                         PAGE_R keyword .............. 24 


98                                   QFAX Class 2.0/Class 2 Facsimile System



    PAGE_S ...................... 34     QFAX Font format ............ 44 
    PAGE_S keyword .............. 24     QFAX Font Format ............ 85 
    Paging fax files ............ 39     QFAX jargon .................. 8 
    PATHFONT keyword ............ 16     QFAX Modem commands ......... 78 
    PBM files ................... 42     qfax MONITOR mode ........... 56 
    pcl2g3 ...................... 73     QFAX overview ................ 3 
    PE features in qfv .......... 61     qfax Overview ............... 51 
    PFAXINI ..................... 17     qfax parameters ............. 51 
    PFAXINI keyword ....... 22,61,68     qfax receive ................ 53 
    PFAXINI usage ............... 68     qfax Receive modes .......... 54 
    Phone Book .................. 14     qfax Server ................. 57 
    PHONEBOOK and qfax .......... 52     qfax server commands ........ 58 
    PHONEBOOK keyword ........... 20     QFAX settings ............... 30 
    PIC examples ................ 41     QFAX source code ............ 75 
    PIC graphics ................ 41     QFAX supplied Examples ...... 71 
    Polling (requests) .......... 52     QFAX Supplied Fonts ......... 87 
    Polling (responding) ........ 57     QFAX Thing ............... 61,88 
    Portable Bit Map ............ 42     qfax, page size ............. 35 
    Postcards ................... 77     qfaxClient .................. 57 
    PPR_TRY keyword ............. 25     qfaxClient_c code ........... 59 
    PREINIT keyword ............. 15     QFAXHEADER .................. 81 
    PRESCAN ..................... 29     QFAXINI ..................... 52 
    Preset Command Options ...... 22     QFAXINI keyword .......... 22,59 
    PRINT keyword ............... 17     QFAXINI usage ............... 59 
    Printer driver .............. 43     QFAXThing ................... 88 
    Printer formats ............. 23     qfaxview .................... 91 
    Printer specific features ... 68     qfax_dat file ............... 11 
    Printer types ............... 68     QFAX_DAT keywords for paging  33 
    printfax .................... 65     qfv ......................... 60 
    printfax options ............ 65     qfv buttons ................. 60 
    printfax popup .............. 65     qfv command options ......... 62 
    printfax, Page & Paper size . 36     qfv keyboard options ........ 61 
    Printing fax .......... 17,55,61     qfv magnification ........... 61 
    Problems receiving .......... 13     qfv menu .................... 60 
    Problems with ID keyword .... 11     qfv Overview ................ 60 
    PRVIEW keyword .............. 23     qfv window size ............. 64 
                                         qfv, page size .............. 36 
    QBOX Initialisation ......... 92     qfvINI keyword .............. 22 
    QD .......................... 38     QFVINI keyword .............. 61 
    QED ......................... 38     QFVINI usage ................ 61 
    qfax & CSM .................. 57     qfxfnt ................... 38,73 
    QFAX abbreviations .......... 30     QJUMP Config program ........ 11 
    QFAX and QBOX ............... 92     Qlib programs ............... 51 
    QFAX configuration file ..... 11     qparse ...................... 73 
    QFAX defaults ............... 30     Quill .................... 38,43 
    qfax error codes ............ 51     Quill examples ........... 43,71 
    QFAX file comments .......... 31     Quill parameters ............ 44 
    QFAX File Format ............ 81     qvm ......................... 76 
    QFAX file header ............ 31                                      
    QFAX font ................... 38     RCLASS,SCLASS ............... 26 
    QFAX font editor ............ 38     Receive Alias ............... 21 
    QFAX Font file .............. 16     Receive directory ........ 14,15 


QFAX Class 2.0/Class 2 Facsimile System                                   99



    Receive file naming ......... 53     text2g3 directory ........... 16 
    Receive in BBS .............. 55     text2g3 file names .......... 50 
    Receive path ............. 14,15     text2g3 output .............. 16 
    Receive popup ............ 53,56     text2g3 Overview ............ 38 
    Receive speeds .............. 13     text2g3 parameters .......... 48 
    Reporting Problems .......... 74     The manual .................. 95 
    RES keyword ................. 12     Thing Components ............ 88 
    Review ...................... 61     Thing Load Command .......... 88 
    RMODEM keyword .............. 13     Thing QFAX_DAT .............. 89 
    RSFLAG ...................... 28     Thing, Example .............. 91 
    Running printfax ............ 65     Thing, LFAX users ........... 89 
    Running qfax Receive ........ 54     Thing, Technical Reference .. 90 
    Running qfax send ........... 51     Tilde in fax ................ 43 
    Running qfv ................. 60     Transmission log ............ 16 
    Running text2g3 ............. 48                                      
                                         Underline type ........... 38,43 
    Save Command ................ 89     UNLIMITED keyword ........... 25 
    SAVETHING ................... 25     Upside Down fax ............. 61 
    Screen in fax file .......... 39     USA Legal requirements  11,12,50 
    SCRIPTLOG ................... 28     User defined Fonts .......... 44 
    Send speed limiting ...... 13,51     Using mailers ............... 93 
    Send using Alias ............ 21     Using qfax .................. 51 
    SENDBITS keyword ............ 16     Using qfaxClient ............ 59 
    Sequence numbers ............ 53     Using text2g3 ............... 38 
    SERBAUD keyword ............. 12     Utility Programs ............ 73 
    SERDEV keyword .............. 12                                      
    Serial hardware .............. 3     v.32 ........................ 13 
    Serial Mouse ................ 74     v.32 bis .................... 13 
    Server examples ............. 58     VIA ......................... 14 
    Server Send and Poll ........ 58     Viewing QFAX font ........... 38 
    Setting Data Mode ........... 93                                      
    Shared Mode ................. 55     Wait character .............. 16 
    SIGNATURE keyword ........... 12     WAIT2SEND keyword ........... 16 
    Start character ............. 16     WIDTH_R ..................... 34 
    STARTCHAR keyword ........... 16     WIDTH_R keyword ............. 24 
    STARTSCRIPT ................. 27     WIDTH_S ..................... 33 
    STOPSCRIPT .................. 27     WIDTH_S keyword ............. 24 
    Style Features .............. 43     Wildcards ................... 49 
    SUFFIX keyword .............. 25     Word Processors ............. 38 
    Supported Modems ............ 74     worms ....................... 40 
    Supra Fax Modems. ........... 74                                      
    swapqfax .................... 73     XChange ..................... 43 
    System Requirements .......... 3     XDIAL keyword ............... 25 
                                                                          
    T2G3INI keyword .......... 22,50     ZyXEL ....................... 76 
    Table 1.0 G3 page size ...... 33     ZyXEL modems ............. 13,74 
    TEMP keyword ................ 16                                      
    Testing the modem ............ 4     ~# .......................... 39 
    TeX ......................... 95     ~0 ~9 ....................... 44 
    Text editors ................ 38     ~: & ~; ..................... 39 
    Text Equivalents for Dates .. 22     ~B .......................... 42 
    text2g3 ..................... 38     ~b .......................... 42 


100                                  QFAX Class 2.0/Class 2 Facsimile System



    ~C .......................... 39 
    ~d, ~D ...................... 42 
    ~E .......................... 43 
    ~e .......................... 43 
    ~F .......................... 44 
    ~I .......................... 39 
    ~m .......................... 45 
    ~O .......................... 43 
    ~o .......................... 43 
    ~P .......................... 39 
    ~Q .......................... 41 
    ~q .......................... 41 
    ~S .......................... 39 
    ~s .......................... 41 
    ~U .......................... 43 
    ~u .......................... 43 
    ~X Include Fax .............. 47 
    ~~ .......................... 43 
