/* ptob.c

by Andrew "Alf" Leahy, 29/3/92

Converts PPM images into a sequence of BBC VDU codes.

Reads STDIN and spits out VDU to STDOUT

TODO:
	Add flag/code for Mode 0...and some of the lower res modes.
	Maybe a quick preview option? Using full character blocks (ie. 40x32).
	Figure out the 16 most common "blocks" and save them to separate
	characters (VDU 129-143).
	The "check if the last char is the same as this one" code is buggy.
	Read from file name, not just stdin (eg. ppmtovdu -1 filthy.ppm).
	How about PGM and PBM files as well...hmmmmmm.
	Sometimes, strange characters appear at the bottom of the image, why?
	Sometimes, blocks get repeated, why?
	Fix 10->9 kludge, why is Unix so unkind?
	Needs an error reporting procedure (so argv[0] can be used)
	Further optimisation of image?

(NOTE: code is formatted with tabs set to 4 chars)
*/

#include <stdio.h>                    
 
#define BAD 0
#define FALSE 0
#define TRUE 1
#define OK 1
#define LO_MASK 0x80
#define BYTE unsigned char

FILE	*fp_in, *fp_out;                      
int		WIDTH, HEIGHT, cWIDTH, cHEIGHT, MODE = 1, NOOFCOLS = 2, MODE_MAX=40;
BYTE	*pic, *pos;

int main( argc, argv )
int argc; char *argv[];
{

	if (!strcmp( argv[1], "-0"))
	{
		MODE = 0; NOOFCOLS = 1; MODE_MAX = 80;
	}
	else
	if (!strcmp( argv[1], "-1"))
	{
		MODE = 1; NOOFCOLS = 2; MODE_MAX = 40;
	}
	else
	if (!strcmp( argv[1], "-2"))
	{
		MODE = 2; NOOFCOLS = 3; MODE_MAX = 20;
	};
/*	else
	if ((fp_in = fopen( argv[1], "r" )) == NULL)
	{
		fprintf( stderr, "%s: Couldn't open %s\n", argv[0], argv[1] );
		exit(0);
	}
*/

	fp_in = stdin;

	if (!PPM_ok()) exit(0);		/* if PPM file unacceptable die	*/

	fp_out = stdout;			/* all o/p to stdout*/

	fgetc( fp_in );		/* read past linefeed character */		


	if ((pos = pic = (BYTE *) malloc (cWIDTH *(HEIGHT+1) * NOOFCOLS)) == NULL)
	{
		fprintf(stderr,"%s: Unable to malloc image\n", argv[0] );
		exit(0);
	}
	write_map();			/* reorder the image*/

	display();
	
	fclose( fp_out );

	fclose( fp_in );
	
	return 0;
}

int PPM_ok() /* is the PPM file reasonable? */
{              
#define PTYPE "P6"                                            
#define MAX_WIDTH 640
#define MAX_HEIGHT 256
#define MAX_COL 255
                                                    
char	ptype[2];
int	max_col, return_val = BAD;

	fscanf( fp_in, "%s", ptype );	/* get PPM info from file*/
	fscanf( fp_in, "%d %d", &WIDTH, &HEIGHT );
	fscanf( fp_in, "%d", &max_col );

	fprintf( stderr, "PPM info: %s, %dx%d, %d.\n", ptype, WIDTH, HEIGHT, max_col );

	if (!strcmp( ptype, PTYPE ))
		if (max_col == MAX_COL)
			return_val = OK;
		else	
			fprintf( stderr, "ppmtovdu: PPM max colour value must be 255\n" );
	else
		fprintf( stderr, "ppmtovdu: PPM file type not P6 (PPM RAWBITS)\n" );

	if (WIDTH > MAX_WIDTH || HEIGHT > MAX_HEIGHT)
		fprintf( stderr, "ppmtovdu: image may be too large!\n" );

	cWIDTH = WIDTH /8;
	if (WIDTH % 8 != 0) cWIDTH++;
	
	cHEIGHT = HEIGHT / 8;
	if (HEIGHT %8 != 0) cHEIGHT++;

	return return_val;
}

write_map()
{                                  
#define RED 0
#define GREEN 1
#define BLUE 2

char	row [80] [3], dummy; /* should use malloc here to setup array */
int	y, x, i, shift, colour;
                                     
	for( y=0; y < HEIGHT; y++ )
	{
		/* Initialise array */

		for( i=0; i < cWIDTH; i++ )
			row [i] [RED] = row [i] [GREEN] = row [i] [BLUE] = 0;

		/* Read PPM row into array, masking lower 7 bits */

		for( x=0; x < WIDTH; x++ )
		{
			i = x / 8; shift = x % 8;
			row [i] [RED  ] += (fgetc( fp_in ) & LO_MASK) >> shift;
			row [i] [GREEN] += (fgetc( fp_in ) & LO_MASK) >> shift;
			row [i] [BLUE ] += (fgetc( fp_in ) & LO_MASK) >> shift;
		}
                          
		/* Write out each row in turn */
                             
		for( i=0; i < cWIDTH; i++ )
			*pos++ = row [i] [RED];
		if(MODE==1 || MODE ==2)
			for( i=0; i < cWIDTH; i++ )
			    *pos++ = row [i] [GREEN];

		if (MODE == 2)
			for( i=0; i < cWIDTH; i++ )
				*pos++ = row [i] [BLUE];

	}
}

display()
{
#define SPACE 32
#define BLOCK 255
#define FULL 2040

int	colour, row, col, sum, line, ch, fullwidth, fullheight;
int	sp, new, blockdefined = FALSE;
BYTE	gchar[8], byteread;
long	bsum,obsum;


ch = cWIDTH; fullwidth = ch * NOOFCOLS; fullheight = fullwidth * 8;

#ifdef DEBUG
fprintf(stderr,"ch=%d,fullwidth=%d,fullheight=%d,cHEIGHT=%d\n",ch,fullwidth,fullheight,cHEIGHT);
#endif

mode( MODE );
vdu( 5 );
if (MODE == 1)
		{
			vdu( 20);
			setcol( 0,0 );
			setcol( 1,1 );
			setcol( 2, 2 );
			setcol( 3, 7 );
		}
	if (MODE == 2)
	{
			vdu( 20 );
	}

for (colour=0; colour < NOOFCOLS; colour++ )
{
	new = TRUE;
	if (MODE == 1)
	{
		if (colour == 1)
		{
			gcol( 1, 2 );
		}
		else
			gcol( 1, 1);
	}

	if (MODE == 2)
	{
		if (colour == 1)
		{
			vdu( 20 );
			setcol( 3, 7 );
			gcol( 1, 2 );
		}
		else
			if (colour == 2)
			{
				vdu( 20 );
				gcol( 1, 4 );
			}
			else
				gcol( 1, 1 );
	}

	for (row=0; row < cHEIGHT; row++ )
	{
		sp = 0;
		for (col=0; col < cWIDTH; col++ )
		{
			sum = 0; bsum = 0;
			for (line=0; line < 8; line++ )
			{
				byteread = pic[
							col
							+ colour 	* cWIDTH 
							+line 	* cWIDTH*NOOFCOLS 
							+ row 	* cWIDTH*NOOFCOLS* 8
							];

#ifdef DEBUG
fprintf(stderr,"%d %d %d %d-", colour, row, col, line );
fprintf(stderr,"%d\n", line * fullwidth + col + row * fullheight + colour * ch);
#endif

				/* this is a kludge to replace "10"'s in the image */
				/* since "0A" get's stripped by Unix (for some reason) */
				/* try removing it...may not be needed on your system */

/*				if (byteread == 10)	byteread = 9; */

				gchar[line] = byteread;
				sum += byteread;
				bsum = bsum + (line+1) * byteread;
			}

			if (sum == 0) 
				sp++;
			else
			{
				if (new)
				{
					move( sp * MODE * 32, 1023 - row * 32 );
					sp = 0;
					new = FALSE;
				}

				if (sp > 6)
				{
					move( col * MODE * 32, 1023 - row * 32 );
					sp = 0;
				}
				else
					if (sp > 0)
					{
						int i;
						for(i=0; i<sp; i++ )
							vdu( SPACE );
						sp = 0;
					}

				if (sum == FULL) 
				{
					if (!blockdefined)
					{
						define( 255, 255, 255, 255, 255, 255, 255, 255, 255 );
						blockdefined = TRUE;
					}
					vdu( BLOCK );
				}
				else
/*				if (bsum == obsum)
				{
					vdu( 128 );
				}
				else
*/
				{
					define( 128, gchar[0], gchar[1], gchar[2],
							gchar[3], gchar[4], gchar[5], gchar[6],
							gchar[7] );
					vdu( 128 );
					/*obsum = bsum;*/
				}
			}
		}
		if ((col == MODE_MAX)  && (sum > 0))
			new = FALSE;
		else
			new = TRUE;
	}
}	

vdu( 4 );

}

vdu( V )
int V;
{ printf( "%c", V ); }

mode( M )
int M;
{ printf( "%c%c", 22,M ); }

setcol( r,l )
int r,l;
{ printf( "%c%c%c%c%c%c", 19,r,l,0,0,0 ); }

gcol( o, c)
int o,c;
{ printf( "%c%c%c", 18,o,c ); }

plot( o,x,y )
int o,x,y;
{ printf( "%c%c%c%c%c%c", 25,o,x%256,x/256,y%256,y/256 ); }

define( C, b1, b2, b3, b4, b5, b6, b7, b8 )
int C, b1, b2, b3, b4, b5, b6, b7, b8;
{ printf( "%c%c%c%c%c%c%c%c%c%c", 23,C,b1,b2,b3,b4,b5,b6,b7,b8 ); }

move( x,y )
int x, y;
{ plot( 4, x, y ); }
